/* moonshot-idcard-widget.c generated by valac 0.34.9, the Vala compiler
 * generated from moonshot-idcard-widget.vala, do not modify */

/*
 * Copyright (c) 2011-2016, JANET(UK)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JANET(UK) nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_ID_CARD_WIDGET (id_card_widget_get_type ())
#define ID_CARD_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD_WIDGET, IdCardWidget))
#define ID_CARD_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD_WIDGET, IdCardWidgetClass))
#define IS_ID_CARD_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD_WIDGET))
#define IS_ID_CARD_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD_WIDGET))
#define ID_CARD_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD_WIDGET, IdCardWidgetClass))

typedef struct _IdCardWidget IdCardWidget;
typedef struct _IdCardWidgetClass IdCardWidgetClass;
typedef struct _IdCardWidgetPrivate IdCardWidgetPrivate;

#define TYPE_IDENTITY_MANAGER_VIEW (identity_manager_view_get_type ())
#define IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerView))
#define IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))
#define IS_IDENTITY_MANAGER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IDENTITY_MANAGER_VIEW))
#define IS_IDENTITY_MANAGER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IDENTITY_MANAGER_VIEW))
#define IDENTITY_MANAGER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IDENTITY_MANAGER_VIEW, IdentityManagerViewClass))

typedef struct _IdentityManagerView IdentityManagerView;
typedef struct _IdentityManagerViewClass IdentityManagerViewClass;

#define TYPE_ID_CARD (id_card_get_type ())
#define ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ID_CARD, IdCard))
#define ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ID_CARD, IdCardClass))
#define IS_ID_CARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ID_CARD))
#define IS_ID_CARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ID_CARD))
#define ID_CARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ID_CARD, IdCardClass))

typedef struct _IdCard IdCard;
typedef struct _IdCardClass IdCardClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TRUST_ANCHOR (trust_anchor_get_type ())
#define TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRUST_ANCHOR, TrustAnchor))
#define TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRUST_ANCHOR, TrustAnchorClass))
#define IS_TRUST_ANCHOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRUST_ANCHOR))
#define IS_TRUST_ANCHOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRUST_ANCHOR))
#define TRUST_ANCHOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRUST_ANCHOR, TrustAnchorClass))

typedef struct _TrustAnchor TrustAnchor;
typedef struct _TrustAnchorClass TrustAnchorClass;

struct _IdCardWidget {
	GtkBox parent_instance;
	IdCardWidgetPrivate * priv;
	gint _position;
};

struct _IdCardWidgetClass {
	GtkBoxClass parent_class;
};

struct _IdCardWidgetPrivate {
	IdentityManagerView* manager_view;
	IdCard* _id_card;
	GtkVBox* main_vbox;
	GtkHBox* hbox;
	GtkEventBox* event_box;
	gboolean is_selected;
	GtkArrow* arrow;
	GtkVBox* details;
};


static gpointer id_card_widget_parent_class = NULL;

GType id_card_widget_get_type (void) G_GNUC_CONST;
GType identity_manager_view_get_type (void) G_GNUC_CONST;
GType id_card_get_type (void) G_GNUC_CONST;
#define ID_CARD_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ID_CARD_WIDGET, IdCardWidgetPrivate))
enum  {
	ID_CARD_WIDGET_DUMMY_PROPERTY,
	ID_CARD_WIDGET_ID_CARD,
	ID_CARD_WIDGET_POSITION
};
#define ID_CARD_WIDGET_ARROW_SHADOW GTK_SHADOW_NONE
void id_card_widget_select (IdCardWidget* self);
void id_card_widget_expand (IdCardWidget* self);
void id_card_widget_unselect (IdCardWidget* self);
void id_card_widget_collapse (IdCardWidget* self);
static void id_card_widget_set_idcard_color (IdCardWidget* self);
static gboolean id_card_widget_button_press_cb (IdCardWidget* self);
gint id_card_widget_get_position (IdCardWidget* self);
static void id_card_widget_make_id_card_label (IdCardWidget* self, GtkLabel* label);
gboolean identity_manager_view_selection_in_progress (IdentityManagerView* self);
IdCard* id_card_widget_get_id_card (IdCardWidget* self);
gboolean id_card_is_no_identity (IdCard* self);
const gchar* id_card_get_display_name (IdCard* self);
IdCardWidget* id_card_widget_new (IdCard* id_card, IdentityManagerView* manager_view);
IdCardWidget* id_card_widget_construct (GType object_type, IdCard* id_card, IdentityManagerView* manager_view);
void id_card_widget_set_id_card (IdCardWidget* self, IdCard* value);
const gchar* id_card_get_username (IdCard* self);
const gchar* id_card_get_issuer (IdCard* self);
GType trust_anchor_get_type (void) G_GNUC_CONST;
TrustAnchor* id_card_get_trust_anchor (IdCard* self);
gboolean trust_anchor_is_empty (TrustAnchor* self);
gchar* id_card_get_services_string (IdCard* self, const gchar* sep);
GdkPixbuf* get_pixbuf (IdCard* id);
static gboolean _id_card_widget_button_press_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
void id_card_widget_set_position (IdCardWidget* self, gint value);
static void id_card_widget_finalize (GObject* obj);
static void _vala_id_card_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_id_card_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void id_card_widget_select (IdCardWidget* self) {
#line 60 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	id_card_widget_expand (self);
#line 63 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_signal_emit_by_name (self, "expanded");
#line 163 "moonshot-idcard-widget.c"
}


void id_card_widget_unselect (IdCardWidget* self) {
#line 66 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	id_card_widget_collapse (self);
#line 69 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_signal_emit_by_name (self, "collapsed");
#line 174 "moonshot-idcard-widget.c"
}


void id_card_widget_expand (IdCardWidget* self) {
	GtkVBox* _tmp0_ = NULL;
	GtkArrow* _tmp1_ = NULL;
#line 72 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->is_selected = TRUE;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp0_ = self->priv->details;
#line 75 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
#line 77 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	id_card_widget_set_idcard_color (self);
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp1_ = self->priv->arrow;
#line 78 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_arrow_set (_tmp1_, GTK_ARROW_DOWN, ID_CARD_WIDGET_ARROW_SHADOW);
#line 195 "moonshot-idcard-widget.c"
}


void id_card_widget_collapse (IdCardWidget* self) {
	GtkVBox* _tmp0_ = NULL;
	GtkArrow* _tmp1_ = NULL;
#line 81 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->is_selected = FALSE;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp0_ = self->priv->details;
#line 84 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 86 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	id_card_widget_set_idcard_color (self);
#line 87 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp1_ = self->priv->arrow;
#line 87 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_arrow_set (_tmp1_, GTK_ARROW_RIGHT, ID_CARD_WIDGET_ARROW_SHADOW);
#line 216 "moonshot-idcard-widget.c"
}


static gboolean id_card_widget_button_press_cb (IdCardWidget* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 90 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp0_ = self->priv->is_selected;
#line 92 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	if (_tmp0_) {
#line 93 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		id_card_widget_unselect (self);
#line 231 "moonshot-idcard-widget.c"
	} else {
#line 95 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		id_card_widget_select (self);
#line 235 "moonshot-idcard-widget.c"
	}
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	result = FALSE;
#line 97 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	return result;
#line 241 "moonshot-idcard-widget.c"
}


static void id_card_widget_set_idcard_color (IdCardWidget* self) {
	GdkColor color = {0};
	gboolean _tmp0_ = FALSE;
	GtkEventBox* _tmp5_ = NULL;
	GdkColor _tmp6_ = {0};
	GtkArrow* _tmp7_ = NULL;
	GdkColor _tmp8_ = {0};
#line 100 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_if_fail (self != NULL);
#line 102 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	memset (&color, 0, sizeof (GdkColor));
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp0_ = self->priv->is_selected;
#line 104 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	if (_tmp0_) {
#line 106 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		color.red = (guint16) (0xd9 << 8);
#line 107 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		color.green = (guint16) (0xf7 << 8);
#line 108 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		color.blue = (guint16) 65535;
#line 266 "moonshot-idcard-widget.c"
	} else {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp1_ = id_card_widget_get_position (self);
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp2_ = _tmp1_;
#line 111 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		if ((_tmp2_ % 2) == 0) {
#line 276 "moonshot-idcard-widget.c"
			guint16 _tmp3_ = 0U;
			guint16 _tmp4_ = 0U;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			color.blue = (guint16) (0xf2 << 8);
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			_tmp3_ = color.blue;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			color.green = _tmp3_;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			_tmp4_ = color.green;
#line 113 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			color.red = _tmp4_;
#line 289 "moonshot-idcard-widget.c"
		} else {
#line 117 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			color.red = (guint16) 65535;
#line 118 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			color.green = (guint16) 65535;
#line 119 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			color.blue = (guint16) 65535;
#line 297 "moonshot-idcard-widget.c"
		}
	}
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp5_ = self->priv->event_box;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp6_ = color;
#line 123 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_widget_modify_bg ((GtkWidget*) _tmp5_, GTK_STATE_NORMAL, &_tmp6_);
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp7_ = self->priv->arrow;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp8_ = color;
#line 124 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_widget_modify_bg ((GtkWidget*) _tmp7_, GTK_STATE_NORMAL, &_tmp8_);
#line 312 "moonshot-idcard-widget.c"
}


static void id_card_widget_make_id_card_label (IdCardWidget* self, GtkLabel* label) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	IdentityManagerView* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* display_name = NULL;
	gchar* _tmp10_ = NULL;
	gchar* label_text = NULL;
	gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_if_fail (label != NULL);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp2_ = self->priv->manager_view;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp3_ = identity_manager_view_selection_in_progress (_tmp2_);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	if (_tmp3_) {
#line 336 "moonshot-idcard-widget.c"
		IdCard* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp4_ = self->priv->_id_card;
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp5_ = id_card_is_no_identity (_tmp4_);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp1_ = _tmp5_;
#line 345 "moonshot-idcard-widget.c"
	} else {
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp1_ = FALSE;
#line 349 "moonshot-idcard-widget.c"
	}
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	if (_tmp1_) {
#line 353 "moonshot-idcard-widget.c"
		const gchar* _tmp6_ = NULL;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp6_ = _ ("Do not use a Moonshot identity for this service");
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp0_ = _tmp6_;
#line 359 "moonshot-idcard-widget.c"
	} else {
		IdCard* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp7_ = self->priv->_id_card;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp8_ = id_card_get_display_name (_tmp7_);
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp9_ = _tmp8_;
#line 131 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp0_ = _tmp9_;
#line 372 "moonshot-idcard-widget.c"
	}
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp10_ = g_strdup (_tmp0_);
#line 130 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	display_name = _tmp10_;
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp11_ = g_markup_printf_escaped ("<span rise='8000'><big>%s</big></span>", display_name);
#line 132 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	label_text = _tmp11_;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp12_ = label;
#line 134 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_label_set_markup (_tmp12_, label_text);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_free0 (label_text);
#line 127 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_free0 (display_name);
#line 390 "moonshot-idcard-widget.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	return self ? g_object_ref (self) : NULL;
#line 397 "moonshot-idcard-widget.c"
}


static gboolean _id_card_widget_button_press_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = id_card_widget_button_press_cb ((IdCardWidget*) self);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	return result;
#line 406 "moonshot-idcard-widget.c"
}


IdCardWidget* id_card_widget_construct (GType object_type, IdCard* id_card, IdentityManagerView* manager_view) {
	IdCardWidget * self = NULL;
	IdCard* _tmp0_ = NULL;
	IdentityManagerView* _tmp1_ = NULL;
	IdentityManagerView* _tmp2_ = NULL;
	GtkLabel* display_name_label = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkVBox* details_wrapper = NULL;
	GtkVBox* _tmp7_ = NULL;
	GtkVBox* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkVBox* _tmp10_ = NULL;
	GtkVBox* _tmp11_ = NULL;
	GtkVBox* _tmp12_ = NULL;
	IdCard* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GtkHBox* services_hbox = NULL;
	GtkHBox* _tmp49_ = NULL;
	GtkLabel* services_label = NULL;
	const gchar* _tmp50_ = NULL;
	GtkLabel* _tmp51_ = NULL;
	GtkLabel* _tmp52_ = NULL;
	gchar* services_text = NULL;
	IdCard* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	GtkLabel* service_list = NULL;
	const gchar* _tmp55_ = NULL;
	GtkLabel* _tmp56_ = NULL;
	GtkLabel* _tmp57_ = NULL;
	GtkLabel* _tmp58_ = NULL;
	GtkLabel* _tmp59_ = NULL;
	GtkHBox* _tmp60_ = NULL;
	GtkLabel* _tmp61_ = NULL;
	GtkHBox* _tmp62_ = NULL;
	GtkLabel* _tmp63_ = NULL;
	GtkVBox* _tmp64_ = NULL;
	GtkHBox* _tmp65_ = NULL;
	GtkHBox* _tmp66_ = NULL;
	GtkImage* image = NULL;
	IdCard* _tmp67_ = NULL;
	GdkPixbuf* _tmp68_ = NULL;
	GdkPixbuf* _tmp69_ = NULL;
	GtkImage* _tmp70_ = NULL;
	GtkImage* _tmp71_ = NULL;
	IdCard* _tmp72_ = NULL;
	gboolean _tmp73_ = FALSE;
	GtkHBox* _tmp76_ = NULL;
	GtkImage* _tmp77_ = NULL;
	GtkHBox* _tmp78_ = NULL;
	GtkVBox* _tmp79_ = NULL;
	GtkArrow* _tmp80_ = NULL;
	GtkArrow* _tmp81_ = NULL;
	GtkHBox* _tmp82_ = NULL;
	GtkArrow* _tmp83_ = NULL;
	GtkVBox* _tmp84_ = NULL;
	GtkVBox* _tmp85_ = NULL;
	GtkHBox* _tmp86_ = NULL;
	GtkVBox* _tmp87_ = NULL;
	GtkEventBox* _tmp88_ = NULL;
	GtkEventBox* _tmp89_ = NULL;
	GtkVBox* _tmp90_ = NULL;
	GtkEventBox* _tmp91_ = NULL;
	GtkEventBox* _tmp92_ = NULL;
	GtkEventBox* _tmp93_ = NULL;
	GtkVBox* _tmp94_ = NULL;
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_val_if_fail (id_card != NULL, NULL);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_val_if_fail (manager_view != NULL, NULL);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self = (IdCardWidget*) g_object_new (object_type, NULL);
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp0_ = id_card;
#line 139 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	id_card_widget_set_id_card (self, _tmp0_);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp1_ = manager_view;
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->manager_view);
#line 140 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->manager_view = _tmp2_;
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp3_ = (GtkLabel*) gtk_label_new (NULL);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp3_);
#line 142 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	display_name_label = _tmp3_;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp4_ = display_name_label;
#line 143 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp4_, (gfloat) 0, (gfloat) 0.5);
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp5_ = display_name_label;
#line 144 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_label_set_ellipsize (_tmp5_, PANGO_ELLIPSIZE_END);
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp6_ = display_name_label;
#line 145 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	id_card_widget_make_id_card_label (self, _tmp6_);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp7_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp7_);
#line 147 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	details_wrapper = _tmp7_;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp8_ = details_wrapper;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp9_ = display_name_label;
#line 148 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_box_pack_start ((GtkBox*) _tmp8_, (GtkWidget*) _tmp9_, FALSE, FALSE, (guint) 0);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp10_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp10_);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->details);
#line 149 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->details = _tmp10_;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp11_ = details_wrapper;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp12_ = self->priv->details;
#line 150 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_box_pack_start ((GtkBox*) _tmp11_, (GtkWidget*) _tmp12_, FALSE, FALSE, (guint) 0);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp13_ = self->priv->_id_card;
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp14_ = id_card_is_no_identity (_tmp13_);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	if (!_tmp14_) {
#line 546 "moonshot-idcard-widget.c"
		gchar* upper_details_text = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		IdCard* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		IdCard* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		IdCard* _tmp35_ = NULL;
		TrustAnchor* _tmp36_ = NULL;
		TrustAnchor* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		GtkLabel* upper_details = NULL;
		const gchar* _tmp44_ = NULL;
		GtkLabel* _tmp45_ = NULL;
		GtkLabel* _tmp46_ = NULL;
		GtkVBox* _tmp47_ = NULL;
		GtkLabel* _tmp48_ = NULL;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp15_ = _ ("Username");
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp16_ = g_strconcat (_tmp15_, ":  ", NULL);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp17_ = _tmp16_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp18_ = id_card;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp19_ = id_card_get_username (_tmp18_);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp20_ = _tmp19_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp21_ = g_strconcat (_tmp17_, _tmp20_, NULL);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp22_ = _tmp21_;
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_g_free0 (_tmp17_);
#line 153 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		upper_details_text = _tmp22_;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp23_ = upper_details_text;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp24_ = _ ("Realm:");
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp25_ = g_strconcat ("\n", _tmp24_, NULL);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp26_ = _tmp25_;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp27_ = g_strconcat (_tmp26_, "  ", NULL);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp28_ = _tmp27_;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp29_ = id_card;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp30_ = id_card_get_issuer (_tmp29_);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp31_ = _tmp30_;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp32_ = g_strconcat (_tmp28_, _tmp31_, NULL);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp33_ = _tmp32_;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp34_ = g_strconcat (_tmp23_, _tmp33_, NULL);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_g_free0 (upper_details_text);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		upper_details_text = _tmp34_;
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_g_free0 (_tmp33_);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_g_free0 (_tmp28_);
#line 154 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_g_free0 (_tmp26_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp35_ = id_card;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp36_ = id_card_get_trust_anchor (_tmp35_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp37_ = _tmp36_;
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp38_ = trust_anchor_is_empty (_tmp37_);
#line 155 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		if (!_tmp38_) {
#line 642 "moonshot-idcard-widget.c"
			const gchar* _tmp39_ = NULL;
			const gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			_tmp39_ = upper_details_text;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			_tmp40_ = _ ("Trust anchor: Enterprise provisioned");
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			_tmp41_ = g_strconcat ("\n", _tmp40_, NULL);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			_tmp42_ = _tmp41_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			_g_free0 (upper_details_text);
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			upper_details_text = _tmp43_;
#line 156 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
			_g_free0 (_tmp42_);
#line 664 "moonshot-idcard-widget.c"
		}
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp44_ = upper_details_text;
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp45_ = (GtkLabel*) gtk_label_new (_tmp44_);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		g_object_ref_sink (_tmp45_);
#line 158 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		upper_details = _tmp45_;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp46_ = upper_details;
#line 159 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		gtk_misc_set_alignment ((GtkMisc*) _tmp46_, (gfloat) 0, (gfloat) 0);
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp47_ = self->priv->details;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp48_ = upper_details;
#line 160 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		gtk_box_pack_start ((GtkBox*) _tmp47_, (GtkWidget*) _tmp48_, TRUE, TRUE, (guint) 0);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_g_object_unref0 (upper_details);
#line 152 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_g_free0 (upper_details_text);
#line 688 "moonshot-idcard-widget.c"
	}
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp49_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp49_);
#line 162 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	services_hbox = _tmp49_;
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp50_ = _ ("Services: ");
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp51_ = (GtkLabel*) gtk_label_new (_tmp50_);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp51_);
#line 163 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	services_label = _tmp51_;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp52_ = services_label;
#line 164 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp52_, (gfloat) 0, (gfloat) 0);
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp53_ = self->priv->_id_card;
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp54_ = id_card_get_services_string (_tmp53_, "\n");
#line 166 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	services_text = _tmp54_;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp55_ = services_text;
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp56_ = (GtkLabel*) gtk_label_new (_tmp55_);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp56_);
#line 167 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	service_list = _tmp56_;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp57_ = service_list;
#line 168 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp57_, (gfloat) 0, (gfloat) 0);
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp58_ = service_list;
#line 169 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_label_set_ellipsize (_tmp58_, PANGO_ELLIPSIZE_END);
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp59_ = service_list;
#line 170 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_label_set_max_width_chars (_tmp59_, 50);
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp60_ = services_hbox;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp61_ = services_label;
#line 171 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_box_pack_start ((GtkBox*) _tmp60_, (GtkWidget*) _tmp61_, FALSE, FALSE, (guint) 0);
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp62_ = services_hbox;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp63_ = service_list;
#line 172 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_box_pack_start ((GtkBox*) _tmp62_, (GtkWidget*) _tmp63_, FALSE, FALSE, (guint) 0);
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp64_ = self->priv->details;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp65_ = services_hbox;
#line 173 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_box_pack_start ((GtkBox*) _tmp64_, (GtkWidget*) _tmp65_, TRUE, TRUE, (guint) 0);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp66_ = (GtkHBox*) gtk_hbox_new (FALSE, 6);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp66_);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->hbox);
#line 175 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->hbox = _tmp66_;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp67_ = id_card;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp68_ = get_pixbuf (_tmp67_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp69_ = _tmp68_;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp70_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp69_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp70_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp71_ = _tmp70_;
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (_tmp69_);
#line 176 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	image = _tmp71_;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp72_ = self->priv->_id_card;
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp73_ = id_card_is_no_identity (_tmp72_);
#line 177 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	if (_tmp73_) {
#line 782 "moonshot-idcard-widget.c"
		GtkImage* _tmp74_ = NULL;
		GtkImage* _tmp75_ = NULL;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp74_ = image;
#line 178 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		gtk_image_clear (_tmp74_);
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		_tmp75_ = image;
#line 180 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		gtk_misc_set_padding ((GtkMisc*) _tmp75_, 24, 24);
#line 793 "moonshot-idcard-widget.c"
	}
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp76_ = self->priv->hbox;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp77_ = image;
#line 182 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_box_pack_start ((GtkBox*) _tmp76_, (GtkWidget*) _tmp77_, FALSE, FALSE, (guint) 0);
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp78_ = self->priv->hbox;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp79_ = details_wrapper;
#line 183 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_box_pack_start ((GtkBox*) _tmp78_, (GtkWidget*) _tmp79_, TRUE, TRUE, (guint) 0);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp80_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_RIGHT, ID_CARD_WIDGET_ARROW_SHADOW);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp80_);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->arrow);
#line 184 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->arrow = _tmp80_;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp81_ = self->priv->arrow;
#line 185 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_misc_set_alignment ((GtkMisc*) _tmp81_, (gfloat) 0.5, (gfloat) 0);
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp82_ = self->priv->hbox;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp83_ = self->priv->arrow;
#line 186 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_box_pack_start ((GtkBox*) _tmp82_, (GtkWidget*) _tmp83_, FALSE, FALSE, (guint) 0);
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp84_ = (GtkVBox*) gtk_vbox_new (FALSE, 12);
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp84_);
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 188 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->main_vbox = _tmp84_;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp85_ = self->priv->main_vbox;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp86_ = self->priv->hbox;
#line 189 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_box_pack_start ((GtkBox*) _tmp85_, (GtkWidget*) _tmp86_, TRUE, TRUE, (guint) 0);
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp87_ = self->priv->main_vbox;
#line 190 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp87_, (guint) 12);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp88_ = (GtkEventBox*) gtk_event_box_new ();
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_ref_sink (_tmp88_);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->event_box);
#line 192 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->event_box = _tmp88_;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp89_ = self->priv->event_box;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp90_ = self->priv->main_vbox;
#line 193 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_container_add ((GtkContainer*) _tmp89_, (GtkWidget*) _tmp90_);
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp91_ = self->priv->event_box;
#line 194 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_signal_connect_object ((GtkWidget*) _tmp91_, "button-press-event", (GCallback) _id_card_widget_button_press_cb_gtk_widget_button_press_event, self, 0);
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp92_ = self->priv->event_box;
#line 195 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp92_, FALSE);
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp93_ = self->priv->event_box;
#line 196 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp93_, TRUE, TRUE, (guint) 0);
#line 198 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp94_ = self->priv->details;
#line 199 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	gtk_widget_hide ((GtkWidget*) _tmp94_);
#line 201 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	id_card_widget_set_idcard_color (self);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (image);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (service_list);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_free0 (services_text);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (services_label);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (services_hbox);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (details_wrapper);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (display_name_label);
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	return self;
#line 893 "moonshot-idcard-widget.c"
}


IdCardWidget* id_card_widget_new (IdCard* id_card, IdentityManagerView* manager_view) {
#line 137 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	return id_card_widget_construct (TYPE_ID_CARD_WIDGET, id_card, manager_view);
#line 900 "moonshot-idcard-widget.c"
}


IdCard* id_card_widget_get_id_card (IdCardWidget* self) {
	IdCard* result;
	IdCard* _tmp0_ = NULL;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp0_ = self->priv->_id_card;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	result = _tmp0_;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	return result;
#line 915 "moonshot-idcard-widget.c"
}


void id_card_widget_set_id_card (IdCardWidget* self, IdCard* value) {
	IdCard* _tmp0_ = NULL;
	IdCard* _tmp1_ = NULL;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp0_ = value;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->_id_card);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->_id_card = _tmp1_;
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_notify ((GObject *) self, "id-card");
#line 934 "moonshot-idcard-widget.c"
}


gint id_card_widget_get_position (IdCardWidget* self) {
	gint result;
	gint _tmp0_ = 0;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp0_ = self->_position;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	result = _tmp0_;
#line 53 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	return result;
#line 949 "moonshot-idcard-widget.c"
}


void id_card_widget_set_position (IdCardWidget* self, gint value) {
	gint _tmp0_ = 0;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_tmp0_ = value;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->_position = _tmp0_;
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	id_card_widget_set_idcard_color (self);
#line 54 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_notify ((GObject *) self, "position");
#line 965 "moonshot-idcard-widget.c"
}


static void id_card_widget_class_init (IdCardWidgetClass * klass) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	id_card_widget_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_type_class_add_private (klass, sizeof (IdCardWidgetPrivate));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_id_card_widget_get_property;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_id_card_widget_set_property;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	G_OBJECT_CLASS (klass)->finalize = id_card_widget_finalize;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_WIDGET_ID_CARD, g_param_spec_object ("id-card", "id-card", "id-card", TYPE_ID_CARD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ID_CARD_WIDGET_POSITION, g_param_spec_int ("position", "position", "position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_signal_new ("expanded", TYPE_ID_CARD_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	g_signal_new ("collapsed", TYPE_ID_CARD_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 988 "moonshot-idcard-widget.c"
}


static void id_card_widget_instance_init (IdCardWidget * self) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv = ID_CARD_WIDGET_GET_PRIVATE (self);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->_id_card = NULL;
#line 46 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->priv->is_selected = FALSE;
#line 51 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self->_position = 0;
#line 1001 "moonshot-idcard-widget.c"
}


static void id_card_widget_finalize (GObject* obj) {
	IdCardWidget * self;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ID_CARD_WIDGET, IdCardWidget);
#line 40 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->manager_view);
#line 42 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->_id_card);
#line 43 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->main_vbox);
#line 44 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->hbox);
#line 45 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->event_box);
#line 47 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->arrow);
#line 49 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	_g_object_unref0 (self->priv->details);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	G_OBJECT_CLASS (id_card_widget_parent_class)->finalize (obj);
#line 1025 "moonshot-idcard-widget.c"
}


GType id_card_widget_get_type (void) {
	static volatile gsize id_card_widget_type_id__volatile = 0;
	if (g_once_init_enter (&id_card_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IdCardWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) id_card_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IdCardWidget), 0, (GInstanceInitFunc) id_card_widget_instance_init, NULL };
		GType id_card_widget_type_id;
		id_card_widget_type_id = g_type_register_static (GTK_TYPE_BOX, "IdCardWidget", &g_define_type_info, 0);
		g_once_init_leave (&id_card_widget_type_id__volatile, id_card_widget_type_id);
	}
	return id_card_widget_type_id__volatile;
}


static void _vala_id_card_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IdCardWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ID_CARD_WIDGET, IdCardWidget);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	switch (property_id) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		case ID_CARD_WIDGET_ID_CARD:
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		g_value_set_object (value, id_card_widget_get_id_card (self));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		break;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		case ID_CARD_WIDGET_POSITION:
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		g_value_set_int (value, id_card_widget_get_position (self));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		break;
#line 1058 "moonshot-idcard-widget.c"
		default:
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		break;
#line 1064 "moonshot-idcard-widget.c"
	}
}


static void _vala_id_card_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IdCardWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ID_CARD_WIDGET, IdCardWidget);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
	switch (property_id) {
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		case ID_CARD_WIDGET_ID_CARD:
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		id_card_widget_set_id_card (self, g_value_get_object (value));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		break;
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		case ID_CARD_WIDGET_POSITION:
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		id_card_widget_set_position (self, g_value_get_int (value));
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		break;
#line 1086 "moonshot-idcard-widget.c"
		default:
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 34 "/home/hartmans/moonshot/moonshot/ui/src/moonshot-idcard-widget.vala"
		break;
#line 1092 "moonshot-idcard-widget.c"
	}
}



