/* ex: set ro ft=c:
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *
 * This file is generated automatically from 'compilers/imcc/imcc.y'
 * by tools/build/fixup_gen_file.pl.
 *
 * Any changes made here will be lost!
 *
 */
/* HEADERIZER HFILE: none */
/* HEADERIZER STOP */
/* A Bison parser, made by GNU Bison 2.5.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2011 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Copy the first part of user declarations.  */

/* Line 268 of yacc.c  */
#line 1 "compilers/imcc/imcc.y"

/*
 * imcc.y
 *
 * Intermediate Code Compiler for Parrot.
 *
 * Copyright (C) 2002 Melvin Smith <melvin.smith@mindspring.com>
 * Copyright (C) 2002-2010, Parrot Foundation.
 *
 * Grammar of the PIR language parser.
 *
 *
 */

/*

=pod

=head1 NAME

compilers/imcc/imcc.y - Intermediate Code Compiler for Parrot.

=head1 DESCRIPTION

This file contains the grammar of the PIR language parser.

=cut

*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define _PARSER
#define PARSER_MAIN
#include "imc.h"
#include "parrot/dynext.h"
#include "pmc/pmc_callcontext.h"
#include "pbc.h"
#include "parser.h"
#include "optimizer.h"
#include "instructions.h"
#include "symreg.h"

/* prevent declarations of malloc() and free() in the generated parser. */
#define YYMALLOC
#define YYFREE(Ptr) do { /* empty */; } while (YYID (0))

#ifndef YYENABLE_NLS
#  define YYENABLE_NLS 0
#endif

#ifndef YYLTYPE_IS_TRIVIAL
#  define YYLTYPE_IS_TRIVIAL 0
#endif

/* HEADERIZER HFILE: compilers/imcc/imc.h */

/* HEADERIZER BEGIN: static */
/* Don't modify between HEADERIZER BEGIN / HEADERIZER END.  Your changes will be lost. */

static void add_pcc_named_arg(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *cur_call),
    ARGMOD(SymReg *name),
    ARGMOD(SymReg *value))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*cur_call)
        FUNC_MODIFIES(*name)
        FUNC_MODIFIES(*value);

static void add_pcc_named_arg_var(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *cur_call),
    ARGMOD(SymReg *name),
    ARGMOD(SymReg *value))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*cur_call)
        FUNC_MODIFIES(*name)
        FUNC_MODIFIES(*value);

static void add_pcc_named_param(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *cur_call),
    ARGMOD(SymReg *name),
    ARGMOD(SymReg *value))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*cur_call)
        FUNC_MODIFIES(*name)
        FUNC_MODIFIES(*value);

static void add_pcc_named_result(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *cur_call),
    ARGMOD(SymReg *name),
    ARGMOD(SymReg *value))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*cur_call)
        FUNC_MODIFIES(*name)
        FUNC_MODIFIES(*value);

static void add_pcc_named_return(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *cur_call),
    ARGMOD(SymReg *name),
    ARGMOD(SymReg *value))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*cur_call)
        FUNC_MODIFIES(*name)
        FUNC_MODIFIES(*value);

static void adv_named_set(ARGMOD(imc_info_t *imcc), ARGIN(const char *name))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*imcc);

static void adv_named_set_u(
    ARGMOD(imc_info_t *imcc),
    ARGIN(const char *name))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*imcc);

static void begin_return_or_yield(ARGMOD(imc_info_t *imcc), int yield)
        __attribute__nonnull__(1)
        FUNC_MODIFIES(*imcc);

static void clear_state(ARGMOD(imc_info_t *imcc))
        __attribute__nonnull__(1)
        FUNC_MODIFIES(*imcc);

static void do_loadlib(ARGMOD(imc_info_t *imcc), ARGIN(const char *lib))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*imcc);

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction* func_ins(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(IMC_Unit *unit),
    ARGIN(SymReg *lhs),
    ARGIN(const char *op),
    ARGMOD(SymReg **r),
    int n,
    int keyv,
    int emit)
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        __attribute__nonnull__(5)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit)
        FUNC_MODIFIES(*r);

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction * iINDEXFETCH(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(IMC_Unit *unit),
    ARGIN(SymReg *r0),
    ARGIN(SymReg *r1),
    ARGIN(SymReg *r2))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        __attribute__nonnull__(5)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit);

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction * iINDEXSET(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(IMC_Unit *unit),
    ARGIN(SymReg *r0),
    ARGIN(SymReg *r1),
    ARGIN(SymReg *r2))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        __attribute__nonnull__(5)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit);

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static Instruction * iLABEL(
    ARGMOD(imc_info_t *imcc),
    ARGMOD_NULLOK(IMC_Unit *unit),
    ARGMOD(SymReg *r0))
        __attribute__nonnull__(1)
        __attribute__nonnull__(3)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit)
        FUNC_MODIFIES(*r0);

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static const char * inv_op(ARGIN(const char *op))
        __attribute__nonnull__(1);

PARROT_IGNORABLE_RESULT
PARROT_CANNOT_RETURN_NULL
static Instruction * iSUBROUTINE(
    ARGMOD(imc_info_t *imcc),
    ARGMOD_NULLOK(IMC_Unit *unit),
    ARGMOD(SymReg *r))
        __attribute__nonnull__(1)
        __attribute__nonnull__(3)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit)
        FUNC_MODIFIES(*r);

PARROT_IGNORABLE_RESULT
PARROT_CAN_RETURN_NULL
static Instruction * MK_I(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(IMC_Unit *unit),
    ARGIN(const char *fmt),
    int n,
    ...)
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit);

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction* mk_pmc_const_named(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(IMC_Unit *unit),
    ARGIN(const char *name),
    ARGMOD(SymReg *left),
    ARGIN(const char *constant))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        __attribute__nonnull__(4)
        __attribute__nonnull__(5)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*unit)
        FUNC_MODIFIES(*left);

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static SymReg * mk_sub_address_fromc(
    ARGMOD(imc_info_t *imcc),
    ARGIN(const char *name))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*imcc);

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static SymReg * mk_sub_address_u(
    ARGMOD(imc_info_t *imcc),
    ARGIN(const char *name))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        FUNC_MODIFIES(*imcc);

static void set_lexical(
    ARGMOD(imc_info_t *imcc),
    ARGMOD(SymReg *r),
    ARGMOD(SymReg *name))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        FUNC_MODIFIES(*imcc)
        FUNC_MODIFIES(*r)
        FUNC_MODIFIES(*name);

#define ASSERT_ARGS_add_pcc_named_arg __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(cur_call) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(value))
#define ASSERT_ARGS_add_pcc_named_arg_var __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(cur_call) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(value))
#define ASSERT_ARGS_add_pcc_named_param __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(cur_call) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(value))
#define ASSERT_ARGS_add_pcc_named_result __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(cur_call) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(value))
#define ASSERT_ARGS_add_pcc_named_return __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(cur_call) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(value))
#define ASSERT_ARGS_adv_named_set __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(name))
#define ASSERT_ARGS_adv_named_set_u __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(name))
#define ASSERT_ARGS_begin_return_or_yield __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc))
#define ASSERT_ARGS_clear_state __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc))
#define ASSERT_ARGS_do_loadlib __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(lib))
#define ASSERT_ARGS_func_ins __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(unit) \
    , PARROT_ASSERT_ARG(lhs) \
    , PARROT_ASSERT_ARG(op) \
    , PARROT_ASSERT_ARG(r))
#define ASSERT_ARGS_iINDEXFETCH __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(unit) \
    , PARROT_ASSERT_ARG(r0) \
    , PARROT_ASSERT_ARG(r1) \
    , PARROT_ASSERT_ARG(r2))
#define ASSERT_ARGS_iINDEXSET __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(unit) \
    , PARROT_ASSERT_ARG(r0) \
    , PARROT_ASSERT_ARG(r1) \
    , PARROT_ASSERT_ARG(r2))
#define ASSERT_ARGS_iLABEL __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(r0))
#define ASSERT_ARGS_inv_op __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(op))
#define ASSERT_ARGS_iSUBROUTINE __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(r))
#define ASSERT_ARGS_MK_I __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(unit) \
    , PARROT_ASSERT_ARG(fmt))
#define ASSERT_ARGS_mk_pmc_const_named __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(unit) \
    , PARROT_ASSERT_ARG(name) \
    , PARROT_ASSERT_ARG(left) \
    , PARROT_ASSERT_ARG(constant))
#define ASSERT_ARGS_mk_sub_address_fromc __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(name))
#define ASSERT_ARGS_mk_sub_address_u __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(name))
#define ASSERT_ARGS_set_lexical __attribute__unused__ int _ASSERT_ARGS_CHECK = (\
       PARROT_ASSERT_ARG(imcc) \
    , PARROT_ASSERT_ARG(r) \
    , PARROT_ASSERT_ARG(name))
/* Don't modify between HEADERIZER BEGIN / HEADERIZER END.  Your changes will be lost. */
/* HEADERIZER END: static */


#define YYDEBUG 1
#define YYERROR_VERBOSE 1

/* Warning: parser is probably not reentrant */

/*
 * Choosing instructions for Parrot is pretty easy since many are
 * polymorphic.
 */


/*

=over 4

=item C<static Instruction * MK_I(imc_info_t *imcc, IMC_Unit *unit, const char
*fmt, int n, ...)>

build and emitb instruction by INS. fmt may contain:

  op %s, %s # comment

or just

  op

NOTE: Most usage of this function is with
imcc->cur_unit, but there are some
exceptions. Thus, we can't easily factorize that piece of
code.

=cut

 */

PARROT_IGNORABLE_RESULT
PARROT_CAN_RETURN_NULL
static Instruction *
MK_I(ARGMOD(imc_info_t *imcc), ARGMOD(IMC_Unit *unit), ARGIN(const char *fmt), int n, ...)
{
    ASSERT_ARGS(MK_I)
    char opname[64];
    char *p;
    const char *q;
    va_list ap;
    SymReg *r[IMCC_MAX_FIX_REGS];
    int i;

    for (p = opname, q = fmt; *q && *q != ' ';)
        *p++ = *q++;
    *p = '\0';
    if (!*q)
        fmt = NULL;
    else
        fmt = ++q;
#ifdef OPDEBUG
    fprintf(stderr, "op '%s' format '%s' (%d)\n", opname, fmt?:"", n);
#endif
    va_start(ap, n);
    i = 0;
    for (i = 0; i < n; ++i) {
        r[i] = va_arg(ap, SymReg *);
    }
    va_end(ap);
    return INS(imcc, unit, opname, fmt, r, n, imcc->keyvec, 1);
}

/*

=item C<static Instruction* mk_pmc_const_named(imc_info_t *imcc, IMC_Unit *unit,
const char *name, SymReg *left, const char *constant)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction*
mk_pmc_const_named(ARGMOD(imc_info_t *imcc), ARGMOD(IMC_Unit *unit),
    ARGIN(const char *name), ARGMOD(SymReg *left), ARGIN(const char *constant))
{
    ASSERT_ARGS(mk_pmc_const_named)
    SymReg *rhs;
    SymReg *r[3];
    char   *const_name;
    const int ascii       = (*constant == '\'' || *constant == '"');
    char   *unquoted_name = mem_sys_strdup(name + 1);
    size_t  name_length   = strlen(unquoted_name) - 1;

    unquoted_name[name_length] = 0;

    if (left->type == VTADDRESS) {      /* IDENTIFIER */
        if (imcc->state->pasm_file) {
            IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                        "Ident as PMC constant",
                        " %s\n", left->name);
        }
        left->type = VTIDENTIFIER;
        left->set = 'P';
    }
    r[0] = left;
    if (ascii) {
        /* strip delimiters */
        const_name = mem_sys_strdup(constant + 1);
        const_name[strlen(const_name) - 1] = 0;
    }
    else {
        const_name = mem_sys_strdup(constant);
    }

    if ((strncmp(unquoted_name, "Sub",       name_length) == 0)
    ||  (strncmp(unquoted_name, "Coroutine", name_length) == 0)) {
        rhs = mk_const(imcc, const_name, 'p');

        if (!ascii)
            rhs->type |= VT_ENCODED;

        rhs->usage    |= U_FIXUP | U_SUBID_LOOKUP;
    }
    else if (strncmp(unquoted_name, "LexInfo", name_length) == 0) {
        rhs = mk_const(imcc, const_name, 'l');
        if (!ascii)
            rhs->type |= VT_ENCODED;
        rhs->usage    |= U_FIXUP | U_LEXINFO_LOOKUP;
    }
    else {
        rhs = mk_const(imcc, const_name, 'P');
    }

    r[1]          = rhs;
    rhs->pmc_type = Parrot_pmc_get_type_str(imcc->interp,
        Parrot_str_new(imcc->interp, unquoted_name, name_length));

    mem_sys_free(unquoted_name);
    mem_sys_free(const_name);

    return INS(imcc, unit, "set_p_pc", "", r, 2, 0, 1);
}

/*

=item C<static Instruction* func_ins(imc_info_t *imcc, IMC_Unit *unit, SymReg
*lhs, const char *op, SymReg **r, int n, int keyv, int emit)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction*
func_ins(ARGMOD(imc_info_t *imcc), ARGMOD(IMC_Unit *unit), ARGIN(SymReg *lhs),
        ARGIN(const char *op), ARGMOD(SymReg **r), int n, int keyv, int emit)
{
    ASSERT_ARGS(func_ins)
    int i;
    /* shift regs up by 1 */
    for (i = n - 1; i >= 0; --i)
        r[i+1] = r[i];
    r[0] = lhs;
    /* shift keyvec */
    keyv <<= 1;
    return INS(imcc, unit, op, "", r, n+1, keyv, emit);
}

/*

=item C<static void clear_state(imc_info_t *imcc)>

=cut

*/

static void
clear_state(ARGMOD(imc_info_t *imcc))
{
    ASSERT_ARGS(clear_state)
    imcc -> nargs = 0;
    imcc -> keyvec = 0;
}

/*

=item C<Instruction * INS_LABEL(imc_info_t *imcc, IMC_Unit *unit, SymReg *r0,
int emit)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
Instruction *
INS_LABEL(ARGMOD(imc_info_t *imcc), ARGMOD_NULLOK(IMC_Unit *unit),
        ARGMOD(SymReg *r0), int emit)
{
    ASSERT_ARGS(INS_LABEL)

    Instruction * const ins = _mk_instruction("", "%s:", 1, &r0, 0);
    ins->type               = ITLABEL;
    r0->first_ins           = ins;

    if (emit)
        emitb(imcc, unit, ins);

    return ins;
}

/*

=item C<static Instruction * iLABEL(imc_info_t *imcc, IMC_Unit *unit, SymReg
*r0)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static Instruction *
iLABEL(ARGMOD(imc_info_t *imcc), ARGMOD_NULLOK(IMC_Unit *unit),
        ARGMOD(SymReg *r0))
{
    ASSERT_ARGS(iLABEL)
    Instruction * const i = INS_LABEL(imcc, unit, r0, 1);
    i->line               = imcc->line;

    clear_state(imcc);
    return i;
}

/*

=item C<static Instruction * iSUBROUTINE(imc_info_t *imcc, IMC_Unit *unit,
SymReg *r)>

=cut

*/

PARROT_IGNORABLE_RESULT
PARROT_CANNOT_RETURN_NULL
static Instruction *
iSUBROUTINE(ARGMOD(imc_info_t *imcc), ARGMOD_NULLOK(IMC_Unit *unit), ARGMOD(SymReg *r))
{
    ASSERT_ARGS(iSUBROUTINE)
    Instruction * const i = iLABEL(imcc, unit, r);
    i->type              |= ITPCCPARAM;

    r->type    = (r->type & VT_ENCODED) ? VT_PCC_SUB|VT_ENCODED : VT_PCC_SUB;
    r->pcc_sub = mem_gc_allocate_zeroed_typed(imcc->interp, pcc_sub_t);

    imcc->cur_call = r;
    i->line = imcc->line;

    add_namespace(imcc, unit);
    return i;
}

/*

=item C<static Instruction * iINDEXFETCH(imc_info_t *imcc, IMC_Unit *unit,
SymReg *r0, SymReg *r1, SymReg *r2)>

substr or X = P[key]

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction *
iINDEXFETCH(ARGMOD(imc_info_t *imcc), ARGMOD(IMC_Unit *unit), ARGIN(SymReg *r0),
        ARGIN(SymReg *r1), ARGIN(SymReg *r2))
{
    ASSERT_ARGS(iINDEXFETCH)
    imcc -> keyvec |= KEY_BIT(2);
    return MK_I(imcc, unit, "set %s, %s[%s]", 3, r0, r1, r2);
}

/*

=item C<static Instruction * iINDEXSET(imc_info_t *imcc, IMC_Unit *unit, SymReg
*r0, SymReg *r1, SymReg *r2)>

substr or P[key] = X

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static Instruction *
iINDEXSET(ARGMOD(imc_info_t *imcc), ARGMOD(IMC_Unit *unit), ARGIN(SymReg *r0),
        ARGIN(SymReg *r1), ARGIN(SymReg *r2))
{
    ASSERT_ARGS(iINDEXSET)
    if (r0->set == 'P') {
        imcc->keyvec |= KEY_BIT(1);
        MK_I(imcc, unit, "set %s[%s], %s", 3, r0, r1, r2);
    }
    else
        IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
            "unsupported indexed set op\n");

    return NULL;
}

/*

=item C<static const char * inv_op(const char *op)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CAN_RETURN_NULL
static const char *
inv_op(ARGIN(const char *op))
{
    ASSERT_ARGS(inv_op)
    int n;
    return get_neg_op(op, &n);
}

/*

=item C<Instruction * IMCC_create_itcall_label(imc_info_t *imcc)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
Instruction *
IMCC_create_itcall_label(ARGMOD(imc_info_t *imcc))
{
    ASSERT_ARGS(IMCC_create_itcall_label)
    char         name[128];
    SymReg      *r;
    Instruction *i;

    snprintf(name, sizeof (name), "%cpcc_sub_call_%d", IMCC_INTERNAL_CHAR,
        imcc->cnr++);

    r       = mk_pcc_sub(imcc, name, 0);
    i       = iLABEL(imcc, imcc->cur_unit, r);
    i->type = ITCALL | ITPCCSUB;

    imcc->cur_call = r;

    return i;
}

/*

=item C<static SymReg * mk_sub_address_fromc(imc_info_t *imcc, const char
*name)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static SymReg *
mk_sub_address_fromc(ARGMOD(imc_info_t *imcc), ARGIN(const char *name))
{
    ASSERT_ARGS(mk_sub_address_fromc)
    /* name is a quoted sub name */
    SymReg *r;
    char   *name_copy;

    /* interpolate only if the first character is a double-quote */
    if (*name == '"') {
        STRING *unescaped = Parrot_str_unescape(imcc->interp, name, '"', NULL);
        name_copy         = Parrot_str_to_cstring(imcc->interp, unescaped);
    }
    else {
        name_copy = mem_sys_strdup(name);
        name_copy[strlen(name) - 1] = 0;
    }

    r = mk_sub_address(imcc, name_copy + 1);
    mem_sys_free(name_copy);

    return r;
}

/*

=item C<static SymReg * mk_sub_address_u(imc_info_t *imcc, const char *name)>

=cut

*/

PARROT_WARN_UNUSED_RESULT
PARROT_CANNOT_RETURN_NULL
static SymReg *
mk_sub_address_u(ARGMOD(imc_info_t *imcc), ARGIN(const char *name))
{
    ASSERT_ARGS(mk_sub_address_u)
    SymReg * const r = mk_sub_address(imcc, name);
    r->type         |= VT_ENCODED;

    return r;
}

/*

=item C<void IMCC_itcall_sub(imc_info_t *imcc, SymReg *sub)>

=cut

*/

void
IMCC_itcall_sub(ARGMOD(imc_info_t *imcc), ARGIN(SymReg *sub))
{
    ASSERT_ARGS(IMCC_itcall_sub)
    imcc->cur_call->pcc_sub->sub = sub;

    if (imcc->cur_obj) {
        if (imcc->cur_obj->set != 'P')
            IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR, "object isn't a PMC");

        imcc->cur_call->pcc_sub->object = imcc->cur_obj;
        imcc->cur_obj = NULL;
    }
}


/*

=item C<static void begin_return_or_yield(imc_info_t *imcc, int yield)>

=cut

*/

static void
begin_return_or_yield(ARGMOD(imc_info_t *imcc), int yield)
{
    ASSERT_ARGS(begin_return_or_yield)
    Instruction *i;
    Instruction * const ins = imcc->cur_unit->instructions;
    char                name[128];

    if (!ins || !ins->symregs[0] || !(ins->symregs[0]->type & VT_PCC_SUB))
        IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                    "yield or return directive outside pcc subroutine\n");
    ins->symregs[0]->pcc_sub->yield = yield;
    snprintf(name, sizeof (name), yield ? "%cpcc_sub_yield_%d" : "%cpcc_sub_ret_%d",
            IMCC_INTERNAL_CHAR, imcc->cnr++);
    imcc->sr_return = mk_pcc_sub(imcc, name, 0);
    i = iLABEL(imcc, imcc->cur_unit, imcc->sr_return);
    i->type = yield ? ITPCCSUB | ITLABEL | ITPCCYIELD : ITPCCSUB | ITLABEL ;
    imcc->asm_state = yield ? AsmInYield : AsmInReturn;
}

/*

=item C<static void set_lexical(imc_info_t *imcc, SymReg *r, SymReg *name)>

=cut

*/

static void
set_lexical(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *r), ARGMOD(SymReg *name))
{
    ASSERT_ARGS(set_lexical)

    r->usage |= U_LEXICAL;

    if (name == r->reg)
        IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
            "register %s already declared as lexical %s", r->name, name->name);

    /* chain all names in r->reg */
    name->reg    = r->reg;
    r->reg       = name;
    name->usage |= U_LEXICAL;
    r->use_count++;
}


/*

=item C<static void add_pcc_named_arg(imc_info_t *imcc, SymReg *cur_call, SymReg
*name, SymReg *value)>

=cut

*/

static void
add_pcc_named_arg(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *cur_call),
        ARGMOD(SymReg *name), ARGMOD(SymReg *value))
{
    ASSERT_ARGS(add_pcc_named_arg)
    name->type  |= VT_NAMED;

    add_pcc_arg(imcc, cur_call, name);
    add_pcc_arg(imcc, cur_call, value);
}

/*

=item C<static void add_pcc_named_arg_var(imc_info_t *imcc, SymReg *cur_call,
SymReg *name, SymReg *value)>

=cut

*/

static void
add_pcc_named_arg_var(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *cur_call),
        ARGMOD(SymReg *name), ARGMOD(SymReg *value))
{
    ASSERT_ARGS(add_pcc_named_arg_var)
    name->type |= VT_NAMED;
    add_pcc_arg(imcc, cur_call, name);
    add_pcc_arg(imcc, cur_call, value);
}

/*

=item C<static void add_pcc_named_result(imc_info_t *imcc, SymReg *cur_call,
SymReg *name, SymReg *value)>

=cut

*/

static void
add_pcc_named_result(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *cur_call),
        ARGMOD(SymReg *name), ARGMOD(SymReg *value))
{
    ASSERT_ARGS(add_pcc_named_result)
    name->type |= VT_NAMED;

    add_pcc_result(imcc, cur_call, name);
    add_pcc_result(imcc, cur_call, value);
}

/*

=item C<static void add_pcc_named_param(imc_info_t *imcc, SymReg *cur_call,
SymReg *name, SymReg *value)>

=cut

*/

static void
add_pcc_named_param(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *cur_call),
        ARGMOD(SymReg *name), ARGMOD(SymReg *value))
{
    ASSERT_ARGS(add_pcc_named_param)
    name->type |= VT_NAMED;

    add_pcc_arg(imcc, cur_call, name);
    add_pcc_arg(imcc, cur_call, value);
}

/*

=item C<static void add_pcc_named_return(imc_info_t *imcc, SymReg *cur_call,
SymReg *name, SymReg *value)>

=cut

*/

static void
add_pcc_named_return(ARGMOD(imc_info_t *imcc), ARGMOD(SymReg *cur_call),
        ARGMOD(SymReg *name), ARGMOD(SymReg *value))
{
    ASSERT_ARGS(add_pcc_named_return)
    name->type |= VT_NAMED;

    add_pcc_result(imcc, cur_call, name);
    add_pcc_result(imcc, cur_call, value);
}

/*

=item C<static void adv_named_set(imc_info_t *imcc, const char *name)>

=item C<static void adv_named_set_u(imc_info_t *imcc, const char *name)>

Sets the name of the current named argument.

C<adv_named_set_u> is the Unicode version of this function.

=cut

*/

static void
adv_named_set(ARGMOD(imc_info_t *imcc), ARGIN(const char *name))
{
    ASSERT_ARGS(adv_named_set)
    if (imcc->adv_named_id)
        IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                    "Named parameter with more than one name.\n");

    imcc->adv_named_id = mk_const(imcc, name, 'S');
}

static void
adv_named_set_u(ARGMOD(imc_info_t *imcc), ARGIN(const char *name))
{
    ASSERT_ARGS(adv_named_set_u)
    if (imcc->adv_named_id)
        IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                    "Named parameter with more than one name.\n");

    imcc->adv_named_id = mk_const(imcc, name, 'U');
}

/*

=item C<static void do_loadlib(imc_info_t *imcc, const char *lib)>

=cut

*/

static void
do_loadlib(ARGMOD(imc_info_t *imcc), ARGIN(const char *lib))
{
    ASSERT_ARGS(do_loadlib)
    STRING * const s = Parrot_str_unescape(imcc->interp, lib + 1, '"', NULL);
    PMC    * const lib_pmc = Parrot_dyn_load_lib(imcc->interp, s, NULL);
    if (PMC_IS_NULL(lib_pmc) || !VTABLE_get_bool(imcc->interp, lib_pmc)) {
        IMCC_fataly(imcc, EXCEPTION_LIBRARY_ERROR,
            "loadlib directive could not find library `%S'", s);
    }

    /* store non-dynoplib library deps here, dynoplibs are treated separately for now */
    /* TODO: This is very ugly and heavily nested. Can we avoid this? */
    if (!STRING_equal(imcc->interp,
            VTABLE_get_string(imcc->interp,
                Parrot_pmc_getprop(imcc->interp, lib_pmc,
                    Parrot_str_new_constant(imcc->interp, "_type"))),
            Parrot_str_new_constant(imcc->interp, "Ops")))
        imcc_pbc_add_libdep(imcc, s);
}

/* HEADERIZER STOP */



/* Line 268 of yacc.c  */
#line 1103 "compilers/imcc/imcparser.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     LOW_PREC = 258,
     PARAM = 259,
     SOL = 260,
     HLL = 261,
     GOTO = 262,
     ARG = 263,
     IF = 264,
     UNLESS = 265,
     PNULL = 266,
     SET_RETURN = 267,
     SET_YIELD = 268,
     ADV_FLAT = 269,
     ADV_SLURPY = 270,
     ADV_OPTIONAL = 271,
     ADV_OPT_FLAG = 272,
     ADV_NAMED = 273,
     ADV_ARROW = 274,
     ADV_INVOCANT = 275,
     ADV_CALL_SIG = 276,
     NAMESPACE = 277,
     DOT_METHOD = 278,
     SUB = 279,
     SYM = 280,
     LOCAL = 281,
     LEXICAL = 282,
     CONST = 283,
     ANNOTATE = 284,
     GLOBAL_CONST = 285,
     PLUS_ASSIGN = 286,
     MINUS_ASSIGN = 287,
     MUL_ASSIGN = 288,
     DIV_ASSIGN = 289,
     CONCAT_ASSIGN = 290,
     BAND_ASSIGN = 291,
     BOR_ASSIGN = 292,
     BXOR_ASSIGN = 293,
     FDIV = 294,
     FDIV_ASSIGN = 295,
     MOD_ASSIGN = 296,
     SHR_ASSIGN = 297,
     SHL_ASSIGN = 298,
     SHR_U_ASSIGN = 299,
     SHIFT_LEFT = 300,
     SHIFT_RIGHT = 301,
     INTV = 302,
     FLOATV = 303,
     STRINGV = 304,
     PMCV = 305,
     LOG_XOR = 306,
     RELOP_EQ = 307,
     RELOP_NE = 308,
     RELOP_GT = 309,
     RELOP_GTE = 310,
     RELOP_LT = 311,
     RELOP_LTE = 312,
     RESULT = 313,
     RETURN = 314,
     TAILCALL = 315,
     YIELDT = 316,
     GET_RESULTS = 317,
     POW = 318,
     SHIFT_RIGHT_U = 319,
     LOG_AND = 320,
     LOG_OR = 321,
     COMMA = 322,
     ESUB = 323,
     DOTDOT = 324,
     PCC_BEGIN = 325,
     PCC_END = 326,
     PCC_CALL = 327,
     PCC_SUB = 328,
     PCC_BEGIN_RETURN = 329,
     PCC_END_RETURN = 330,
     PCC_BEGIN_YIELD = 331,
     PCC_END_YIELD = 332,
     INVOCANT = 333,
     MAIN = 334,
     LOAD = 335,
     INIT = 336,
     IMMEDIATE = 337,
     POSTCOMP = 338,
     METHOD = 339,
     ANON = 340,
     OUTER = 341,
     NEED_LEX = 342,
     MULTI = 343,
     SUBTAG = 344,
     VTABLE_METHOD = 345,
     LOADLIB = 346,
     SUB_INSTANCE_OF = 347,
     SUBID = 348,
     NS_ENTRY = 349,
     LABEL = 350,
     EMIT = 351,
     EOM = 352,
     IREG = 353,
     NREG = 354,
     SREG = 355,
     PREG = 356,
     IDENTIFIER = 357,
     REG = 358,
     MACRO = 359,
     ENDM = 360,
     STRINGC = 361,
     INTC = 362,
     FLOATC = 363,
     USTRINGC = 364,
     PARROT_OP = 365,
     VAR = 366,
     LINECOMMENT = 367,
     FILECOMMENT = 368,
     DOT = 369,
     CONCAT = 370
   };
#endif
/* Tokens.  */
#define LOW_PREC 258
#define PARAM 259
#define SOL 260
#define HLL 261
#define GOTO 262
#define ARG 263
#define IF 264
#define UNLESS 265
#define PNULL 266
#define SET_RETURN 267
#define SET_YIELD 268
#define ADV_FLAT 269
#define ADV_SLURPY 270
#define ADV_OPTIONAL 271
#define ADV_OPT_FLAG 272
#define ADV_NAMED 273
#define ADV_ARROW 274
#define ADV_INVOCANT 275
#define ADV_CALL_SIG 276
#define NAMESPACE 277
#define DOT_METHOD 278
#define SUB 279
#define SYM 280
#define LOCAL 281
#define LEXICAL 282
#define CONST 283
#define ANNOTATE 284
#define GLOBAL_CONST 285
#define PLUS_ASSIGN 286
#define MINUS_ASSIGN 287
#define MUL_ASSIGN 288
#define DIV_ASSIGN 289
#define CONCAT_ASSIGN 290
#define BAND_ASSIGN 291
#define BOR_ASSIGN 292
#define BXOR_ASSIGN 293
#define FDIV 294
#define FDIV_ASSIGN 295
#define MOD_ASSIGN 296
#define SHR_ASSIGN 297
#define SHL_ASSIGN 298
#define SHR_U_ASSIGN 299
#define SHIFT_LEFT 300
#define SHIFT_RIGHT 301
#define INTV 302
#define FLOATV 303
#define STRINGV 304
#define PMCV 305
#define LOG_XOR 306
#define RELOP_EQ 307
#define RELOP_NE 308
#define RELOP_GT 309
#define RELOP_GTE 310
#define RELOP_LT 311
#define RELOP_LTE 312
#define RESULT 313
#define RETURN 314
#define TAILCALL 315
#define YIELDT 316
#define GET_RESULTS 317
#define POW 318
#define SHIFT_RIGHT_U 319
#define LOG_AND 320
#define LOG_OR 321
#define COMMA 322
#define ESUB 323
#define DOTDOT 324
#define PCC_BEGIN 325
#define PCC_END 326
#define PCC_CALL 327
#define PCC_SUB 328
#define PCC_BEGIN_RETURN 329
#define PCC_END_RETURN 330
#define PCC_BEGIN_YIELD 331
#define PCC_END_YIELD 332
#define INVOCANT 333
#define MAIN 334
#define LOAD 335
#define INIT 336
#define IMMEDIATE 337
#define POSTCOMP 338
#define METHOD 339
#define ANON 340
#define OUTER 341
#define NEED_LEX 342
#define MULTI 343
#define SUBTAG 344
#define VTABLE_METHOD 345
#define LOADLIB 346
#define SUB_INSTANCE_OF 347
#define SUBID 348
#define NS_ENTRY 349
#define LABEL 350
#define EMIT 351
#define EOM 352
#define IREG 353
#define NREG 354
#define SREG 355
#define PREG 356
#define IDENTIFIER 357
#define REG 358
#define MACRO 359
#define ENDM 360
#define STRINGC 361
#define INTC 362
#define FLOATC 363
#define USTRINGC 364
#define PARROT_OP 365
#define VAR 366
#define LINECOMMENT 367
#define FILECOMMENT 368
#define DOT 369
#define CONCAT 370




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 293 of yacc.c  */
#line 1032 "compilers/imcc/imcc.y"

    IdList * idlist;
    int t;
    char * s;
    SymReg * sr;
    Instruction *i;



/* Line 293 of yacc.c  */
#line 1379 "compilers/imcc/imcparser.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 343 of yacc.c  */
#line 1391 "compilers/imcc/imcparser.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  26
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   616

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  132
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  128
/* YYNRULES -- Number of rules.  */
#define YYNRULES  331
/* YYNRULES -- Number of states.  */
#define YYNSTATES  521

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   370

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       4,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   123,     2,     2,     2,   129,   130,     2,
     121,   122,   127,   126,     2,   125,     2,   128,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,   120,
       2,   117,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   118,     2,   119,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   131,     2,   124,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,   111,   112,   113,   114,   115,
     116
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     7,    10,    12,    14,    16,    18,
      21,    23,    25,    28,    32,    37,    40,    41,    48,    49,
      56,    58,    60,    62,    65,    69,    72,    74,    76,    78,
      80,    82,    83,    87,    88,    93,    96,   101,   102,   104,
     105,   110,   111,   113,   117,   121,   124,   125,   128,   130,
     134,   135,   136,   137,   147,   148,   149,   155,   159,   164,
     165,   169,   171,   173,   175,   177,   179,   181,   183,   187,
     192,   196,   198,   203,   208,   210,   215,   217,   222,   224,
     229,   234,   236,   241,   242,   244,   245,   255,   256,   259,
     260,   264,   265,   267,   269,   272,   274,   276,   278,   280,
     282,   284,   286,   288,   290,   292,   294,   296,   298,   300,
     302,   308,   312,   313,   317,   320,   321,   325,   329,   330,
     335,   336,   339,   341,   343,   345,   347,   352,   357,   359,
     360,   366,   368,   369,   375,   376,   379,   383,   384,   387,
     391,   395,   399,   400,   406,   408,   410,   411,   413,   417,
     421,   427,   429,   432,   433,   435,   438,   441,   443,   445,
     447,   448,   450,   453,   455,   457,   461,   464,   466,   470,
     472,   474,   476,   477,   482,   487,   492,   493,   500,   502,
     503,   510,   513,   516,   519,   522,   524,   526,   528,   530,
     531,   533,   535,   537,   539,   543,   548,   554,   561,   568,
     572,   573,   583,   585,   587,   589,   593,   595,   597,   599,
     601,   603,   605,   607,   609,   611,   613,   615,   617,   619,
     621,   623,   625,   627,   629,   631,   633,   635,   637,   639,
     641,   643,   645,   646,   652,   656,   660,   662,   664,   666,
     668,   670,   672,   674,   676,   678,   680,   682,   684,   689,
     691,   693,   695,   697,   701,   705,   709,   713,   714,   720,
     721,   725,   727,   733,   737,   741,   744,   745,   748,   750,
     752,   754,   759,   764,   767,   771,   777,   779,   783,   784,
     786,   788,   795,   801,   806,   811,   818,   824,   826,   828,
     830,   832,   834,   836,   838,   840,   842,   844,   845,   847,
     851,   853,   855,   860,   864,   866,   868,   870,   872,   874,
     876,   878,   880,   882,   884,   886,   887,   890,   891,   894,
     896,   900,   902,   904,   906,   908,   910,   912,   914,   916,
     918,   920
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     133,     0,    -1,   134,    -1,   135,    -1,   134,   135,    -1,
     153,    -1,   139,    -1,   158,    -1,   150,    -1,   105,     4,
      -1,   136,    -1,     4,    -1,   138,     4,    -1,    92,   107,
       4,    -1,    30,   107,    68,   259,    -1,     7,   107,    -1,
      -1,    29,   140,   218,   103,   117,   259,    -1,    -1,    29,
     142,   107,   249,   117,   143,    -1,   107,    -1,   110,    -1,
     145,    -1,   144,   145,    -1,   208,   146,     4,    -1,   105,
       4,    -1,   114,    -1,   113,    -1,   153,    -1,   141,    -1,
     136,    -1,    -1,   147,   111,   149,    -1,    -1,    74,   148,
     182,    96,    -1,    12,   250,    -1,    28,   107,    68,   104,
      -1,    -1,   243,    -1,    -1,    97,   151,   152,    98,    -1,
      -1,   144,    -1,    23,   154,     4,    -1,   118,   155,   119,
      -1,   118,   119,    -1,    -1,   156,   157,    -1,   258,    -1,
     157,   120,   258,    -1,    -1,    -1,    -1,    25,   159,   246,
     160,   182,     4,   161,   177,    69,    -1,    -1,    -1,     5,
     163,   165,     4,   164,    -1,   218,   103,   191,    -1,    89,
     121,   167,   122,    -1,    -1,   167,    68,   168,    -1,   168,
      -1,    48,    -1,    49,    -1,    51,    -1,    50,    -1,   103,
      -1,   107,    -1,   118,   251,   119,    -1,    90,   121,   170,
     122,    -1,   170,    68,   107,    -1,   107,    -1,    87,   121,
     107,   122,    -1,    87,   121,   103,   122,    -1,    91,    -1,
      91,   121,   107,   122,    -1,    85,    -1,    85,   121,   143,
     122,    -1,    95,    -1,    95,   121,   143,   122,    -1,    93,
     121,   107,   122,    -1,    94,    -1,    94,   121,   143,   122,
      -1,    -1,   205,    -1,    -1,    71,     4,   179,   186,   181,
     185,   180,   188,    72,    -1,    -1,   210,     4,    -1,    -1,
      79,   250,     4,    -1,    -1,   183,    -1,   184,    -1,   183,
     184,    -1,    81,    -1,    82,    -1,    80,    -1,    83,    -1,
      84,    -1,    86,    -1,    88,    -1,   166,    -1,   169,    -1,
     171,    -1,   172,    -1,   173,    -1,   174,    -1,   175,    -1,
     176,    -1,    73,   250,    68,   250,     4,    -1,    73,   250,
       4,    -1,    -1,   186,   187,     4,    -1,     9,   232,    -1,
      -1,   188,   189,     4,    -1,    59,   242,   191,    -1,    -1,
      27,   190,   218,   213,    -1,    -1,   191,   192,    -1,    16,
      -1,    17,    -1,    18,    -1,    19,    -1,    19,   121,   107,
     122,    -1,    19,   121,   110,   122,    -1,    22,    -1,    -1,
      75,     4,   194,   197,    76,    -1,   201,    -1,    -1,    77,
       4,   196,   198,    78,    -1,    -1,   197,     4,    -1,   197,
     199,     4,    -1,    -1,   198,     4,    -1,   198,   200,     4,
      -1,    13,   250,   233,    -1,    14,   250,   233,    -1,    -1,
     203,   121,   202,   204,   122,    -1,    60,    -1,    62,    -1,
      -1,   232,    -1,   107,    20,   250,    -1,   204,    68,   232,
      -1,   204,    68,   107,    20,   250,    -1,   207,    -1,   205,
     207,    -1,    -1,   162,    -1,   206,   211,    -1,   105,     4,
      -1,   114,    -1,   113,    -1,   137,    -1,    -1,   209,    -1,
     209,   210,    -1,   210,    -1,    96,    -1,   208,   214,     4,
      -1,     1,     4,    -1,   213,    -1,   212,    68,   213,    -1,
     103,    -1,   219,    -1,   237,    -1,    -1,    27,   215,   218,
     212,    -1,    28,   107,    68,   242,    -1,    28,   110,    68,
     242,    -1,    -1,    29,   216,   218,   103,   117,   259,    -1,
     141,    -1,    -1,    31,   217,   218,   103,   117,   259,    -1,
      61,   229,    -1,     8,   248,    -1,   111,   243,    -1,    12,
     250,    -1,   229,    -1,   178,    -1,   193,    -1,   195,    -1,
      -1,    48,    -1,    49,    -1,    50,    -1,    51,    -1,   242,
     117,   250,    -1,   242,   117,   221,   250,    -1,   242,   117,
     250,   222,   250,    -1,   242,   117,   250,   118,   251,   119,
      -1,   242,   118,   251,   119,   117,   250,    -1,   242,   117,
     229,    -1,    -1,   121,   220,   236,   122,   117,   228,   121,
     231,   122,    -1,   223,    -1,   225,    -1,   227,    -1,   242,
     117,    12,    -1,   123,    -1,   124,    -1,   125,    -1,   125,
      -1,   126,    -1,   127,    -1,   128,    -1,   129,    -1,    40,
      -1,    64,    -1,   116,    -1,    53,    -1,    54,    -1,    55,
      -1,    56,    -1,    57,    -1,    58,    -1,    46,    -1,    47,
      -1,    65,    -1,    66,    -1,    67,    -1,    52,    -1,   130,
      -1,   131,    -1,   124,    -1,    -1,    63,   224,   121,   236,
     122,    -1,   242,   226,   250,    -1,   242,    36,   250,    -1,
      32,    -1,    33,    -1,    34,    -1,    35,    -1,    42,    -1,
      41,    -1,    37,    -1,    38,    -1,    39,    -1,    43,    -1,
      44,    -1,    45,    -1,   242,   117,   111,   149,    -1,   103,
      -1,   107,    -1,   110,    -1,   242,    -1,   242,   115,   247,
      -1,   242,   115,   110,    -1,   242,   115,   107,    -1,   242,
     115,   242,    -1,    -1,   228,   230,   121,   231,   122,    -1,
      -1,   231,    68,   232,    -1,   232,    -1,   231,    68,   107,
      20,   250,    -1,   250,    20,   250,    -1,   107,    20,   250,
      -1,   250,   233,    -1,    -1,   233,   234,    -1,    15,    -1,
      19,    -1,    22,    -1,    19,   121,   110,   122,    -1,    19,
     121,   107,   122,    -1,   242,   191,    -1,   236,    68,   235,
      -1,   236,    68,   107,    20,   242,    -1,   235,    -1,   107,
      20,   242,    -1,    -1,   239,    -1,   238,    -1,    11,   250,
     241,   250,     8,   248,    -1,    11,    12,   250,     8,   248,
      -1,    11,   250,   240,   248,    -1,    10,   250,   240,   248,
      -1,    10,   250,   241,   250,     8,   248,    -1,    10,    12,
     250,     8,   248,    -1,    68,    -1,     8,    -1,    53,    -1,
      54,    -1,    55,    -1,    56,    -1,    57,    -1,    58,    -1,
     112,    -1,   257,    -1,    -1,   244,    -1,   244,    68,   245,
      -1,   245,    -1,   249,    -1,   242,   118,   251,   119,    -1,
     118,   253,   119,    -1,   247,    -1,   107,    -1,   110,    -1,
     103,    -1,   111,    -1,   103,    -1,   111,    -1,   248,    -1,
     250,    -1,   242,    -1,   259,    -1,    -1,   252,   255,    -1,
      -1,   254,   255,    -1,   256,    -1,   255,   120,   256,    -1,
     250,    -1,    99,    -1,   100,    -1,   101,    -1,   102,    -1,
     104,    -1,   107,    -1,   110,    -1,   108,    -1,   109,    -1,
     258,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1123,  1123,  1127,  1128,  1132,  1133,  1134,  1140,  1146,
    1147,  1148,  1152,  1153,  1162,  1174,  1187,  1187,  1196,  1196,
    1205,  1206,  1210,  1211,  1215,  1216,  1217,  1218,  1219,  1220,
    1221,  1224,  1224,  1232,  1231,  1242,  1246,  1259,  1263,  1267,
    1267,  1279,  1281,  1285,  1300,  1301,  1305,  1305,  1315,  1316,
    1325,  1329,  1333,  1324,  1345,  1347,  1344,  1374,  1399,  1404,
    1407,  1412,  1420,  1421,  1422,  1423,  1424,  1435,  1446,  1451,
    1455,  1462,  1473,  1479,  1488,  1494,  1503,  1509,  1518,  1524,
    1533,  1541,  1546,  1556,  1558,  1563,  1562,  1588,  1589,  1593,
    1594,  1598,  1599,  1603,  1604,  1608,  1616,  1624,  1625,  1626,
    1627,  1628,  1629,  1630,  1631,  1632,  1633,  1634,  1635,  1636,
    1640,  1645,  1652,  1653,  1666,  1671,  1672,  1680,  1681,  1681,
    1693,  1694,  1698,  1699,  1700,  1701,  1702,  1703,  1704,  1709,
    1709,  1712,  1720,  1720,  1726,  1727,  1732,  1740,  1741,  1746,
    1754,  1758,  1763,  1762,  1775,  1776,  1780,  1781,  1791,  1796,
    1806,  1815,  1816,  1828,  1832,  1833,  1835,  1836,  1837,  1838,
    1842,  1843,  1847,  1848,  1852,  1864,  1865,  1876,  1883,  1892,
    1901,  1902,  1903,  1903,  1916,  1926,  1932,  1932,  1939,  1940,
    1940,  1946,  1952,  1956,  1962,  1963,  1964,  1965,  1966,  1967,
    1971,  1972,  1973,  1974,  1978,  1980,  1982,  1984,  1986,  1989,
    1996,  1995,  2004,  2005,  2006,  2007,  2015,  2016,  2017,  2021,
    2022,  2023,  2024,  2025,  2026,  2027,  2028,  2029,  2030,  2031,
    2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,  2041,
    2042,  2043,  2049,  2048,  2060,  2062,  2072,  2073,  2074,  2075,
    2076,  2077,  2078,  2079,  2080,  2081,  2082,  2083,  2088,  2097,
    2098,  2099,  2100,  2106,  2120,  2126,  2132,  2142,  2141,  2150,
    2151,  2161,  2171,  2177,  2182,  2192,  2196,  2197,  2201,  2202,
    2203,  2205,  2211,  2220,  2224,  2234,  2240,  2250,  2255,  2259,
    2260,  2264,  2268,  2272,  2279,  2283,  2287,  2294,  2295,  2299,
    2300,  2301,  2302,  2303,  2304,  2308,  2309,  2313,  2314,  2318,
    2319,  2323,  2324,  2331,  2338,  2339,  2340,  2344,  2345,  2349,
    2350,  2354,  2355,  2359,  2360,  2364,  2364,  2374,  2374,  2386,
    2387,  2395,  2402,  2403,  2404,  2405,  2406,  2410,  2411,  2415,
    2416,  2417
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "LOW_PREC", "'\\n'", "PARAM", "SOL",
  "HLL", "GOTO", "ARG", "IF", "UNLESS", "PNULL", "SET_RETURN", "SET_YIELD",
  "ADV_FLAT", "ADV_SLURPY", "ADV_OPTIONAL", "ADV_OPT_FLAG", "ADV_NAMED",
  "ADV_ARROW", "ADV_INVOCANT", "ADV_CALL_SIG", "NAMESPACE", "DOT_METHOD",
  "SUB", "SYM", "LOCAL", "LEXICAL", "CONST", "ANNOTATE", "GLOBAL_CONST",
  "PLUS_ASSIGN", "MINUS_ASSIGN", "MUL_ASSIGN", "DIV_ASSIGN",
  "CONCAT_ASSIGN", "BAND_ASSIGN", "BOR_ASSIGN", "BXOR_ASSIGN", "FDIV",
  "FDIV_ASSIGN", "MOD_ASSIGN", "SHR_ASSIGN", "SHL_ASSIGN", "SHR_U_ASSIGN",
  "SHIFT_LEFT", "SHIFT_RIGHT", "INTV", "FLOATV", "STRINGV", "PMCV",
  "LOG_XOR", "RELOP_EQ", "RELOP_NE", "RELOP_GT", "RELOP_GTE", "RELOP_LT",
  "RELOP_LTE", "RESULT", "RETURN", "TAILCALL", "YIELDT", "GET_RESULTS",
  "POW", "SHIFT_RIGHT_U", "LOG_AND", "LOG_OR", "COMMA", "ESUB", "DOTDOT",
  "PCC_BEGIN", "PCC_END", "PCC_CALL", "PCC_SUB", "PCC_BEGIN_RETURN",
  "PCC_END_RETURN", "PCC_BEGIN_YIELD", "PCC_END_YIELD", "INVOCANT", "MAIN",
  "LOAD", "INIT", "IMMEDIATE", "POSTCOMP", "METHOD", "ANON", "OUTER",
  "NEED_LEX", "MULTI", "SUBTAG", "VTABLE_METHOD", "LOADLIB",
  "SUB_INSTANCE_OF", "SUBID", "NS_ENTRY", "LABEL", "EMIT", "EOM", "IREG",
  "NREG", "SREG", "PREG", "IDENTIFIER", "REG", "MACRO", "ENDM", "STRINGC",
  "INTC", "FLOATC", "USTRINGC", "PARROT_OP", "VAR", "LINECOMMENT",
  "FILECOMMENT", "DOT", "CONCAT", "'='", "'['", "']'", "';'", "'('", "')'",
  "'!'", "'~'", "'-'", "'+'", "'*'", "'/'", "'%'", "'&'", "'|'", "$accept",
  "program", "compilation_units", "compilation_unit", "pragma",
  "annotate_directive", "hll_def", "constdef", "$@1", "pmc_const", "$@2",
  "any_string", "pasmcode", "pasmline", "pasm_inst", "$@3", "$@4",
  "pasm_args", "emit", "$@5", "opt_pasmcode", "class_namespace",
  "maybe_ns", "nslist", "$@6", "_nslist", "sub", "$@7", "$@8", "$@9",
  "sub_param", "$@10", "$@11", "sub_param_type_def", "multi",
  "multi_types", "multi_type", "subtag", "subtags", "outer", "vtable",
  "method", "ns_entry_name", "instanceof", "subid", "sub_body",
  "pcc_sub_call", "@12", "opt_label", "opt_invocant", "sub_proto",
  "sub_proto_list", "proto", "pcc_call", "pcc_args", "pcc_arg",
  "pcc_results", "pcc_result", "$@13", "paramtype_list", "paramtype",
  "pcc_ret", "$@14", "pcc_yield", "$@15", "pcc_returns", "pcc_yields",
  "pcc_return", "pcc_set_yield", "pcc_return_many", "$@16",
  "return_or_yield", "var_returns", "statements", "helper_clear_state",
  "statement", "labels", "_labels", "label", "instruction", "id_list",
  "id_list_id", "labeled_inst", "$@17", "$@18", "$@19", "type",
  "assignment", "@20", "un_op", "bin_op", "get_results", "@21",
  "op_assign", "assign_op", "func_assign", "the_sub", "sub_call", "@22",
  "arglist", "arg", "argtype_list", "argtype", "result", "targetlist",
  "conditional_statement", "unless_statement", "if_statement",
  "comma_or_goto", "relop", "target", "vars", "_vars", "_var_or_i",
  "sub_label_op_c", "sub_label_op", "label_op", "var_or_i", "var",
  "keylist", "$@23", "keylist_force", "$@24", "_keylist", "key", "reg",
  "stringc", "const", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,    10,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
     284,   285,   286,   287,   288,   289,   290,   291,   292,   293,
     294,   295,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,   370,    61,    91,    93,
      59,    40,    41,    33,   126,    45,    43,    42,    47,    37,
      38,   124
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   132,   133,   134,   134,   135,   135,   135,   135,   135,
     135,   135,   136,   136,   137,   138,   140,   139,   142,   141,
     143,   143,   144,   144,   145,   145,   145,   145,   145,   145,
     145,   147,   146,   148,   146,   146,   146,   146,   149,   151,
     150,   152,   152,   153,   154,   154,   156,   155,   157,   157,
     159,   160,   161,   158,   163,   164,   162,   165,   166,   167,
     167,   167,   168,   168,   168,   168,   168,   168,   168,   169,
     170,   170,   171,   171,   172,   172,   173,   173,   174,   174,
     175,   176,   176,   177,   177,   179,   178,   180,   180,   181,
     181,   182,   182,   183,   183,   184,   184,   184,   184,   184,
     184,   184,   184,   184,   184,   184,   184,   184,   184,   184,
     185,   185,   186,   186,   187,   188,   188,   189,   190,   189,
     191,   191,   192,   192,   192,   192,   192,   192,   192,   194,
     193,   193,   196,   195,   197,   197,   197,   198,   198,   198,
     199,   200,   202,   201,   203,   203,   204,   204,   204,   204,
     204,   205,   205,   206,   207,   207,   207,   207,   207,   207,
     208,   208,   209,   209,   210,   211,   211,   212,   212,   213,
     214,   214,   215,   214,   214,   214,   216,   214,   214,   217,
     214,   214,   214,   214,   214,   214,   214,   214,   214,   214,
     218,   218,   218,   218,   219,   219,   219,   219,   219,   219,
     220,   219,   219,   219,   219,   219,   221,   221,   221,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   222,
     222,   222,   224,   223,   225,   225,   226,   226,   226,   226,
     226,   226,   226,   226,   226,   226,   226,   226,   227,   228,
     228,   228,   228,   228,   228,   228,   228,   230,   229,   231,
     231,   231,   231,   231,   231,   232,   233,   233,   234,   234,
     234,   234,   234,   235,   236,   236,   236,   236,   236,   237,
     237,   238,   238,   238,   239,   239,   239,   240,   240,   241,
     241,   241,   241,   241,   241,   242,   242,   243,   243,   244,
     244,   245,   245,   245,   246,   246,   246,   247,   247,   248,
     248,   249,   249,   250,   250,   252,   251,   254,   253,   255,
     255,   256,   257,   257,   257,   257,   257,   258,   258,   259,
     259,   259
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     2,     1,     1,     1,     1,     2,
       1,     1,     2,     3,     4,     2,     0,     6,     0,     6,
       1,     1,     1,     2,     3,     2,     1,     1,     1,     1,
       1,     0,     3,     0,     4,     2,     4,     0,     1,     0,
       4,     0,     1,     3,     3,     2,     0,     2,     1,     3,
       0,     0,     0,     9,     0,     0,     5,     3,     4,     0,
       3,     1,     1,     1,     1,     1,     1,     1,     3,     4,
       3,     1,     4,     4,     1,     4,     1,     4,     1,     4,
       4,     1,     4,     0,     1,     0,     9,     0,     2,     0,
       3,     0,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     3,     0,     3,     2,     0,     3,     3,     0,     4,
       0,     2,     1,     1,     1,     1,     4,     4,     1,     0,
       5,     1,     0,     5,     0,     2,     3,     0,     2,     3,
       3,     3,     0,     5,     1,     1,     0,     1,     3,     3,
       5,     1,     2,     0,     1,     2,     2,     1,     1,     1,
       0,     1,     2,     1,     1,     3,     2,     1,     3,     1,
       1,     1,     0,     4,     4,     4,     0,     6,     1,     0,
       6,     2,     2,     2,     2,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     3,     4,     5,     6,     6,     3,
       0,     9,     1,     1,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     5,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     1,
       1,     1,     1,     3,     3,     3,     3,     0,     5,     0,
       3,     1,     5,     3,     3,     2,     0,     2,     1,     1,
       1,     4,     4,     2,     3,     5,     1,     3,     0,     1,
       1,     6,     5,     4,     4,     6,     5,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     3,
       1,     1,     4,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     2,     0,     2,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,    11,     0,     0,    50,    16,     0,    39,     0,     0,
       2,     3,    10,     0,     6,     8,     5,     7,    15,    46,
       0,     0,     0,     0,   160,     9,     1,     4,    12,    45,
       0,     0,    43,   307,   305,   306,   308,    51,   304,   190,
     191,   192,   193,     0,    13,    18,   164,     0,    27,    26,
      30,    29,   160,    22,     0,    28,    31,   161,   163,    44,
     327,   328,    47,    48,    91,     0,     0,    25,    23,    40,
       0,     0,    33,     0,     0,   162,     0,    97,    95,    96,
      98,    99,    76,   100,     0,   101,     0,     0,    74,     0,
      81,    78,   102,   103,   104,   105,   106,   107,   108,   109,
       0,    92,    93,     0,     0,   322,   323,   324,   325,   326,
     329,   330,   295,   313,    35,   296,   331,   314,     0,    91,
      24,   297,    49,     0,     0,    59,     0,     0,     0,     0,
       0,    52,    94,    17,   309,   310,   311,     0,   312,     0,
       0,   317,    32,   313,    38,   298,   300,   301,    20,    21,
       0,     0,     0,    62,    63,    65,    64,    66,    67,   315,
       0,    61,    71,     0,     0,     0,     0,     0,   153,     0,
      36,    34,     0,     0,   315,     0,    77,    73,    72,     0,
       0,     0,    58,     0,    69,    75,    80,    82,    79,    54,
       0,     0,   158,   157,   159,   154,     0,   153,     0,   151,
      19,   303,   321,   318,   319,     0,   299,    68,   316,    60,
      70,     0,     0,   156,    53,   152,     0,   189,   155,     0,
     302,     0,     0,     0,   166,     0,     0,     0,     0,   172,
       0,   176,   179,   144,     0,   145,   232,     0,     0,     0,
     249,   250,   251,   297,   200,   178,   186,   187,   188,   131,
       0,     0,   170,   202,   203,   204,   257,   185,   171,   280,
     279,   252,   320,    55,   120,    14,   182,     0,     0,     0,
       0,   184,     0,     0,     0,     0,     0,   181,   252,     0,
      85,   129,   132,   183,   278,   142,   165,     0,   236,   237,
     238,   239,     0,   242,   243,   244,   241,   240,   245,   246,
     247,     0,     0,   315,     0,    56,    57,     0,   288,   289,
     290,   291,   292,   293,   294,   287,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   278,   112,   134,   137,
       0,   276,     0,   120,   146,   259,   235,   255,   254,   256,
     253,   205,   327,   328,   297,   206,   207,   208,     0,   199,
     313,   194,     0,   234,   122,   123,   124,   125,   128,   121,
       0,   284,     0,     0,   283,     0,   169,   173,   167,   174,
     175,     0,     0,     0,    89,     0,     0,     0,     0,     0,
     273,   327,     0,   147,   266,   327,     0,   261,   266,   248,
     195,   214,   223,   224,   228,   217,   218,   219,   220,   221,
     222,   215,   225,   226,   227,   216,   315,   231,   209,   210,
     211,   212,   213,   229,   230,     0,     0,     0,   286,     0,
     282,     0,     0,     0,     0,   233,     0,     0,     0,     0,
     135,     0,   130,     0,   138,     0,   133,     0,   277,     0,
     274,     0,     0,     0,   143,   265,     0,     0,   258,     0,
       0,   196,     0,     0,     0,   285,   281,   168,   177,   180,
     114,     0,     0,    87,   113,   266,   136,   266,   139,     0,
       0,   148,   327,   149,   268,   269,   270,   267,   264,   327,
     260,   263,   197,   198,   126,   127,    90,     0,   115,     0,
     140,   141,   275,   259,     0,     0,     0,   111,     0,     0,
      88,     0,   150,     0,     0,   262,     0,   118,     0,    86,
       0,   201,   272,   271,   110,     0,   120,   116,     0,   117,
     119
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     9,    10,    11,    12,   194,    13,    14,    22,    51,
      66,   150,    52,    53,    73,    74,   119,   142,    15,    24,
      54,    16,    20,    30,    31,    62,    17,    21,    64,   168,
     195,   211,   305,   221,    92,   160,   161,    93,   163,    94,
      95,    96,    97,    98,    99,   196,   246,   327,   488,   428,
     100,   101,   102,   463,   374,   429,   499,   510,   515,   306,
     359,   247,   328,   248,   329,   375,   376,   433,   437,   249,
     334,   250,   382,   197,   198,   199,    56,    57,    58,   218,
     367,   368,   251,   272,   275,   276,    43,   252,   284,   348,
     415,   253,   279,   254,   304,   255,   256,   257,   287,   386,
     387,   445,   477,   331,   332,   258,   259,   260,   316,   317,
     113,   144,   145,   146,    37,    38,   136,   147,   138,   179,
     180,   172,   173,   203,   204,   115,   116,   117
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -418
static const yytype_int16 yypact[] =
{
      83,  -418,   -86,   -77,  -418,  -418,   -43,  -418,    62,    74,
      83,  -418,  -418,    72,  -418,  -418,  -418,  -418,  -418,   -34,
     105,    59,   218,   122,    63,  -418,  -418,  -418,  -418,  -418,
      24,    35,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,
    -418,  -418,  -418,   -20,  -418,  -418,  -418,   127,  -418,  -418,
    -418,  -418,   125,  -418,    52,  -418,    27,    55,  -418,  -418,
    -418,  -418,    32,  -418,   437,    46,    60,  -418,  -418,  -418,
     369,    66,  -418,   175,    80,  -418,    35,  -418,  -418,  -418,
    -418,  -418,    73,  -418,    84,  -418,    85,    88,    98,    99,
     103,   112,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,
     189,   437,  -418,   186,   387,  -418,  -418,  -418,  -418,  -418,
    -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,   130,   437,
    -418,   354,  -418,    64,    57,   -36,    94,   128,   129,    64,
      64,  -418,  -418,  -418,  -418,  -418,  -418,    78,  -418,   144,
     153,  -418,  -418,   137,  -418,   202,  -418,  -418,  -418,  -418,
     150,   151,   152,  -418,  -418,  -418,  -418,  -418,  -418,  -418,
     -50,  -418,  -418,   -28,   154,   161,   163,   164,    22,    64,
    -418,  -418,   172,   369,  -418,   354,  -418,  -418,  -418,   178,
     369,   -36,  -418,   198,  -418,  -418,  -418,  -418,  -418,  -418,
     199,   305,  -418,  -418,  -418,  -418,   244,    33,    18,  -418,
    -418,  -418,  -418,   194,  -418,   196,  -418,  -418,   194,  -418,
    -418,   218,   248,  -418,  -418,  -418,   313,   200,  -418,   369,
    -418,   314,   216,   186,  -418,   -67,   180,   286,   369,  -418,
      71,   213,  -418,  -418,   504,  -418,  -418,   321,   322,   329,
    -418,  -418,  -418,   354,  -418,  -418,  -418,  -418,  -418,  -418,
     226,   330,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,
    -418,   367,  -418,  -418,  -418,  -418,  -418,   369,   188,   369,
     188,  -418,   218,   280,   287,   218,   218,  -418,   243,   238,
    -418,  -418,  -418,  -418,   242,  -418,  -418,   239,  -418,  -418,
    -418,  -418,   369,  -418,  -418,  -418,  -418,  -418,  -418,  -418,
    -418,   434,   228,  -418,   369,  -418,   235,   355,  -418,  -418,
    -418,  -418,  -418,  -418,  -418,  -418,   -67,   369,   356,   -67,
     369,   259,   114,   114,   263,   264,   242,  -418,  -418,  -418,
     348,  -418,   -26,  -418,   448,   462,  -418,  -418,  -418,  -418,
    -418,  -418,   249,   250,   354,  -418,  -418,  -418,   369,  -418,
     -78,   385,   255,  -418,  -418,  -418,  -418,   254,  -418,  -418,
     -67,  -418,   361,   -67,  -418,   370,  -418,   312,  -418,  -418,
    -418,   266,   267,   -15,    26,    12,     6,   114,   315,   274,
     235,   377,   -11,  -418,  -418,   393,    -9,  -418,   398,  -418,
    -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,
    -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,
    -418,  -418,  -418,  -418,  -418,   369,   303,    77,  -418,   -67,
    -418,   -67,   259,   186,   186,  -418,   369,   369,   308,   417,
    -418,   369,  -418,   425,  -418,   369,  -418,   426,  -418,   413,
    -418,   504,   369,   476,  -418,    39,   369,   490,  -418,   369,
     316,  -418,   369,   323,   324,  -418,  -418,  -418,  -418,  -418,
    -418,   430,   369,    55,  -418,  -418,  -418,  -418,  -418,   114,
     326,  -418,   416,  -418,  -418,   327,  -418,  -418,  -418,   424,
    -418,  -418,  -418,  -418,  -418,  -418,  -418,     7,  -418,   455,
      39,    39,  -418,   462,   369,    79,   369,  -418,   369,   113,
    -418,    31,  -418,   338,   345,  -418,   470,  -418,   114,  -418,
     471,  -418,  -418,  -418,  -418,   218,  -418,  -418,   259,   235,
    -418
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -418,  -418,  -418,   473,    -1,  -418,  -418,  -418,  -418,   275,
    -418,   -96,  -418,   428,  -418,  -418,  -418,   149,  -418,  -418,
    -418,     8,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,
    -418,  -418,  -418,  -418,  -418,  -418,   319,  -418,  -418,  -418,
    -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,
     383,  -418,   403,  -418,  -418,  -418,  -418,  -418,  -418,  -326,
    -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,  -418,
    -418,  -418,  -418,  -418,  -418,   309,   307,  -418,   -56,  -418,
    -418,  -414,  -418,  -418,  -418,  -418,  -207,  -418,  -418,  -418,
    -418,  -418,  -418,  -418,  -418,  -418,    67,  -225,  -418,    14,
    -310,  -417,  -418,   162,   203,  -418,  -418,  -418,   269,   272,
    -119,   300,  -418,   376,  -418,   252,  -219,   450,   -70,  -169,
    -418,  -418,  -418,   379,   346,  -418,   -14,  -100
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -253
static const yytype_int16 yytable[] =
{
     114,    75,   143,   133,   222,   205,   266,   380,   457,   277,
     434,   497,   153,   154,   155,   156,   430,    63,   181,   216,
     435,    18,  -160,    50,   383,   431,  -160,   189,  -160,  -160,
    -160,   -37,    55,   166,   167,   426,   134,   301,   189,    70,
     183,    19,   378,  -252,   135,  -160,  -160,  -160,   490,  -160,
     491,    50,   190,   378,   474,    71,   143,   443,   475,   447,
      55,   476,   122,   190,    23,   321,    25,   157,   324,   325,
       2,   158,   182,   200,    26,   498,    28,   349,  -160,  -160,
    -160,  -160,   159,    65,   436,    29,     3,     1,   432,  -160,
       2,   -83,    45,  -160,   184,  -160,   379,   361,   261,   447,
     364,    72,   -84,   202,   520,   427,     3,   425,     4,    32,
     202,   444,     5,   448,    46,   278,   460,  -160,  -160,  -160,
    -160,  -160,  -160,   265,   143,  -160,    44,   191,  -160,  -160,
    -160,    67,     2,   473,   352,   192,   193,   480,   191,  -160,
     507,   418,    60,    59,   420,    61,   192,   193,     3,   202,
      69,    46,    76,   511,    45,     6,   268,   270,   271,    46,
     151,   -41,    33,   103,   152,   333,    34,   104,    47,    35,
      36,   148,   508,   118,   149,     6,    48,    49,   273,   120,
       7,   274,   339,   350,   453,   509,   503,   454,     8,   504,
     519,   121,   267,   131,   123,   169,   308,   307,   139,   318,
     455,   162,   456,   369,   370,   124,   125,   333,   225,   126,
     226,   227,   228,   105,   106,   107,   108,     6,   109,   127,
     128,    46,   336,   -42,   129,   143,   112,   229,   230,   231,
      47,   232,   351,   130,   353,   164,   165,   450,    48,    49,
     341,   309,   310,   311,   312,   313,   314,   362,   170,   171,
     365,   354,   355,   356,   357,   174,   315,   358,   438,   333,
     233,   234,   235,   236,   384,   388,    39,    40,    41,    42,
     175,   237,   176,   177,   178,   238,   185,   239,   390,   105,
     106,   107,   108,   186,   109,   187,   188,    60,   110,   111,
      61,   201,   112,    60,   110,   111,    61,   207,   269,   105,
     106,   107,   108,   240,   109,   210,   212,   241,   518,   213,
     242,   243,   112,   214,   219,   220,   223,   224,   263,   264,
     -18,   244,   278,   458,   459,   280,   281,   105,   106,   107,
     108,   240,   109,   282,   286,   342,   110,   111,   343,   344,
     112,   105,   106,   107,   108,   451,   109,   285,   322,   330,
     492,   345,   346,   347,   112,   323,   384,   461,   301,   326,
     335,   465,   366,   360,   363,   467,   371,   372,   377,   419,
    -250,  -251,   471,   384,   416,   417,   478,   384,   421,   481,
     422,   462,   483,   423,   424,   105,   106,   107,   108,   516,
     109,   441,   487,    60,   110,   111,    61,   442,   112,   288,
     289,   290,   291,   292,   293,   294,   295,   489,   296,   297,
     298,   299,   300,   446,   105,   106,   107,   108,   449,   109,
     452,   464,   439,   388,   502,   391,   505,   112,   506,   466,
     468,   392,   393,   469,   486,   482,   494,   394,   395,   396,
     397,   398,   399,   400,   496,   484,   485,   493,   495,   401,
     402,   403,   404,   105,   106,   107,   108,   134,   109,   500,
     512,    60,   110,   111,    61,   135,   112,   513,   105,   106,
     107,   108,   141,   109,   514,   517,    60,   110,   111,    61,
      68,   112,   301,    27,   302,   303,   105,   106,   107,   108,
     134,   109,   245,   389,    60,   110,   111,    61,   135,   112,
     209,   405,   140,   406,   132,   217,   215,   501,   470,   407,
     408,   409,   410,   411,   412,   413,   414,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,   373,
      89,    90,    91,   105,   106,   107,   108,    33,   109,   319,
     440,   337,   320,   283,   338,    36,   112,   105,   106,   107,
     108,   206,   109,   340,   137,   381,   110,   111,    61,   208,
     112,   105,   106,   107,   108,   262,   109,     0,     0,   385,
     110,   111,    61,     0,   112,   105,   106,   107,   108,     0,
     109,     0,     0,   472,   110,   111,    61,     0,   112,   105,
     106,   107,   108,     0,   109,     0,     0,   479,   110,   111,
      61,     0,   112,   105,   106,   107,   108,   240,   109,     0,
       0,   241,     0,     0,   242,     0,   112
};

#define yypact_value_is_default(yystate) \
  ((yystate) == (-418))

#define yytable_value_is_error(yytable_value) \
  YYID (0)

static const yytype_int16 yycheck[] =
{
      70,    57,   121,   103,   211,   174,   225,   333,   422,   234,
       4,     4,    48,    49,    50,    51,     4,    31,    68,     1,
      14,   107,     4,    24,   334,    13,     8,     5,    10,    11,
      12,     4,    24,   129,   130,     9,   103,   115,     5,    12,
      68,   118,    68,   121,   111,    27,    28,    29,   465,    31,
     467,    52,    30,    68,    15,    28,   175,    68,    19,    68,
      52,    22,    76,    30,   107,   272,     4,   103,   275,   276,
       7,   107,   122,   169,     0,    68,     4,   302,    60,    61,
      62,    63,   118,   103,    78,   119,    23,     4,    76,    71,
       7,    69,    29,    75,   122,    77,   122,   316,   217,    68,
     319,    74,    69,   173,   518,    79,    23,   122,    25,     4,
     180,   122,    29,   122,    96,   234,   426,    99,   100,   101,
     102,   103,   104,   223,   243,   107,     4,   105,   110,   111,
     112,     4,     7,   443,   303,   113,   114,   447,   105,   121,
      27,   360,   107,   119,   363,   110,   113,   114,    23,   219,
      98,    96,   120,   122,    29,    92,   226,   227,   228,    96,
     103,    98,   103,   117,   107,   284,   107,   107,   105,   110,
     111,   107,    59,   107,   110,    92,   113,   114,   107,     4,
      97,   110,   301,   302,   107,    72,   107,   110,   105,   110,
     516,   111,    12,     4,   121,   117,     8,   267,    68,   269,
     419,   107,   421,   322,   323,   121,   121,   326,     8,   121,
      10,    11,    12,    99,   100,   101,   102,    92,   104,   121,
     121,    96,   292,    98,   121,   344,   112,    27,    28,    29,
     105,    31,   302,   121,   304,   107,   107,   406,   113,   114,
      12,    53,    54,    55,    56,    57,    58,   317,   104,    96,
     320,    16,    17,    18,    19,   118,    68,    22,   377,   378,
      60,    61,    62,    63,   334,   335,    48,    49,    50,    51,
      68,    71,   122,   122,   122,    75,   122,    77,   348,    99,
     100,   101,   102,   122,   104,   122,   122,   107,   108,   109,
     110,   119,   112,   107,   108,   109,   110,   119,    12,    99,
     100,   101,   102,   103,   104,   107,   107,   107,   515,     4,
     110,   111,   112,    69,   120,   119,    68,     4,     4,   103,
     107,   121,   441,   423,   424,     4,     4,    99,   100,   101,
     102,   103,   104,     4,     4,   107,   108,   109,   110,   111,
     112,    99,   100,   101,   102,   415,   104,   121,    68,   107,
     469,   123,   124,   125,   112,    68,   426,   427,   115,   121,
     121,   431,   103,     8,     8,   435,   103,   103,    20,     8,
     121,   121,   442,   443,   119,   121,   446,   447,     8,   449,
      68,    73,   452,   117,   117,    99,   100,   101,   102,   508,
     104,   117,   462,   107,   108,   109,   110,    20,   112,    32,
      33,    34,    35,    36,    37,    38,    39,   463,    41,    42,
      43,    44,    45,    20,    99,   100,   101,   102,    20,   104,
     117,     4,   107,   493,   494,    40,   496,   112,   498,     4,
       4,    46,    47,    20,     4,   119,    20,    52,    53,    54,
      55,    56,    57,    58,    20,   122,   122,   121,   121,    64,
      65,    66,    67,    99,   100,   101,   102,   103,   104,     4,
     122,   107,   108,   109,   110,   111,   112,   122,    99,   100,
     101,   102,   118,   104,     4,     4,   107,   108,   109,   110,
      52,   112,   115,    10,   117,   118,    99,   100,   101,   102,
     103,   104,   217,   344,   107,   108,   109,   110,   111,   112,
     181,   116,   119,   118,   101,   198,   197,   493,   441,   124,
     125,   126,   127,   128,   129,   130,   131,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,   326,
      93,    94,    95,    99,   100,   101,   102,   103,   104,   270,
     378,   107,   270,   243,   110,   111,   112,    99,   100,   101,
     102,   175,   104,   301,   104,   107,   108,   109,   110,   180,
     112,    99,   100,   101,   102,   219,   104,    -1,    -1,   107,
     108,   109,   110,    -1,   112,    99,   100,   101,   102,    -1,
     104,    -1,    -1,   107,   108,   109,   110,    -1,   112,    99,
     100,   101,   102,    -1,   104,    -1,    -1,   107,   108,   109,
     110,    -1,   112,    99,   100,   101,   102,   103,   104,    -1,
      -1,   107,    -1,    -1,   110,    -1,   112
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     4,     7,    23,    25,    29,    92,    97,   105,   133,
     134,   135,   136,   138,   139,   150,   153,   158,   107,   118,
     154,   159,   140,   107,   151,     4,     0,   135,     4,   119,
     155,   156,     4,   103,   107,   110,   111,   246,   247,    48,
      49,    50,    51,   218,     4,    29,    96,   105,   113,   114,
     136,   141,   144,   145,   152,   153,   208,   209,   210,   119,
     107,   110,   157,   258,   160,   103,   142,     4,   145,    98,
      12,    28,    74,   146,   147,   210,   120,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    93,
      94,    95,   166,   169,   171,   172,   173,   174,   175,   176,
     182,   183,   184,   117,   107,    99,   100,   101,   102,   104,
     108,   109,   112,   242,   250,   257,   258,   259,   107,   148,
       4,   111,   258,   121,   121,   121,   121,   121,   121,   121,
     121,     4,   184,   259,   103,   111,   248,   249,   250,    68,
     182,   118,   149,   242,   243,   244,   245,   249,   107,   110,
     143,   103,   107,    48,    49,    50,    51,   103,   107,   118,
     167,   168,   107,   170,   107,   107,   143,   143,   161,   117,
     104,    96,   253,   254,   118,    68,   122,   122,   122,   251,
     252,    68,   122,    68,   122,   122,   122,   122,   122,     5,
      30,   105,   113,   114,   137,   162,   177,   205,   206,   207,
     143,   119,   250,   255,   256,   251,   245,   119,   255,   168,
     107,   163,   107,     4,    69,   207,     1,   208,   211,   120,
     119,   165,   218,    68,     4,     8,    10,    11,    12,    27,
      28,    29,    31,    60,    61,    62,    63,    71,    75,    77,
     103,   107,   110,   111,   121,   141,   178,   193,   195,   201,
     203,   214,   219,   223,   225,   227,   228,   229,   237,   238,
     239,   242,   256,     4,   103,   259,   248,    12,   250,    12,
     250,   250,   215,   107,   110,   216,   217,   229,   242,   224,
       4,     4,     4,   243,   220,   121,     4,   230,    32,    33,
      34,    35,    36,    37,    38,    39,    41,    42,    43,    44,
      45,   115,   117,   118,   226,   164,   191,   250,     8,    53,
      54,    55,    56,    57,    58,    68,   240,   241,   250,   240,
     241,   218,    68,    68,   218,   218,   121,   179,   194,   196,
     107,   235,   236,   242,   202,   121,   250,   107,   110,   242,
     247,    12,   107,   110,   111,   123,   124,   125,   221,   229,
     242,   250,   251,   250,    16,    17,    18,    19,    22,   192,
       8,   248,   250,     8,   248,   250,   103,   212,   213,   242,
     242,   103,   103,   236,   186,   197,   198,    20,    68,   122,
     191,   107,   204,   232,   250,   107,   231,   232,   250,   149,
     250,    40,    46,    47,    52,    53,    54,    55,    56,    57,
      58,    64,    65,    66,    67,   116,   118,   124,   125,   126,
     127,   128,   129,   130,   131,   222,   119,   121,   248,     8,
     248,     8,    68,   117,   117,   122,     9,    79,   181,   187,
       4,    13,    76,   199,     4,    14,    78,   200,   242,   107,
     235,   117,    20,    68,   122,   233,    20,    68,   122,    20,
     251,   250,   117,   107,   110,   248,   248,   213,   259,   259,
     232,   250,    73,   185,     4,   250,     4,   250,     4,    20,
     228,   250,   107,   232,    15,    19,    22,   234,   250,   107,
     232,   250,   119,   250,   122,   122,     4,   250,   180,   210,
     233,   233,   242,   121,    20,   121,    20,     4,    68,   188,
       4,   231,   250,   107,   110,   250,   250,    27,    59,    72,
     189,   122,   122,   122,     4,   190,   242,     4,   218,   191,
     213
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  However,
   YYFAIL appears to be in use.  Nevertheless, it is formally deprecated
   in Bison 2.4.2's NEWS entry, where a plan to phase it out is
   discussed.  */

#define YYFAIL		goto yyerrlab
#if defined YYFAIL
  /* This is here to suppress warnings from the GCC cpp's
     -Wunused-macros.  Normally we don't worry about that warning, but
     some users do, and we want to make it easy for users to remove
     YYFAIL uses, which will produce warnings from Bison 2.5.  */
#endif

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (yyscanner, imcc, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* This macro is provided for backward compatibility. */

#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, yyscanner, imcc)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, yyscanner, imcc); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, void *yyscanner, imc_info_t *imcc)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, yyscanner, imcc)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    void *yyscanner;
    imc_info_t *imcc;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (yyscanner);
  YYUSE (imcc);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, void *yyscanner, imc_info_t *imcc)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, yyscanner, imcc)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    void *yyscanner;
    imc_info_t *imcc;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yyscanner, imcc);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule, void *yyscanner, imc_info_t *imcc)
#else
static void
yy_reduce_print (yyvsp, yyrule, yyscanner, imcc)
    YYSTYPE *yyvsp;
    int yyrule;
    void *yyscanner;
    imc_info_t *imcc;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       , yyscanner, imcc);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule, yyscanner, imcc); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (0, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  YYSIZE_T yysize1;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = 0;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - Assume YYFAIL is not used.  It's too flawed to consider.  See
       <http://lists.gnu.org/archive/html/bison-patches/2009-12/msg00024.html>
       for details.  YYERROR is fine as it does not invoke this
       function.
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                yysize1 = yysize + yytnamerr (0, yytname[yyx]);
                if (! (yysize <= yysize1
                       && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                  return 2;
                yysize = yysize1;
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  yysize1 = yysize + yystrlen (yyformat);
  if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
    return 2;
  yysize = yysize1;

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, void *yyscanner, imc_info_t *imcc)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yyscanner, imcc)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    void *yyscanner;
    imc_info_t *imcc;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (yyscanner);
  YYUSE (imcc);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void *yyscanner, imc_info_t *imcc);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *yyscanner, imc_info_t *imcc)
#else
int
yyparse (yyscanner, imcc)
    void *yyscanner;
    imc_info_t *imcc;
#endif
#endif
{
/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1806 of yacc.c  */
#line 1123 "compilers/imcc/imcc.y"
    { if (yynerrs) YYABORT; (yyval.i) = 0; }
    break;

  case 5:

/* Line 1806 of yacc.c  */
#line 1132 "compilers/imcc/imcc.y"
    { (yyval.i) = (yyvsp[(1) - (1)].i); }
    break;

  case 6:

/* Line 1806 of yacc.c  */
#line 1133 "compilers/imcc/imcc.y"
    { (yyval.i) = (yyvsp[(1) - (1)].i); }
    break;

  case 7:

/* Line 1806 of yacc.c  */
#line 1135 "compilers/imcc/imcc.y"
    {
           (yyval.i) = (yyvsp[(1) - (1)].i);
           imc_close_unit(imcc, imcc->cur_unit);
           imcc->cur_unit = 0;
         }
    break;

  case 8:

/* Line 1806 of yacc.c  */
#line 1141 "compilers/imcc/imcc.y"
    {
           (yyval.i) = (yyvsp[(1) - (1)].i);
           imc_close_unit(imcc, imcc->cur_unit);
           imcc->cur_unit = 0;
         }
    break;

  case 9:

/* Line 1806 of yacc.c  */
#line 1146 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; }
    break;

  case 10:

/* Line 1806 of yacc.c  */
#line 1147 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; }
    break;

  case 11:

/* Line 1806 of yacc.c  */
#line 1148 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; }
    break;

  case 12:

/* Line 1806 of yacc.c  */
#line 1152 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; }
    break;

  case 13:

/* Line 1806 of yacc.c  */
#line 1154 "compilers/imcc/imcc.y"
    {
           (yyval.i) = 0;
           do_loadlib(imcc, (yyvsp[(2) - (3)].s));
           mem_sys_free((yyvsp[(2) - (3)].s));
         }
    break;

  case 14:

/* Line 1806 of yacc.c  */
#line 1163 "compilers/imcc/imcc.y"
    {
          /* We'll want to store an entry while emitting instructions, so just
           * store annotation like it's an instruction. */
          SymReg * const key = mk_const(imcc, (yyvsp[(2) - (4)].s), 'S');
          (yyval.i) = MK_I(imcc, imcc->cur_unit, ".annotate", 2, key, (yyvsp[(4) - (4)].sr));
          mem_sys_free((yyvsp[(2) - (4)].s));
        }
    break;

  case 15:

/* Line 1806 of yacc.c  */
#line 1175 "compilers/imcc/imcc.y"
    {
            STRING * const hll_name = Parrot_str_unescape(imcc->interp, (yyvsp[(2) - (2)].s) + 1, '"', NULL);
            Parrot_pcc_set_HLL(imcc->interp, CURRENT_CONTEXT(imcc->interp),
                Parrot_hll_register_HLL(imcc->interp, hll_name));

            imcc->cur_namespace = NULL;
            mem_sys_free((yyvsp[(2) - (2)].s));
            (yyval.t) = 0;
         }
    break;

  case 16:

/* Line 1806 of yacc.c  */
#line 1187 "compilers/imcc/imcc.y"
    { imcc->is_def = 1; }
    break;

  case 17:

/* Line 1806 of yacc.c  */
#line 1188 "compilers/imcc/imcc.y"
    {
             mk_const_ident(imcc, (yyvsp[(4) - (6)].s), (yyvsp[(3) - (6)].t), (yyvsp[(6) - (6)].sr), 1);
             mem_sys_free((yyvsp[(4) - (6)].s));
             imcc->is_def = 0;
         }
    break;

  case 18:

/* Line 1806 of yacc.c  */
#line 1196 "compilers/imcc/imcc.y"
    { imcc->is_def = 1; }
    break;

  case 19:

/* Line 1806 of yacc.c  */
#line 1197 "compilers/imcc/imcc.y"
    {
           (yyval.i) = mk_pmc_const_named(imcc, imcc->cur_unit, (yyvsp[(3) - (6)].s), (yyvsp[(4) - (6)].sr), (yyvsp[(6) - (6)].s));
           mem_sys_free((yyvsp[(3) - (6)].s));
           mem_sys_free((yyvsp[(6) - (6)].s));
           imcc->is_def = 0;
         }
    break;

  case 24:

/* Line 1806 of yacc.c  */
#line 1215 "compilers/imcc/imcc.y"
    { (yyval.i) = 0;  }
    break;

  case 25:

/* Line 1806 of yacc.c  */
#line 1216 "compilers/imcc/imcc.y"
    { (yyval.i) = 0;  }
    break;

  case 26:

/* Line 1806 of yacc.c  */
#line 1217 "compilers/imcc/imcc.y"
    { (yyval.i) = 0;  }
    break;

  case 27:

/* Line 1806 of yacc.c  */
#line 1218 "compilers/imcc/imcc.y"
    { (yyval.i) = 0;  }
    break;

  case 28:

/* Line 1806 of yacc.c  */
#line 1219 "compilers/imcc/imcc.y"
    { (yyval.i) = (yyvsp[(1) - (1)].i); }
    break;

  case 31:

/* Line 1806 of yacc.c  */
#line 1224 "compilers/imcc/imcc.y"
    { clear_state(imcc); }
    break;

  case 32:

/* Line 1806 of yacc.c  */
#line 1226 "compilers/imcc/imcc.y"
    {
           (yyval.i) = INS(imcc, imcc->cur_unit, (yyvsp[(2) - (3)].s), 0, imcc->regs,
                    imcc->nargs, imcc -> keyvec, 1);
            mem_sys_free((yyvsp[(2) - (3)].s));
         }
    break;

  case 33:

/* Line 1806 of yacc.c  */
#line 1232 "compilers/imcc/imcc.y"
    {
           imc_close_unit(imcc, imcc->cur_unit);
           imcc->cur_unit = imc_open_unit(imcc, IMC_PASM);
         }
    break;

  case 34:

/* Line 1806 of yacc.c  */
#line 1237 "compilers/imcc/imcc.y"
    {
           (yyval.i) = iSUBROUTINE(imcc, imcc->cur_unit, mk_sub_label(imcc, (yyvsp[(4) - (4)].s)));
           imcc->cur_call->pcc_sub->pragma = (yyvsp[(3) - (4)].t);
           mem_sys_free((yyvsp[(4) - (4)].s));
         }
    break;

  case 35:

/* Line 1806 of yacc.c  */
#line 1243 "compilers/imcc/imcc.y"
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "null", 1, (yyvsp[(2) - (2)].sr));
         }
    break;

  case 36:

/* Line 1806 of yacc.c  */
#line 1247 "compilers/imcc/imcc.y"
    {
           char   *name = mem_sys_strdup((yyvsp[(2) - (4)].s) + 1);
           SymReg *r    = mk_pasm_reg(imcc, (yyvsp[(4) - (4)].s));
           SymReg *n;
           name[strlen(name) - 1] = 0;
           n = mk_const(imcc, name, 'S');
           set_lexical(imcc, r, n);
           (yyval.i) = 0;
           mem_sys_free(name);
           mem_sys_free((yyvsp[(2) - (4)].s));
           mem_sys_free((yyvsp[(4) - (4)].s));
         }
    break;

  case 37:

/* Line 1806 of yacc.c  */
#line 1259 "compilers/imcc/imcc.y"
    { (yyval.i) = 0;}
    break;

  case 39:

/* Line 1806 of yacc.c  */
#line 1267 "compilers/imcc/imcc.y"
    { imcc->cur_unit = imc_open_unit(imcc, IMC_PASM); }
    break;

  case 40:

/* Line 1806 of yacc.c  */
#line 1270 "compilers/imcc/imcc.y"
    {
           /* if (optimizer_level & OPT_PASM)
                         imc_compile_unit(interp, imcc->cur_unit);
                         emit_flush(interp);
           */
           (yyval.i) = 0;
         }
    break;

  case 43:

/* Line 1806 of yacc.c  */
#line 1286 "compilers/imcc/imcc.y"
    {
           int re_open = 0;
           (yyval.i) = 0;
           if (imcc->state->pasm_file && imcc->cur_namespace) {
               imc_close_unit(imcc, imcc->cur_unit);
               re_open = 1;
           }
           imcc->cur_namespace = (yyvsp[(2) - (3)].sr);
           if (re_open)
               imcc->cur_unit = imc_open_unit(imcc, IMC_PASM);
         }
    break;

  case 44:

/* Line 1806 of yacc.c  */
#line 1300 "compilers/imcc/imcc.y"
    { (yyval.sr) = (yyvsp[(2) - (3)].sr); }
    break;

  case 45:

/* Line 1806 of yacc.c  */
#line 1301 "compilers/imcc/imcc.y"
    { (yyval.sr) = NULL; }
    break;

  case 46:

/* Line 1806 of yacc.c  */
#line 1305 "compilers/imcc/imcc.y"
    {
           imcc->nkeys    = 0;
         }
    break;

  case 47:

/* Line 1806 of yacc.c  */
#line 1309 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = link_keys(imcc, imcc->nkeys, imcc->keys, 0);
         }
    break;

  case 48:

/* Line 1806 of yacc.c  */
#line 1315 "compilers/imcc/imcc.y"
    { imcc->keys[imcc->nkeys++] = (yyvsp[(1) - (1)].sr); }
    break;

  case 49:

/* Line 1806 of yacc.c  */
#line 1317 "compilers/imcc/imcc.y"
    {
           imcc->keys[imcc->nkeys++] = (yyvsp[(3) - (3)].sr);
           (yyval.sr) = imcc->keys[0];
         }
    break;

  case 50:

/* Line 1806 of yacc.c  */
#line 1325 "compilers/imcc/imcc.y"
    {
           imcc->cur_unit = imc_open_unit(imcc, IMC_PCCSUB);
         }
    break;

  case 51:

/* Line 1806 of yacc.c  */
#line 1329 "compilers/imcc/imcc.y"
    {
           iSUBROUTINE(imcc, imcc->cur_unit, (yyvsp[(3) - (3)].sr));
         }
    break;

  case 52:

/* Line 1806 of yacc.c  */
#line 1333 "compilers/imcc/imcc.y"
    {
          imcc->cur_call->pcc_sub->pragma = (yyvsp[(5) - (6)].t);
          if (!imcc->cur_unit->instructions->symregs[0]->subid) {
            imcc->cur_unit->instructions->symregs[0]->subid =
                imcc->cur_unit->instructions->symregs[0];
          }
        }
    break;

  case 53:

/* Line 1806 of yacc.c  */
#line 1340 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; imcc->cur_call = NULL; }
    break;

  case 54:

/* Line 1806 of yacc.c  */
#line 1345 "compilers/imcc/imcc.y"
    { imcc->is_def = 1; }
    break;

  case 55:

/* Line 1806 of yacc.c  */
#line 1347 "compilers/imcc/imcc.y"
    {
           if (/* IMCC_INFO(interp)->cur_unit->last_ins->op
           ||  */ !(imcc->cur_unit->last_ins->type & ITPCCPARAM)) {
               SymReg *r;
               Instruction *i;
               char name[128];
               snprintf(name, sizeof (name), "%cpcc_params_%d",
                        IMCC_INTERNAL_CHAR, imcc->cnr++);
               r = mk_symreg(imcc, name, 0);
               r->type    = VT_PCC_SUB;
               r->pcc_sub = mem_gc_allocate_zeroed_typed(imcc->interp, pcc_sub_t);
               i = iLABEL(imcc, imcc->cur_unit, r);
               imcc->cur_call = r;
               i->type = ITPCCPARAM;
           }
           if (imcc->adv_named_id) {
                 add_pcc_named_param(imcc, imcc->cur_call,
                                     imcc->adv_named_id, (yyvsp[(3) - (4)].sr));
                 imcc->adv_named_id = NULL;
           }
           else
               add_pcc_arg(imcc, imcc->cur_call, (yyvsp[(3) - (4)].sr));
         }
    break;

  case 56:

/* Line 1806 of yacc.c  */
#line 1370 "compilers/imcc/imcc.y"
    { imcc->is_def = 0; }
    break;

  case 57:

/* Line 1806 of yacc.c  */
#line 1375 "compilers/imcc/imcc.y"
    {
           if ((yyvsp[(3) - (3)].t) & VT_OPT_FLAG && (yyvsp[(1) - (3)].t) != 'I') {
               const char *type;
               switch ((yyvsp[(1) - (3)].t)) {
                    case 'N': type = "num";     break;
                    case 'S': type = "string";  break;
                    case 'P': type = "pmc";     break;
                    default:  type = "strange"; break;
               }

               IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                   ":opt_flag parameter must be of type 'int', not '%s'", type);
           }
           if ((yyvsp[(3) - (3)].t) & VT_NAMED && !((yyvsp[(3) - (3)].t) & VT_FLAT) && !imcc->adv_named_id)
               adv_named_set(imcc, (yyvsp[(2) - (3)].s));
           (yyval.sr) = mk_ident(imcc, (yyvsp[(2) - (3)].s), (yyvsp[(1) - (3)].t), VTIDENTIFIER);
           (yyval.sr)->type |= (yyvsp[(3) - (3)].t);
           mem_sys_free((yyvsp[(2) - (3)].s));
          }
    break;

  case 58:

/* Line 1806 of yacc.c  */
#line 1399 "compilers/imcc/imcc.y"
    { (yyval.t) = 0; }
    break;

  case 59:

/* Line 1806 of yacc.c  */
#line 1404 "compilers/imcc/imcc.y"
    {
           add_pcc_multi(imcc, imcc->cur_call, NULL);
         }
    break;

  case 60:

/* Line 1806 of yacc.c  */
#line 1408 "compilers/imcc/imcc.y"
    {
           (yyval.t) = 0;
           add_pcc_multi(imcc, imcc->cur_call, (yyvsp[(3) - (3)].sr));
         }
    break;

  case 61:

/* Line 1806 of yacc.c  */
#line 1413 "compilers/imcc/imcc.y"
    {
           (yyval.t) = 0;
           add_pcc_multi(imcc, imcc->cur_call, (yyvsp[(1) - (1)].sr));
         }
    break;

  case 62:

/* Line 1806 of yacc.c  */
#line 1420 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_const(imcc, "INTVAL",   'S'); }
    break;

  case 63:

/* Line 1806 of yacc.c  */
#line 1421 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_const(imcc, "FLOATVAL", 'S'); }
    break;

  case 64:

/* Line 1806 of yacc.c  */
#line 1422 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_const(imcc, "PMC",      'S'); }
    break;

  case 65:

/* Line 1806 of yacc.c  */
#line 1423 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_const(imcc, "STRING",   'S'); }
    break;

  case 66:

/* Line 1806 of yacc.c  */
#line 1425 "compilers/imcc/imcc.y"
    {
           SymReg *r;
           if (strcmp((yyvsp[(1) - (1)].s), "_") != 0)
               r = mk_const(imcc, (yyvsp[(1) - (1)].s), 'S');
           else {
               r = mk_const(imcc, "PMC", 'S');
           }
           mem_sys_free((yyvsp[(1) - (1)].s));
           (yyval.sr) = r;
         }
    break;

  case 67:

/* Line 1806 of yacc.c  */
#line 1436 "compilers/imcc/imcc.y"
    {
           SymReg *r;
           if (strcmp((yyvsp[(1) - (1)].s), "\"_\"") == 0 || strcmp((yyvsp[(1) - (1)].s), "'_'") == 0)
               r = mk_const(imcc, "PMC", 'S');
           else {
               r = mk_const(imcc, (yyvsp[(1) - (1)].s), 'S');
           }
           mem_sys_free((yyvsp[(1) - (1)].s));
           (yyval.sr) = r;
         }
    break;

  case 68:

/* Line 1806 of yacc.c  */
#line 1446 "compilers/imcc/imcc.y"
    { (yyval.sr) = (yyvsp[(2) - (3)].sr); }
    break;

  case 69:

/* Line 1806 of yacc.c  */
#line 1451 "compilers/imcc/imcc.y"
    { (yyval.t) = 0; }
    break;

  case 70:

/* Line 1806 of yacc.c  */
#line 1456 "compilers/imcc/imcc.y"
    {
           SymReg * const r = mk_const(imcc, (yyvsp[(3) - (3)].s), 'S');
           add_pcc_flag_str(imcc, imcc->cur_call, r);
           mem_sys_free((yyvsp[(3) - (3)].s));
           (yyval.sr) = r;
         }
    break;

  case 71:

/* Line 1806 of yacc.c  */
#line 1463 "compilers/imcc/imcc.y"
    {
           SymReg * const r = mk_const(imcc, (yyvsp[(1) - (1)].s), 'S');
           add_pcc_flag_str(imcc, imcc->cur_call, r);
           mem_sys_free((yyvsp[(1) - (1)].s));
           (yyval.sr) = r;
         }
    break;

  case 72:

/* Line 1806 of yacc.c  */
#line 1474 "compilers/imcc/imcc.y"
    {
           (yyval.t) = 0;
           imcc->cur_unit->outer = mk_sub_address_fromc(imcc, (yyvsp[(3) - (4)].s));
           mem_sys_free((yyvsp[(3) - (4)].s));
         }
    break;

  case 73:

/* Line 1806 of yacc.c  */
#line 1480 "compilers/imcc/imcc.y"
    {
           (yyval.t) = 0;
           imcc->cur_unit->outer = mk_const(imcc, (yyvsp[(3) - (4)].s), 'S');
           mem_sys_free((yyvsp[(3) - (4)].s));
         }
    break;

  case 74:

/* Line 1806 of yacc.c  */
#line 1489 "compilers/imcc/imcc.y"
    {
           (yyval.t) = P_VTABLE;
           imcc->cur_unit->vtable_name      = NULL;
           imcc->cur_unit->is_vtable_method = 1;
         }
    break;

  case 75:

/* Line 1806 of yacc.c  */
#line 1495 "compilers/imcc/imcc.y"
    {
           (yyval.t) = P_VTABLE;
           imcc->cur_unit->vtable_name      = (yyvsp[(3) - (4)].s);
           imcc->cur_unit->is_vtable_method = 1;
         }
    break;

  case 76:

/* Line 1806 of yacc.c  */
#line 1504 "compilers/imcc/imcc.y"
    {
           (yyval.t) = P_METHOD;
           imcc->cur_unit->method_name = NULL;
           imcc->cur_unit->is_method   = 1;
         }
    break;

  case 77:

/* Line 1806 of yacc.c  */
#line 1510 "compilers/imcc/imcc.y"
    {
           (yyval.t) = P_METHOD;
           imcc->cur_unit->method_name = (yyvsp[(3) - (4)].s);
           imcc->cur_unit->is_method   = 1;
         }
    break;

  case 78:

/* Line 1806 of yacc.c  */
#line 1519 "compilers/imcc/imcc.y"
    {
           (yyval.t) = P_NSENTRY;
           imcc->cur_unit->ns_entry_name     = NULL;
           imcc->cur_unit->has_ns_entry_name = 1;
         }
    break;

  case 79:

/* Line 1806 of yacc.c  */
#line 1525 "compilers/imcc/imcc.y"
    {
           (yyval.t) = P_NSENTRY;
           imcc->cur_unit->ns_entry_name = (yyvsp[(3) - (4)].s);
           imcc->cur_unit->has_ns_entry_name = 1;
         }
    break;

  case 80:

/* Line 1806 of yacc.c  */
#line 1534 "compilers/imcc/imcc.y"
    {
           (yyval.t) = 0;
           imcc->cur_unit->instance_of = (yyvsp[(3) - (4)].s);
         }
    break;

  case 81:

/* Line 1806 of yacc.c  */
#line 1542 "compilers/imcc/imcc.y"
    {
           (yyval.t) = 0;
           imcc->cur_unit->subid = NULL;
         }
    break;

  case 82:

/* Line 1806 of yacc.c  */
#line 1547 "compilers/imcc/imcc.y"
    {
           SymReg *r = mk_const(imcc, (yyvsp[(3) - (4)].s), 'S');
           (yyval.t) = 0;
           imcc->cur_unit->subid = r;
           imcc->cur_unit->instructions->symregs[0]->subid = r;
           mem_sys_free((yyvsp[(3) - (4)].s));
         }
    break;

  case 85:

/* Line 1806 of yacc.c  */
#line 1563 "compilers/imcc/imcc.y"
    {
           char name[128];
           SymReg *r;
           Instruction *i;

           snprintf(name, sizeof (name), "%cpcc_sub_call_%d",
                   IMCC_INTERNAL_CHAR, imcc->cnr++);
           (yyval.sr) = r = mk_pcc_sub(imcc, name, 0);
           /* this mid rule action has the semantic value of the
            * sub SymReg.
            * This is used below to append args & results
            */
           i = iLABEL(imcc, imcc->cur_unit, r);
           imcc->cur_call = r;
           i->type = ITPCCSUB;
         }
    break;

  case 86:

/* Line 1806 of yacc.c  */
#line 1584 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; imcc->cur_call = NULL; }
    break;

  case 87:

/* Line 1806 of yacc.c  */
#line 1588 "compilers/imcc/imcc.y"
    { (yyval.i) = NULL; imcc->cur_call->pcc_sub->label = 0; }
    break;

  case 88:

/* Line 1806 of yacc.c  */
#line 1589 "compilers/imcc/imcc.y"
    { (yyval.i) = NULL; imcc->cur_call->pcc_sub->label = 1; }
    break;

  case 89:

/* Line 1806 of yacc.c  */
#line 1593 "compilers/imcc/imcc.y"
    { (yyval.i) = NULL; }
    break;

  case 90:

/* Line 1806 of yacc.c  */
#line 1594 "compilers/imcc/imcc.y"
    { (yyval.i) = NULL;  imcc->cur_call->pcc_sub->object = (yyvsp[(2) - (3)].sr); }
    break;

  case 91:

/* Line 1806 of yacc.c  */
#line 1598 "compilers/imcc/imcc.y"
    { (yyval.t) = 0; }
    break;

  case 93:

/* Line 1806 of yacc.c  */
#line 1603 "compilers/imcc/imcc.y"
    { (yyval.t) = (yyvsp[(1) - (1)].t); }
    break;

  case 94:

/* Line 1806 of yacc.c  */
#line 1604 "compilers/imcc/imcc.y"
    { (yyval.t) = (yyvsp[(1) - (2)].t) | (yyvsp[(2) - (2)].t); }
    break;

  case 95:

/* Line 1806 of yacc.c  */
#line 1608 "compilers/imcc/imcc.y"
    {
                (yyval.t) = P_LOAD;
                /*
                SymReg * const r = mk_const(imcc, "load", 'S');
                add_pcc_flag_str(imcc, imcc->cur_call, r);
                $$ = r;
                */
            }
    break;

  case 96:

/* Line 1806 of yacc.c  */
#line 1616 "compilers/imcc/imcc.y"
    {
                (yyval.t) = P_INIT;
                /*
                SymReg * const r = mk_const(imcc, "load", 'S');
                add_pcc_flag_str(imcc, imcc->cur_call, r);
                $$ = r;
                */
            }
    break;

  case 97:

/* Line 1806 of yacc.c  */
#line 1624 "compilers/imcc/imcc.y"
    { (yyval.t) = P_MAIN; }
    break;

  case 98:

/* Line 1806 of yacc.c  */
#line 1625 "compilers/imcc/imcc.y"
    { (yyval.t) = P_IMMEDIATE; }
    break;

  case 99:

/* Line 1806 of yacc.c  */
#line 1626 "compilers/imcc/imcc.y"
    { (yyval.t) = P_POSTCOMP; }
    break;

  case 100:

/* Line 1806 of yacc.c  */
#line 1627 "compilers/imcc/imcc.y"
    { (yyval.t) = P_ANON; }
    break;

  case 101:

/* Line 1806 of yacc.c  */
#line 1628 "compilers/imcc/imcc.y"
    { (yyval.t) = P_NEED_LEX; }
    break;

  case 110:

/* Line 1806 of yacc.c  */
#line 1641 "compilers/imcc/imcc.y"
    {
           add_pcc_sub(imcc->cur_call, (yyvsp[(2) - (5)].sr));
           add_pcc_cc(imcc->cur_call, (yyvsp[(4) - (5)].sr));
         }
    break;

  case 111:

/* Line 1806 of yacc.c  */
#line 1646 "compilers/imcc/imcc.y"
    {
           add_pcc_sub(imcc->cur_call, (yyvsp[(2) - (3)].sr));
         }
    break;

  case 112:

/* Line 1806 of yacc.c  */
#line 1652 "compilers/imcc/imcc.y"
    { (yyval.sr) = 0; }
    break;

  case 113:

/* Line 1806 of yacc.c  */
#line 1654 "compilers/imcc/imcc.y"
    {
                 if (imcc->adv_named_id) {
                     add_pcc_named_param(imcc, imcc->cur_call,
                                    imcc->adv_named_id, (yyvsp[(2) - (3)].sr));
                     imcc->adv_named_id = NULL;
                 }
                 else
                     add_pcc_arg(imcc, imcc->cur_call, (yyvsp[(2) - (3)].sr));
            }
    break;

  case 114:

/* Line 1806 of yacc.c  */
#line 1666 "compilers/imcc/imcc.y"
    { (yyval.sr) = (yyvsp[(2) - (2)].sr); }
    break;

  case 115:

/* Line 1806 of yacc.c  */
#line 1671 "compilers/imcc/imcc.y"
    { (yyval.sr) = 0; }
    break;

  case 116:

/* Line 1806 of yacc.c  */
#line 1673 "compilers/imcc/imcc.y"
    {
           if ((yyvsp[(2) - (3)].sr))
               add_pcc_result(imcc, imcc->cur_call, (yyvsp[(2) - (3)].sr));
         }
    break;

  case 117:

/* Line 1806 of yacc.c  */
#line 1680 "compilers/imcc/imcc.y"
    { (yyval.sr) = (yyvsp[(2) - (3)].sr); (yyval.sr)->type |= (yyvsp[(3) - (3)].t); }
    break;

  case 118:

/* Line 1806 of yacc.c  */
#line 1681 "compilers/imcc/imcc.y"
    { imcc->is_def = 1; }
    break;

  case 119:

/* Line 1806 of yacc.c  */
#line 1682 "compilers/imcc/imcc.y"
    {
           IdList * const l = (yyvsp[(4) - (4)].idlist);
           SymReg *ignored;
           ignored = mk_ident(imcc, l->id, (yyvsp[(3) - (4)].t), VTIDENTIFIER);
           UNUSED(ignored);
           imcc->is_def = 0;
           (yyval.sr) = 0;
         }
    break;

  case 120:

/* Line 1806 of yacc.c  */
#line 1693 "compilers/imcc/imcc.y"
    { (yyval.t) = 0; }
    break;

  case 121:

/* Line 1806 of yacc.c  */
#line 1694 "compilers/imcc/imcc.y"
    { (yyval.t) = (yyvsp[(1) - (2)].t) | (yyvsp[(2) - (2)].t); }
    break;

  case 122:

/* Line 1806 of yacc.c  */
#line 1698 "compilers/imcc/imcc.y"
    { (yyval.t) = VT_FLAT;   }
    break;

  case 123:

/* Line 1806 of yacc.c  */
#line 1699 "compilers/imcc/imcc.y"
    { (yyval.t) = VT_OPTIONAL; }
    break;

  case 124:

/* Line 1806 of yacc.c  */
#line 1700 "compilers/imcc/imcc.y"
    { (yyval.t) = VT_OPT_FLAG; }
    break;

  case 125:

/* Line 1806 of yacc.c  */
#line 1701 "compilers/imcc/imcc.y"
    { (yyval.t) = VT_NAMED; }
    break;

  case 126:

/* Line 1806 of yacc.c  */
#line 1702 "compilers/imcc/imcc.y"
    { adv_named_set(imcc, (yyvsp[(3) - (4)].s));   (yyval.t) = VT_NAMED; mem_sys_free((yyvsp[(3) - (4)].s)); }
    break;

  case 127:

/* Line 1806 of yacc.c  */
#line 1703 "compilers/imcc/imcc.y"
    { adv_named_set_u(imcc, (yyvsp[(3) - (4)].s)); (yyval.t) = VT_NAMED; mem_sys_free((yyvsp[(3) - (4)].s)); }
    break;

  case 128:

/* Line 1806 of yacc.c  */
#line 1704 "compilers/imcc/imcc.y"
    { (yyval.t) = VT_CALL_SIG; }
    break;

  case 129:

/* Line 1806 of yacc.c  */
#line 1709 "compilers/imcc/imcc.y"
    { begin_return_or_yield(imcc, 0); }
    break;

  case 130:

/* Line 1806 of yacc.c  */
#line 1711 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; imcc->asm_state = AsmDefault; }
    break;

  case 131:

/* Line 1806 of yacc.c  */
#line 1713 "compilers/imcc/imcc.y"
    {
           imcc->asm_state = AsmDefault;
           (yyval.i) = 0;
         }
    break;

  case 132:

/* Line 1806 of yacc.c  */
#line 1720 "compilers/imcc/imcc.y"
    { begin_return_or_yield(imcc, 1); }
    break;

  case 133:

/* Line 1806 of yacc.c  */
#line 1722 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; imcc->asm_state = AsmDefault; }
    break;

  case 134:

/* Line 1806 of yacc.c  */
#line 1726 "compilers/imcc/imcc.y"
    { (yyval.sr) = 0; }
    break;

  case 135:

/* Line 1806 of yacc.c  */
#line 1728 "compilers/imcc/imcc.y"
    {
           if ((yyvsp[(1) - (2)].sr))
               add_pcc_result(imcc, imcc->sr_return, (yyvsp[(1) - (2)].sr));
         }
    break;

  case 136:

/* Line 1806 of yacc.c  */
#line 1733 "compilers/imcc/imcc.y"
    {
           if ((yyvsp[(2) - (3)].sr))
               add_pcc_result(imcc, imcc->sr_return, (yyvsp[(2) - (3)].sr));
         }
    break;

  case 137:

/* Line 1806 of yacc.c  */
#line 1740 "compilers/imcc/imcc.y"
    { (yyval.sr) = 0; }
    break;

  case 138:

/* Line 1806 of yacc.c  */
#line 1742 "compilers/imcc/imcc.y"
    {
           if ((yyvsp[(1) - (2)].sr))
               add_pcc_result(imcc, imcc->sr_return, (yyvsp[(1) - (2)].sr));
         }
    break;

  case 139:

/* Line 1806 of yacc.c  */
#line 1747 "compilers/imcc/imcc.y"
    {
           if ((yyvsp[(2) - (3)].sr))
               add_pcc_result(imcc, imcc->sr_return, (yyvsp[(2) - (3)].sr));
         }
    break;

  case 140:

/* Line 1806 of yacc.c  */
#line 1754 "compilers/imcc/imcc.y"
    { (yyval.sr) = (yyvsp[(2) - (3)].sr); (yyval.sr)->type |= (yyvsp[(3) - (3)].t); }
    break;

  case 141:

/* Line 1806 of yacc.c  */
#line 1758 "compilers/imcc/imcc.y"
    { (yyval.sr) = (yyvsp[(2) - (3)].sr); (yyval.sr)->type |= (yyvsp[(3) - (3)].t); }
    break;

  case 142:

/* Line 1806 of yacc.c  */
#line 1763 "compilers/imcc/imcc.y"
    {
          if (imcc->asm_state == AsmDefault)
              begin_return_or_yield(imcc, (yyvsp[(1) - (2)].t));
        }
    break;

  case 143:

/* Line 1806 of yacc.c  */
#line 1768 "compilers/imcc/imcc.y"
    {
          imcc->asm_state = AsmDefault;
          (yyval.t) = 0;
        }
    break;

  case 144:

/* Line 1806 of yacc.c  */
#line 1775 "compilers/imcc/imcc.y"
    { (yyval.t) = 0; }
    break;

  case 145:

/* Line 1806 of yacc.c  */
#line 1776 "compilers/imcc/imcc.y"
    { (yyval.t) = 1; }
    break;

  case 146:

/* Line 1806 of yacc.c  */
#line 1780 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; }
    break;

  case 147:

/* Line 1806 of yacc.c  */
#line 1782 "compilers/imcc/imcc.y"
    {
           if (imcc->adv_named_id) {
               add_pcc_named_return(imcc, imcc->sr_return,
                                    imcc->adv_named_id, (yyvsp[(1) - (1)].sr));
               imcc->adv_named_id = NULL;
           }
           else
               add_pcc_result(imcc, imcc->sr_return, (yyvsp[(1) - (1)].sr));
         }
    break;

  case 148:

/* Line 1806 of yacc.c  */
#line 1792 "compilers/imcc/imcc.y"
    {
            SymReg * const name = mk_const(imcc, (yyvsp[(1) - (3)].s), 'S');
            add_pcc_named_return(imcc, imcc->sr_return, name, (yyvsp[(3) - (3)].sr));
         }
    break;

  case 149:

/* Line 1806 of yacc.c  */
#line 1797 "compilers/imcc/imcc.y"
    {
           if (imcc->adv_named_id) {
               add_pcc_named_return(imcc, imcc->sr_return,
                                    imcc->adv_named_id, (yyvsp[(3) - (3)].sr));
               imcc->adv_named_id = NULL;
             }
             else
                 add_pcc_result(imcc, imcc->sr_return, (yyvsp[(3) - (3)].sr));
         }
    break;

  case 150:

/* Line 1806 of yacc.c  */
#line 1807 "compilers/imcc/imcc.y"
    {
           SymReg * const name = mk_const(imcc, (yyvsp[(3) - (5)].s), 'S');
           add_pcc_named_return(imcc, imcc->sr_return, name, (yyvsp[(5) - (5)].sr));
         }
    break;

  case 153:

/* Line 1806 of yacc.c  */
#line 1828 "compilers/imcc/imcc.y"
    { clear_state(imcc); }
    break;

  case 154:

/* Line 1806 of yacc.c  */
#line 1832 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; }
    break;

  case 155:

/* Line 1806 of yacc.c  */
#line 1834 "compilers/imcc/imcc.y"
    { (yyval.i) = (yyvsp[(2) - (2)].i); }
    break;

  case 156:

/* Line 1806 of yacc.c  */
#line 1835 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; }
    break;

  case 157:

/* Line 1806 of yacc.c  */
#line 1836 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; }
    break;

  case 158:

/* Line 1806 of yacc.c  */
#line 1837 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; }
    break;

  case 159:

/* Line 1806 of yacc.c  */
#line 1838 "compilers/imcc/imcc.y"
    { (yyval.i) = (yyvsp[(1) - (1)].i); }
    break;

  case 160:

/* Line 1806 of yacc.c  */
#line 1842 "compilers/imcc/imcc.y"
    { (yyval.i) = NULL; }
    break;

  case 164:

/* Line 1806 of yacc.c  */
#line 1853 "compilers/imcc/imcc.y"
    {
             Instruction * const i = iLABEL(imcc, imcc->cur_unit,
                    mk_local_label(imcc, (yyvsp[(1) - (1)].s)));
             mem_sys_free((yyvsp[(1) - (1)].s));
             (yyval.i) = i;
         }
    break;

  case 165:

/* Line 1806 of yacc.c  */
#line 1864 "compilers/imcc/imcc.y"
    { (yyval.i) = (yyvsp[(2) - (3)].i); }
    break;

  case 166:

/* Line 1806 of yacc.c  */
#line 1866 "compilers/imcc/imcc.y"
    {
           if (yynerrs >= PARROT_MAX_RECOVER_ERRORS) {
               IMCC_warning(imcc, "Too many errors. Correct some first.\n");
               YYABORT;
           }
           yyerrok;
         }
    break;

  case 167:

/* Line 1806 of yacc.c  */
#line 1877 "compilers/imcc/imcc.y"
    {
           IdList* const l = (yyvsp[(1) - (1)].idlist);
           l->next = NULL;
           (yyval.idlist) = l;
         }
    break;

  case 168:

/* Line 1806 of yacc.c  */
#line 1884 "compilers/imcc/imcc.y"
    {
           IdList* const l = (yyvsp[(3) - (3)].idlist);
           l->next = (yyvsp[(1) - (3)].idlist);
           (yyval.idlist) = l;
         }
    break;

  case 169:

/* Line 1806 of yacc.c  */
#line 1893 "compilers/imcc/imcc.y"
    {
           IdList* const l = mem_gc_allocate_n_zeroed_typed(imcc->interp, 1, IdList);
           l->id           = (yyvsp[(1) - (1)].s);
           (yyval.idlist) = l;
         }
    break;

  case 172:

/* Line 1806 of yacc.c  */
#line 1903 "compilers/imcc/imcc.y"
    { imcc->is_def = 1; }
    break;

  case 173:

/* Line 1806 of yacc.c  */
#line 1904 "compilers/imcc/imcc.y"
    {
           IdList *l = (yyvsp[(4) - (4)].idlist);
           while (l) {
               IdList *l1;
               mk_ident(imcc, l->id, (yyvsp[(3) - (4)].t), VTIDENTIFIER);
               l1 = l;
               l  = l->next;
               mem_sys_free(l1->id);
               mem_sys_free(l1);
           }
           imcc->is_def = 0; (yyval.i) = 0;
         }
    break;

  case 174:

/* Line 1806 of yacc.c  */
#line 1917 "compilers/imcc/imcc.y"
    {
           SymReg *n;
           char   *name = mem_sys_strdup((yyvsp[(2) - (4)].s) + 1);
           name[strlen(name) - 1] = 0;
           n = mk_const(imcc, name, 'S');
           set_lexical(imcc, (yyvsp[(4) - (4)].sr), n); (yyval.i) = 0;
           mem_sys_free((yyvsp[(2) - (4)].s));
           mem_sys_free(name);
         }
    break;

  case 175:

/* Line 1806 of yacc.c  */
#line 1927 "compilers/imcc/imcc.y"
    {
           SymReg *n = mk_const(imcc, (yyvsp[(2) - (4)].s), 'U');
           set_lexical(imcc, (yyvsp[(4) - (4)].sr), n); (yyval.i) = 0;
           mem_sys_free((yyvsp[(2) - (4)].s));
         }
    break;

  case 176:

/* Line 1806 of yacc.c  */
#line 1932 "compilers/imcc/imcc.y"
    { imcc->is_def = 1; }
    break;

  case 177:

/* Line 1806 of yacc.c  */
#line 1933 "compilers/imcc/imcc.y"
    {
           mk_const_ident(imcc, (yyvsp[(4) - (6)].s), (yyvsp[(3) - (6)].t), (yyvsp[(6) - (6)].sr), 0);
           imcc->is_def = 0;
           mem_sys_free((yyvsp[(4) - (6)].s));
         }
    break;

  case 179:

/* Line 1806 of yacc.c  */
#line 1940 "compilers/imcc/imcc.y"
    { imcc->is_def = 1; }
    break;

  case 180:

/* Line 1806 of yacc.c  */
#line 1941 "compilers/imcc/imcc.y"
    {
           mk_const_ident(imcc, (yyvsp[(4) - (6)].s), (yyvsp[(3) - (6)].t), (yyvsp[(6) - (6)].sr), 1);
           imcc->is_def = 0;
           mem_sys_free((yyvsp[(4) - (6)].s));
         }
    break;

  case 181:

/* Line 1806 of yacc.c  */
#line 1947 "compilers/imcc/imcc.y"
    {
           (yyval.i) = NULL;
           imcc->cur_call->pcc_sub->tailcall = 1;
           imcc->cur_call = NULL;
         }
    break;

  case 182:

/* Line 1806 of yacc.c  */
#line 1953 "compilers/imcc/imcc.y"
    {
            (yyval.i) = MK_I(imcc, imcc->cur_unit, "branch", 1, (yyvsp[(2) - (2)].sr));
         }
    break;

  case 183:

/* Line 1806 of yacc.c  */
#line 1957 "compilers/imcc/imcc.y"
    {
           (yyval.i) = INS(imcc, imcc->cur_unit, (yyvsp[(1) - (2)].s), 0, imcc->regs, imcc->nargs,
                    imcc->keyvec, 1);
           mem_sys_free((yyvsp[(1) - (2)].s));
         }
    break;

  case 184:

/* Line 1806 of yacc.c  */
#line 1962 "compilers/imcc/imcc.y"
    { (yyval.i) = MK_I(imcc, imcc->cur_unit, "null", 1, (yyvsp[(2) - (2)].sr)); }
    break;

  case 185:

/* Line 1806 of yacc.c  */
#line 1963 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; imcc->cur_call = NULL; }
    break;

  case 186:

/* Line 1806 of yacc.c  */
#line 1964 "compilers/imcc/imcc.y"
    { (yyval.i) = 0; }
    break;

  case 189:

/* Line 1806 of yacc.c  */
#line 1967 "compilers/imcc/imcc.y"
    { (yyval.i) = 0;}
    break;

  case 190:

/* Line 1806 of yacc.c  */
#line 1971 "compilers/imcc/imcc.y"
    {(yyval.t) = 'I'; }
    break;

  case 191:

/* Line 1806 of yacc.c  */
#line 1972 "compilers/imcc/imcc.y"
    { (yyval.t) = 'N'; }
    break;

  case 192:

/* Line 1806 of yacc.c  */
#line 1973 "compilers/imcc/imcc.y"
    { (yyval.t) = 'S'; }
    break;

  case 193:

/* Line 1806 of yacc.c  */
#line 1974 "compilers/imcc/imcc.y"
    { (yyval.t) = 'P'; }
    break;

  case 194:

/* Line 1806 of yacc.c  */
#line 1979 "compilers/imcc/imcc.y"
    { (yyval.i) = MK_I(imcc, imcc->cur_unit, "set", 2, (yyvsp[(1) - (3)].sr), (yyvsp[(3) - (3)].sr));  }
    break;

  case 195:

/* Line 1806 of yacc.c  */
#line 1981 "compilers/imcc/imcc.y"
    { (yyval.i) = MK_I(imcc, imcc->cur_unit, (yyvsp[(3) - (4)].s), 2, (yyvsp[(1) - (4)].sr), (yyvsp[(4) - (4)].sr));  }
    break;

  case 196:

/* Line 1806 of yacc.c  */
#line 1983 "compilers/imcc/imcc.y"
    { (yyval.i) = MK_I(imcc, imcc->cur_unit, (yyvsp[(4) - (5)].s), 3, (yyvsp[(1) - (5)].sr), (yyvsp[(3) - (5)].sr), (yyvsp[(5) - (5)].sr)); }
    break;

  case 197:

/* Line 1806 of yacc.c  */
#line 1985 "compilers/imcc/imcc.y"
    { (yyval.i) = iINDEXFETCH(imcc, imcc->cur_unit, (yyvsp[(1) - (6)].sr), (yyvsp[(3) - (6)].sr), (yyvsp[(5) - (6)].sr)); }
    break;

  case 198:

/* Line 1806 of yacc.c  */
#line 1987 "compilers/imcc/imcc.y"
    { (yyval.i) = iINDEXSET(imcc, imcc->cur_unit, (yyvsp[(1) - (6)].sr), (yyvsp[(3) - (6)].sr), (yyvsp[(6) - (6)].sr)); }
    break;

  case 199:

/* Line 1806 of yacc.c  */
#line 1990 "compilers/imcc/imcc.y"
    {
           add_pcc_result(imcc, (yyvsp[(3) - (3)].i)->symregs[0], (yyvsp[(1) - (3)].sr));
           imcc->cur_call = NULL;
           (yyval.i) = 0;
         }
    break;

  case 200:

/* Line 1806 of yacc.c  */
#line 1996 "compilers/imcc/imcc.y"
    {
           (yyval.i) = IMCC_create_itcall_label(imcc);
         }
    break;

  case 201:

/* Line 1806 of yacc.c  */
#line 2000 "compilers/imcc/imcc.y"
    {
           IMCC_itcall_sub(imcc, (yyvsp[(6) - (9)].sr));
           imcc->cur_call = NULL;
         }
    break;

  case 205:

/* Line 1806 of yacc.c  */
#line 2008 "compilers/imcc/imcc.y"
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "null", 1, (yyvsp[(1) - (3)].sr));
         }
    break;

  case 206:

/* Line 1806 of yacc.c  */
#line 2015 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"not"; }
    break;

  case 207:

/* Line 1806 of yacc.c  */
#line 2016 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"bnot"; }
    break;

  case 208:

/* Line 1806 of yacc.c  */
#line 2017 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"neg"; }
    break;

  case 209:

/* Line 1806 of yacc.c  */
#line 2021 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"sub"; }
    break;

  case 210:

/* Line 1806 of yacc.c  */
#line 2022 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"add"; }
    break;

  case 211:

/* Line 1806 of yacc.c  */
#line 2023 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"mul"; }
    break;

  case 212:

/* Line 1806 of yacc.c  */
#line 2024 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"div"; }
    break;

  case 213:

/* Line 1806 of yacc.c  */
#line 2025 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"mod"; }
    break;

  case 214:

/* Line 1806 of yacc.c  */
#line 2026 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"fdiv"; }
    break;

  case 215:

/* Line 1806 of yacc.c  */
#line 2027 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"pow"; }
    break;

  case 216:

/* Line 1806 of yacc.c  */
#line 2028 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"concat"; }
    break;

  case 217:

/* Line 1806 of yacc.c  */
#line 2029 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"iseq"; }
    break;

  case 218:

/* Line 1806 of yacc.c  */
#line 2030 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"isne"; }
    break;

  case 219:

/* Line 1806 of yacc.c  */
#line 2031 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"isgt"; }
    break;

  case 220:

/* Line 1806 of yacc.c  */
#line 2032 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"isge"; }
    break;

  case 221:

/* Line 1806 of yacc.c  */
#line 2033 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"islt"; }
    break;

  case 222:

/* Line 1806 of yacc.c  */
#line 2034 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"isle"; }
    break;

  case 223:

/* Line 1806 of yacc.c  */
#line 2035 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"shl"; }
    break;

  case 224:

/* Line 1806 of yacc.c  */
#line 2036 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"shr"; }
    break;

  case 225:

/* Line 1806 of yacc.c  */
#line 2037 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"lsr"; }
    break;

  case 226:

/* Line 1806 of yacc.c  */
#line 2038 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"and"; }
    break;

  case 227:

/* Line 1806 of yacc.c  */
#line 2039 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"or"; }
    break;

  case 228:

/* Line 1806 of yacc.c  */
#line 2040 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"xor"; }
    break;

  case 229:

/* Line 1806 of yacc.c  */
#line 2041 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"band"; }
    break;

  case 230:

/* Line 1806 of yacc.c  */
#line 2042 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"bor"; }
    break;

  case 231:

/* Line 1806 of yacc.c  */
#line 2043 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"bxor"; }
    break;

  case 232:

/* Line 1806 of yacc.c  */
#line 2049 "compilers/imcc/imcc.y"
    {
           (yyval.i) = IMCC_create_itcall_label(imcc);
           (yyval.i)->type &= ~ITCALL;
           (yyval.i)->type |= ITRESULT;
         }
    break;

  case 233:

/* Line 1806 of yacc.c  */
#line 2054 "compilers/imcc/imcc.y"
    {  (yyval.i) = 0; }
    break;

  case 234:

/* Line 1806 of yacc.c  */
#line 2061 "compilers/imcc/imcc.y"
    { (yyval.i) = MK_I(imcc, imcc->cur_unit, (yyvsp[(2) - (3)].s), 2, (yyvsp[(1) - (3)].sr), (yyvsp[(3) - (3)].sr)); }
    break;

  case 235:

/* Line 1806 of yacc.c  */
#line 2063 "compilers/imcc/imcc.y"
    {
             if ((yyvsp[(1) - (3)].sr)->set == 'P')
                 (yyval.i) = MK_I(imcc, imcc->cur_unit, "concat", 2, (yyvsp[(1) - (3)].sr), (yyvsp[(3) - (3)].sr));
             else
                 (yyval.i) = MK_I(imcc, imcc->cur_unit, "concat", 3, (yyvsp[(1) - (3)].sr), (yyvsp[(1) - (3)].sr), (yyvsp[(3) - (3)].sr));
         }
    break;

  case 236:

/* Line 1806 of yacc.c  */
#line 2072 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"add"; }
    break;

  case 237:

/* Line 1806 of yacc.c  */
#line 2073 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"sub"; }
    break;

  case 238:

/* Line 1806 of yacc.c  */
#line 2074 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"mul"; }
    break;

  case 239:

/* Line 1806 of yacc.c  */
#line 2075 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"div"; }
    break;

  case 240:

/* Line 1806 of yacc.c  */
#line 2076 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"mod"; }
    break;

  case 241:

/* Line 1806 of yacc.c  */
#line 2077 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"fdiv"; }
    break;

  case 242:

/* Line 1806 of yacc.c  */
#line 2078 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"band"; }
    break;

  case 243:

/* Line 1806 of yacc.c  */
#line 2079 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"bor"; }
    break;

  case 244:

/* Line 1806 of yacc.c  */
#line 2080 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"bxor"; }
    break;

  case 245:

/* Line 1806 of yacc.c  */
#line 2081 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"shr"; }
    break;

  case 246:

/* Line 1806 of yacc.c  */
#line 2082 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"shl"; }
    break;

  case 247:

/* Line 1806 of yacc.c  */
#line 2083 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"lsr"; }
    break;

  case 248:

/* Line 1806 of yacc.c  */
#line 2089 "compilers/imcc/imcc.y"
    {
        (yyval.i) = func_ins(imcc, imcc->cur_unit, (yyvsp[(1) - (4)].sr), (yyvsp[(3) - (4)].s), imcc -> regs,
                      imcc -> nargs, imcc -> keyvec, 1);
         mem_sys_free((yyvsp[(3) - (4)].s));
       }
    break;

  case 249:

/* Line 1806 of yacc.c  */
#line 2097 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_sub_address(imcc, (yyvsp[(1) - (1)].s));       mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 250:

/* Line 1806 of yacc.c  */
#line 2098 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_sub_address_fromc(imcc, (yyvsp[(1) - (1)].s)); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 251:

/* Line 1806 of yacc.c  */
#line 2099 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_sub_address_u(imcc, (yyvsp[(1) - (1)].s));     mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 252:

/* Line 1806 of yacc.c  */
#line 2101 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = (yyvsp[(1) - (1)].sr);
           if ((yyvsp[(1) - (1)].sr)->set != 'P')
               IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR, "Sub isn't a PMC");
         }
    break;

  case 253:

/* Line 1806 of yacc.c  */
#line 2107 "compilers/imcc/imcc.y"
    {
            /* disallow bareword method names; SREG name constants are fine */
            const char * const name = (yyvsp[(3) - (3)].sr)->name;
            if (!((yyvsp[(3) - (3)].sr)->type & VTREG)) {
                if (*name != '\'' || *name != '\"')
                    IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR,
                        "Bareword method name '%s' not allowed in PIR",
                        (yyvsp[(3) - (3)].sr)->name);
            }

            imcc->cur_obj = (yyvsp[(1) - (3)].sr);
            (yyval.sr) = (yyvsp[(3) - (3)].sr);
        }
    break;

  case 254:

/* Line 1806 of yacc.c  */
#line 2121 "compilers/imcc/imcc.y"
    {
            imcc->cur_obj = (yyvsp[(1) - (3)].sr);
            (yyval.sr) = mk_const(imcc, (yyvsp[(3) - (3)].s), 'U');
            mem_sys_free((yyvsp[(3) - (3)].s));
         }
    break;

  case 255:

/* Line 1806 of yacc.c  */
#line 2127 "compilers/imcc/imcc.y"
    {
            imcc->cur_obj = (yyvsp[(1) - (3)].sr);
            (yyval.sr) = mk_const(imcc, (yyvsp[(3) - (3)].s), 'S');
            mem_sys_free((yyvsp[(3) - (3)].s));
         }
    break;

  case 256:

/* Line 1806 of yacc.c  */
#line 2133 "compilers/imcc/imcc.y"
    {
            imcc->cur_obj = (yyvsp[(1) - (3)].sr);
            (yyval.sr) = (yyvsp[(3) - (3)].sr);
        }
    break;

  case 257:

/* Line 1806 of yacc.c  */
#line 2142 "compilers/imcc/imcc.y"
    {
           (yyval.i) = IMCC_create_itcall_label(imcc);
           IMCC_itcall_sub(imcc, (yyvsp[(1) - (1)].sr));
         }
    break;

  case 258:

/* Line 1806 of yacc.c  */
#line 2146 "compilers/imcc/imcc.y"
    { (yyval.i) = (yyvsp[(2) - (5)].i); }
    break;

  case 259:

/* Line 1806 of yacc.c  */
#line 2150 "compilers/imcc/imcc.y"
    { (yyval.sr) = 0; }
    break;

  case 260:

/* Line 1806 of yacc.c  */
#line 2152 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = 0;
           if (imcc->adv_named_id) {
               add_pcc_named_arg(imcc, imcc->cur_call, imcc->adv_named_id, (yyvsp[(3) - (3)].sr));
               imcc->adv_named_id = NULL;
           }
           else
               add_pcc_arg(imcc, imcc->cur_call, (yyvsp[(3) - (3)].sr));
         }
    break;

  case 261:

/* Line 1806 of yacc.c  */
#line 2162 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = 0;
           if (imcc->adv_named_id) {
               add_pcc_named_arg(imcc, imcc->cur_call, imcc->adv_named_id, (yyvsp[(1) - (1)].sr));
               imcc->adv_named_id = NULL;
           }
           else
               add_pcc_arg(imcc, imcc->cur_call, (yyvsp[(1) - (1)].sr));
         }
    break;

  case 262:

/* Line 1806 of yacc.c  */
#line 2172 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = 0;
           add_pcc_named_arg(imcc, imcc->cur_call, mk_const(imcc, (yyvsp[(3) - (5)].s), 'S'), (yyvsp[(5) - (5)].sr));
           mem_sys_free((yyvsp[(3) - (5)].s));
         }
    break;

  case 263:

/* Line 1806 of yacc.c  */
#line 2178 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = 0;
           add_pcc_named_arg_var(imcc, imcc->cur_call, (yyvsp[(1) - (3)].sr), (yyvsp[(3) - (3)].sr));
         }
    break;

  case 264:

/* Line 1806 of yacc.c  */
#line 2183 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = 0;
           add_pcc_named_arg(imcc, imcc->cur_call,
                mk_const(imcc, (yyvsp[(1) - (3)].s), 'S'), (yyvsp[(3) - (3)].sr));
           mem_sys_free((yyvsp[(1) - (3)].s));
         }
    break;

  case 265:

/* Line 1806 of yacc.c  */
#line 2192 "compilers/imcc/imcc.y"
    { (yyval.sr) = (yyvsp[(1) - (2)].sr); (yyval.sr)->type |= (yyvsp[(2) - (2)].t); }
    break;

  case 266:

/* Line 1806 of yacc.c  */
#line 2196 "compilers/imcc/imcc.y"
    { (yyval.t) = 0; }
    break;

  case 267:

/* Line 1806 of yacc.c  */
#line 2197 "compilers/imcc/imcc.y"
    { (yyval.t) = (yyvsp[(1) - (2)].t) | (yyvsp[(2) - (2)].t); }
    break;

  case 268:

/* Line 1806 of yacc.c  */
#line 2201 "compilers/imcc/imcc.y"
    { (yyval.t) = VT_FLAT;     }
    break;

  case 269:

/* Line 1806 of yacc.c  */
#line 2202 "compilers/imcc/imcc.y"
    { (yyval.t) = VT_NAMED;    }
    break;

  case 270:

/* Line 1806 of yacc.c  */
#line 2203 "compilers/imcc/imcc.y"
    { (yyval.t) = VT_CALL_SIG; }
    break;

  case 271:

/* Line 1806 of yacc.c  */
#line 2206 "compilers/imcc/imcc.y"
    {
            adv_named_set_u(imcc, (yyvsp[(3) - (4)].s));
            mem_sys_free((yyvsp[(3) - (4)].s));
            (yyval.t) = 0;
        }
    break;

  case 272:

/* Line 1806 of yacc.c  */
#line 2212 "compilers/imcc/imcc.y"
    {
            adv_named_set(imcc, (yyvsp[(3) - (4)].s));
            mem_sys_free((yyvsp[(3) - (4)].s));
            (yyval.t) = 0;
        }
    break;

  case 273:

/* Line 1806 of yacc.c  */
#line 2220 "compilers/imcc/imcc.y"
    { (yyval.sr) = (yyvsp[(1) - (2)].sr); (yyval.sr)->type |= (yyvsp[(2) - (2)].t); }
    break;

  case 274:

/* Line 1806 of yacc.c  */
#line 2225 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = 0;
           if (imcc->adv_named_id) {
               add_pcc_named_result(imcc, imcc->cur_call, imcc->adv_named_id, (yyvsp[(3) - (3)].sr));
               imcc->adv_named_id = NULL;
           }
           else
               add_pcc_result(imcc, imcc->cur_call, (yyvsp[(3) - (3)].sr));
         }
    break;

  case 275:

/* Line 1806 of yacc.c  */
#line 2235 "compilers/imcc/imcc.y"
    {
            add_pcc_named_result(imcc, imcc->cur_call,
                    mk_const(imcc, (yyvsp[(3) - (5)].s), 'S'), (yyvsp[(5) - (5)].sr));
            mem_sys_free((yyvsp[(3) - (5)].s));
         }
    break;

  case 276:

/* Line 1806 of yacc.c  */
#line 2241 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = 0;
           if (imcc->adv_named_id) {
               add_pcc_named_result(imcc, imcc->cur_call, imcc->adv_named_id, (yyvsp[(1) - (1)].sr));
               imcc->adv_named_id = NULL;
           }
           else
               add_pcc_result(imcc, imcc->cur_call, (yyvsp[(1) - (1)].sr));
         }
    break;

  case 277:

/* Line 1806 of yacc.c  */
#line 2251 "compilers/imcc/imcc.y"
    {
           add_pcc_named_result(imcc, imcc->cur_call, mk_const(imcc, (yyvsp[(1) - (3)].s), 'S'), (yyvsp[(3) - (3)].sr));
           mem_sys_free((yyvsp[(1) - (3)].s));
         }
    break;

  case 278:

/* Line 1806 of yacc.c  */
#line 2255 "compilers/imcc/imcc.y"
    { (yyval.sr) = 0; }
    break;

  case 279:

/* Line 1806 of yacc.c  */
#line 2259 "compilers/imcc/imcc.y"
    { (yyval.i) = (yyvsp[(1) - (1)].i); }
    break;

  case 280:

/* Line 1806 of yacc.c  */
#line 2260 "compilers/imcc/imcc.y"
    { (yyval.i) = (yyvsp[(1) - (1)].i); }
    break;

  case 281:

/* Line 1806 of yacc.c  */
#line 2265 "compilers/imcc/imcc.y"
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, inv_op((yyvsp[(3) - (6)].s)), 3, (yyvsp[(2) - (6)].sr), (yyvsp[(4) - (6)].sr), (yyvsp[(6) - (6)].sr));
         }
    break;

  case 282:

/* Line 1806 of yacc.c  */
#line 2269 "compilers/imcc/imcc.y"
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "unless_null", 2, (yyvsp[(3) - (5)].sr), (yyvsp[(5) - (5)].sr));
         }
    break;

  case 283:

/* Line 1806 of yacc.c  */
#line 2273 "compilers/imcc/imcc.y"
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "unless", 2, (yyvsp[(2) - (4)].sr), (yyvsp[(4) - (4)].sr));
         }
    break;

  case 284:

/* Line 1806 of yacc.c  */
#line 2280 "compilers/imcc/imcc.y"
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "if", 2, (yyvsp[(2) - (4)].sr), (yyvsp[(4) - (4)].sr));
         }
    break;

  case 285:

/* Line 1806 of yacc.c  */
#line 2284 "compilers/imcc/imcc.y"
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, (yyvsp[(3) - (6)].s), 3, (yyvsp[(2) - (6)].sr), (yyvsp[(4) - (6)].sr), (yyvsp[(6) - (6)].sr));
         }
    break;

  case 286:

/* Line 1806 of yacc.c  */
#line 2288 "compilers/imcc/imcc.y"
    {
           (yyval.i) = MK_I(imcc, imcc->cur_unit, "if_null", 2, (yyvsp[(3) - (5)].sr), (yyvsp[(5) - (5)].sr));
         }
    break;

  case 287:

/* Line 1806 of yacc.c  */
#line 2294 "compilers/imcc/imcc.y"
    { (yyval.t) = 0; }
    break;

  case 288:

/* Line 1806 of yacc.c  */
#line 2295 "compilers/imcc/imcc.y"
    { (yyval.t) = 0; }
    break;

  case 289:

/* Line 1806 of yacc.c  */
#line 2299 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"eq"; }
    break;

  case 290:

/* Line 1806 of yacc.c  */
#line 2300 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"ne"; }
    break;

  case 291:

/* Line 1806 of yacc.c  */
#line 2301 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"gt"; }
    break;

  case 292:

/* Line 1806 of yacc.c  */
#line 2302 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"ge"; }
    break;

  case 293:

/* Line 1806 of yacc.c  */
#line 2303 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"lt"; }
    break;

  case 294:

/* Line 1806 of yacc.c  */
#line 2304 "compilers/imcc/imcc.y"
    { (yyval.s) = (char *)"le"; }
    break;

  case 297:

/* Line 1806 of yacc.c  */
#line 2313 "compilers/imcc/imcc.y"
    { (yyval.sr) = NULL; }
    break;

  case 298:

/* Line 1806 of yacc.c  */
#line 2314 "compilers/imcc/imcc.y"
    { (yyval.sr) = (yyvsp[(1) - (1)].sr); }
    break;

  case 299:

/* Line 1806 of yacc.c  */
#line 2318 "compilers/imcc/imcc.y"
    { (yyval.sr) = imcc->regs[0]; }
    break;

  case 301:

/* Line 1806 of yacc.c  */
#line 2323 "compilers/imcc/imcc.y"
    { imcc->regs[imcc->nargs++] = (yyvsp[(1) - (1)].sr); }
    break;

  case 302:

/* Line 1806 of yacc.c  */
#line 2325 "compilers/imcc/imcc.y"
    {
           imcc -> regs[imcc->nargs++] = (yyvsp[(1) - (4)].sr);
           imcc -> keyvec |= KEY_BIT(imcc->nargs);
           imcc -> regs[imcc->nargs++] = (yyvsp[(3) - (4)].sr);
           (yyval.sr) = (yyvsp[(1) - (4)].sr);
         }
    break;

  case 303:

/* Line 1806 of yacc.c  */
#line 2332 "compilers/imcc/imcc.y"
    {
           imcc -> regs[imcc->nargs++] = (yyvsp[(2) - (3)].sr);
           (yyval.sr) = (yyvsp[(2) - (3)].sr);
         }
    break;

  case 305:

/* Line 1806 of yacc.c  */
#line 2339 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_sub_address_fromc(imcc, (yyvsp[(1) - (1)].s)); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 306:

/* Line 1806 of yacc.c  */
#line 2340 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_sub_address_u(imcc, (yyvsp[(1) - (1)].s));     mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 307:

/* Line 1806 of yacc.c  */
#line 2344 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_sub_address(imcc, (yyvsp[(1) - (1)].s)); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 308:

/* Line 1806 of yacc.c  */
#line 2345 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_sub_address(imcc, (yyvsp[(1) - (1)].s)); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 309:

/* Line 1806 of yacc.c  */
#line 2349 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_label_address(imcc, (yyvsp[(1) - (1)].s)); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 310:

/* Line 1806 of yacc.c  */
#line 2350 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_label_address(imcc, (yyvsp[(1) - (1)].s)); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 315:

/* Line 1806 of yacc.c  */
#line 2364 "compilers/imcc/imcc.y"
    {
           imcc->nkeys    = 0;
         }
    break;

  case 316:

/* Line 1806 of yacc.c  */
#line 2368 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = link_keys(imcc, imcc->nkeys, imcc->keys, 0);
         }
    break;

  case 317:

/* Line 1806 of yacc.c  */
#line 2374 "compilers/imcc/imcc.y"
    {
           imcc->nkeys = 0;
         }
    break;

  case 318:

/* Line 1806 of yacc.c  */
#line 2378 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = link_keys(imcc,
                          imcc->nkeys,
                          imcc->keys, 1);
         }
    break;

  case 319:

/* Line 1806 of yacc.c  */
#line 2386 "compilers/imcc/imcc.y"
    { imcc->keys[imcc->nkeys++] = (yyvsp[(1) - (1)].sr); }
    break;

  case 320:

/* Line 1806 of yacc.c  */
#line 2388 "compilers/imcc/imcc.y"
    {
           imcc->keys[imcc->nkeys++] = (yyvsp[(3) - (3)].sr);
           (yyval.sr) = imcc->keys[0];
         }
    break;

  case 321:

/* Line 1806 of yacc.c  */
#line 2396 "compilers/imcc/imcc.y"
    {
           (yyval.sr) = (yyvsp[(1) - (1)].sr);
         }
    break;

  case 322:

/* Line 1806 of yacc.c  */
#line 2402 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_symreg(imcc, (yyvsp[(1) - (1)].s), 'I'); }
    break;

  case 323:

/* Line 1806 of yacc.c  */
#line 2403 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_symreg(imcc, (yyvsp[(1) - (1)].s), 'N'); }
    break;

  case 324:

/* Line 1806 of yacc.c  */
#line 2404 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_symreg(imcc, (yyvsp[(1) - (1)].s), 'S'); }
    break;

  case 325:

/* Line 1806 of yacc.c  */
#line 2405 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_symreg(imcc, (yyvsp[(1) - (1)].s), 'P'); }
    break;

  case 326:

/* Line 1806 of yacc.c  */
#line 2406 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_pasm_reg(imcc, (yyvsp[(1) - (1)].s)); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 327:

/* Line 1806 of yacc.c  */
#line 2410 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_const(imcc, (yyvsp[(1) - (1)].s), 'S'); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 328:

/* Line 1806 of yacc.c  */
#line 2411 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_const(imcc, (yyvsp[(1) - (1)].s), 'U'); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 329:

/* Line 1806 of yacc.c  */
#line 2415 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_const(imcc, (yyvsp[(1) - (1)].s), 'I'); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 330:

/* Line 1806 of yacc.c  */
#line 2416 "compilers/imcc/imcc.y"
    { (yyval.sr) = mk_const(imcc, (yyvsp[(1) - (1)].s), 'N'); mem_sys_free((yyvsp[(1) - (1)].s)); }
    break;

  case 331:

/* Line 1806 of yacc.c  */
#line 2417 "compilers/imcc/imcc.y"
    { (yyval.sr) = (yyvsp[(1) - (1)].sr); }
    break;



/* Line 1806 of yacc.c  */
#line 5734 "compilers/imcc/imcparser.c"
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (yyscanner, imcc, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yyscanner, imcc, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, yyscanner, imcc);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, yyscanner, imcc);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (yyscanner, imcc, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, yyscanner, imcc);
    }
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, yyscanner, imcc);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 2067 of yacc.c  */
#line 2421 "compilers/imcc/imcc.y"


/* I need this prototype somewhere... */
char *yyget_text(yyscan_t yyscanner);

/* I do not like this function, but, atm, it is the only way I can
 * make the code in yyerror work without segfault on some specific
 * cases.
 */
/* int yyholds_char(yyscan_t yyscanner); */

int yyerror(void *yyscanner, ARGMOD(imc_info_t *imcc), const char *s)
{
    /* If the error occurr in the end of the buffer (I mean, the last
     * token was already read), yyget_text will return a pointer
     * outside the bison buffer, and thus, not "accessible" by
     * us. This means it may segfault. */
    const char * const chr = yyget_text((yyscan_t)yyscanner);

    /* IMCC_fataly(imcc, EXCEPTION_SYNTAX_ERROR, s); */
    /* --- This was called before, not sure if I should call some
           similar function that does not die like this one. */

    /* Basically, if current token is a newline, it mean the error was
     * before the newline, and thus, line is the line *after* the
     * error. Instead of duplicating code for both cases (the 'newline' and
     * non-newline case, do the test twice; efficiency is not important when
     * we have an error anyway. */
    if (!at_eof(yyscanner)) {
        IMCC_warning(imcc, "error:imcc:%s", s);

        /* don't print the current token if it is a newline */
        if (*chr != '\n')
            IMCC_warning(imcc, " ('%s')", chr);

        IMCC_print_inc(imcc);
    }

    /* scanner is at EOF; just to be sure, don't print "current" token */
    else {
        IMCC_warning(imcc, "error:imcc:%s", s);
        IMCC_print_inc(imcc);
    }

    return 0;
}

/*

=back

 */
/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4 cinoptions='\:2=2' :
 */
