/*	Native_Methods

PIRL CVS ID: Native_Methods.java,v 1.5 2012/04/16 06:04:10 castalia Exp

Copyright (C) 2007-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package	PIRL.Conductor;

/**	Native methods.
<p>
	An encapsulation of native method interfaces.
<p>
	This class contains only static methods. It loads the required
	native library automatically the first time it is used.
<p>
	@author		Andrew Davidson, Bradford Castalia - UA/PIRL
	@version	1.5
*/
public class Native_Methods
{
/**	Class name and version identification.
*/
public static final String
	ID = "PIRL.Conductor.Native_Methods (1.5 2012/04/16 06:04:10)";

/**	The name of the library that contains the native methods implementations.
*/
public static final String
	NATIVE_METHODS_LIBRARY_NAME	= "Native_Methods";

/**	Process ID of the JVM.
*/
private static int
	JVM_PID = 0;

//	Load the library and intialize data members.
static {load_library ();}


// Debug control.
private static final int
	DEBUG_OFF					= 0,
	DEBUG_SETUP					= 1 << 0,
	DEBUG_ALL					= -1,

	DEBUG						= DEBUG_OFF;


/**	This class contains only static methods; there's nothing to construct.
*/
private Native_Methods ()
{}

/**	Load the {@link #NATIVE_METHODS_LIBRARY_NAME} library.

	After the library is successfully loaded the process ID of the
	JVM is cached locally. If the library fails to load successfully
	nothing is done.
*/
private static void load_library ()
{
if ((DEBUG & DEBUG_SETUP) != 0)
	System.out.println
		(">>> Native_Methods.load_library");
try
	{
	System.loadLibrary (NATIVE_METHODS_LIBRARY_NAME);
	if ((DEBUG & DEBUG_SETUP) != 0)
		System.out.println
			("    Library " + NATIVE_METHODS_LIBRARY_NAME + " loaded.");

	JVM_PID = get_PID ();
	if ((DEBUG & DEBUG_SETUP) != 0)
		System.out.println
			("    JVM_PID initialized to " + JVM_PID);
	}
catch (SecurityException exception)
	{
	if ((DEBUG & DEBUG_SETUP) != 0)
		System.out.println
			("    " + exception);
	}
catch (UnsatisfiedLinkError exception)
	{
	if ((DEBUG & DEBUG_SETUP) != 0)
		System.out.println
			("    " + exception);
	}
if ((DEBUG & DEBUG_SETUP) != 0)
	System.out.println
		("<<< Native_Methods.load_library");
}

/**	Native_Methods function interface.

	@return	The PID obtained from the getpid system function.
*/
private static native int get_PID ();

/**	Get the process ID of the Java Virtual Machine.

	The process ID has been pre-fetched, so there is no overhead cost
	in repeated accesses to its value.

	If the library implementing the native method that provides the
	interface to the getpid system function did not load successfully,
	then the return value will be zero.

	@return	The process ID (PID) of the JVM running this class. This
		will be zero if the native getpid system function could not
		be accessed because the {@link #NATIVE_METHODS_LIBRARY_NAME}
		library failed to load.
*/
public static int PID ()
{return JVM_PID;}

}
