/* Tic-Tac-Toe plasmoid
 * Copyright (C) 2009 Mauro E. Bender <mbender@dc.uba.ar>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _PLASMATICTACTOE_H
#define _PLASMATICTACTOE_H

#include "theme.h"
#include "tictactoe.h"
#include "appearanceSettings.h"
#include "playersSettings.h"

#include <Plasma/Applet>
#include <Plasma/Svg>

class QSizeF;

class PlasmaTictactoe : public Plasma::Applet {
	Q_OBJECT
	
	public:
		PlasmaTictactoe( QObject *, const QVariantList &);
		~PlasmaTictactoe();
		
		void paintInterface( QPainter *, const QStyleOptionGraphicsItem *, const QRect&);
		void init();
		void mousePressEvent(QGraphicsSceneMouseEvent *event);
		QList< QAction*> contextualActions() { return _contextualActions; }
		void createConfigurationInterface ( KConfigDialog *parent );
		
	private:
		Tictactoe *_tictactoe;
		AppearanceSettings *_appearanceSettings;
		PlayersSettings *_playersSettings;
		QList<QAction *> _contextualActions;
		Plasma::Svg _xo;
		Theme _currentTheme;
		
	private slots:
		void resetGame();
		void applyConfiguration();
};

K_EXPORT_PLASMA_APPLET(tictactoe,PlasmaTictactoe );

#endif
