# coding=utf-8
# pylint: disable=too-many-lines,anomalous-backslash-in-string,name-too-long
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_discriminator, rest_field
from ._enums import (
    DistributionModeKind,
    ExceptionActionKind,
    ExceptionTriggerKind,
    JobMatchingModeKind,
    QueueSelectorAttachmentKind,
    RouterRuleKind,
    WorkerSelectorAttachmentKind,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AcceptJobOfferResult(_model_base.Model):
    """Response containing ids for the worker, job, and assignment from an accepted offer.

    All required parameters must be populated in order to send to server.

    :ivar assignment_id: Id of job assignment that assigns a worker that has accepted an offer to a
     job. Required.
    :vartype assignment_id: str
    :ivar job_id: Id of the job assigned. Required.
    :vartype job_id: str
    :ivar worker_id: Id of the worker that has been assigned this job. Required.
    :vartype worker_id: str
    """

    assignment_id: str = rest_field(name="assignmentId")
    """Id of job assignment that assigns a worker that has accepted an offer to a job. Required."""
    job_id: str = rest_field(name="jobId")
    """Id of the job assigned. Required."""
    worker_id: str = rest_field(name="workerId")
    """Id of the worker that has been assigned this job. Required."""

    @overload
    def __init__(
        self,
        *,
        assignment_id: str,
        job_id: str,
        worker_id: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DistributionMode(_model_base.Model):
    """Abstract base class for defining a distribution mode.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BestWorkerMode, LongestIdleMode, RoundRobinMode

    All required parameters must be populated in order to send to server.

    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: If set to true, then router will match workers to jobs even if they
     don't match label selectors. Warning: You may get workers that are not qualified for a job they
     are matched with if you set this variable to true. This flag is intended more for temporary
     usage. By default, set to false.
    :vartype bypass_selectors: bool
    :ivar kind: The type discriminator describing a sub-type of DistributionMode. Required. Known
     values are: "bestWorker", "longestIdle", and "roundRobin".
    :vartype kind: str or ~azure.communication.jobrouter.models.DistributionModeKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    min_concurrent_offers: Optional[int] = rest_field(name="minConcurrentOffers")
    """Governs the minimum desired number of active concurrent offers a job can have."""
    max_concurrent_offers: Optional[int] = rest_field(name="maxConcurrentOffers")
    """Governs the maximum number of active concurrent offers a job can have."""
    bypass_selectors: Optional[bool] = rest_field(name="bypassSelectors")
    """If set to true, then router will match workers to jobs even if they don't match label
     selectors. Warning: You may get workers that are not qualified for a job they are matched with
     if you set this variable to true. This flag is intended more for temporary usage. By default,
     set to false."""
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a sub-type of DistributionMode. Required. Known values are:
     \"bestWorker\", \"longestIdle\", and \"roundRobin\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        min_concurrent_offers: Optional[int] = None,
        max_concurrent_offers: Optional[int] = None,
        bypass_selectors: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class BestWorkerMode(DistributionMode, discriminator="bestWorker"):
    """Jobs are distributed to the worker with the strongest abilities available.

    All required parameters must be populated in order to send to server.

    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: If set to true, then router will match workers to jobs even if they
     don't match label selectors. Warning: You may get workers that are not qualified for a job they
     are matched with if you set this variable to true. This flag is intended more for temporary
     usage. By default, set to false.
    :vartype bypass_selectors: bool
    :ivar scoring_rule: Define a scoring rule to use, when calculating a score to determine the
     best worker. If not set, will use a default scoring formula that uses the number of job labels
     that the worker labels match, as well as the number of label selectors the worker labels match
     and/or exceed using a logistic function (https://en.wikipedia.org/wiki/Logistic_function).
    :vartype scoring_rule: ~azure.communication.jobrouter.models.RouterRule
    :ivar scoring_rule_options: Options to configure 'scoringRule'. If not set, default values are
     used.
    :vartype scoring_rule_options: ~azure.communication.jobrouter.models.ScoringRuleOptions
    :ivar kind: The type discriminator describing a sub-type of Mode. Required. Discriminator value
     for BestWorkerMode.
    :vartype kind: str or ~azure.communication.jobrouter.models.BEST_WORKER
    """

    scoring_rule: Optional["_models.RouterRule"] = rest_field(name="scoringRule")
    """Define a scoring rule to use, when calculating a score to determine the best worker. If not
     set, will use a default scoring formula that uses the number of job labels that the worker
     labels match, as well as the number of label selectors the worker labels match and/or exceed
     using a logistic function (https://en.wikipedia.org/wiki/Logistic_function)."""
    scoring_rule_options: Optional["_models.ScoringRuleOptions"] = rest_field(name="scoringRuleOptions")
    """Options to configure 'scoringRule'. If not set, default values are used."""
    kind: Literal[DistributionModeKind.BEST_WORKER] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of Mode. Required. Discriminator value for
     BestWorkerMode."""

    @overload
    def __init__(
        self,
        *,
        min_concurrent_offers: Optional[int] = None,
        max_concurrent_offers: Optional[int] = None,
        bypass_selectors: Optional[bool] = None,
        scoring_rule: Optional["_models.RouterRule"] = None,
        scoring_rule_options: Optional["_models.ScoringRuleOptions"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=DistributionModeKind.BEST_WORKER, **kwargs)


class ExceptionAction(_model_base.Model):
    """The action to take when the exception is triggered.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CancelExceptionAction, ManualReclassifyExceptionAction, ReclassifyExceptionAction

    All required parameters must be populated in order to send to server.

    :ivar id: Unique Id of the exception action.
    :vartype id: str
    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required. Known
     values are: "cancel", "manualReclassify", and "reclassify".
    :vartype kind: str or ~azure.communication.jobrouter.models.ExceptionActionKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    id: Optional[str] = rest_field()
    """Unique Id of the exception action."""
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a sub-type of ExceptionAction. Required. Known values are:
     \"cancel\", \"manualReclassify\", and \"reclassify\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CancelExceptionAction(ExceptionAction, discriminator="cancel"):
    """An action that marks a job as cancelled.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique Id of the exception action.
    :vartype id: str
    :ivar note: A note that will be appended to a job's notes collection with the current
     timestamp.
    :vartype note: str
    :ivar disposition_code: Indicates the outcome of a job, populate this field with your own
     custom values.
    :vartype disposition_code: str
    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
     Discriminator value for CancelExceptionAction.
    :vartype kind: str or ~azure.communication.jobrouter.models.CANCEL
    """

    note: Optional[str] = rest_field()
    """A note that will be appended to a job's notes collection with the current timestamp."""
    disposition_code: Optional[str] = rest_field(name="dispositionCode")
    """Indicates the outcome of a job, populate this field with your own custom values."""
    kind: Literal[ExceptionActionKind.CANCEL] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of ExceptionAction. Required. Discriminator value
     for CancelExceptionAction."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        note: Optional[str] = None,
        disposition_code: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=ExceptionActionKind.CANCEL, **kwargs)


class CancelJobOptions(_model_base.Model):
    """Request payload for cancelling a job.

    :ivar note: A note that will be appended to a job's Notes collection with the current
     timestamp.
    :vartype note: str
    :ivar disposition_code: Indicates the outcome of a job, populate this field with your own
     custom values. If not provided, default value of "Cancelled" is set.
    :vartype disposition_code: str
    """

    note: Optional[str] = rest_field()
    """A note that will be appended to a job's Notes collection with the current timestamp."""
    disposition_code: Optional[str] = rest_field(name="dispositionCode")
    """Indicates the outcome of a job, populate this field with your own custom values. If not
     provided, default value of \"Cancelled\" is set."""

    @overload
    def __init__(
        self,
        *,
        note: Optional[str] = None,
        disposition_code: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CancelJobResult(_model_base.Model):
    """Response payload from cancelling a job."""


class ClassificationPolicy(_model_base.Model):
    """A container for the rules that govern how jobs are classified.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar etag: The entity tag for this resource. Required.
    :vartype etag: str
    :ivar id: Id of a classification policy. Required.
    :vartype id: str
    :ivar name: Friendly name of this policy.
    :vartype name: str
    :ivar fallback_queue_id: Id of a fallback queue to select if queue selector attachments doesn't
     find a match.
    :vartype fallback_queue_id: str
    :ivar queue_selector_attachments: Queue selector attachments used to resolve a queue for a job.
    :vartype queue_selector_attachments:
     list[~azure.communication.jobrouter.models.QueueSelectorAttachment]
    :ivar prioritization_rule: A rule to determine a priority score for a job.
    :vartype prioritization_rule: ~azure.communication.jobrouter.models.RouterRule
    :ivar worker_selector_attachments: Worker selector attachments used to attach worker selectors
     to a job.
    :vartype worker_selector_attachments:
     list[~azure.communication.jobrouter.models.WorkerSelectorAttachment]
    """

    etag: str = rest_field(visibility=["read"])
    """The entity tag for this resource. Required."""
    id: str = rest_field(visibility=["read"])
    """Id of a classification policy. Required."""
    name: Optional[str] = rest_field()
    """Friendly name of this policy."""
    fallback_queue_id: Optional[str] = rest_field(name="fallbackQueueId")
    """Id of a fallback queue to select if queue selector attachments doesn't find a match."""
    queue_selector_attachments: Optional[List["_models.QueueSelectorAttachment"]] = rest_field(
        name="queueSelectorAttachments"
    )
    """Queue selector attachments used to resolve a queue for a job."""
    prioritization_rule: Optional["_models.RouterRule"] = rest_field(name="prioritizationRule")
    """A rule to determine a priority score for a job."""
    worker_selector_attachments: Optional[List["_models.WorkerSelectorAttachment"]] = rest_field(
        name="workerSelectorAttachments"
    )
    """Worker selector attachments used to attach worker selectors to a job."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        fallback_queue_id: Optional[str] = None,
        queue_selector_attachments: Optional[List["_models.QueueSelectorAttachment"]] = None,
        prioritization_rule: Optional["_models.RouterRule"] = None,
        worker_selector_attachments: Optional[List["_models.WorkerSelectorAttachment"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CloseJobOptions(_model_base.Model):
    """Request payload for closing jobs.

    :ivar disposition_code: Indicates the outcome of a job, populate this field with your own
     custom values.
    :vartype disposition_code: str
    :ivar close_at: If not provided, worker capacity is released immediately along with a
     JobClosedEvent notification. If provided, worker capacity is released along with a
     JobClosedEvent notification at a future time in UTC.
    :vartype close_at: ~datetime.datetime
    :ivar note: A note that will be appended to a job's Notes collection with the current
     timestamp.
    :vartype note: str
    """

    disposition_code: Optional[str] = rest_field(name="dispositionCode")
    """Indicates the outcome of a job, populate this field with your own custom values."""
    close_at: Optional[datetime.datetime] = rest_field(name="closeAt", format="rfc3339")
    """If not provided, worker capacity is released immediately along with a JobClosedEvent
     notification. If provided, worker capacity is released along with a JobClosedEvent notification
     at a future time in UTC."""
    note: Optional[str] = rest_field()
    """A note that will be appended to a job's Notes collection with the current timestamp."""

    @overload
    def __init__(
        self,
        *,
        disposition_code: Optional[str] = None,
        close_at: Optional[datetime.datetime] = None,
        note: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CloseJobResult(_model_base.Model):
    """Response payload from closing a job."""


class CompleteJobOptions(_model_base.Model):
    """Request payload for completing jobs.

    :ivar note: A note that will be appended to a job's Notes collection with the current
     timestamp.
    :vartype note: str
    """

    note: Optional[str] = rest_field()
    """A note that will be appended to a job's Notes collection with the current timestamp."""

    @overload
    def __init__(
        self,
        *,
        note: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class CompleteJobResult(_model_base.Model):
    """Response payload from completing a job."""


class QueueSelectorAttachment(_model_base.Model):
    """An attachment of queue selectors to resolve a queue to a job from a classification policy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConditionalQueueSelectorAttachment, PassThroughQueueSelectorAttachment,
    RuleEngineQueueSelectorAttachment, StaticQueueSelectorAttachment,
    WeightedAllocationQueueSelectorAttachment

    All required parameters must be populated in order to send to server.

    :ivar kind: The type discriminator describing a sub-type of QueueSelectorAttachment. Required.
     Known values are: "conditional", "passThrough", "ruleEngine", "static", and
     "weightedAllocation".
    :vartype kind: str or ~azure.communication.jobrouter.models.QueueSelectorAttachmentKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a sub-type of QueueSelectorAttachment. Required. Known values
     are: \"conditional\", \"passThrough\", \"ruleEngine\", \"static\", and \"weightedAllocation\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ConditionalQueueSelectorAttachment(QueueSelectorAttachment, discriminator="conditional"):
    """Describes a set of queue selectors that will be attached if the given condition resolves to
    true.

    All required parameters must be populated in order to send to server.

    :ivar condition: The condition that must be true for the queue selectors to be attached.
     Required.
    :vartype condition: ~azure.communication.jobrouter.models.RouterRule
    :ivar queue_selectors: The queue selectors to attach. Required.
    :vartype queue_selectors: list[~azure.communication.jobrouter.models.RouterQueueSelector]
    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
     Discriminator value for ConditionalQueueSelectorAttachment.
    :vartype kind: str or ~azure.communication.jobrouter.models.CONDITIONAL
    """

    condition: "_models.RouterRule" = rest_field()
    """The condition that must be true for the queue selectors to be attached. Required."""
    queue_selectors: List["_models.RouterQueueSelector"] = rest_field(name="queueSelectors")
    """The queue selectors to attach. Required."""
    kind: Literal[QueueSelectorAttachmentKind.CONDITIONAL] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing the type of queue selector attachment. Required.
     Discriminator value for ConditionalQueueSelectorAttachment."""

    @overload
    def __init__(
        self,
        *,
        condition: "_models.RouterRule",
        queue_selectors: List["_models.RouterQueueSelector"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=QueueSelectorAttachmentKind.CONDITIONAL, **kwargs)


class WorkerSelectorAttachment(_model_base.Model):
    """An attachment which attaches worker selectors to a job.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConditionalWorkerSelectorAttachment, PassThroughWorkerSelectorAttachment,
    RuleEngineWorkerSelectorAttachment, StaticWorkerSelectorAttachment,
    WeightedAllocationWorkerSelectorAttachment

    All required parameters must be populated in order to send to server.

    :ivar kind: The type discriminator describing a sub-type of WorkerSelectorAttachment. Required.
     Known values are: "conditional", "passThrough", "ruleEngine", "static", and
     "weightedAllocation".
    :vartype kind: str or ~azure.communication.jobrouter.models.WorkerSelectorAttachmentKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a sub-type of WorkerSelectorAttachment. Required. Known
     values are: \"conditional\", \"passThrough\", \"ruleEngine\", \"static\", and
     \"weightedAllocation\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ConditionalWorkerSelectorAttachment(WorkerSelectorAttachment, discriminator="conditional"):
    """Describes a set of worker selectors that will be attached if the given condition resolves to
    true.

    All required parameters must be populated in order to send to server.

    :ivar condition: The condition that must be true for the worker selectors to be attached.
     Required.
    :vartype condition: ~azure.communication.jobrouter.models.RouterRule
    :ivar worker_selectors: The worker selectors to attach. Required.
    :vartype worker_selectors: list[~azure.communication.jobrouter.models.RouterWorkerSelector]
    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
     Discriminator value for ConditionalWorkerSelectorAttachment.
    :vartype kind: str or ~azure.communication.jobrouter.models.CONDITIONAL
    """

    condition: "_models.RouterRule" = rest_field()
    """The condition that must be true for the worker selectors to be attached. Required."""
    worker_selectors: List["_models.RouterWorkerSelector"] = rest_field(name="workerSelectors")
    """The worker selectors to attach. Required."""
    kind: Literal[WorkerSelectorAttachmentKind.CONDITIONAL] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing the type of worker selector attachment. Required.
     Discriminator value for ConditionalWorkerSelectorAttachment."""

    @overload
    def __init__(
        self,
        *,
        condition: "_models.RouterRule",
        worker_selectors: List["_models.RouterWorkerSelector"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=WorkerSelectorAttachmentKind.CONDITIONAL, **kwargs)


class DeclineJobOfferOptions(_model_base.Model):
    """Request payload for declining offers.

    :ivar retry_offer_at: If the RetryOfferAt is not provided, then this job will not be offered
     again to the worker who declined this job unless the worker is de-registered and re-registered.
     If a RetryOfferAt time is provided, then the job will be re-matched to eligible workers at the
     retry time in UTC.  The worker that declined the job will also be eligible for the job at that
     time.
    :vartype retry_offer_at: ~datetime.datetime
    """

    retry_offer_at: Optional[datetime.datetime] = rest_field(name="retryOfferAt", format="rfc3339")
    """If the RetryOfferAt is not provided, then this job will not be offered again to the worker who
     declined this job unless the worker is de-registered and re-registered.  If a RetryOfferAt time
     is provided, then the job will be re-matched to eligible workers at the retry time in UTC.  The
     worker that declined the job will also be eligible for the job at that time."""

    @overload
    def __init__(
        self,
        *,
        retry_offer_at: Optional[datetime.datetime] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DeclineJobOfferResult(_model_base.Model):
    """Response payload from declining a job."""


class RouterRule(_model_base.Model):
    """A rule of one of the following types:
    StaticRule:  A rule providing static rules that always return the same result, regardless of
    input.
    DirectMapRule:  A rule that return the same labels as the input labels.
    ExpressionRule: A rule providing inline expression rules.
    FunctionRule: A rule providing a binding to an HTTP Triggered Azure Function.
    WebhookRule: A rule providing a binding to a webserver following OAuth2.0 authentication
    protocol.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DirectMapRouterRule, ExpressionRouterRule, FunctionRouterRule, StaticRouterRule,
    WebhookRouterRule

    All required parameters must be populated in order to send to server.

    :ivar kind: The type discriminator describing a sub-type of RouterRule. Required. Known values
     are: "directMap", "expression", "function", "static", and "webhook".
    :vartype kind: str or ~azure.communication.jobrouter.models.RouterRuleKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a sub-type of RouterRule. Required. Known values are:
     \"directMap\", \"expression\", \"function\", \"static\", and \"webhook\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class DirectMapRouterRule(RouterRule, discriminator="directMap"):
    """A rule that return the same labels as the input labels.

    All required parameters must be populated in order to send to server.

    :ivar kind: The type discriminator describing a sub-type of Rule. Required. Discriminator value
     for DirectMapRouterRule.
    :vartype kind: str or ~azure.communication.jobrouter.models.DIRECT_MAP
    """

    kind: Literal[RouterRuleKind.DIRECT_MAP] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of Rule. Required. Discriminator value for
     DirectMapRouterRule."""


class DistributionPolicy(_model_base.Model):
    """Policy governing how jobs are distributed to workers.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar etag: The entity tag for this resource. Required.
    :vartype etag: str
    :ivar id: Id of a distribution policy. Required.
    :vartype id: str
    :ivar name: Friendly name of this policy.
    :vartype name: str
    :ivar offer_expires_after_seconds: Number of seconds after which any offers created under this
     policy will be expired.
    :vartype offer_expires_after_seconds: float
    :ivar mode: Mode governing the specific distribution method.
    :vartype mode: ~azure.communication.jobrouter.models.DistributionMode
    """

    etag: str = rest_field(visibility=["read"])
    """The entity tag for this resource. Required."""
    id: str = rest_field(visibility=["read"])
    """Id of a distribution policy. Required."""
    name: Optional[str] = rest_field()
    """Friendly name of this policy."""
    offer_expires_after_seconds: Optional[float] = rest_field(name="offerExpiresAfterSeconds")
    """Number of seconds after which any offers created under this policy will be expired."""
    mode: Optional["_models.DistributionMode"] = rest_field()
    """Mode governing the specific distribution method."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        offer_expires_after_seconds: Optional[float] = None,
        mode: Optional["_models.DistributionMode"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ExceptionPolicy(_model_base.Model):
    """A policy that defines actions to execute when exception are triggered.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar etag: The entity tag for this resource. Required.
    :vartype etag: str
    :ivar id: Id of an exception policy. Required.
    :vartype id: str
    :ivar name: Friendly name of this policy.
    :vartype name: str
    :ivar exception_rules: A collection of exception rules on the exception policy.
    :vartype exception_rules: list[~azure.communication.jobrouter.models.ExceptionRule]
    """

    etag: str = rest_field(visibility=["read"])
    """The entity tag for this resource. Required."""
    id: str = rest_field(visibility=["read"])
    """Id of an exception policy. Required."""
    name: Optional[str] = rest_field()
    """Friendly name of this policy."""
    exception_rules: Optional[List["_models.ExceptionRule"]] = rest_field(name="exceptionRules")
    """A collection of exception rules on the exception policy."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        exception_rules: Optional[List["_models.ExceptionRule"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ExceptionRule(_model_base.Model):
    """A rule that defines actions to execute upon a specific trigger.

    All required parameters must be populated in order to send to server.

    :ivar id: Id of an exception rule. Required.
    :vartype id: str
    :ivar trigger: The trigger for this exception rule. Required.
    :vartype trigger: ~azure.communication.jobrouter.models.ExceptionTrigger
    :ivar actions: A collection of actions to perform once the exception is triggered. Required.
    :vartype actions: list[~azure.communication.jobrouter.models.ExceptionAction]
    """

    id: str = rest_field()
    """Id of an exception rule. Required."""
    trigger: "_models.ExceptionTrigger" = rest_field()
    """The trigger for this exception rule. Required."""
    actions: List["_models.ExceptionAction"] = rest_field()
    """A collection of actions to perform once the exception is triggered. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        trigger: "_models.ExceptionTrigger",
        actions: List["_models.ExceptionAction"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ExceptionTrigger(_model_base.Model):
    """Abstract base class for defining a trigger for exception rules.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    QueueLengthExceptionTrigger, WaitTimeExceptionTrigger

    All required parameters must be populated in order to send to server.

    :ivar kind: The type discriminator describing a sub-type of ExceptionTrigger. Required. Known
     values are: "queueLength" and "waitTime".
    :vartype kind: str or ~azure.communication.jobrouter.models.ExceptionTriggerKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a sub-type of ExceptionTrigger. Required. Known values are:
     \"queueLength\" and \"waitTime\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ExpressionRouterRule(RouterRule, discriminator="expression"):
    """A rule providing inline expression rules.

    All required parameters must be populated in order to send to server.

    :ivar language: The expression language to compile to and execute. "powerFx"
    :vartype language: str or ~azure.communication.jobrouter.models.ExpressionRouterRuleLanguage
    :ivar expression: An expression to evaluate. Should contain return statement with calculated
     values. Required.
    :vartype expression: str
    :ivar kind: The type discriminator describing a sub-type of Rule. Required. Discriminator value
     for ExpressionRouterRule.
    :vartype kind: str or ~azure.communication.jobrouter.models.EXPRESSION
    """

    language: Optional[Union[str, "_models.ExpressionRouterRuleLanguage"]] = rest_field()
    """The expression language to compile to and execute. \"powerFx\""""
    expression: str = rest_field()
    """An expression to evaluate. Should contain return statement with calculated values. Required."""
    kind: Literal[RouterRuleKind.EXPRESSION] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of Rule. Required. Discriminator value for
     ExpressionRouterRule."""

    @overload
    def __init__(
        self,
        *,
        expression: str,
        language: Optional[Union[str, "_models.ExpressionRouterRuleLanguage"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RouterRuleKind.EXPRESSION, **kwargs)


class FunctionRouterRule(RouterRule, discriminator="function"):
    """A rule providing a binding to an HTTP Triggered Azure Function.

    All required parameters must be populated in order to send to server.

    :ivar function_uri: URL for Azure Function. Required.
    :vartype function_uri: str
    :ivar credential: Credentials used to access Azure function rule.
    :vartype credential: ~azure.communication.jobrouter.models.FunctionRouterRuleCredential
    :ivar kind: The type discriminator describing a sub-type of Rule. Required. Discriminator value
     for FunctionRouterRule.
    :vartype kind: str or ~azure.communication.jobrouter.models.FUNCTION
    """

    function_uri: str = rest_field(name="functionUri")
    """URL for Azure Function. Required."""
    credential: Optional["_models.FunctionRouterRuleCredential"] = rest_field()
    """Credentials used to access Azure function rule."""
    kind: Literal[RouterRuleKind.FUNCTION] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of Rule. Required. Discriminator value for
     FunctionRouterRule."""

    @overload
    def __init__(
        self,
        *,
        function_uri: str,
        credential: Optional["_models.FunctionRouterRuleCredential"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RouterRuleKind.FUNCTION, **kwargs)


class FunctionRouterRuleCredential(_model_base.Model):
    """Credentials used to access Azure function rule.

    :ivar function_key: Access key scoped to a particular function.
    :vartype function_key: str
    :ivar app_key: Access key scoped to a Azure Function app. This key grants access to all
     functions under the app.
    :vartype app_key: str
    :ivar client_id: Client id, when AppKey is provided In context of Azure function, this is
     usually the name of the key.
    :vartype client_id: str
    """

    function_key: Optional[str] = rest_field(name="functionKey")
    """Access key scoped to a particular function."""
    app_key: Optional[str] = rest_field(name="appKey")
    """Access key scoped to a Azure Function app. This key grants access to all functions under the
     app."""
    client_id: Optional[str] = rest_field(name="clientId")
    """Client id, when AppKey is provided In context of Azure function, this is usually the name of
     the key."""

    @overload
    def __init__(
        self,
        *,
        function_key: Optional[str] = None,
        app_key: Optional[str] = None,
        client_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class JobMatchingMode(_model_base.Model):
    """A matching mode of one of the following types:
    QueueAndMatchMode: Used when matching worker to a job is required to be done right after job is
    queued.
    ScheduleAndSuspendMode: Used for scheduling jobs to be queued at a future time. At specified
    time, matching of a worker to the job will not start automatically.
    SuspendMode: Used when matching workers to a job needs to be suspended.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    QueueAndMatchMode, ScheduleAndSuspendMode, SuspendMode

    All required parameters must be populated in order to send to server.

    :ivar kind: The type discriminator describing a sub-type of JobMatchingMode. Required. Known
     values are: "queueAndMatch", "scheduleAndSuspend", and "suspend".
    :vartype kind: str or ~azure.communication.jobrouter.models.JobMatchingModeKind
    """

    __mapping__: Dict[str, _model_base.Model] = {}
    kind: str = rest_discriminator(name="kind")
    """The type discriminator describing a sub-type of JobMatchingMode. Required. Known values are:
     \"queueAndMatch\", \"scheduleAndSuspend\", and \"suspend\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class LongestIdleMode(DistributionMode, discriminator="longestIdle"):
    """Jobs are directed to the worker who has been idle longest.

    All required parameters must be populated in order to send to server.

    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: If set to true, then router will match workers to jobs even if they
     don't match label selectors. Warning: You may get workers that are not qualified for a job they
     are matched with if you set this variable to true. This flag is intended more for temporary
     usage. By default, set to false.
    :vartype bypass_selectors: bool
    :ivar kind: The type discriminator describing a sub-type of Mode. Required. Discriminator value
     for LongestIdleMode.
    :vartype kind: str or ~azure.communication.jobrouter.models.LONGEST_IDLE
    """

    kind: Literal[DistributionModeKind.LONGEST_IDLE] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of Mode. Required. Discriminator value for
     LongestIdleMode."""

    @overload
    def __init__(
        self,
        *,
        min_concurrent_offers: Optional[int] = None,
        max_concurrent_offers: Optional[int] = None,
        bypass_selectors: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=DistributionModeKind.LONGEST_IDLE, **kwargs)


class ManualReclassifyExceptionAction(ExceptionAction, discriminator="manualReclassify"):
    """An action that manually reclassifies a job by providing the queue, priority and worker
    selectors.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique Id of the exception action.
    :vartype id: str
    :ivar queue_id: Updated QueueId.
    :vartype queue_id: str
    :ivar priority: Updated Priority.
    :vartype priority: int
    :ivar worker_selectors: Updated WorkerSelectors.
    :vartype worker_selectors: list[~azure.communication.jobrouter.models.RouterWorkerSelector]
    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
     Discriminator value for ManualReclassifyExceptionAction.
    :vartype kind: str or ~azure.communication.jobrouter.models.MANUAL_RECLASSIFY
    """

    queue_id: Optional[str] = rest_field(name="queueId")
    """Updated QueueId."""
    priority: Optional[int] = rest_field()
    """Updated Priority."""
    worker_selectors: Optional[List["_models.RouterWorkerSelector"]] = rest_field(name="workerSelectors")
    """Updated WorkerSelectors."""
    kind: Literal[ExceptionActionKind.MANUAL_RECLASSIFY] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of ExceptionAction. Required. Discriminator value
     for ManualReclassifyExceptionAction."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        queue_id: Optional[str] = None,
        priority: Optional[int] = None,
        worker_selectors: Optional[List["_models.RouterWorkerSelector"]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=ExceptionActionKind.MANUAL_RECLASSIFY, **kwargs)


class OAuth2WebhookClientCredential(_model_base.Model):
    """OAuth2.0 Credentials used to Contoso's Authorization server. Reference:
    https://www.oauth.com/oauth2-servers/access-tokens/client-credentials/.

    :ivar client_id: ClientId for Contoso Authorization server.
    :vartype client_id: str
    :ivar client_secret: Client secret for Contoso Authorization server.
    :vartype client_secret: str
    """

    client_id: Optional[str] = rest_field(name="clientId")
    """ClientId for Contoso Authorization server."""
    client_secret: Optional[str] = rest_field(name="clientSecret")
    """Client secret for Contoso Authorization server."""

    @overload
    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class PassThroughQueueSelectorAttachment(QueueSelectorAttachment, discriminator="passThrough"):
    """Attaches a queue selector where the value is passed through from a job's label with the same
    key.

    All required parameters must be populated in order to send to server.

    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value pass
     through. Required. Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
     "greaterThan", and "greaterThanOrEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
     Discriminator value for PassThroughQueueSelectorAttachment.
    :vartype kind: str or ~azure.communication.jobrouter.models.PASS_THROUGH
    """

    key: str = rest_field()
    """The label key to query against. Required."""
    label_operator: Union[str, "_models.LabelOperator"] = rest_field(name="labelOperator")
    """Describes how the value of the label is compared to the value pass through. Required. Known
     values are: \"equal\", \"notEqual\", \"lessThan\", \"lessThanOrEqual\", \"greaterThan\", and
     \"greaterThanOrEqual\"."""
    kind: Literal[QueueSelectorAttachmentKind.PASS_THROUGH] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing the type of queue selector attachment. Required.
     Discriminator value for PassThroughQueueSelectorAttachment."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        label_operator: Union[str, "_models.LabelOperator"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=QueueSelectorAttachmentKind.PASS_THROUGH, **kwargs)


class PassThroughWorkerSelectorAttachment(WorkerSelectorAttachment, discriminator="passThrough"):
    """Attaches a worker selector where the value is passed through from a job's label with the same
    key.

    All required parameters must be populated in order to send to server.

    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value pass
     through. Required. Known values are: "equal", "notEqual", "lessThan", "lessThanOrEqual",
     "greaterThan", and "greaterThanOrEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    :ivar expires_after_seconds: Describes how long the attached label selector is valid in
     seconds.
    :vartype expires_after_seconds: float
    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
     Discriminator value for PassThroughWorkerSelectorAttachment.
    :vartype kind: str or ~azure.communication.jobrouter.models.PASS_THROUGH
    """

    key: str = rest_field()
    """The label key to query against. Required."""
    label_operator: Union[str, "_models.LabelOperator"] = rest_field(name="labelOperator")
    """Describes how the value of the label is compared to the value pass through. Required. Known
     values are: \"equal\", \"notEqual\", \"lessThan\", \"lessThanOrEqual\", \"greaterThan\", and
     \"greaterThanOrEqual\"."""
    expires_after_seconds: Optional[float] = rest_field(name="expiresAfterSeconds")
    """Describes how long the attached label selector is valid in seconds."""
    kind: Literal[WorkerSelectorAttachmentKind.PASS_THROUGH] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing the type of worker selector attachment. Required.
     Discriminator value for PassThroughWorkerSelectorAttachment."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        label_operator: Union[str, "_models.LabelOperator"],
        expires_after_seconds: Optional[float] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=WorkerSelectorAttachmentKind.PASS_THROUGH, **kwargs)


class QueueAndMatchMode(JobMatchingMode, discriminator="queueAndMatch"):
    """Describes a matching mode where matching worker to a job is automatically started after job is
    queued successfully.

    All required parameters must be populated in order to send to server.

    :ivar kind: The type discriminator describing QueueAndMatchMode. Required. Discriminator value
     for QueueAndMatchMode.
    :vartype kind: str or ~azure.communication.jobrouter.models.QUEUE_AND_MATCH
    """

    kind: Literal[JobMatchingModeKind.QUEUE_AND_MATCH] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing QueueAndMatchMode. Required. Discriminator value for
     QueueAndMatchMode."""


class QueueLengthExceptionTrigger(ExceptionTrigger, discriminator="queueLength"):
    """Trigger for an exception action on exceeding queue length.

    All required parameters must be populated in order to send to server.

    :ivar threshold: Threshold of number of jobs ahead in the queue to for this trigger to fire.
     Required.
    :vartype threshold: int
    :ivar kind: The type discriminator describing a sub-type of ExceptionTrigger. Required.
     Discriminator value for QueueLengthExceptionTrigger.
    :vartype kind: str or ~azure.communication.jobrouter.models.QUEUE_LENGTH
    """

    threshold: int = rest_field()
    """Threshold of number of jobs ahead in the queue to for this trigger to fire. Required."""
    kind: Literal[ExceptionTriggerKind.QUEUE_LENGTH] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of ExceptionTrigger. Required. Discriminator value
     for QueueLengthExceptionTrigger."""

    @overload
    def __init__(
        self,
        *,
        threshold: int,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=ExceptionTriggerKind.QUEUE_LENGTH, **kwargs)


class QueueWeightedAllocation(_model_base.Model):
    """Contains the weight percentage and queue selectors to be applied if selected for weighted
    distributions.

    All required parameters must be populated in order to send to server.

    :ivar weight: The percentage of this weight, expressed as a fraction of 1. Required.
    :vartype weight: float
    :ivar queue_selectors: A collection of queue selectors that will be applied if this allocation
     is selected. Required.
    :vartype queue_selectors: list[~azure.communication.jobrouter.models.RouterQueueSelector]
    """

    weight: float = rest_field()
    """The percentage of this weight, expressed as a fraction of 1. Required."""
    queue_selectors: List["_models.RouterQueueSelector"] = rest_field(name="queueSelectors")
    """A collection of queue selectors that will be applied if this allocation is selected. Required."""

    @overload
    def __init__(
        self,
        *,
        weight: float,
        queue_selectors: List["_models.RouterQueueSelector"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class ReclassifyExceptionAction(ExceptionAction, discriminator="reclassify"):
    """An action that modifies labels on a job and then reclassifies it.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique Id of the exception action.
    :vartype id: str
    :ivar classification_policy_id: The new classification policy that will determine queue,
     priority and worker selectors.
    :vartype classification_policy_id: str
    :ivar labels_to_upsert: Dictionary containing the labels to update (or add if not existing) in
     key-value pairs.  Values must be primitive values - number, string, boolean.
    :vartype labels_to_upsert: dict[str, any]
    :ivar kind: The type discriminator describing a sub-type of ExceptionAction. Required.
     Discriminator value for ReclassifyExceptionAction.
    :vartype kind: str or ~azure.communication.jobrouter.models.RECLASSIFY
    """

    classification_policy_id: Optional[str] = rest_field(name="classificationPolicyId")
    """The new classification policy that will determine queue, priority and worker selectors."""
    labels_to_upsert: Optional[Dict[str, Any]] = rest_field(name="labelsToUpsert")
    """Dictionary containing the labels to update (or add if not existing) in key-value pairs.  Values
     must be primitive values - number, string, boolean."""
    kind: Literal[ExceptionActionKind.RECLASSIFY] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of ExceptionAction. Required. Discriminator value
     for ReclassifyExceptionAction."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        classification_policy_id: Optional[str] = None,
        labels_to_upsert: Optional[Dict[str, Any]] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=ExceptionActionKind.RECLASSIFY, **kwargs)


class ReclassifyJobOptions(_model_base.Model):
    """Request payload for reclassifying jobs."""


class ReclassifyJobResult(_model_base.Model):
    """Response payload from reclassifying a job."""


class RoundRobinMode(DistributionMode, discriminator="roundRobin"):
    """Jobs are distributed in order to workers, starting with the worker that is after the last
    worker to receive a job.

    All required parameters must be populated in order to send to server.

    :ivar min_concurrent_offers: Governs the minimum desired number of active concurrent offers a
     job can have.
    :vartype min_concurrent_offers: int
    :ivar max_concurrent_offers: Governs the maximum number of active concurrent offers a job can
     have.
    :vartype max_concurrent_offers: int
    :ivar bypass_selectors: If set to true, then router will match workers to jobs even if they
     don't match label selectors. Warning: You may get workers that are not qualified for a job they
     are matched with if you set this variable to true. This flag is intended more for temporary
     usage. By default, set to false.
    :vartype bypass_selectors: bool
    :ivar kind: The type discriminator describing a sub-type of Mode. Required. Discriminator value
     for RoundRobinMode.
    :vartype kind: str or ~azure.communication.jobrouter.models.ROUND_ROBIN
    """

    kind: Literal[DistributionModeKind.ROUND_ROBIN] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of Mode. Required. Discriminator value for
     RoundRobinMode."""

    @overload
    def __init__(
        self,
        *,
        min_concurrent_offers: Optional[int] = None,
        max_concurrent_offers: Optional[int] = None,
        bypass_selectors: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=DistributionModeKind.ROUND_ROBIN, **kwargs)


class RouterChannel(_model_base.Model):
    """Represents the capacity a job in this channel will consume from a worker.

    All required parameters must be populated in order to send to server.

    :ivar channel_id: Id of a channel. Required.
    :vartype channel_id: str
    :ivar capacity_cost_per_job: The amount of capacity that an instance of a job of this channel
     will consume of the total worker capacity. Required.
    :vartype capacity_cost_per_job: int
    :ivar max_number_of_jobs: The maximum number of jobs that can be supported concurrently for
     this channel.
    :vartype max_number_of_jobs: int
    """

    channel_id: str = rest_field(name="channelId")
    """Id of a channel. Required."""
    capacity_cost_per_job: int = rest_field(name="capacityCostPerJob")
    """The amount of capacity that an instance of a job of this channel will consume of the total
     worker capacity. Required."""
    max_number_of_jobs: Optional[int] = rest_field(name="maxNumberOfJobs")
    """The maximum number of jobs that can be supported concurrently for this channel."""

    @overload
    def __init__(
        self,
        *,
        channel_id: str,
        capacity_cost_per_job: int,
        max_number_of_jobs: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterJob(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """A unit of work to be routed.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar etag: The entity tag for this resource. Required.
    :vartype etag: str
    :ivar id: Id of a job. Required.
    :vartype id: str
    :ivar channel_reference: Reference to an external parent context, eg. call ID.
    :vartype channel_reference: str
    :ivar status: The status of the job. Known values are: "pendingClassification", "queued",
     "assigned", "completed", "closed", "cancelled", "classificationFailed", "created",
     "pendingSchedule", "scheduled", "scheduleFailed", and "waitingForActivation".
    :vartype status: str or ~azure.communication.jobrouter.models.RouterJobStatus
    :ivar enqueued_at: Timestamp a job was queued in UTC.
    :vartype enqueued_at: ~datetime.datetime
    :ivar channel_id: The channel identifier. eg. voice, chat, etc.
    :vartype channel_id: str
    :ivar classification_policy_id: Id of a classification policy used for classifying this job.
    :vartype classification_policy_id: str
    :ivar queue_id: Id of a queue that this job is queued to.
    :vartype queue_id: str
    :ivar priority: Priority of this job.
    :vartype priority: int
    :ivar disposition_code: Reason code for cancelled or closed jobs.
    :vartype disposition_code: str
    :ivar requested_worker_selectors: A collection of manually specified worker selectors, which a
     worker must satisfy in order to process this job.
    :vartype requested_worker_selectors:
     list[~azure.communication.jobrouter.models.RouterWorkerSelector]
    :ivar attached_worker_selectors: A collection of worker selectors attached by a classification
     policy, which a worker must satisfy in order to process this job.
    :vartype attached_worker_selectors:
     list[~azure.communication.jobrouter.models.RouterWorkerSelector]
    :ivar labels: A set of key/value pairs that are identifying attributes used by the rules
     engines to make decisions. Values must be primitive values - number, string, boolean.
    :vartype labels: dict[str, any]
    :ivar assignments: A collection of the assignments of the job. Key is AssignmentId.
    :vartype assignments: dict[str, ~azure.communication.jobrouter.models.RouterJobAssignment]
    :ivar tags: A set of non-identifying attributes attached to this job. Values must be primitive
     values - number, string, boolean.
    :vartype tags: dict[str, any]
    :ivar notes: Notes attached to a job, sorted by timestamp.
    :vartype notes: list[~azure.communication.jobrouter.models.RouterJobNote]
    :ivar scheduled_at: If set, job will be scheduled to be enqueued at a given time.
    :vartype scheduled_at: ~datetime.datetime
    :ivar matching_mode: If provided, will determine how job matching will be carried out. Default
     mode: QueueAndMatchMode.
    :vartype matching_mode: ~azure.communication.jobrouter.models.JobMatchingMode
    """

    etag: str = rest_field(visibility=["read"])
    """The entity tag for this resource. Required."""
    id: str = rest_field(visibility=["read"])
    """Id of a job. Required."""
    channel_reference: Optional[str] = rest_field(name="channelReference")
    """Reference to an external parent context, eg. call ID."""
    status: Optional[Union[str, "_models.RouterJobStatus"]] = rest_field(visibility=["read"])
    """The status of the job. Known values are: \"pendingClassification\", \"queued\", \"assigned\",
     \"completed\", \"closed\", \"cancelled\", \"classificationFailed\", \"created\",
     \"pendingSchedule\", \"scheduled\", \"scheduleFailed\", and \"waitingForActivation\"."""
    enqueued_at: Optional[datetime.datetime] = rest_field(name="enqueuedAt", visibility=["read"], format="rfc3339")
    """Timestamp a job was queued in UTC."""
    channel_id: Optional[str] = rest_field(name="channelId")
    """The channel identifier. eg. voice, chat, etc."""
    classification_policy_id: Optional[str] = rest_field(name="classificationPolicyId")
    """Id of a classification policy used for classifying this job."""
    queue_id: Optional[str] = rest_field(name="queueId")
    """Id of a queue that this job is queued to."""
    priority: Optional[int] = rest_field()
    """Priority of this job."""
    disposition_code: Optional[str] = rest_field(name="dispositionCode")
    """Reason code for cancelled or closed jobs."""
    requested_worker_selectors: Optional[List["_models.RouterWorkerSelector"]] = rest_field(
        name="requestedWorkerSelectors"
    )
    """A collection of manually specified worker selectors, which a worker must satisfy in order to
     process this job."""
    attached_worker_selectors: Optional[List["_models.RouterWorkerSelector"]] = rest_field(
        name="attachedWorkerSelectors", visibility=["read"]
    )
    """A collection of worker selectors attached by a classification policy, which a worker must
     satisfy in order to process this job."""
    labels: Optional[Dict[str, Any]] = rest_field()
    """A set of key/value pairs that are identifying attributes used by the rules engines to make
     decisions. Values must be primitive values - number, string, boolean."""
    assignments: Optional[Dict[str, "_models.RouterJobAssignment"]] = rest_field(visibility=["read"])
    """A collection of the assignments of the job. Key is AssignmentId."""
    tags: Optional[Dict[str, Any]] = rest_field()
    """A set of non-identifying attributes attached to this job. Values must be primitive values -
     number, string, boolean."""
    notes: Optional[List["_models.RouterJobNote"]] = rest_field()
    """Notes attached to a job, sorted by timestamp."""
    scheduled_at: Optional[datetime.datetime] = rest_field(name="scheduledAt", visibility=["read"], format="rfc3339")
    """If set, job will be scheduled to be enqueued at a given time."""
    matching_mode: Optional["_models.JobMatchingMode"] = rest_field(name="matchingMode")
    """If provided, will determine how job matching will be carried out. Default mode:
     QueueAndMatchMode."""

    @overload
    def __init__(
        self,
        *,
        channel_reference: Optional[str] = None,
        channel_id: Optional[str] = None,
        classification_policy_id: Optional[str] = None,
        queue_id: Optional[str] = None,
        priority: Optional[int] = None,
        disposition_code: Optional[str] = None,
        requested_worker_selectors: Optional[List["_models.RouterWorkerSelector"]] = None,
        labels: Optional[Dict[str, Any]] = None,
        tags: Optional[Dict[str, Any]] = None,
        notes: Optional[List["_models.RouterJobNote"]] = None,
        matching_mode: Optional["_models.JobMatchingMode"] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterJobAssignment(_model_base.Model):
    """Assignment details of a job to a worker.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar assignment_id: Id of a job assignment. Required.
    :vartype assignment_id: str
    :ivar worker_id: Id of the Worker assigned to the job.
    :vartype worker_id: str
    :ivar assigned_at: Timestamp when the job was assigned to a worker in UTC. Required.
    :vartype assigned_at: ~datetime.datetime
    :ivar completed_at: Timestamp when the job was marked as completed after being assigned in UTC.
    :vartype completed_at: ~datetime.datetime
    :ivar closed_at: Timestamp when the job was marked as closed after being completed in UTC.
    :vartype closed_at: ~datetime.datetime
    """

    assignment_id: str = rest_field(name="assignmentId", visibility=["read"])
    """Id of a job assignment. Required."""
    worker_id: Optional[str] = rest_field(name="workerId")
    """Id of the Worker assigned to the job."""
    assigned_at: datetime.datetime = rest_field(name="assignedAt", format="rfc3339")
    """Timestamp when the job was assigned to a worker in UTC. Required."""
    completed_at: Optional[datetime.datetime] = rest_field(name="completedAt", format="rfc3339")
    """Timestamp when the job was marked as completed after being assigned in UTC."""
    closed_at: Optional[datetime.datetime] = rest_field(name="closedAt", format="rfc3339")
    """Timestamp when the job was marked as closed after being completed in UTC."""

    @overload
    def __init__(
        self,
        *,
        assigned_at: datetime.datetime,
        worker_id: Optional[str] = None,
        completed_at: Optional[datetime.datetime] = None,
        closed_at: Optional[datetime.datetime] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterJobNote(_model_base.Model):
    """A note attached to a job.

    All required parameters must be populated in order to send to server.

    :ivar message: The message contained in the note. Required.
    :vartype message: str
    :ivar added_at: The time at which the note was added in UTC. If not provided, will default to
     the current time.
    :vartype added_at: ~datetime.datetime
    """

    message: str = rest_field()
    """The message contained in the note. Required."""
    added_at: Optional[datetime.datetime] = rest_field(name="addedAt", format="rfc3339")
    """The time at which the note was added in UTC. If not provided, will default to the current time."""

    @overload
    def __init__(
        self,
        *,
        message: str,
        added_at: Optional[datetime.datetime] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterJobOffer(_model_base.Model):
    """An offer of a job to a worker.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offer_id: Id of an offer. Required.
    :vartype offer_id: str
    :ivar job_id: Id of the job. Required.
    :vartype job_id: str
    :ivar capacity_cost: The capacity cost consumed by the job offer. Required.
    :vartype capacity_cost: int
    :ivar offered_at: Timestamp when the offer was created in UTC.
    :vartype offered_at: ~datetime.datetime
    :ivar expires_at: Timestamp when the offer will expire in UTC.
    :vartype expires_at: ~datetime.datetime
    """

    offer_id: str = rest_field(name="offerId", visibility=["read"])
    """Id of an offer. Required."""
    job_id: str = rest_field(name="jobId")
    """Id of the job. Required."""
    capacity_cost: int = rest_field(name="capacityCost")
    """The capacity cost consumed by the job offer. Required."""
    offered_at: Optional[datetime.datetime] = rest_field(name="offeredAt", format="rfc3339")
    """Timestamp when the offer was created in UTC."""
    expires_at: Optional[datetime.datetime] = rest_field(name="expiresAt", format="rfc3339")
    """Timestamp when the offer will expire in UTC."""

    @overload
    def __init__(
        self,
        *,
        job_id: str,
        capacity_cost: int,
        offered_at: Optional[datetime.datetime] = None,
        expires_at: Optional[datetime.datetime] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterJobPositionDetails(_model_base.Model):
    """Position and estimated wait time for a job.

    All required parameters must be populated in order to send to server.

    :ivar job_id: Id of the job these details are about. Required.
    :vartype job_id: str
    :ivar position: Position of the job in question within that queue. Required.
    :vartype position: int
    :ivar queue_id: Id of the queue this job is enqueued in. Required.
    :vartype queue_id: str
    :ivar queue_length: Length of the queue: total number of enqueued jobs. Required.
    :vartype queue_length: int
    :ivar estimated_wait_time_minutes: Estimated wait time of the job rounded up to the nearest
     minute. Required.
    :vartype estimated_wait_time_minutes: float
    """

    job_id: str = rest_field(name="jobId")
    """Id of the job these details are about. Required."""
    position: int = rest_field()
    """Position of the job in question within that queue. Required."""
    queue_id: str = rest_field(name="queueId")
    """Id of the queue this job is enqueued in. Required."""
    queue_length: int = rest_field(name="queueLength")
    """Length of the queue: total number of enqueued jobs. Required."""
    estimated_wait_time_minutes: float = rest_field(name="estimatedWaitTimeMinutes")
    """Estimated wait time of the job rounded up to the nearest minute. Required."""

    @overload
    def __init__(
        self,
        *,
        job_id: str,
        position: int,
        queue_id: str,
        queue_length: int,
        estimated_wait_time_minutes: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterQueue(_model_base.Model):
    """A queue that can contain jobs to be routed.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar etag: The entity tag for this resource. Required.
    :vartype etag: str
    :ivar id: Id of a queue. Required.
    :vartype id: str
    :ivar name: Friendly name of this queue.
    :vartype name: str
    :ivar distribution_policy_id: Id of a distribution policy that will determine how a job is
     distributed to workers.
    :vartype distribution_policy_id: str
    :ivar labels: A set of key/value pairs that are identifying attributes used by the rules
     engines to make decisions. Values must be primitive values - number, string, boolean.
    :vartype labels: dict[str, any]
    :ivar exception_policy_id: Id of an exception policy that determines various job escalation
     rules.
    :vartype exception_policy_id: str
    """

    etag: str = rest_field(visibility=["read"])
    """The entity tag for this resource. Required."""
    id: str = rest_field(visibility=["read"])
    """Id of a queue. Required."""
    name: Optional[str] = rest_field()
    """Friendly name of this queue."""
    distribution_policy_id: Optional[str] = rest_field(name="distributionPolicyId")
    """Id of a distribution policy that will determine how a job is distributed to workers."""
    labels: Optional[Dict[str, Any]] = rest_field()
    """A set of key/value pairs that are identifying attributes used by the rules engines to make
     decisions. Values must be primitive values - number, string, boolean."""
    exception_policy_id: Optional[str] = rest_field(name="exceptionPolicyId")
    """Id of an exception policy that determines various job escalation rules."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        distribution_policy_id: Optional[str] = None,
        labels: Optional[Dict[str, Any]] = None,
        exception_policy_id: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterQueueSelector(_model_base.Model):
    """Describes a condition that must be met against a set of labels for queue selection.

    All required parameters must be populated in order to send to server.

    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value defined on
     the label selector. Required. Known values are: "equal", "notEqual", "lessThan",
     "lessThanOrEqual", "greaterThan", and "greaterThanOrEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    :ivar value: The value to compare against the actual label value with the given operator.
     Values must be primitive values - number, string, boolean.
    :vartype value: any
    """

    key: str = rest_field()
    """The label key to query against. Required."""
    label_operator: Union[str, "_models.LabelOperator"] = rest_field(name="labelOperator")
    """Describes how the value of the label is compared to the value defined on the label selector.
     Required. Known values are: \"equal\", \"notEqual\", \"lessThan\", \"lessThanOrEqual\",
     \"greaterThan\", and \"greaterThanOrEqual\"."""
    value: Optional[Any] = rest_field()
    """The value to compare against the actual label value with the given operator. Values must be
     primitive values - number, string, boolean."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        label_operator: Union[str, "_models.LabelOperator"],
        value: Optional[Any] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterQueueStatistics(_model_base.Model):
    """Statistics for the queue.

    All required parameters must be populated in order to send to server.

    :ivar queue_id: Id of the queue these details are about. Required.
    :vartype queue_id: str
    :ivar length: Length of the queue: total number of enqueued jobs. Required.
    :vartype length: int
    :ivar estimated_wait_time_minutes: The estimated wait time of this queue rounded up to the
     nearest minute, grouped by job priority.
    :vartype estimated_wait_time_minutes: dict[str, float]
    :ivar longest_job_wait_time_minutes: The wait time of the job that has been enqueued in this
     queue for the longest.
    :vartype longest_job_wait_time_minutes: float
    """

    queue_id: str = rest_field(name="queueId")
    """Id of the queue these details are about. Required."""
    length: int = rest_field()
    """Length of the queue: total number of enqueued jobs. Required."""
    estimated_wait_time_minutes: Optional[Dict[str, float]] = rest_field(name="estimatedWaitTimeMinutes")
    """The estimated wait time of this queue rounded up to the nearest minute, grouped by job
     priority."""
    longest_job_wait_time_minutes: Optional[float] = rest_field(name="longestJobWaitTimeMinutes")
    """The wait time of the job that has been enqueued in this queue for the longest."""

    @overload
    def __init__(
        self,
        *,
        queue_id: str,
        length: int,
        estimated_wait_time_minutes: Optional[Dict[str, float]] = None,
        longest_job_wait_time_minutes: Optional[float] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterWorker(_model_base.Model):  # pylint: disable=too-many-instance-attributes
    """An entity for jobs to be routed to.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar etag: The entity tag for this resource. Required.
    :vartype etag: str
    :ivar id: Id of a worker. Required.
    :vartype id: str
    :ivar state: Current state of a worker. Known values are: "active", "draining", and "inactive".
    :vartype state: str or ~azure.communication.jobrouter.models.RouterWorkerState
    :ivar queues: Collection of queue(s) that this worker can receive work from.
    :vartype queues: list[str]
    :ivar capacity: The total capacity score this worker has to manage multiple concurrent jobs.
    :vartype capacity: int
    :ivar labels: A set of key/value pairs that are identifying attributes used by the rules
     engines to make decisions. Values must be primitive values - number, string, boolean.
    :vartype labels: dict[str, any]
    :ivar tags: A set of non-identifying attributes attached to this worker. Values must be
     primitive values - number, string, boolean.
    :vartype tags: dict[str, any]
    :ivar channels: Collection of channel(s) this worker can handle and their impact on the workers
     capacity.
    :vartype channels: list[~azure.communication.jobrouter.models.RouterChannel]
    :ivar offers: A list of active offers issued to this worker.
    :vartype offers: list[~azure.communication.jobrouter.models.RouterJobOffer]
    :ivar assigned_jobs: A list of assigned jobs attached to this worker.
    :vartype assigned_jobs: list[~azure.communication.jobrouter.models.RouterWorkerAssignment]
    :ivar load_ratio: A value indicating the workers capacity. A value of '1' means all capacity is
     consumed. A value of '0' means no capacity is currently consumed.
    :vartype load_ratio: float
    :ivar available_for_offers: A flag indicating this worker is open to receive offers or not.
    :vartype available_for_offers: bool
    :ivar max_concurrent_offers: If this is set, the worker will only receive up to this many new
     offers at a time.
    :vartype max_concurrent_offers: int
    """

    etag: str = rest_field(visibility=["read"])
    """The entity tag for this resource. Required."""
    id: str = rest_field(visibility=["read"])
    """Id of a worker. Required."""
    state: Optional[Union[str, "_models.RouterWorkerState"]] = rest_field(visibility=["read"])
    """Current state of a worker. Known values are: \"active\", \"draining\", and \"inactive\"."""
    queues: Optional[List[str]] = rest_field()
    """Collection of queue(s) that this worker can receive work from."""
    capacity: Optional[int] = rest_field()
    """The total capacity score this worker has to manage multiple concurrent jobs."""
    labels: Optional[Dict[str, Any]] = rest_field()
    """A set of key/value pairs that are identifying attributes used by the rules engines to make
     decisions. Values must be primitive values - number, string, boolean."""
    tags: Optional[Dict[str, Any]] = rest_field()
    """A set of non-identifying attributes attached to this worker. Values must be primitive values -
     number, string, boolean."""
    channels: Optional[List["_models.RouterChannel"]] = rest_field()
    """Collection of channel(s) this worker can handle and their impact on the workers capacity."""
    offers: Optional[List["_models.RouterJobOffer"]] = rest_field(visibility=["read"])
    """A list of active offers issued to this worker."""
    assigned_jobs: Optional[List["_models.RouterWorkerAssignment"]] = rest_field(
        name="assignedJobs", visibility=["read"]
    )
    """A list of assigned jobs attached to this worker."""
    load_ratio: Optional[float] = rest_field(name="loadRatio", visibility=["read"])
    """A value indicating the workers capacity. A value of '1' means all capacity is consumed. A value
     of '0' means no capacity is currently consumed."""
    available_for_offers: Optional[bool] = rest_field(name="availableForOffers")
    """A flag indicating this worker is open to receive offers or not."""
    max_concurrent_offers: Optional[int] = rest_field(name="maxConcurrentOffers")
    """If this is set, the worker will only receive up to this many new offers at a time."""

    @overload
    def __init__(
        self,
        *,
        queues: Optional[List[str]] = None,
        capacity: Optional[int] = None,
        labels: Optional[Dict[str, Any]] = None,
        tags: Optional[Dict[str, Any]] = None,
        channels: Optional[List["_models.RouterChannel"]] = None,
        available_for_offers: Optional[bool] = None,
        max_concurrent_offers: Optional[int] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterWorkerAssignment(_model_base.Model):
    """The assignment for a worker to a job.

    All required parameters must be populated in order to send to server.

    :ivar assignment_id: Id of the assignment. Required.
    :vartype assignment_id: str
    :ivar job_id: Id of the job assigned. Required.
    :vartype job_id: str
    :ivar capacity_cost: The amount of capacity this assignment has consumed on the worker.
     Required.
    :vartype capacity_cost: int
    :ivar assigned_at: The assignment time of the job in UTC. Required.
    :vartype assigned_at: ~datetime.datetime
    """

    assignment_id: str = rest_field(name="assignmentId")
    """Id of the assignment. Required."""
    job_id: str = rest_field(name="jobId")
    """Id of the job assigned. Required."""
    capacity_cost: int = rest_field(name="capacityCost")
    """The amount of capacity this assignment has consumed on the worker. Required."""
    assigned_at: datetime.datetime = rest_field(name="assignedAt", format="rfc3339")
    """The assignment time of the job in UTC. Required."""

    @overload
    def __init__(
        self,
        *,
        assignment_id: str,
        job_id: str,
        capacity_cost: int,
        assigned_at: datetime.datetime,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RouterWorkerSelector(_model_base.Model):
    """Describes a condition that must be met against a set of labels for worker selection.

    Readonly variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar key: The label key to query against. Required.
    :vartype key: str
    :ivar label_operator: Describes how the value of the label is compared to the value defined on
     the worker selector. Required. Known values are: "equal", "notEqual", "lessThan",
     "lessThanOrEqual", "greaterThan", and "greaterThanOrEqual".
    :vartype label_operator: str or ~azure.communication.jobrouter.models.LabelOperator
    :ivar value: The value to compare against the actual label value with the given operator.
     Values must be primitive values - number, string, boolean.
    :vartype value: any
    :ivar expires_after_seconds: Describes how long this label selector is valid in seconds.
    :vartype expires_after_seconds: float
    :ivar expedite: Pushes a job to the front of the queue as long as this selector is active.
    :vartype expedite: bool
    :ivar status: Status of the worker selector. Known values are: "active" and "expired".
    :vartype status: str or ~azure.communication.jobrouter.models.RouterWorkerSelectorStatus
    :ivar expires_at: The time at which this worker selector expires in UTC.
    :vartype expires_at: ~datetime.datetime
    """

    key: str = rest_field()
    """The label key to query against. Required."""
    label_operator: Union[str, "_models.LabelOperator"] = rest_field(name="labelOperator")
    """Describes how the value of the label is compared to the value defined on the worker selector.
     Required. Known values are: \"equal\", \"notEqual\", \"lessThan\", \"lessThanOrEqual\",
     \"greaterThan\", and \"greaterThanOrEqual\"."""
    value: Optional[Any] = rest_field()
    """The value to compare against the actual label value with the given operator. Values must be
     primitive values - number, string, boolean."""
    expires_after_seconds: Optional[float] = rest_field(name="expiresAfterSeconds")
    """Describes how long this label selector is valid in seconds."""
    expedite: Optional[bool] = rest_field()
    """Pushes a job to the front of the queue as long as this selector is active."""
    status: Optional[Union[str, "_models.RouterWorkerSelectorStatus"]] = rest_field(visibility=["read"])
    """Status of the worker selector. Known values are: \"active\" and \"expired\"."""
    expires_at: Optional[datetime.datetime] = rest_field(name="expiresAt", visibility=["read"], format="rfc3339")
    """The time at which this worker selector expires in UTC."""

    @overload
    def __init__(
        self,
        *,
        key: str,
        label_operator: Union[str, "_models.LabelOperator"],
        value: Optional[Any] = None,
        expires_after_seconds: Optional[float] = None,
        expedite: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class RuleEngineQueueSelectorAttachment(QueueSelectorAttachment, discriminator="ruleEngine"):
    """Attaches queue selectors to a job when the RouterRule is resolved.

    All required parameters must be populated in order to send to server.

    :ivar rule: A RouterRule that resolves a collection of queue selectors to attach. Required.
    :vartype rule: ~azure.communication.jobrouter.models.RouterRule
    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
     Discriminator value for RuleEngineQueueSelectorAttachment.
    :vartype kind: str or ~azure.communication.jobrouter.models.RULE_ENGINE
    """

    rule: "_models.RouterRule" = rest_field()
    """A RouterRule that resolves a collection of queue selectors to attach. Required."""
    kind: Literal[QueueSelectorAttachmentKind.RULE_ENGINE] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing the type of queue selector attachment. Required.
     Discriminator value for RuleEngineQueueSelectorAttachment."""

    @overload
    def __init__(
        self,
        *,
        rule: "_models.RouterRule",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=QueueSelectorAttachmentKind.RULE_ENGINE, **kwargs)


class RuleEngineWorkerSelectorAttachment(WorkerSelectorAttachment, discriminator="ruleEngine"):
    """Attaches worker selectors to a job when a RouterRule is resolved.

    All required parameters must be populated in order to send to server.

    :ivar rule: A RouterRule that resolves a collection of worker selectors to attach. Required.
    :vartype rule: ~azure.communication.jobrouter.models.RouterRule
    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
     Discriminator value for RuleEngineWorkerSelectorAttachment.
    :vartype kind: str or ~azure.communication.jobrouter.models.RULE_ENGINE
    """

    rule: "_models.RouterRule" = rest_field()
    """A RouterRule that resolves a collection of worker selectors to attach. Required."""
    kind: Literal[WorkerSelectorAttachmentKind.RULE_ENGINE] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing the type of worker selector attachment. Required.
     Discriminator value for RuleEngineWorkerSelectorAttachment."""

    @overload
    def __init__(
        self,
        *,
        rule: "_models.RouterRule",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=WorkerSelectorAttachmentKind.RULE_ENGINE, **kwargs)


class ScheduleAndSuspendMode(JobMatchingMode, discriminator="scheduleAndSuspend"):
    """Describes a matching mode used for scheduling jobs to be queued at a future time. At the
    specified time, matching worker to a job will not start automatically.

    All required parameters must be populated in order to send to server.

    :ivar schedule_at: Requested schedule time. Required.
    :vartype schedule_at: ~datetime.datetime
    :ivar kind: The type discriminator describing ScheduleAndSuspendMode. Required. Discriminator
     value for ScheduleAndSuspendMode.
    :vartype kind: str or ~azure.communication.jobrouter.models.SCHEDULE_AND_SUSPEND
    """

    schedule_at: datetime.datetime = rest_field(name="scheduleAt", format="rfc3339")
    """Requested schedule time. Required."""
    kind: Literal[JobMatchingModeKind.SCHEDULE_AND_SUSPEND] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing ScheduleAndSuspendMode. Required. Discriminator value for
     ScheduleAndSuspendMode."""

    @overload
    def __init__(
        self,
        *,
        schedule_at: datetime.datetime,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=JobMatchingModeKind.SCHEDULE_AND_SUSPEND, **kwargs)


class ScoringRuleOptions(_model_base.Model):
    """Encapsulates all options that can be passed as parameters for scoring rule with BestWorkerMode.

    :ivar batch_size: Set batch size when 'isBatchScoringEnabled' is set to true. Defaults to 20 if
     not configured.
    :vartype batch_size: int
    :ivar scoring_parameters: List of extra parameters from a job that will be sent as part of the
     payload to scoring rule. If not set, a job's labels (sent in the payload as ``job``\ ) and a
     job's worker selectors (sent in the payload as ``selectors``\ ) are added to the payload of the
     scoring rule by default. Note: Worker labels are always sent with scoring payload.
    :vartype scoring_parameters: list[str or
     ~azure.communication.jobrouter.models.ScoringRuleParameterSelector]
    :ivar is_batch_scoring_enabled: If set to true, will score workers in batches, and the
     parameter name of the worker labels will be sent as ``workers``. By default, set to false and
     the parameter name for the worker labels will be sent as ``worker``. Note: If enabled, use
     'batchSize' to set batch size.
    :vartype is_batch_scoring_enabled: bool
    :ivar descending_order: If false, will sort scores by ascending order. By default, set to true.
    :vartype descending_order: bool
    """

    batch_size: Optional[int] = rest_field(name="batchSize")
    """Set batch size when 'isBatchScoringEnabled' is set to true. Defaults to 20 if not configured."""
    scoring_parameters: Optional[List[Union[str, "_models.ScoringRuleParameterSelector"]]] = rest_field(
        name="scoringParameters"
    )
    """List of extra parameters from a job that will be sent as part of the payload to scoring rule.
     If not set, a job's labels (sent in the payload as ``job``\ ) and a job's worker selectors
     (sent in the payload as ``selectors``\ ) are added to the payload of the scoring rule by
     default. Note: Worker labels are always sent with scoring payload."""
    is_batch_scoring_enabled: Optional[bool] = rest_field(name="isBatchScoringEnabled")
    """If set to true, will score workers in batches, and the parameter name of the worker labels will
     be sent as ``workers``. By default, set to false and the parameter name for the worker labels
     will be sent as ``worker``. Note: If enabled, use 'batchSize' to set batch size."""
    descending_order: Optional[bool] = rest_field(name="descendingOrder")
    """If false, will sort scores by ascending order. By default, set to true."""

    @overload
    def __init__(
        self,
        *,
        batch_size: Optional[int] = None,
        scoring_parameters: Optional[List[Union[str, "_models.ScoringRuleParameterSelector"]]] = None,
        is_batch_scoring_enabled: Optional[bool] = None,
        descending_order: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class StaticQueueSelectorAttachment(QueueSelectorAttachment, discriminator="static"):
    """Describes a queue selector that will be attached to a job.

    All required parameters must be populated in order to send to server.

    :ivar queue_selector: The queue selector to attach. Required.
    :vartype queue_selector: ~azure.communication.jobrouter.models.RouterQueueSelector
    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
     Discriminator value for StaticQueueSelectorAttachment.
    :vartype kind: str or ~azure.communication.jobrouter.models.STATIC
    """

    queue_selector: "_models.RouterQueueSelector" = rest_field(name="queueSelector")
    """The queue selector to attach. Required."""
    kind: Literal[QueueSelectorAttachmentKind.STATIC] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing the type of queue selector attachment. Required.
     Discriminator value for StaticQueueSelectorAttachment."""

    @overload
    def __init__(
        self,
        *,
        queue_selector: "_models.RouterQueueSelector",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=QueueSelectorAttachmentKind.STATIC, **kwargs)


class StaticRouterRule(RouterRule, discriminator="static"):
    """A rule providing static rules that always return the same result, regardless of input.

    All required parameters must be populated in order to send to server.

    :ivar value: The static value this rule always returns. Values must be primitive values -
     number, string, boolean.
    :vartype value: any
    :ivar kind: The type discriminator describing a sub-type of Rule. Required. Discriminator value
     for StaticRouterRule.
    :vartype kind: str or ~azure.communication.jobrouter.models.STATIC
    """

    value: Optional[Any] = rest_field()
    """The static value this rule always returns. Values must be primitive values - number, string,
     boolean."""
    kind: Literal[RouterRuleKind.STATIC] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of Rule. Required. Discriminator value for
     StaticRouterRule."""

    @overload
    def __init__(
        self,
        *,
        value: Optional[Any] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RouterRuleKind.STATIC, **kwargs)


class StaticWorkerSelectorAttachment(WorkerSelectorAttachment, discriminator="static"):
    """Describes a worker selector that will be attached to a job.

    All required parameters must be populated in order to send to server.

    :ivar worker_selector: The worker selector to attach. Required.
    :vartype worker_selector: ~azure.communication.jobrouter.models.RouterWorkerSelector
    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
     Discriminator value for StaticWorkerSelectorAttachment.
    :vartype kind: str or ~azure.communication.jobrouter.models.STATIC
    """

    worker_selector: "_models.RouterWorkerSelector" = rest_field(name="workerSelector")
    """The worker selector to attach. Required."""
    kind: Literal[WorkerSelectorAttachmentKind.STATIC] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing the type of worker selector attachment. Required.
     Discriminator value for StaticWorkerSelectorAttachment."""

    @overload
    def __init__(
        self,
        *,
        worker_selector: "_models.RouterWorkerSelector",
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=WorkerSelectorAttachmentKind.STATIC, **kwargs)


class SuspendMode(JobMatchingMode, discriminator="suspend"):
    """Describes a matching mode where matching worker to a job is suspended.

    All required parameters must be populated in order to send to server.

    :ivar kind: The type discriminator describing SuspendMode. Required. Discriminator value for
     SuspendMode.
    :vartype kind: str or ~azure.communication.jobrouter.models.SUSPEND
    """

    kind: Literal[JobMatchingModeKind.SUSPEND] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing SuspendMode. Required. Discriminator value for SuspendMode."""


class UnassignJobOptions(_model_base.Model):
    """Request payload for unassigning a job.

    :ivar suspend_matching: If SuspendMatching is true, then a job is not queued for re-matching
     with a worker.
    :vartype suspend_matching: bool
    """

    suspend_matching: Optional[bool] = rest_field(name="suspendMatching")
    """If SuspendMatching is true, then a job is not queued for re-matching with a worker."""

    @overload
    def __init__(
        self,
        *,
        suspend_matching: Optional[bool] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class UnassignJobResult(_model_base.Model):
    """Response payload after a job has been successfully unassigned.

    All required parameters must be populated in order to send to server.

    :ivar job_id: Id of an unassigned job. Required.
    :vartype job_id: str
    :ivar unassignment_count: The number of times a job is unassigned. At a maximum 3. Required.
    :vartype unassignment_count: int
    """

    job_id: str = rest_field(name="jobId")
    """Id of an unassigned job. Required."""
    unassignment_count: int = rest_field(name="unassignmentCount")
    """The number of times a job is unassigned. At a maximum 3. Required."""

    @overload
    def __init__(
        self,
        *,
        job_id: str,
        unassignment_count: int,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)


class WaitTimeExceptionTrigger(ExceptionTrigger, discriminator="waitTime"):
    """Trigger for an exception action on exceeding wait time.

    All required parameters must be populated in order to send to server.

    :ivar threshold_seconds: Threshold for wait time for this trigger. Required.
    :vartype threshold_seconds: float
    :ivar kind: The type discriminator describing a sub-type of ExceptionTrigger. Required.
     Discriminator value for WaitTimeExceptionTrigger.
    :vartype kind: str or ~azure.communication.jobrouter.models.WAIT_TIME
    """

    threshold_seconds: float = rest_field(name="thresholdSeconds")
    """Threshold for wait time for this trigger. Required."""
    kind: Literal[ExceptionTriggerKind.WAIT_TIME] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of ExceptionTrigger. Required. Discriminator value
     for WaitTimeExceptionTrigger."""

    @overload
    def __init__(
        self,
        *,
        threshold_seconds: float,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=ExceptionTriggerKind.WAIT_TIME, **kwargs)


class WebhookRouterRule(RouterRule, discriminator="webhook"):
    """A rule providing a binding to an external web server.

    All required parameters must be populated in order to send to server.

    :ivar authorization_server_uri: Uri for Authorization Server.
    :vartype authorization_server_uri: str
    :ivar client_credential: OAuth2.0 Credentials used to Contoso's Authorization server.
     Reference: https://www.oauth.com/oauth2-servers/access-tokens/client-credentials/.
    :vartype client_credential: ~azure.communication.jobrouter.models.OAuth2WebhookClientCredential
    :ivar webhook_uri: Uri for Contoso's Web Server.
    :vartype webhook_uri: str
    :ivar kind: The type discriminator describing a sub-type of Rule. Required. Discriminator value
     for WebhookRouterRule.
    :vartype kind: str or ~azure.communication.jobrouter.models.WEBHOOK
    """

    authorization_server_uri: Optional[str] = rest_field(name="authorizationServerUri")
    """Uri for Authorization Server."""
    client_credential: Optional["_models.OAuth2WebhookClientCredential"] = rest_field(name="clientCredential")
    """OAuth2.0 Credentials used to Contoso's Authorization server. Reference:
     https://www.oauth.com/oauth2-servers/access-tokens/client-credentials/."""
    webhook_uri: Optional[str] = rest_field(name="webhookUri")
    """Uri for Contoso's Web Server."""
    kind: Literal[RouterRuleKind.WEBHOOK] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing a sub-type of Rule. Required. Discriminator value for
     WebhookRouterRule."""

    @overload
    def __init__(
        self,
        *,
        authorization_server_uri: Optional[str] = None,
        client_credential: Optional["_models.OAuth2WebhookClientCredential"] = None,
        webhook_uri: Optional[str] = None,
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=RouterRuleKind.WEBHOOK, **kwargs)


class WeightedAllocationQueueSelectorAttachment(
    QueueSelectorAttachment, discriminator="weightedAllocation"
):  # pylint: disable=name-too-long
    """Describes multiple sets of queue selectors, of which one will be selected and attached
    according to a weighting.

    All required parameters must be populated in order to send to server.

    :ivar allocations: A collection of percentage based weighted allocations. Required.
    :vartype allocations: list[~azure.communication.jobrouter.models.QueueWeightedAllocation]
    :ivar kind: The type discriminator describing the type of queue selector attachment. Required.
     Discriminator value for WeightedAllocationQueueSelectorAttachment.
    :vartype kind: str or ~azure.communication.jobrouter.models.WEIGHTED_ALLOCATION
    """

    allocations: List["_models.QueueWeightedAllocation"] = rest_field()
    """A collection of percentage based weighted allocations. Required."""
    kind: Literal[QueueSelectorAttachmentKind.WEIGHTED_ALLOCATION] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing the type of queue selector attachment. Required.
     Discriminator value for WeightedAllocationQueueSelectorAttachment."""

    @overload
    def __init__(
        self,
        *,
        allocations: List["_models.QueueWeightedAllocation"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=QueueSelectorAttachmentKind.WEIGHTED_ALLOCATION, **kwargs)


class WeightedAllocationWorkerSelectorAttachment(
    WorkerSelectorAttachment, discriminator="weightedAllocation"
):  # pylint: disable=name-too-long
    """Describes multiple sets of worker selectors, of which one will be selected and attached
    according to a weighting.

    All required parameters must be populated in order to send to server.

    :ivar allocations: A collection of percentage based weighted allocations. Required.
    :vartype allocations: list[~azure.communication.jobrouter.models.WorkerWeightedAllocation]
    :ivar kind: The type discriminator describing the type of worker selector attachment. Required.
     Discriminator value for WeightedAllocationWorkerSelectorAttachment.
    :vartype kind: str or ~azure.communication.jobrouter.models.WEIGHTED_ALLOCATION
    """

    allocations: List["_models.WorkerWeightedAllocation"] = rest_field()
    """A collection of percentage based weighted allocations. Required."""
    kind: Literal[WorkerSelectorAttachmentKind.WEIGHTED_ALLOCATION] = rest_discriminator(name="kind")  # type: ignore
    """The type discriminator describing the type of worker selector attachment. Required.
     Discriminator value for WeightedAllocationWorkerSelectorAttachment."""

    @overload
    def __init__(
        self,
        *,
        allocations: List["_models.WorkerWeightedAllocation"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, kind=WorkerSelectorAttachmentKind.WEIGHTED_ALLOCATION, **kwargs)


class WorkerWeightedAllocation(_model_base.Model):
    """Contains the weight percentage and worker selectors to be applied if selected for weighted
    distributions.

    All required parameters must be populated in order to send to server.

    :ivar weight: The percentage of this weight, expressed as a fraction of 1. Required.
    :vartype weight: float
    :ivar worker_selectors: A collection of worker selectors that will be applied if this
     allocation is selected. Required.
    :vartype worker_selectors: list[~azure.communication.jobrouter.models.RouterWorkerSelector]
    """

    weight: float = rest_field()
    """The percentage of this weight, expressed as a fraction of 1. Required."""
    worker_selectors: List["_models.RouterWorkerSelector"] = rest_field(name="workerSelectors")
    """A collection of worker selectors that will be applied if this allocation is selected. Required."""

    @overload
    def __init__(
        self,
        *,
        weight: float,
        worker_selectors: List["_models.RouterWorkerSelector"],
    ): ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]):
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:  # pylint: disable=useless-super-delegation
        super().__init__(*args, **kwargs)
