# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.pineconevectordb import PineconeVectorDbMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-pineconevectordb
# USAGE
    python organizations_create_or_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = PineconeVectorDbMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.organizations.begin_create_or_update(
        resource_group_name="rgopenapi",
        organizationname="example-organization-name",
        resource={
            "identity": {"type": "None", "userAssignedIdentities": {"ident904655400": {}}},
            "location": "us-east",
            "properties": {
                "marketplace": {
                    "offerDetails": {
                        "offerId": "013124d0-bf05-4eab-a6bb-01fa83870642",
                        "planId": "62dda065-5acd-4ac5-b418-8610beed92a2",
                        "planName": "Freemium",
                        "publisherId": "4d194daf-fa20-46a8-bfb4-5b7d96cae009",
                        "termId": "a2b7ce01-f06d-4874-9f77-6ea4a4875c16",
                        "termUnit": "der",
                    },
                    "subscriptionId": "76a38ef6-c8c1-4f0d-bfe0-00ec782c8077",
                    "subscriptionStatus": "PendingFulfillmentStart",
                },
                "partnerProperties": {"displayName": "My Example Organization"},
                "singleSignOnProperties": {
                    "aadDomains": ["exampledomain"],
                    "enterpriseAppId": "44d3fb26-d8d5-41ff-9b9a-769737f22f13",
                    "state": "Initial",
                    "type": "Saml",
                    "url": "https://login.pinecone.io/?sso=true&connection=dfwgsqzkbrjqrglcsa",
                },
                "user": {
                    "emailAddress": "example.user@example.com",
                    "firstName": "Jimmy",
                    "lastName": "McExample",
                    "phoneNumber": "555-555-5555",
                    "upn": "example.user@example.com",
                },
            },
            "tags": {"my-tag": "tag.value"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2024-10-22-preview/Organizations_CreateOrUpdate_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
