% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_condition}
\alias{plot_condition}
\title{Plot DNA concentrations as a function of experimental conditions.}
\usage{
plot_condition(seqtab, condition, conc, batch = NULL, log = FALSE)
}
\arguments{
\item{seqtab}{(Required). \code{Integer matrix} or \code{phyloseq} object.
A feature table recording the observed abundances of each sequence feature (e.g. OTUs or ASVs or
or genus or ortholog or...) in each sample.
Rows should correspond to samples, and columns to sequences (or OTUs).
If a phyloseq object is provided, the otu-table component will be extracted.}

\item{condition}{(Required). \code{numeric} or any type coercible to a \code{factor}. Default NULL.
If provided, should be a vector of length equal to the number of input samples which specifies the
experimental condition of interest for each sample (e.g. pH).
If \code{seqtab} was provided as a phyloseq object, the name of the appropriate sample-variable in that
phyloseq object can be provided.}

\item{conc}{(Required). \code{numeric}.
A quantitative measure of the concentration of amplified DNA in each sample prior to sequencing.
All values must be greater than zero. Zero is assumed to represent the complete absence of DNA.
If \code{seqtab} was provided as a \code{phyloseq} object, the name of the sample variable in the
\code{phyloseq} object can be provided.}

\item{batch}{(Optional). \code{factor}, or any type coercible to a \code{factor}. Default NULL.
If provided, should be a vector of length equal to the number of input samples which specifies which batch
each sample belongs to (eg. sequencing run). Contaminants identification will be performed independently
within each batch.
If \code{seqtab} was provided as a phyloseq object, the name of the appropriate sample-variable in that
phyloseq object can be provided.}

\item{log}{(Optional). \code{logical}. Default TRUE.
If TRUE, the axes are log10-scaled.}
}
\description{
Plots DNA concentration as a function of experimental conditions. This function is intended as a
convenient exploration of potential covariation between DNA concentrations and conditions that
could influence the community composition, as this could lead to higher rates of false-positive
contaminant identifications.
}
\examples{
# MUC is a phyloseq object, MUC.conc is the vector of sample concentrations
MUC <- readRDS(system.file("extdata", "MUClite.rds", package="decontam"))
MUC.conc <- readRDS(system.file("extdata", "MUCconc.rds", package="decontam"))
plot_condition(MUC, "Habitat", MUC.conc)
# Plot against random quantitative variable
plot_condition(MUC, runif(length(MUC.conc)), MUC.conc, log=TRUE)

}
