% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colSums2.R, R/rowSums2.R
\name{colSums2,DelayedMatrix-method}
\alias{colSums2,DelayedMatrix-method}
\alias{colSums2,Matrix-method}
\alias{colSums2,SolidRleArraySeed-method}
\alias{rowSums2,DelayedMatrix-method}
\alias{rowSums2,Matrix-method}
\title{Calculates the sum for each row (column) of a matrix-like object}
\usage{
\S4method{colSums2}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{colSums2}{Matrix}(x, rows = NULL, cols = NULL, na.rm = FALSE, ..., useNames = TRUE)

\S4method{colSums2}{SolidRleArraySeed}(x, rows = NULL, cols = NULL, na.rm = FALSE, ..., useNames = TRUE)

\S4method{rowSums2}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowSums2}{Matrix}(x, rows = NULL, cols = NULL, na.rm = FALSE, ..., useNames = TRUE)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the sum for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowSums2}} /
\code{matrixStats::\link[matrixStats]{colSums2}}.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))
# A DelayedMatrix with a 'Matrix' seed
dm_Matrix <- DelayedArray(Matrix::Matrix(c(rep(1L, 5),
                                           as.integer((0:4) ^ 2),
                                           seq(-5L, -1L, 1L)),
                                         ncol = 3))

colSums2(dm_matrix)

# NOTE: Temporarily use verbose output to demonstrate which method is
#       which method is being used
options(DelayedMatrixStats.verbose = TRUE)
# By default, this uses a seed-aware method for a DelayedMatrix with a
# 'SolidRleArraySeed' seed
rowSums2(dm_Matrix)
# Alternatively, can use the block-processing strategy
rowSums2(dm_Matrix, force_block_processing = TRUE)
options(DelayedMatrixStats.verbose = FALSE)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowSums2}()} and
\code{matrixStats::\link[matrixStats:rowSums2]{colSums2}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item For mean estimates, see \code{\link[MatrixGenerics]{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
\item \code{base::\link{sum}()}.
}
}
\author{
Peter Hickey
}
