% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateVarianceExplained.R
\name{calculateVarianceExplained}
\alias{calculateVarianceExplained}
\title{Calculate variance explained by the model}
\usage{
calculateVarianceExplained(object, views = "all", factors = "all")
}
\arguments{
\item{object}{a trained \code{\link{MOFAmodel}} object.}

\item{views}{character vector with the view names, or numeric vector with view indexes.
Default is 'all'}

\item{factors}{character vector with the factor names,
or numeric vector with the factor indexes. Default is 'all'}
}
\value{
a list with matrices with the amount of variation explained 
per factor and view and the total variance explained per view.
}
\description{
Method to calculate variance explained by the MOFA model for each view and latent factor. \cr
As a measure of variance explained for gaussian data we adopt the coefficient of determination (R2). \cr
For non-gaussian views the calculations are based on the normally-distributed pseudo-data 
(for more information on the non-gaussian model 
see Supplementary Methods of the MOFA paper or Seeger & Bouchard, 2012).
}
\details{
This function takes a trained MOFA model as input and calculates
 for each view the coefficient of determination (R2),
i.e. the proportion of variance in the data explained by the MOFA factor(s) 
(both jointly and for each individual factor). 
In case of non-Gaussian data the variance explained on the Gaussian pseudo-data is calculated.
}
\examples{
# Using an existing trained model on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
calculateVarianceExplained(MOFA_CLL)

# Using an existing trained model on the scMT data
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFA_scMT <- loadModel(filepath)
calculateVarianceExplained(MOFA_scMT)
}
