% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateBMFeatures.R
\name{annotateBMFeatures}
\alias{annotateBMFeatures}
\alias{getBMFeatureAnnos}
\title{Get feature annotation information from Biomart}
\usage{
annotateBMFeatures(
  ids,
  biomart = "ENSEMBL_MART_ENSEMBL",
  dataset = "mmusculus_gene_ensembl",
  id.type = "ensembl_gene_id",
  symbol.type,
  attributes = c(id.type, symbol.type, "chromosome_name", "gene_biotype",
    "start_position", "end_position"),
  filters = id.type,
  ...
)

getBMFeatureAnnos(x, ids = rownames(x), ...)
}
\arguments{
\item{ids}{A character vector containing feature identifiers.}

\item{biomart}{String defining the biomaRt to be used, to be passed to \code{\link[biomaRt]{useMart}}.}

\item{dataset}{String defining the dataset to use, to be passed to \code{\link[biomaRt]{useMart}}.}

\item{id.type}{String specifying the type of identifier in \code{ids}.}

\item{symbol.type}{String specifying the type of symbol to retrieve.
If missing, this is set to \code{"mgi_symbol"} if \code{dataset="mmusculus_gene_ensembl"},
or to \code{"hgnc_symbol"} if \code{dataset="hsapiens_gene_ensembl"},}

\item{attributes}{Character vector defining the attributes to pass to \code{\link[biomaRt]{getBM}}.}

\item{filters}{String defining the type of identifier in \code{ids}, to be used as a filter in \code{\link[biomaRt]{getBM}}.}

\item{...}{For \code{annotateBMFeatures}, further named arguments to pass to \code{biomaRt::useMart}.

For \code{getBMFeatureAnnos}, further arguments to pass to \code{annotateBMFeatures}.}

\item{x}{A \linkS4class{SingleCellExperiment} object.}
}
\value{
For \code{annotateBMFeatures}, a \linkS4class{DataFrame} containing feature annotation, with one row per value in \code{ids}.

For \code{getBMFeatureAnnos}, \code{x} is returned containing the output of \code{annotateBMFeatures} appended to its \code{\link{rowData}}.
}
\description{
Use the \pkg{biomaRt} package to add feature annotation information to an \code{\link{SingleCellExperiment}}.
}
\details{
These functions provide convenient wrappers around \pkg{biomaRt} to quickly obtain annotation in the required format.
}
\examples{
\dontrun{
# Making up Ensembl IDs for demonstration purposes.
mock_id <- paste0("ENSMUSG", sprintf("\%011d", seq_len(1000)))
anno <- annotateBMFeatures(ids=mock_id)
}
}
\author{
Aaron Lun, based on code by Davis McCarthy
}
