% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrenchSource.R
\name{wrench}
\alias{wrench}
\title{Normalization for sparse, under-sampled count data.}
\usage{
wrench(mat, condition, etype = "w.marg.mean", ebcf = TRUE,
  z.adj = FALSE, phi.adj = TRUE, detrend = FALSE, ...)
}
\arguments{
\item{mat}{count matrix; rows are features and columns are samples}

\item{condition}{a vector with group information on the samples}

\item{etype}{weighting strategy with the following options:
\itemize{
\item{ hurdle.w.mean, the W1 estimator in manuscript.}
\item{ w.marg.mean, the W2 estimator in manuscript. These are appropriately computed depending on
                     whether \code{z.adj}=TRUE (see below)
}
\item{s2.w.mean, weight by inverse of feature-variances of logged count data. }
}}

\item{ebcf}{TRUE if empirical bayes regularization of ratios needs to be performed. Default recommended.}

\item{z.adj}{TRUE if the feature-wise ratios need to be adjusted
by hurdle probabilities (arises when taking marginal expectation). Default recommended.}

\item{phi.adj}{TRUE if estimates need to be adjusted for variance terms
(arises when considering positive-part expectations). Default recommended.}

\item{detrend}{FALSE if any linear dependence between sample-depth and compositional factors needs to be removed.
(setting this to TRUE reduces variation in compositional factors and can improve accuracy, but requires an extra assumption that no linear dependence between compositional factors and sample depth is present in samples).}

\item{...}{other parameters}
}
\value{
a \code{list} with components:
        \itemize{
        \item{ \code{nf}, \emph{normalization factors} for samples passed.
               Samples with zero total counts are removed from output. }
        \item{ \code{ccf}, \emph{compositional correction factors}.
               Samples with zero total counts are removed from output.
          }
        \item{ \code{others},  a \code{list} with results from intermediate computations. }
        \itemize{
        \item{ \code{qref},  reference chosen. }
        \item{ \code{design},  design matrix used for computation of positive-part parameters. }
        \item{ \code{s2},   feature-wise variances of logged count data. }
        \item{ \code{r},  (regularized) ratios of feature-wise proportions. }
        \item{ \code{radj},  adjustments made to the regularized ratios based
                             on z.adj and phi.adj settings.}
        }
        }
}
\description{
Obtain normalization factors for sparse, under-sampled count data that often arise with
metagenomic count data.
}
\examples{
#Obtain counts matrix and some group information
require(metagenomeSeq)
data(mouseData)
cntsMatrix <- MRcounts(mouseData)
group <- pData(mouseData)$diet
#Running wrench with defaults
W <- wrench( cntsMatrix, condition=group  )
compositionalFactors <- W$ccf
normalizationFactors <- W$nf

#Introducing the above normalization factors for the most
# commonly used tools is shown below.

#If using metagenomeSeq
normalizedObject <- mouseData
normFactors(normalizedObject) <- normalizationFactors

#If using edgeR, we must pass in the compositional factors
require(edgeR)
edgerobj <- DGEList( counts=cntsMatrix,
                     group = as.matrix(group),
                     norm.factors=compositionalFactors )

#If using DESeq/DESeq2
require(DESeq2)
deseq.obj <- DESeqDataSetFromMatrix(countData = cntsMatrix,
                                   DataFrame(group),
                                   ~ group )
DESeq2::sizeFactors(deseq.obj) <- normalizationFactors
}
\author{
M. Senthil Kumar
}
