% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Alakazam.R
\docType{package}
\name{alakazam}
\alias{alakazam}
\title{The alakazam package}
\description{
\code{alakazam} in a member of the Immcantation framework of tools and serves five main 
purposes:
\itemize{
  \item  Providing core functionality for other R packages in Immcantation. This
         includes common tasks such as file I/O, basic DNA sequence manipulation, and
         interacting with V(D)J segment and gene annotations.
  \item  Providing an R interface for interacting with the output of the pRESTO and 
         Change-O tool suites.
  \item  Performing clonal abundance and diversity analysis on lymphocyte repertoires.
  \item  Performing lineage reconstruction on clonal populations of immunoglobulin 
         (Ig) sequences.
  \item  Performing physicochemical property analyses of lymphocyte receptor sequences.
}
For additional details regarding the use of the \code{alakazam} package see the 
vignettes:\cr
\code{browseVignettes("alakazam")}
}
\section{File I/O}{

\itemize{
  \item  \link{readChangeoDb}:        Input Change-O style files.
  \item  \link{writeChangeoDb}:       Output Change-O style files.
}
}

\section{Sequence cleaning}{

\itemize{
  \item  \link{maskSeqEnds}:          Mask ragged ends.
  \item  \link{maskSeqGaps}:          Mask gap characters.
  \item  \link{collapseDuplicates}:   Remove duplicate sequences.
}
}

\section{Lineage reconstruction}{

\itemize{
  \item  \link{makeChangeoClone}:     Clean sequences for lineage reconstruction.
  \item  \link{buildPhylipLineage}:   Perform lineage reconstruction of Ig sequences.
}
}

\section{Lineage topology analysis}{

\itemize{
  \item  \link{tableEdges}:           Tabulate annotation relationships over edges.
  \item  \link{testEdges}:            Significance testing of annotation edges.
  \item  \link{testMRCA}:             Significance testing of MRCA annotations.
  \item  \link{summarizeSubtrees}:    Various summary statistics for subtrees.
  \item  \link{plotSubtrees}:         Plot distributions of summary statistics 
                                      for a population of trees.
}
}

\section{Diversity analysis}{

\itemize{
  \item  \link{countClones}:          Calculate clonal abundance.
  \item  \link{estimateAbundance}:  	 Bootstrap clonal abundance curves.
  \item  \link{alphaDiversity}:  	 Generate clonal alpha diversity curves.
  \item  \link{plotAbundanceCurve}:   Plot clone size distribution as a rank-abundance 
  \item  \link{plotDiversityCurve}:   Plot clonal diversity curves.
  \item  \link{plotDiversityTest}:    Plot testing at given diversity hill indicex. 
}
}

\section{Ig and TCR sequence annotation}{

\itemize{
  \item  \link{countGenes}:           Calculate Ig and TCR allele, gene and family usage.
  \item  \link{extractVRegion}:       Extract CDRs and FWRs sub-sequences.
  \item  \link{getAllele}:            Get V(D)J allele names.
  \item  \link{getGene}:              Get V(D)J gene names.
  \item  \link{getFamily}:            Get V(D)J family names.
  \item  \link{junctionAlignment}: Junction alignment properties 
}
}

\section{Sequence distance calculation}{

\itemize{
  \item  \link{seqDist}:        Calculate Hamming distance between two sequences.
  \item  \link{seqEqual}:       Test two sequences for equivalence.
  \item  \link{pairwiseDist}:   Calculate a matrix of pairwise Hamming distances for a 
                                set of sequences.
  \item  \link{pairwiseEqual}:  Calculate a logical matrix of pairwise equivalence for a 
                                set of sequences.
}
}

\section{Amino acid propertes}{

\itemize{
  \item  \link{translateDNA}:         Translate DNA sequences to amino acid sequences.
  \item  \link{aminoAcidProperties}:  Calculate various physicochemical properties of amino acid 
                                      sequences.
  \item  \link{countPatterns}:        Count patterns in sequences.
                                             
}
}

\references{
\enumerate{
  \item  Vander Heiden JA, Yaari G, et al. pRESTO: a toolkit for processing 
           high-throughput sequencing raw reads of lymphocyte receptor repertoires. 
           Bioinformatics. 2014 30(13):1930-2.
  \item  Stern JNH, Yaari G, Vander Heiden JA, et al. B cells populating the multiple 
           sclerosis brain mature in the draining cervical lymph nodes. 
           Sci Transl Med. 2014 6(248):248ra107.
  \item  Wu Y-CB, et al. Influence of seasonal exposure to grass pollen on local and 
           peripheral blood IgE repertoires in patients with allergic rhinitis. 
           J Allergy Clin Immunol. 2014 134(3):604-12.
  \item  Gupta NT, Vander Heiden JA, et al. Change-O: a toolkit for analyzing 
           large-scale B cell immunoglobulin repertoire sequencing data.
           Bioinformatics. 2015 Oct 15;31(20):3356-8.
}
}
