% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_assign.R
\name{model_get_assign}
\alias{model_get_assign}
\alias{model_get_assign.default}
\alias{model_get_assign.vglm}
\alias{model_get_assign.svy_vglm}
\alias{model_get_assign.model_fit}
\alias{model_get_assign.fixest}
\title{Get the assign attribute of model matrix of a model}
\usage{
model_get_assign(model)

\method{model_get_assign}{default}(model)

\method{model_get_assign}{vglm}(model)

\method{model_get_assign}{svy_vglm}(model)

\method{model_get_assign}{model_fit}(model)

\method{model_get_assign}{fixest}(model)
}
\arguments{
\item{model}{(a model object, e.g. \code{glm})\cr
A model object.}
}
\description{
Return the assign attribute attached to the object returned by
\code{\link[stats:model.matrix]{stats::model.matrix()}}.
}
\examples{
lm(hp ~ mpg + factor(cyl), mtcars) |>
  model_get_assign()
}
\seealso{
\code{\link[stats:model.matrix]{stats::model.matrix()}}

Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_n}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_pairwise_contrasts}()},
\code{\link{model_get_response}()},
\code{\link{model_get_response_variable}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_higher_order_variables}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
