% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pluralize.R
\name{pluralization}
\alias{pluralization}
\title{About cli pluralization}
\description{
About cli pluralization
}
\section{Introduction}{
cli has tools to create messages that are printed correctly in singular
and plural forms. This usually requires minimal extra work, and
increases the quality of the messages greatly. In this document we first
show some pluralization examples that you can use as guidelines.
Hopefully these are intuitive enough, so that they can be used without
knowing the exact cli pluralization rules.

If you need pluralization without the semantic cli functions, see the
\code{pluralize()} function.
}

\section{Examples}{
\subsection{Pluralization markup}{

In the simplest case the message contains a single \code{{}} glue
substitution, which specifies the quantity that is used to select
between the singular and plural forms. Pluralization uses markup that is
similar to glue, but uses the \verb{\{?} and \verb{\}} delimiters:\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(cli)
nfile <- 0; cli_text("Found \{nfile\} file\{?s\}.")
}\if{html}{\out{</div>}}\preformatted{#> Found 0 files.
}\if{html}{\out{<div class="sourceCode r">}}\preformatted{nfile <- 1; cli_text("Found \{nfile\} file\{?s\}.")
}\if{html}{\out{</div>}}\preformatted{#> Found 1 file.
}\if{html}{\out{<div class="sourceCode r">}}\preformatted{nfile <- 2; cli_text("Found \{nfile\} file\{?s\}.")
}\if{html}{\out{</div>}}\preformatted{#> Found 2 files.
}

Here the value of \code{nfile} is used to decide whether the singular or
plural form of \code{file} is used. This is the most common case for English
messages.
}

\subsection{Irregular plurals}{

If the plural form is more difficult than a simple \code{s} suffix, then the
singular and plural forms can be given, separated with a forward slash:\if{html}{\out{<div class="sourceCode r">}}\preformatted{ndir <- 1; cli_text("Found \{ndir\} director\{?y/ies\}.")
}\if{html}{\out{</div>}}\preformatted{#> Found 1 directory.
}\if{html}{\out{<div class="sourceCode r">}}\preformatted{ndir <- 5; cli_text("Found \{ndir\} director\{?y/ies\}.")
}\if{html}{\out{</div>}}\preformatted{#> Found 5 directories.
}
}

\subsection{Use \code{"no"} instead of zero}{

For readability, it is better to use the \code{no()} helper function to
include a count in a message. \code{no()} prints the word \code{"no"} if the count
is zero, and prints the numeric count otherwise:\if{html}{\out{<div class="sourceCode r">}}\preformatted{nfile <- 0; cli_text("Found \{no(nfile)\} file\{?s\}.")
}\if{html}{\out{</div>}}\preformatted{#> Found no files.
}\if{html}{\out{<div class="sourceCode r">}}\preformatted{nfile <- 1; cli_text("Found \{no(nfile)\} file\{?s\}.")
}\if{html}{\out{</div>}}\preformatted{#> Found 1 file.
}\if{html}{\out{<div class="sourceCode r">}}\preformatted{nfile <- 2; cli_text("Found \{no(nfile)\} file\{?s\}.")
}\if{html}{\out{</div>}}\preformatted{#> Found 2 files.
}
}

\subsection{Use the length of character vectors}{

With the auto-collapsing feature of cli it is easy to include a list of
objects in a message. When cli interprets a character vector as a
pluralization quantity, it takes the length of the vector:\if{html}{\out{<div class="sourceCode r">}}\preformatted{pkgs <- "pkg1"
cli_text("Will remove the \{.pkg \{pkgs\}\} package\{?s\}.")
}\if{html}{\out{</div>}}\preformatted{#> Will remove the pkg1 package.
}\if{html}{\out{<div class="sourceCode r">}}\preformatted{pkgs <- c("pkg1", "pkg2", "pkg3")
cli_text("Will remove the \{.pkg \{pkgs\}\} package\{?s\}.")
}\if{html}{\out{</div>}}\preformatted{#> Will remove the pkg1, pkg2, and pkg3 packages.
}

Note that the length is only used for non-numeric vectors (when
\code{is.numeric(x)} return \code{FALSE}). If you want to use the length of a
numeric vector, convert it to character via \code{as.character()}.

You can combine collapsed vectors with \code{"no"}, like this:\if{html}{\out{<div class="sourceCode r">}}\preformatted{pkgs <- character()
cli_text("Will remove \{?no/the/the\} \{.pkg \{pkgs\}\} package\{?s\}.")
}\if{html}{\out{</div>}}\preformatted{#> Will remove no packages.
}\if{html}{\out{<div class="sourceCode r">}}\preformatted{pkgs <- c("pkg1", "pkg2", "pkg3")
cli_text("Will remove \{?no/the/the\} \{.pkg \{pkgs\}\} package\{?s\}.")
}\if{html}{\out{</div>}}\preformatted{#> Will remove the pkg1, pkg2, and pkg3 packages.
}

When the pluralization markup contains three alternatives, like above,
the first one is used for zero, the second for one, and the third one
for larger quantities.
}

\subsection{Choosing the right quantity}{

When the text contains multiple glue \code{{}} substitutions, the one right
before the pluralization markup is used. For example:\if{html}{\out{<div class="sourceCode r">}}\preformatted{nfiles <- 3; ndirs <- 1
cli_text("Found \{nfiles\} file\{?s\} and \{ndirs\} director\{?y/ies\}")
}\if{html}{\out{</div>}}\preformatted{#> Found 3 files and 1 directory
}

This is sometimes not the the correct one. You can explicitly specify
the correct quantity using the \code{qty()} function. This sets that quantity
without printing anything:\if{html}{\out{<div class="sourceCode r">}}\preformatted{nupd <- 3; ntotal <- 10
cli_text("\{nupd\}/\{ntotal\} \{qty(nupd)\} file\{?s\} \{?needs/need\} updates")
}\if{html}{\out{</div>}}\preformatted{#> 3/10 files need updates
}

Note that if the message only contains a single \code{{}} substitution, then
this may appear before or after the pluralization markup. If the message
contains multiple \code{{}} substitutions \emph{after} pluralization markup, an
error is thrown.

Similarly, if the message contains no \code{{}} substitutions at all, but has
pluralization markup, an error is thrown.
}
}

\section{Rules}{
The exact rules of cli pluralization. There are two sets of rules. The
first set specifies how a quantity is associated with a \verb{\{?\}}
pluralization markup. The second set describes how the \verb{\{?\}} is parsed
and interpreted.
\subsection{Quantities}{
\enumerate{
\item \code{{}} substitutions define quantities. If the value of a \code{{}}
substitution is numeric (when \code{is.numeric(x)} holds), then it has to
have length one to define a quantity. This is only enforced if the
\code{{}} substitution is used for pluralization. The quantity is defined
as the value of \code{{}} then, rounded with \code{as.integer()}. If the value
of \code{{}} is not numeric, then its quantity is defined as its length.
\item If a message has \verb{\{?\}} markup but no \code{{}} substitution, an error is
thrown.
\item If a message has exactly one \code{{}} substitution, its value is used as
the pluralization quantity for all \verb{\{?\}} markup in the message.
\item If a message has multiple \code{{}} substitutions, then for each \verb{\{?\}}
markup cli uses the quantity of the \code{{}} substitution that precedes
it.
\item If a message has multiple \code{{}} substitutions and has pluralization
markup without a preceding \code{{}} substitution, an error is thrown.
}
}

\subsection{Pluralization markup}{
\enumerate{
\item Pluralization markup starts with \verb{\{?} and ends with \verb{\}}. It may not
contain \verb{\{} and \verb{\}} characters, so it may not contain \code{{}}
substitutions either.
\item Alternative words or suffixes are separated by \code{/}.
\item If there is a single alternative, then \emph{nothing} is used if
\code{quantity == 1} and this single alternative is used if
\code{quantity != 1}.
\item If there are two alternatives, the first one is used for
\code{quantity == 1}, the second one for \code{quantity != 1} (including
`\code{quantity == 0}).
\item If there are three alternatives, the first one is used for
\code{quantity == 0}, the second one for \code{quantity == 1}, and the third
one otherwise.
}
}
}

\seealso{
Other pluralization: 
\code{\link{no}()},
\code{\link{pluralize}()}
}
\concept{pluralization}
