% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_dl}
\alias{cli_dl}
\title{Definition list}
\usage{
cli_dl(
  items = NULL,
  labels = names(items),
  id = NULL,
  class = NULL,
  .close = TRUE,
  .auto_close = TRUE,
  .envir = parent.frame()
)
}
\arguments{
\item{items}{Named character vector, or \code{NULL}. If not \code{NULL}, they
are used as list items.}

\item{labels}{Item labels. Defaults the names in \code{items}.}

\item{id}{Id of the list container. Can be used for closing it with
\code{\link[=cli_end]{cli_end()}} or in themes. If \code{NULL}, then an id is generated and
returned invisibly.}

\item{class}{Class of the list container. Can be used in themes.}

\item{.close}{Whether to close the list container if the \code{items} were
specified. If \code{FALSE} then new items can be added to the list.}

\item{.auto_close}{Whether to close the container, when the calling
function finishes (or \code{.envir} is removed, if specified).}

\item{.envir}{Environment to evaluate the glue expressions in. It is
also used to auto-close the container if \code{.auto_close} is \code{TRUE}.}
}
\value{
The id of the new container element, invisibly.
}
\description{
A definition list is a container, see \link{containers}.
}
\details{
\subsection{All items at once}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_dl(c(foo = "one", bar = "two", baz = "three"))
\}
fun()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> foo: one                                                                        
#> bar: two                                                                        
#> baz: three                                                                      
</pre></div>
}}

}

\subsection{Items one by one}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_dl()
  cli_li(c(foo = "\{.emph one\}"))
  cli_li(c(bar = "two"))
  cli_li(c(baz = "three"))
\}
fun()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> foo: <span style="font-style: italic;">one</span>                                                                        
#> bar: two                                                                        
#> baz: three                                                                      
</pre></div>
}}

}
}
\seealso{
This function supports \link[=inline-markup]{inline markup}.

Other functions supporting inline markup: 
\code{\link{cli_abort}()},
\code{\link{cli_alert}()},
\code{\link{cli_blockquote}()},
\code{\link{cli_bullets_raw}()},
\code{\link{cli_bullets}()},
\code{\link{cli_h1}()},
\code{\link{cli_li}()},
\code{\link{cli_ol}()},
\code{\link{cli_process_start}()},
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_bar}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{cli_rule}},
\code{\link{cli_status_update}()},
\code{\link{cli_status}()},
\code{\link{cli_text}()},
\code{\link{cli_ul}()},
\code{\link{format_error}()},
\code{\link{format_inline}()}
}
\concept{functions supporting inline markup}
