% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly-year-quarter-day.R
\name{year_quarter_day}
\alias{year_quarter_day}
\title{Calendar: year-quarter-day}
\usage{
year_quarter_day(
  year,
  quarter = NULL,
  day = NULL,
  hour = NULL,
  minute = NULL,
  second = NULL,
  subsecond = NULL,
  ...,
  start = NULL,
  subsecond_precision = NULL
)
}
\arguments{
\item{year}{\verb{[integer]}

The fiscal year. Values \verb{[-32767, 32767]} are generally allowed.}

\item{quarter}{\verb{[integer / NULL]}

The fiscal quarter. Values \verb{[1, 4]} are allowed.}

\item{day}{\verb{[integer / "last" / NULL]}

The day of the quarter. Values \verb{[1, 92]} are allowed.

If \code{"last"}, the last day of the quarter is returned.}

\item{hour}{\verb{[integer / NULL]}

The hour. Values \verb{[0, 23]} are allowed.}

\item{minute}{\verb{[integer / NULL]}

The minute. Values \verb{[0, 59]} are allowed.}

\item{second}{\verb{[integer / NULL]}

The second. Values \verb{[0, 59]} are allowed.}

\item{subsecond}{\verb{[integer / NULL]}

The subsecond. If specified, \code{subsecond_precision} must also be specified
to determine how to interpret the \code{subsecond}.

If using milliseconds, values \verb{[0, 999]} are allowed.

If using microseconds, values \verb{[0, 999999]} are allowed.

If using nanoseconds, values \verb{[0, 999999999]} are allowed.}

\item{...}{These dots are for future extensions and must be empty.}

\item{start}{\verb{[integer(1) / NULL]}

The month to start the fiscal year in. 1 = January and 12 = December.

If \code{NULL}, a \code{start} of January will be used.}

\item{subsecond_precision}{\verb{[character(1) / NULL]}

The precision to interpret \code{subsecond} as. One of: \code{"millisecond"},
\code{"microsecond"}, or \code{"nanosecond"}.}
}
\value{
A year-quarter-day calendar vector.
}
\description{
\code{year_quarter_day()} constructs a calendar from the fiscal year, fiscal
quarter, and day of the quarter, along with a value determining which
month the fiscal year \code{start}s in.
}
\details{
Fields are recycled against each other using
\link[vctrs:vector_recycling_rules]{tidyverse recycling rules}.

Fields are collected in order until the first \code{NULL} field is located. No
fields after the first \code{NULL} field are used.
}
\examples{
# Year-quarter type
x <- year_quarter_day(2019, 1:4)
x

add_quarters(x, 2)

# Set the day to the last day of the quarter
x <- set_day(x, "last")
x

# Start the fiscal year in June
june <- 6L
y <- year_quarter_day(2019, 1:4, "last", start = june)

# Compare the year-month-day values that result from having different
# fiscal year start months
as_year_month_day(x)
as_year_month_day(y)
}
