% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_beta.R
\name{dist_beta}
\alias{dist_beta}
\title{The Beta distribution}
\usage{
dist_beta(shape1, shape2)
}
\arguments{
\item{shape1, shape2}{The non-negative shape parameters of the Beta distribution.}
}
\description{
\lifecycle{maturing}
}
\examples{
dist <- dist_beta(shape1 = c(0.5, 5, 1, 2, 2), shape2 = c(0.5, 1, 3, 2, 5))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Beta]{stats::Beta}
}
