% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gglikert.R
\name{gglikert}
\alias{gglikert}
\alias{gglikert_data}
\alias{gglikert_stacked}
\title{Plotting Likert-type items}
\usage{
gglikert(
  data,
  include = dplyr::everything(),
  weights = NULL,
  y = ".question",
  variable_labels = NULL,
  sort = c("none", "ascending", "descending"),
  sort_method = c("prop", "mean", "median"),
  sort_prop_include_center = totals_include_center,
  exclude_fill_values = NULL,
  add_labels = TRUE,
  labels_size = 3.5,
  labels_color = "black",
  labels_accuracy = 1,
  labels_hide_below = 0.05,
  add_totals = TRUE,
  totals_size = labels_size,
  totals_color = "black",
  totals_accuracy = labels_accuracy,
  totals_fontface = "bold",
  totals_include_center = FALSE,
  totals_hjust = 0.1,
  y_reverse = TRUE,
  y_label_wrap = 50,
  reverse_likert = FALSE,
  width = 0.9,
  facet_rows = NULL,
  facet_cols = NULL,
  facet_label_wrap = 50
)

gglikert_data(
  data,
  include = dplyr::everything(),
  weights = NULL,
  variable_labels = NULL,
  sort = c("none", "ascending", "descending"),
  sort_method = c("prop", "mean", "median"),
  sort_prop_include_center = TRUE,
  exclude_fill_values = NULL
)

gglikert_stacked(
  data,
  include = dplyr::everything(),
  weights = NULL,
  y = ".question",
  variable_labels = NULL,
  sort = c("none", "ascending", "descending"),
  sort_method = c("prop", "mean", "median"),
  sort_prop_include_center = FALSE,
  add_labels = TRUE,
  labels_size = 3.5,
  labels_color = "black",
  labels_accuracy = 1,
  labels_hide_below = 0.05,
  add_median_line = FALSE,
  y_reverse = TRUE,
  y_label_wrap = 50,
  reverse_fill = TRUE,
  width = 0.9
)
}
\arguments{
\item{data}{a data frame}

\item{include}{variables to include, accept \link[dplyr:select]{tidy-select}
syntax}

\item{weights}{optional variable name of a weighting variable,
accept \link[dplyr:select]{tidy-select} syntax}

\item{y}{name of the variable to be plotted on \code{y} axis (relevant when
\code{.question} is mapped to "facets, see examples),
accept \link[dplyr:select]{tidy-select} syntax}

\item{variable_labels}{a named list or a named vector of custom variable
labels}

\item{sort}{should variables be sorted?}

\item{sort_method}{method used to sort the variables: \code{"prop"} sort according
to the proportion of answers higher than the centered level, \code{"mean"}
considers answer as a score and sort according to the mean score, \code{"median"}
used the median and the majority judgment rule for tie-breaking.}

\item{sort_prop_include_center}{when sorting with \code{"prop"} and if the number
of levels is uneven, should half of the central level be taken into account
to compute the proportion?}

\item{exclude_fill_values}{Vector of values that should not be displayed
(but still taken into account for computing proportions),
see \code{\link[=position_likert]{position_likert()}}}

\item{add_labels}{should percentage labels be added to the plot?}

\item{labels_size}{size of the percentage labels}

\item{labels_color}{color of the percentage labels}

\item{labels_accuracy}{accuracy of the percentages, see
\code{\link[scales:label_percent]{scales::label_percent()}}}

\item{labels_hide_below}{if provided, values below will be masked, see
\code{\link[=label_percent_abs]{label_percent_abs()}}}

\item{add_totals}{should the total proportions of negative and positive
answers be added to plot? \strong{This option is not compatible with facets!}}

\item{totals_size}{size of the total proportions}

\item{totals_color}{color of the total proportions}

\item{totals_accuracy}{accuracy of the total proportions, see
\code{\link[scales:label_percent]{scales::label_percent()}}}

\item{totals_fontface}{font face of the total proportions}

\item{totals_include_center}{if the number of levels is uneven, should half
of the center level be added to the total proportions?}

\item{totals_hjust}{horizontal adjustment of totals labels on the x axis}

\item{y_reverse}{should the y axis be reversed?}

\item{y_label_wrap}{number of characters per line for y axis labels, see
\code{\link[scales:label_wrap]{scales::label_wrap()}}}

\item{reverse_likert}{if \code{TRUE}, will reverse the default stacking order,
see \code{\link[=position_likert]{position_likert()}}}

\item{width}{bar width, see \code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}}}

\item{facet_rows, facet_cols}{A set of variables or expressions quoted by
\code{\link[ggplot2:vars]{ggplot2::vars()}} and defining faceting groups on the rows or columns
dimension (see examples)}

\item{facet_label_wrap}{number of characters per line for facet labels, see
\code{\link[ggplot2:labellers]{ggplot2::label_wrap_gen()}}}

\item{add_median_line}{add a vertical line at 50\%?}

\item{reverse_fill}{if \code{TRUE}, will reverse the default stacking order,
see \code{\link[ggplot2:position_stack]{ggplot2::position_fill()}}}
}
\value{
A \code{ggplot2} plot or a \code{tibble}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Combines several factor variables using the same list of ordered levels
(e.g. Likert-type scales) into a unique data frame and generates a centered
bar plot.

You could use \code{gglikert_data()} to just produce the dataset to be plotted.

If variable labels have been defined (see \code{\link[labelled:var_label]{labelled::var_label()}}), they will
be considered. You can also pass custom variables labels with the
\code{variable_labels} argument.
}
\examples{
library(ggplot2)
library(dplyr)

likert_levels <- c(
  "Strongly disagree",
  "Disagree",
  "Neither agree nor disagree",
  "Agree",
  "Strongly agree"
)
set.seed(42)
df <-
  tibble(
    q1 = sample(likert_levels, 150, replace = TRUE),
    q2 = sample(likert_levels, 150, replace = TRUE, prob = 5:1),
    q3 = sample(likert_levels, 150, replace = TRUE, prob = 1:5),
    q4 = sample(likert_levels, 150, replace = TRUE, prob = 1:5),
    q5 = sample(c(likert_levels, NA), 150, replace = TRUE),
    q6 = sample(likert_levels, 150, replace = TRUE, prob = c(1, 0, 1, 1, 0))
  ) \%>\%
  mutate(across(everything(), ~ factor(.x, levels = likert_levels)))

gglikert(df)

gglikert(df, include = q1:3)

gglikert(df, sort = "ascending")

\donttest{
gglikert(df, sort = "ascending", sort_prop_include_center = TRUE)

gglikert(df, sort = "ascending", sort_method = "mean")

gglikert(df, reverse_likert = TRUE)

gglikert(df, add_totals = FALSE, add_labels = FALSE)

gglikert(
  df,
  totals_include_center = TRUE,
  totals_hjust = .25,
  totals_size = 4.5,
  totals_fontface = "italic",
  totals_accuracy = .01,
  labels_accuracy = 1,
  labels_size = 2.5,
  labels_hide_below = .25
)

gglikert(df, exclude_fill_values = "Neither agree nor disagree")

if (require("labelled")) {
  df \%>\%
    set_variable_labels(
      q1 = "First question",
      q2 = "Second question"
    ) \%>\%
    gglikert(
      variable_labels = c(
        q4 = "a custom label",
        q6 = "a very very very very very very very very very very long label"
      ),
      y_label_wrap = 25
    )
}

# Facets
df_group <- df
df_group$group <- sample(c("A", "B"), 150, replace = TRUE)

gglikert(df_group, q1:q6, facet_rows = vars(group))

gglikert(df_group, q1:q6, facet_cols = vars(group))

gglikert(df_group, q1:q6, y = "group", facet_rows = vars(.question))
}
gglikert_stacked(df, q1:q6)

gglikert_stacked(df, q1:q6, add_median_line = TRUE, sort = "asc")

\donttest{
gglikert_stacked(df_group, q1:q6, y = "group", add_median_line = TRUE) +
  facet_grid(rows = vars(.question))
}
}
\seealso{
\code{vignette("gglikert")}, \code{\link[=position_likert]{position_likert()}}, \code{\link[=stat_prop]{stat_prop()}}
}
