% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableau.R
\name{tableau_gradient_pal}
\alias{tableau_gradient_pal}
\alias{tableau_seq_gradient_pal}
\alias{tableau_div_gradient_pal}
\title{Tableau colour gradient palettes (continuous)}
\usage{
tableau_gradient_pal(palette = "Blue", type = "ordered-sequential")

tableau_seq_gradient_pal(palette = "Blue", ...)

tableau_div_gradient_pal(palette = "Orange-Blue Diverging", ...)
}
\arguments{
\item{palette}{Palette name.
\itemize{
\item{\code{"ordered-sequential"}}{\Sexpr[results=rd]{ggthemes:::rd_optlist(names(ggthemes::ggthemes_data$tableau[["color-palettes"]][["ordered-sequential"]]))}}
\item{\code{"ordered-diverging"}}{\Sexpr[results=rd]{ggthemes:::rd_optlist(names(ggthemes::ggthemes_data$tableau[["color-palettes"]][["ordered-diverging"]]))}}
}}

\item{type}{Palette type, either \code{"ordered-sequential"} or
\code{"ordered-diverging"}.}

\item{...}{Arguments passed to \code{tableau_gradient_pal}.}
}
\description{
Gradient color palettes using the diverging and sequential continous color
palettes in Tableau. See \funclink{tableau_color_pal} for discrete color
palettes.
}
\examples{
library("scales")

x <- seq(0, 1, length = 25)
r <- sqrt(outer(x ^ 2, x ^ 2, "+"))
palettes <-
  ggthemes_data[["tableau"]][["color-palettes"]][["ordered-sequential"]]
for (palname in names(palettes)) {
  col <- tableau_seq_gradient_pal(palname)(seq(0, 1, length = 12))
  image(r, col = col)
  title(main = palname)
}
}
\seealso{
Other colour tableau: \code{\link{scale_colour_gradient2_tableau}},
  \code{\link{scale_colour_gradient_tableau}},
  \code{\link{scale_colour_tableau}},
  \code{\link{tableau_color_pal}}
}
\concept{colour tableau}
