% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{authority_score}
\alias{authority_score}
\alias{hub_score}
\title{Kleinberg's authority centrality scores.}
\usage{
authority_score(
  graph,
  scale = TRUE,
  weights = NULL,
  options = arpack_defaults()
)

hub_score(graph, scale = TRUE, weights = NULL, options = arpack_defaults())
}
\arguments{
\item{graph}{The input graph.}

\item{scale}{Logical scalar, whether to scale the result to have a maximum
score of one. If no scaling is used then the result vector has unit length
in the Euclidean norm.}

\item{weights}{Optional positive weight vector for calculating weighted
scores. If the graph has a \code{weight} edge attribute, then this is used
by default.
This function interprets edge weights as connection strengths. In the
random surfer model, an edge with a larger weight is more likely to be
selected by the surfer.}

\item{options}{A named list, to override some ARPACK options. See
\code{\link[=arpack]{arpack()}} for details.}
}
\description{
Kleinberg's authority centrality scores.

Kleinberg's hub centrality scores.
}
\seealso{
Centrality measures
\code{\link{alpha_centrality}()},
\code{\link{betweenness}()},
\code{\link{closeness}()},
\code{\link{diversity}()},
\code{\link{eigen_centrality}()},
\code{\link{harmonic_centrality}()},
\code{\link{hits_scores}()},
\code{\link{page_rank}()},
\code{\link{power_centrality}()},
\code{\link{spectrum}()},
\code{\link{strength}()},
\code{\link{subgraph_centrality}()}
}
\concept{centrality}
