% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteBogusRows.R
\name{deleteBogusColumns}
\alias{deleteBogusColumns}
\title{Remove columns in which the proportion of missing data exceeds
a threshold.}
\usage{
deleteBogusColumns(dframe, pm = 0.9, drop = FALSE, verbose = TRUE, n = 25)
}
\arguments{
\item{dframe}{A data frame or matrix}

\item{pm}{"proportion missing data" to be tolerated.}

\item{drop}{Default FALSE: if data frame result is reduced to one
column, should R's default drop behavior "demote" this to a
column vector.}

\item{verbose}{Default TRUE. Should a report be printed
summarizing information to be delted?}

\item{n}{Default 25: limit on number of values to print in
diagnostic output. If set to NULL or NA, then all of the
column values will be printed for the bogus rows.}
}
\value{
a data frame, invisibly
}
\description{
This is a column version of \code{deleteBogusRows}. Use the pm
argument to set the proportion of missing required before a column
is flagged for deletion
}
\seealso{
\code{deleteBogusRows}
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
