% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_switch_linter.R
\name{if_switch_linter}
\alias{if_switch_linter}
\title{Require usage of switch() over repeated if/else blocks}
\usage{
if_switch_linter(max_branch_lines = 0L, max_branch_expressions = 0L)
}
\arguments{
\item{max_branch_lines, max_branch_expressions}{Integer, default 0 indicates "no maximum".
If set any \code{if}/\verb{else if}/.../\verb{else} chain where any branch occupies more than
this number of lines (resp. expressions) will not be linted. The conjugate
applies to \code{switch()} statements -- if these parameters are set, any \code{switch()}
statement with any overly-complicated branches will be linted. See examples.}
}
\description{
\code{\link[=switch]{switch()}} statements in R are used to delegate behavior based
on the value of some input scalar string, e.g.
\code{switch(x, a = 1, b = 3, c = 7, d = 8)} will be one of
\code{1}, \code{3}, \code{7}, or \code{8}, depending on the value of \code{x}.
}
\details{
This can also be accomplished by repeated \code{if}/\verb{else} statements like
so: \code{if (x == "a") 1 else if (x == "b") 2 else if (x == "c") 7 else 8}
(implicitly, the last \verb{else} assumes x only takes 4 possible values),
but this is more cluttered and slower (note that \code{switch()} takes the same
time to evaluate regardless of the value of \code{x}, and is faster even
when \code{x} takes the first value (here \code{a}), and that the \code{if}/\verb{else}
approach is roughly linear in the number of conditions that need to
be evaluated, here up to 3 times).
}
\examples{
# will produce lints
lint(
  text = "if (x == 'a') 1 else if (x == 'b') 2 else 3",
  linters = if_switch_linter()
)

code <- paste(
  "if (x == 'a') {",
  "  1",
  "} else if (x == 'b') {",
  "  2",
  "} else if (x == 'c') {",
  "  y <- x",
  "  z <- sqrt(match(y, letters))",
  "  z",
  "}",
  sep = "\n"
)
writeLines(code)
lint(
  text = code,
  linters = if_switch_linter()
)

code <- paste(
  "if (x == 'a') {",
  "  1",
  "} else if (x == 'b') {",
  "  2",
  "} else if (x == 'c') {",
  "  y <- x",
  "  z <- sqrt(",
  "    match(y, letters)",
  "  )",
  "  z",
  "}",
  sep = "\n"
)
writeLines(code)
lint(
  text = code,
  linters = if_switch_linter()
)

code <- paste(
  "switch(x,",
  "  a = {",
  "    1",
  "    2",
  "    3",
  "  },",
  "  b = {",
  "    1",
  "    2",
  "  }",
  ")",
  sep = "\n"
)
writeLines(code)
lint(
  text = code,
  linters = if_switch_linter(max_branch_lines = 2L)
)

# okay
lint(
  text = "switch(x, a = 1, b = 2, 3)",
  linters = if_switch_linter()
)

# switch() version not as clear
lint(
  text = "if (x == 'a') 1 else if (x == 'b' & y == 2) 2 else 3",
  linters = if_switch_linter()
)

code <- paste(
  "if (x == 'a') {",
  "  1",
  "} else if (x == 'b') {",
  "  2",
  "} else if (x == 'c') {",
  "  y <- x",
  "  z <- sqrt(match(y, letters))",
  "  z",
  "}",
  sep = "\n"
)
writeLines(code)
lint(
  text = code,
  linters = if_switch_linter(max_branch_lines = 2L)
)

code <- paste(
  "if (x == 'a') {",
  "  1",
  "} else if (x == 'b') {",
  "  2",
  "} else if (x == 'c') {",
  "  y <- x",
  "  z <- sqrt(",
  "    match(y, letters)",
  "  )",
  "  z",
  "}",
  sep = "\n"
)
writeLines(code)
lint(
  text = code,
  linters = if_switch_linter(max_branch_expressions = 2L)
)

code <- paste(
  "switch(x,",
  "  a = {",
  "    1",
  "    2",
  "    3",
  "  },",
  "  b = {",
  "    1",
  "    2",
  "  }",
  ")",
  sep = "\n"
)
writeLines(code)
lint(
  text = code,
  linters = if_switch_linter(max_branch_lines = 3L)
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=consistency_linters]{consistency}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
