% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alter.r
\name{desaturate}
\alias{desaturate}
\title{Make a munsell colour less saturated}
\usage{
desaturate(col, steps = 1)
}
\arguments{
\item{col}{character vector of Munsell colours}

\item{steps}{number of steps to take in decreasing chroma}
}
\value{
character vector of Munsell colours
}
\description{
Decreases the chroma of the Munsell colour by one step steps (multiples of 2).
}
\examples{
desaturate("5PB 2/4")
cols <- c("5PB 2/6", "5Y 7/8")
p <- plot_mnsl(c(cols, desaturate(cols), desaturate(cols, 2)))
p + ggplot2::facet_wrap(~ names, ncol = 2)
}
