% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxFitFunctionWLS.R
\name{mxDescribeDataWLS}
\alias{mxDescribeDataWLS}
\title{Determine whether a dataset will have weights and summary statistics for the means if used with mxFitFunctionWLS}
\usage{
mxDescribeDataWLS(data, allContinuousMethod = c("cumulants",
  "marginals"), verbose = FALSE)
}
\arguments{
\item{data}{the (currently raw) data being used in a \code{\link{mxFitFunctionWLS}} model.}

\item{allContinuousMethod}{the method used to process data when all columns are continuous.}

\item{verbose}{logical. Whether to report diagnostics.}
}
\value{
- list describing the data.
}
\description{
Given either a data.frame or an mxData of type raw, this function determines whether \code{mxFitFunctionWLS}
will generate expectations for means.
}
\details{
All-continuous data processed using the "cumulants" method lack means, while
all continuous data processed with allContinuousMethod = "marginals" will have means.

When data are not all continuous, allContinuousMethod is ignored, and means are modelled.
}
\examples{

# ====================================
# = All continuous, data.frame input =
# ====================================

tmp = mxDescribeDataWLS(mtcars, allContinuousMethod= "cumulants", verbose = TRUE)
tmp$hasMeans # FALSE - no means with cumulants
tmp = mxDescribeDataWLS(mtcars, allContinuousMethod= "marginals") 
tmp$hasMeans # TRUE we get means with marginals

# ==========================
# = mxData object as input =
# ==========================
tmp = mxData(mtcars, type="raw")
mxDescribeDataWLS(tmp, allContinuousMethod= "cumulants", verbose = TRUE)$hasMeans # FALSE
mxDescribeDataWLS(tmp, allContinuousMethod= "marginals")$hasMeans  # TRUE

# =======================================
# = One var is a factor: Means modelled =
# =======================================
tmp = mtcars
tmp$cyl = factor(tmp$cyl)
mxDescribeDataWLS(tmp, allContinuousMethod= "cumulants")$hasMeans # TRUE - always has means
mxDescribeDataWLS(tmp, allContinuousMethod= "marginals")$hasMeans # TRUE

}
\seealso{
- \code{\link{mxFitFunctionWLS}}, \code{\link{omxAugmentDataWithWLSSummary}}
}
\concept{Data Functions}
