% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\name{terms}
\alias{terms}
\title{Get ITIS terms, i.e., tsn's, authors, common names, and scientific names}
\usage{
terms(query, what = "both", wt = "json", raw = FALSE, ...)
}
\arguments{
\item{query}{One or more common or scientific names, or partial names}

\item{what}{One of both (search common and scientific names), common
(search just common names), or scientific (search just scientific names)}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Get ITIS terms, i.e., tsn's, authors, common names, and scientific names
}
\examples{
\dontrun{
# Get terms searching both common and scientific names
terms(query='bear')

# Get terms searching just common names
terms(query='tarweed', "common")

# Get terms searching just scientific names
terms(query='Poa annua', "scientific")

# many at once
terms(query=c('Poa annua', 'Pinus contorta'), "scientific")
}
}
