% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-abort.R
\name{format_error_call}
\alias{format_error_call}
\title{Validate and format a function call for use in error messages}
\usage{
format_error_call(call)
}
\arguments{
\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[=abort]{abort()}} for more information.}
}
\value{
Either a string formatted as code or \code{NULL} if a simple
call could not be generated.
}
\description{
\code{format_error_call()} simplifies its input to a simple call (see
section below) and formats the result as code (using cli if
available). Use this function to generate the "in" part
of an error message from a stack frame call.

If passed an environment, the corresponding \code{sys.call()} is taken
as call, unless there is a local flag (see \code{\link[=local_error_call]{local_error_call()}}).
}
\section{Details of formatting}{

\itemize{
\item The arguments of function calls are stripped.
\item Complex function calls containing inlined objects return
\code{NULL}.
\item Calls to \code{if} preserve the condition since it might be
informative. Branches are dropped.
\item Calls to operators and other special syntax are formatted using
their names rather than the potentially confusing function form.
}
}

\examples{
# Arguments are stripped
writeLines(format_error_call(quote(foo(bar, baz))))

# Returns `NULL` with complex calls such as those that contain
# inlined functions
format_error_call(call2(list))

# Operators are formatted using their names rather than in
# function call form
writeLines(format_error_call(quote(1 + 2)))
}
\keyword{internal}
