% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/premium.R
\name{search_fullarchive}
\alias{search_fullarchive}
\title{Search fullarchive (PREMIUM)}
\usage{
search_fullarchive(
  q,
  n = 100,
  fromDate = NULL,
  toDate = NULL,
  env_name = NULL,
  safedir = NULL,
  parse = TRUE,
  token = NULL
)
}
\arguments{
\item{q}{Search query on which to match/filter tweets. See details for
information about available search operators.}

\item{n}{Number of tweets to return; it is best to set this number in
intervals of 100 for the '30day' API and either 100 (for sandbox) or 500
(for paid) for the 'fullarchive' API. Default is 100.}

\item{fromDate}{Oldest date-time (YYYYMMDDHHMM) from which tweets should be
searched for.}

\item{toDate}{Newest date-time (YYYYMMDDHHMM) from which tweets should be
searched for.}

\item{env_name}{Name/label of developer environment to use for the search.}

\item{safedir}{Name of directory to which each response object should be
saved. If the directory doesn't exist, it will be created. If NULL (the
default) then a dir will be created in the current working directory. To
override/deactivate safedir set this to FALSE.}

\item{parse}{Logical indicating whether to convert data into data frame.}

\item{token}{A token associated with a user-created APP (requires a developer
account), which is converted to a bearer token in order to make premium
API requests}
}
\value{
A tibble data frame of Twitter data
}
\description{
Search Twitter's 'fullarchive' (PREMIUM) API
}
\section{Developer Account}{

Users must have an approved developer account and an active/labeled
environment to access Twitter's premium APIs. For more information, to check
your current Subscriptions and Dev Environments, or to apply for a developer
account visit \url{https://developer.twitter.com}.
}

\section{Search operators}{

\emph{Note: Bolded operators ending with a colon should be immediately
followed by a word or quoted phrase (if appropriate)–e.g.,} \code{lang:en}
}

\section{Keyword}{

\itemize{
  \item \strong{""}           ~~ match exact phrase
  \item \strong{#}               ~~ hashtag
  \item \strong{@}               ~~ at mentions)
  \item \strong{url:}            ~~ found in URL
  \item \strong{lang:}           ~~ language of tweet
}
}

\section{Accounts of interest}{

\itemize{
  \item \strong{from:}           ~~ authored by
  \item \strong{to:}             ~~ sent to
  \item \strong{retweets_of:}    ~~ retweet author
}
}

\section{Tweet attributes}{

\itemize{
  \item \strong{is:retweet}      ~~ only retweets
  \item \strong{has:mentions}    ~~ uses mention(s)
  \item \strong{has:hashtags}    ~~ uses hashtags(s)
  \item \strong{has:media}       ~~ includes media(s)
  \item \strong{has:videos}      ~~ includes video(s)
  \item \strong{has:images}      ~~ includes image(s)
  \item \strong{has:links}       ~~ includes URL(s)
  \item \strong{is:verified}     ~~ from verified accounts
}
}

\section{Geospatial}{

\itemize{
  \item \strong{bounding_box:[west_long south_lat east_long north_lat]} ~~ lat/long coordinates box
  \item \strong{point_radius:[lon lat radius]} ~~ center of search radius
  \item \strong{has:geo}           ~~ uses geotagging
  \item \strong{place:}            ~~ by place
  \item \strong{place_country:}    ~~ by country
  \item \strong{has:profile_geo}   ~~ geo associated with profile
  \item \strong{profile_country:}  ~~ country associated with profile
  \item \strong{profile_region:}   ~~ region associated with profile
  \item \strong{profile_locality:} ~~ locality associated with profile
}
}

\examples{

\dontrun{
## search fullarchive for up to 300 rstats tweets sent in Jan 2014
rt <- search_fullarchive("#rstats", n = 300, env_name = "research",
  fromDate = "201401010000", toDate = "201401312359")
}

}
