% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate}
\alias{generate}
\title{Generate data from regularized models.}
\usage{
generate(vst_out, genes = rownames(vst_out$model_pars_fit),
  cell_attr = vst_out$cell_attr, n_cells = nrow(cell_attr))
}
\arguments{
\item{vst_out}{A list that provides model parameters and optionally meta data; use output of vst function}

\item{genes}{The gene names for which to generate data; default is rownames(vst_out$model_pars_fit)}

\item{cell_attr}{Provide cell meta data holding latent data info; default is vst_out$cell_attr}

\item{n_cells}{Number of cells to generate; default is nrow(cell_attr)}
}
\value{
Generated data as dgCMatrix
}
\description{
Generate data from regularized models. This generates data from the background,
i.e. no residuals are added to the simulated data. The cell attributes for the
generated cells are sampled from the input with replacment.
}
\examples{
\donttest{
vst_out <- vst(pbmc, return_cell_attr = TRUE)
generated_data <- generate(vst_out)
}

}
