# Announce: Rakudo compiler, Release #145 (2021.04)

On behalf of the Rakudo development team, I’m very happy to announce the
April 2021 release of Rakudo #145. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2021.04:

  + Additions:
    + Make methods `keys`, `values`, `kv`, `pairs`, `antipairs`, `invert` work on `Enum`
      [3a112938][615030d2][b1556cba]
    + Make `uniname` method work on all `Cool` values such as `Num` or `Match` [31331a28]
    + Add the `user` and `group` methods to `IO::Path` [2fa6413b]
    + Add new methods `day-fraction`, `modified-julian-date` and `julian-date` to `DateTime`
      [6841ed5e][457925e9][39260262][2689eac1]
    + Allow `uniparse` to be called on `Cool` [075d6921]
    + Add warnings on improper use of `contains` and `index` methods [39a3862b]
  + Deprecations:
    + Deprecate `Cool.path` method, use `Cool.IO` instead [c715b5cb]
    + The NQP operators `time_i` and `time_n` were deprecated in favor of `time` which
      returns integer nanoseconds since the epoch [b6448c7e][acaef290][c1f341cc]
  + Build System:
    * Properly handle signals (e.g. out of memory) during build phase
      and provide a more informative output [03854ed7]
  + Changes:
    + Rename `deterministic` method on `Iterator` introduced in 2020.12 into
     `is-deterministic` [596ccef3]
    + Calling `ord` method on `Str:U` now throws an exception
      instead of silently returning `Nil` [92dc60b7]
    + The subroutine `subtest` from the `Test` module now outputs a test header
      as a comment `Subtest` with an optional description provided [a7c57a01]
    + Make `Int.chr` and `Int.unival` handling of negative values consistent [627cc406]
  + Efficiency:
    * Make `now` about 38x as fast [06658515]
    + Make `Str.wordcase` about 5x as fast [5d058ea8]
    + Make `Str.uniparse` about 10% faster [9cc65028]
    + Make the `lines` and `words` subroutines up to 20x as fast [b954ef94]
    + Make `my %h is QuantHash = ...`  about 5x as fast [ec73d6c9]
    + Make `Int.unival` and `Str.unival` faster [fb19daa7][bcfa5489][504c89a9]
    + Make `Str.ords` up to 2x as fast [74e449ec]
    + Make `List.sum` faster [18c4c5d4][8f4db8b6]
    + Make `Any.sum` about 40% faster and check for laziness [07aa4aea]
    + Make `chrs` method faster for native int arrays [f75957dd]
    + Make `uninames` method about 2x as fast [d14dda68]
    + Make `Str.univals` about 50% faster [88921320]
    + Make `Datish.daycount` calculation about 30% faster [c07639e6]
    + Make `uniprop` method about 30x as fast [c9aceda4][54c95ebe][885d6390]
    + Make `uniprops` method about 4x as fast [97b2b3f0]
    + Make `Baggy.AT-KEY` about 60% faster [74af72de]
    + Optimize various cases of iteration when `Iterator` produces no values [0bbeb2de]
    + Micro-optimization of a for loop construct [23036f1d]
    + Micro-optimization of startup [9ec3a128]
  + Fixes:
    + Fix a regression in command line arguments parser introduced
      in the 2021.03 release, where certain complex default arguments
      would throw errors when used in a pre-compiled module [10c3dbb9]
    + Fix compilation failure with `EVAL` in precompiled module's mainline [c05b23f1]
    + Make backtraces consistent on all back-ends [2e79780e][0b91b21a]
    + Fix and edge case of sub-signature handling, making `say :([]) eqv :(@);`
      properly result in `False` [41fd1d9f]
    + Make signal handler setup synchronous to avoid race conditions [2d1f4904]
    + Fix race condition in `ThreadPoolScheduler` [98839c80]
    + [JVM] Properly show name of a subset in the error message
      of `X::TypeCheck::Binding::Parameter` [b4367a8f]
    + [JVM] Fix `Bag` objects behavior regression [dc50951e]
    + [JVM] Fix a miscompilation of native arrays [e774e194]
    + Fix a potential issue on subclassing from NQP classes or consuming NQP roles [5959a21c]
    + Fix a potential issue during inlining [c0d7464a]
    + Fix `Int.uniname` to handle big negative and big positive integers [af6662a3]
    + Fix handling of holes in `raku` method for native str arrays [2d1510a9]
    + Fix resource leak when iterating files using `dir` method on `IO::Path` [62c976a4]
    + Fix an exception when `grab` was called on an empty `SetHash` that had contained entries before [e9e3b5fb]
    + Fix `DateTime` equivalence check with `eqv` relying on `raku` representation [01a0c934]
    + Fix methods `substr`, `substr-rw`, `chop`, `chomp`, `pred`, `succ`, `comb`,
     `lines`, `words`, `wordcase`, `trans`, `indent`, `uc`, `lc`, `tc`, `fc`,
     `tclc`, `flip`, `split`, `trim`, `trim-leading`, `trim-trailing`,
      `samemark`, `samespace`, `samecase`, `subst`, `subst-mutate`
      when called on a `Str` subclass
      [da34b40a][f4bfeea6][813d4f1a][a26ff404][b4813bbd][3e43a729]
      [a4a915ec][995d39c0][5ca26c2a][e2ec1607][c5057e86][1819caa1]
      [ffcda845][fd037828][9398ae68]
    + Make sure methods `comb`, `chop`, `chomp`, `substr`, `substr-rw`
      called on a `Allomorph` return Str [7a77b397][ba814fde]
    + Make sure `trim`, `trim-leading`, `trim-trailing`, `split`,
     `samecase`, `samemark`, `samespace` methods handle `Allomorph` values
      correctly [9a9a59c9][a2399ce9][7e87e20c][fb6441bc]
  + Internal:
    * Disable superseded CIs: Travis, AppVeyor and CircleCI [d272f4fd]
    + Remove two five-year-old compatibility wrappers [1e94845b]
    + Relax lots of Cool subs access checks [c993e33b]
    + Allow for experimental features in the setting [cae44e51]
    + Split history `src/core.c/Cool.pm6` to `src/core.c/unicodey.pm6`
      [0156f521][2d615fcc][4a9098ae][082800c4]
    + Re-organize Unicode related files [2d5e81b1][9f73552a][009d90b8][069c0b20]
      [9d7279d5][2251b70c][dc74f081][496f986e][b88e1ca3][f2f1cda6][dcf1c506]
      [5fd7d068][ee3fa379]
    + Introduce a new private method `!lazy` on `List` [d99bd6b8]
    + Introduce `throw-iterator-cannot-be-lazy` and `fail-iterator-cannot-be-lazy`
      internal helper methods [8e56c8c8][6e5d742e][e592277f][d3c4ff30][057620c9]
      [2cd963de][ec3c7bba][190dc553][28b2a953][3c178036][b1880263][b7b6230d]
      [db778174][fe133c2b][9d1b4821][71960b16]
    + Introduce `throw-iterator-cannot-be-empty` and `fail-iterator-cannot-be-empty`
      internal helper methods [ac9f40d8]
    + Abstract `unival` logic into separate class [504c89a9]
    + Abstract `ords` logic into `Rakudo::Unicodey` [817d1130]
    + Use a better approach to finding leap second days [5070ae3f]
    + Make `CLIENT::` work for code invoked from NQP world [73638877][a6639356][f0a36d89]
    + Re-organize `Nil` implementation code [5c6a80c2][32110eed][47a12a5e]
    + Make `Cool` methods consistently use `.Str` coercion rather than a mix
      with `Stringy` [a68d2579][8cad7d79]
    + Various internal fixes and improvements, most notably making various
      subroutines multi for the consistency
      [f0a345df][2a972b24][6d03c78b][8668474d][e191266f][b0910d5b][bc8a0997]
      [7dd80bb4][b988e763][30263075][e1c2d792][84eac183][e6823863][85e7e63d]
      [bd900c9d][df324f1b][d9fcb759][da80b57c][57ffaf96][ad81b980][1c4577ae]


The following people contributed to this release:

Elizabeth Mattijsen, Richard Hainsworth, Daniel Green, JJ Merelo,
Stefan Seifert, Vadim Belman, Christian Bartolomäus, Will "Coke" Coleda,
Stoned Elipot, Patrick Böker, Nicholas Clark, Jonathan Worthington,
Sizhe Zhao, Tom Browder, Alexander Kiryuhin, Fernando Santagata, demostanis,
Daniel Sockwell, wukgdu

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2021 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#146), is tentatively scheduled for 2021-05-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
