// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from VoltageMonitoringSensor.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class VoltageMonitoringSensor_1_0_3 : Com.Raritan.Idl.sensors.NumericSensor_4_0_8 {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.VoltageMonitoringSensor:1.0.3", Com.Raritan.Idl.sensors.NumericSensor_4_0_8.typeInfo);

    public VoltageMonitoringSensor_1_0_3(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public VoltageMonitoringSensor_1_0_3(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new VoltageMonitoringSensor_1_0_3 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new VoltageMonitoringSensor_1_0_3(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum EventType {
      DIP,
      SWELL,
      UNKNOWN,
    }

    public class DipSwellThresholds : ICloneable {
      public object Clone() {
        DipSwellThresholds copy = new DipSwellThresholds();
        copy.dipActive = this.dipActive;
        copy.dipThreshold = this.dipThreshold;
        copy.swellActive = this.swellActive;
        copy.swellThreshold = this.swellThreshold;
        copy.deassertionHysteresis = this.deassertionHysteresis;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["dipActive"] = this.dipActive;
        json["dipThreshold"] = this.dipThreshold;
        json["swellActive"] = this.swellActive;
        json["swellThreshold"] = this.swellThreshold;
        json["deassertionHysteresis"] = this.deassertionHysteresis;
        return json;
      }

      public static DipSwellThresholds Decode(LightJson.JsonObject json, Agent agent) {
        DipSwellThresholds inst = new DipSwellThresholds();
        inst.dipActive = (bool)json["dipActive"];
        inst.dipThreshold = (double)json["dipThreshold"];
        inst.swellActive = (bool)json["swellActive"];
        inst.swellThreshold = (double)json["swellThreshold"];
        inst.deassertionHysteresis = (float)json["deassertionHysteresis"];
        return inst;
      }

      public bool dipActive = false;
      public double dipThreshold = 0.0;
      public bool swellActive = false;
      public double swellThreshold = 0.0;
      public float deassertionHysteresis = 0.0f;
    }

    public class Event : ICloneable {
      public object Clone() {
        Event copy = new Event();
        copy.type = this.type;
        copy.timestamp = this.timestamp;
        copy.duration = this.duration;
        copy.voltage = this.voltage;
        copy.waveform = this.waveform;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["type"] = (int)this.type;
        json["timestamp"] = (this.timestamp.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
        json["duration"] = this.duration;
        json["voltage"] = this.voltage;
        json["waveform"] = this.waveform.Encode();
        return json;
      }

      public static Event Decode(LightJson.JsonObject json, Agent agent) {
        Event inst = new Event();
        inst.type = (Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.EventType)(int)json["type"];
        inst.timestamp = new System.DateTime(json["timestamp"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
        inst.duration = (int)json["duration"];
        inst.voltage = (double)json["voltage"];
        inst.waveform = Com.Raritan.Idl.pdumodel.Waveform.Decode(json["waveform"], agent);
        return inst;
      }

      public Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.EventType type = Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.EventType.DIP;
      public System.DateTime timestamp = new System.DateTime(0);
      public int duration = 0;
      public double voltage = 0.0;
      public Com.Raritan.Idl.pdumodel.Waveform waveform = new Com.Raritan.Idl.pdumodel.Waveform();
    }

    public class EventOccurredEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.VoltageMonitoringSensor_1_0_3.EventOccurredEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.Event _event = new Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.Event();
    }

    public class EventListClearedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.VoltageMonitoringSensor_1_0_3.EventListClearedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

    }

    public class DipSwellThresholdsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholdsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds oldThresholds = new Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds();
      public Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds newThresholds = new Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds();
    }

    public class GetRecentEventsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.Event> _ret_;
    }

    public GetRecentEventsResult getRecentEvents() {
      JsonObject _parameters = null;
      var _result = RpcCall("getRecentEvents", _parameters);
      var _ret = new GetRecentEventsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.Event>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.Event.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getRecentEvents(AsyncRpcResponse<GetRecentEventsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getRecentEvents(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getRecentEvents(AsyncRpcResponse<GetRecentEventsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getRecentEvents", _parameters,
        _result => {
          try {
            var _ret = new GetRecentEventsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.Event>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.Event.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class ClearRecentEventsResult {
    }

    public ClearRecentEventsResult clearRecentEvents() {
      JsonObject _parameters = null;
      var _result = RpcCall("clearRecentEvents", _parameters);
      var _ret = new ClearRecentEventsResult();
      return _ret;
    }

    public AsyncRequest clearRecentEvents(AsyncRpcResponse<ClearRecentEventsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return clearRecentEvents(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest clearRecentEvents(AsyncRpcResponse<ClearRecentEventsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("clearRecentEvents", _parameters,
        _result => {
          try {
            var _ret = new ClearRecentEventsResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDipSwellThresholdsResult {
      public Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds _ret_;
    }

    public GetDipSwellThresholdsResult getDipSwellThresholds() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDipSwellThresholds", _parameters);
      var _ret = new GetDipSwellThresholdsResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getDipSwellThresholds(AsyncRpcResponse<GetDipSwellThresholdsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDipSwellThresholds(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDipSwellThresholds(AsyncRpcResponse<GetDipSwellThresholdsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDipSwellThresholds", _parameters,
        _result => {
          try {
            var _ret = new GetDipSwellThresholdsResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetDipSwellThresholdsResult {
      public int _ret_;
    }

    public SetDipSwellThresholdsResult setDipSwellThresholds(Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds thresholds) {
      var _parameters = new LightJson.JsonObject();
      _parameters["thresholds"] = thresholds.Encode();

      var _result = RpcCall("setDipSwellThresholds", _parameters);
      var _ret = new SetDipSwellThresholdsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setDipSwellThresholds(Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds thresholds, AsyncRpcResponse<SetDipSwellThresholdsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setDipSwellThresholds(thresholds, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setDipSwellThresholds(Com.Raritan.Idl.pdumodel.VoltageMonitoringSensor_1_0_3.DipSwellThresholds thresholds, AsyncRpcResponse<SetDipSwellThresholdsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["thresholds"] = thresholds.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setDipSwellThresholds", _parameters,
        _result => {
          try {
            var _ret = new SetDipSwellThresholdsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
