/*
*  Rubrica
*  file: form.h
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef _RUBRICA_FORM_CONTACT_H
#define _RUBRICA_FORM_CONTACT_H

#include <glib.h>
#include <glib-object.h>
#include <glade/glade.h>

#include "app.h"
#include "form.h"


#define RUBRICA_FORM_CONTACT_TYPE           (rubrica_form_contact_get_type())

#define RUBRICA_FORM_CONTACT(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),\
                                             RUBRICA_FORM_CONTACT_TYPE,       \
                                             RubricaFormContact))

#define RUBRICA_FORM_CONTACT_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass), \
                                             RUBRICA_FORM_CONTACT_TYPE,       \
                                             RubricaFormContactClass))

#define IS_RUBRICA_FORM_CONTACT(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),\
                                             RUBRICA_FORM_CONTACT_TYPE))

#define IS_RUBRICA_FORM_CONTACT_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),   \
                                             RUBRICA_FORM_CONTACT_TYPE))

#define RUBRICA_FORM_CONTACT_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls), \
                                             RUBRICA_FORM_CONTACT_TYPE,       \
                                             RubricaFormContactClass))



typedef struct _RubricaFormContact        RubricaFormContact; 
typedef struct _RubricaFormContactClass   RubricaFormContactClass;
typedef struct _RubricaFormContactPrivate RubricaFormContactPrivate;



struct _RubricaFormContact {
  RubricaForm parent;
   
  RubricaFormContactPrivate* priv;  
};



struct _RubricaFormContactClass {
   RubricaFormClass parent;
};



GType               rubrica_form_contact_get_type (void);


RubricaFormContact* rubrica_form_contact_new  (RubricaApp* app, GladeXML *gui);
void                rubrica_form_contact_free (RubricaFormContact* form);

#endif



