---
title: 2021 Tutorial
---

This tutorial showcases traffic light layout, indirect left turn, TAZ, OD-traffic, GTFS, and more!

# Files

- [sumo2021_tutorial.zip](https://sumo.dlr.de/daily/sumo2021_tutorial.zip)

# Video
<a class="no-arrow-link" data-youtube href="https://www.youtube.com/watch?v=tlshWdzFWpY">Watch the 2021 Tutorial</a>


# Transcription

## Intro
So again, welcome from me to the SUMO User Conference and to the SUMO tutorial, which has been a tradition since 2015. So the conference are since 2013, and you can get the tutorial files already, I'll show the link in a second, and then you will notice that the tutorials have grown in size over the years. So what are we going to talk about today? We will briefly go over the prerequisites for doing this tutorial, which are sadly a bit more complicated than the last year. Then we'll go over a topic which is mainly for the beginners, namely how to get a scenario quickly with the Web Wizard tool and how to edit networks. And then we'll shift over to more advanced topics, let's say advanced features of network editing and then some exciting new content, how to graphically define traffic with the help of origin, destination, towns and districts. And we'll wrap up with talking about the import of public transport schedules in the GTFS format, which we've been promising for, I think, the last 10 years, and finally it's in the tutorial.

To follow the tutorial, in the sense of running all the simulations that are included, it is enough if you have the latest release version 1.10.0, but if you also wish to follow all the latest features that are shown in netedit, then you should download the latest development version, and than really make sure to get the very latest development version, because the one from let's say yesterday still had some issues that had to be ironed out today. Also if you have SUMO installed you probably have Python installed as well - if not, you will need this for some part of the tutorial.
You will probably need a, if you really follow the tutorial along, you will need a text editor and of course the download files. They are already on the download page in the in the wiki. Let's see if I can share this. In the documentation you'll find the tutorial page in there. The link is already added. All right, so let's start really with the content and since we are a bit low on time it's probably better if you follow the tutorial later and now just listen to and watch the things that are being shown.

## osmWebWizard
All right so the first tool I want to present is the OSM Web Wizard. It downloads network data and some traffic related data from the great open repository of mapping data that is OpenStreetMap. And if you have SUMO installed then you already have an OSM Web Wizard link in your start menu (assuming you do this on Windows). And there you have several controls that allow you to generate a scenario. You can select an area and of course well for that you can select a region of the world. Let's say anywhere you want to go. Let's say you want to go to Paris. Then you select the traffic elements that you would like to see in the scenario. You can select whether you want public transport or whether it's a region for left-hand traffic and finally select the area. And then the simulation will be generated. And that means the data from OpenStreetMap is downloaded to your computer and then all kinds of processes run in the background to generate the scenario for you. And boom the simulation pops up on your screen with plenty of things that we'll go over in the next slides.
All right. As I said files are downloaded and files are generated. So let's first take a look at the simulation, the scenario that was built as part of the tutorial. If you've downloaded the files it's in the `tutorial/01_wizard` folder. And just as a simulation pops up when you click this in the wizard you can start this by clicking the `sumoconfig`.
And then you start your simulation with this big play button. And then all you see is a timer running but you have to squint your eyes and look really careful to see the cars moving. Probably won't be even seeing that here over the connection. But if you zoom in then you can see that there's traffic running in the network with a certain delay that is pre-configured - you can slow it down and speed it up with the delay slider up here.
And this is your simulation. We'll look at that more closely but first let's go briefly over all the stuff that has been put on your hard drive when you generate the scenario. So the most important thing is the `sumoconfig` file. It ties together all the different components that make up the simulation. Namely the traffic network, customarily named with a ending `.net.xml`, and then all kinds of traffic definition files for the passenger cars, for the pedestrians, public transport. Then there's a file for infrastructure, the stops, some files to make the simulation more appealing, background polygons of buildings and land use, and finally some settings on how to present the simulation. And then there are some files that aren't really necessary for running the simulation but which are important for rebuilding scenarios with different settings. 
This is the raw osm data and then all kinds of configuration and batch files that we'll probably talk about as well in the next slides.
All right. So let's look at the simulation again. And when we run this what we do see in the bottom screen that there are some warnings scrolling along here. And we may want to find out really quickly what's going on here. And one way to look at this scenario is to change some of the settings of the visualization.
So I'm zooming out to the whole scenario again with this button and then I'm launching the configuration for the graphical settings. And the first thing I want to see is all the cars. So I'll just increase their drawing size a little bit. Now you see all the little yellow cars. Let's make the color a bit more informative. We could color them by their waiting time. So now we see that some of the cars are shaded in a different hue which means that they are waiting which might be a sign of problems with traffic.
But they tend to go back to the blue color after a little while. So maybe that isn't too bad. Instead, let's color them by the accumulated waiting time. So this counts over the last 100 simulated seconds how much of that time was spent waiting rather than how many cars are actually waiting all the time. So here we have a huge red area which means there is a jam here. And if we zoom in (this is a done by holding the right mouse button and moving the mouse up and down), we see that there's a big jam at this intersection and now the question is why? What's happening here? We see that this looks a bit strange. There are those red bars that signify traffic lights and they're somehow in the middle of the intersection. All this looks bad. So I guess this will be our first area of fixing problems with the network with the help of the graphical network editor netedit. Those that have been following the tutorial from last year, they may recall that we had the very same area and that we didn't have this problem with our initial import. So what are the differences compared to last year? Well of course the data of OpenStreetMap has been updated. And in this year, I didn't talk about it yet, but what I did add is more bike traffic. And actually by adding bike traffic additional bicycle lanes are imported from OpenStreetMap. So these are all changes and it turns out that yes indeed adding those lanes changes some of the network geometry and then some of the functionality that processes the network works differently.
And suddenly one part fails here and it doesn't build a nice junction. So we will fix this and just be aware, this is always something that can happen to you if you import data from OpenStreetMap. All right so let's fix this.

## Network Editing - Join Junctions
You can launch netedit from the menu here. I'll just use the shortcut <kbd>Ctrl</kbd> + <kbd>T</kbd>. And I'll get the network view at the point where I saw it in the simulation. And so the concept here is that we have a complex intersection that is modeled in the OpenStreetMap database with lots of elements that are joined together. Whereas our simulation would prefer it if that was one intersection only. So we'll switch the editing mode of netedit to the selection mode and just click on all these red dots that make up this complex cluster of intersections. And then we'll use hotkey <kbd>F7</kbd> to join this.
And now if we want to see the actual geometry of the junction we can press <kbd>F5</kbd> to see that this has been now joined in one area. And when we save this network, we've already fixed the problem. However we cannot use this fixed network directly for our simulation, because in the traffic that was generated the cars were using some of the network elements that were inside this complex cluster. So these roads are now gone. So in order to really make the simulation run we have to call a little script that is part of what the web wizard built.
A little traffic generation script. And if we run this by double clicking, it calls all the tools that built the traffic again. So that it matches the network. And you can find those results already in this `02_netedit` folder. And then the simulation looks quite different. So here is the the corrected junction (or intersection). And as you can see with the same coloring mode as before by accumulated waiting time it works fine now in this area. So let's put the significance of this single fix in numbers.

You can run the simulation with some options that generate these statistics. And you will find that the time that the cars spend waiting has shrunk significantly. So before, the duration of the average duration of a vehicle in the simulation more than half the time was was lost. Time lost due to standing or driving very slowly almost half the time was spent really standing. And now the duration has shrunk and the cars don't spend nearly as much time waiting. And I'd say for city traffic where you do have traffic lights, this is a very plausible time spent waiting. So yes, that looks good. All right. So it will often be the case that the kind of problems that you get when importing networks from OpenStreetMap lead to decreased efficiency of traffic. So it's a good heuristic to look for jamming, and see if they may be due to a problem with the network themselves. Okay.

## Network Editing - Change traffic light layout
Then let's look at a different kind of fix that we can do because not all fixes have to improve the performance. Let's talk about traffic lights. So as you may know traffic light plans are not part of the OpenStreetMap database. Instead for our purpose we have tools that generate plausible signal plans, to make the simulation run, because without the plan you can't even run the simulation. So again, looking at this intersection we already had before in netedit we can switch to the traffic light mode by either using this menu or pressing the letter <kbd>T</kbd> which is also documented. So just learn those mnemonics and you will be much faster. And then we can click on the intersection and we'll see the traffic light plan here. We can go through the different phases of the traffic light and what we do see is that there are phases where both those ... well I can't really call them north to south, this direction if you can follow the mouse has green at the same time and then there's a phase for the left turning movements and then actually the trams get their own phase and then we have the orthogonal direction again with the left turn phase.
Now as this is an area actually near the German Aerospace Center, it's an intersection that I know quite well and I know that this is not actually the correct signal plan layout. It looks different in reality and we can fix this, again, by changing some properties of this intersection, so I'll leave the traffic light mode and instead go to inspect mode pressing the letter <kbd>I</kbd> and then I can see some properties for this intersection and I see the layout of the traffic light is set to the value of opposites which means that opposite sides get the green light at the same time, that's the idea, and now we can switch it to the layout incoming. Which means that each incoming arm of the traffic light gets their own phase. So let's go back to the traffic light mode and see how the signal plan looks now. As I said every arm gets their own green phase and that's actually how it works in real life at this intersection.
In some countries this is the default layout and you actually can set an option in the netconvert program to get all your layouts in this format, if that is more typical for your area. You will find all these options explained of course in the documentation for traffic lights and their default programs. So let's look at this in the simulation and let's look at it run. We have this here. And let's see how the phases switch. I'll slow this down a bit. Now let's add some simulation delay and see how it runs. And you can see each side gets their green phase. And if we do some measurements on what this does to the traffic performance we actually see that the the travel times increase. Which just goes to show that not every fix will make the traffic flow better. Which is, I guess, what you should expect. And how would you get those statistics that I showed on the previous slide? One thing you can do is you can open up a command line window and run the simulation in batch mode so you don't start the graphics application "sumo-gui" instead you just start the "sumo" application and then it will output all those measures here and you can find those statistics as human readable time values, of course there are options to get this in form of xml output for you to process with other tools, but if you just want to look at those statistics, the console output is often quite useful.

## Network Editing - Indirect Bicycle Turns
All right let's do more fixes to the network, we're now going to the more advanced topic or rather more advanced *and novel* because I want to show you a new feature that was added especially for bicycle simulation and this is indirect bicycle turns. Let's look at this in the network. We'll leave the traffic light mode and we'll go to some other intersection and in the default view you won't actually see the vehicle connections, but you can activate them with this button, actually there's even a shortcut for that that would be <kbd>Alt</kbd> + <kbd>5</kbd>, and now you have all those interesting lines going over the intersection and what you can see here that there are some bicycle turns that move over the intersection in a single arc and especially for big and complex intersections this is not what traffic planners usually want because it is dangerous, I suppose cyclists wouldn't want this either, and so what bicycles often do in real life, is perform an indirect turning maneuver, which means they first move straight across, which has the advantage of not crossing so many lines of traffic, and then they wait at the corner to do a straight cross again. If you want this in your simulation, activate this little checkbox here `indirect`, and if you now rebuild all the geometry with the <kbd>F5</kbd> button or the recompute thing, you can see that we now have, we have a different shape of the connection. And actually there is a small waiting spot. You may be able to see, the faint line here. There's a waiting spot where the bicycles wait for the traffic light to switch to the appropriate phase. So let's look at this in the simulation.

And you already see those. Well, actually you can see them here. The bicycles are waiting and then they're moving across once the light switches. If you want to inspect that traffic light or rather make it more visible, you can also change the visualization settings again with this button here and disable drawing of the intersection shape. And what you will see is that there are even little traffic lights that indicate the state for the cyclists that are doing their indirect turn. So new features for traffic lights. And what you could actually do is instead of clicking those connections one by one, you could use the advanced selection and filtering mechanisms of netedit to effect this change for many bicycle connections. And since there's a selection mode is such a useful thing, I want to show you some of those details.
So, the first thing we may want to do is consider a specific area. So it would be nice if we could select all the connections in a specific area. When you hold the <kbd>Shift</kbd> key in the selection mode, by the letter <kbd>S</kbd>, you can do a rectangle selection, but then you get all the objects in the selection. So hit <kbd>Esc</kbd> to go back on that selection. And instead, you can lock all the elements and then just unlock the connections. So this is one of the new features for doing selection filtering. Let's, and since I'm done with that now, I'll go back and unlock all elements. So, we can see now 1000 connections have been selected, but maybe those are all kinds of connections for pedestrians or car.
Let's just look for the bicycle connection. So what we do is we refine our selection by selecting the allow attribute. And what we want to do is we don't want to add, we just want to keep all the connections that match those attributes. So, I'm typing this out here. So we want to filter the selection to all the connections that allow bicycles. Actually, exactly bicycles. So, now there are much fewer connections, as you can see here. And there are all those that, start or end in those bicycle lanes. But we're not done yet, because we also have some straight connections in our mix. So let's filter this some more. Filter this by the direction of the connection.
That would be, straight. And we have even fewer connections. And now, actually, that was just the wrong thing. We want to filter for the turns, the left turns. So I'll go back on my selection, change the letter here. And now I have the turns. And what I can do is I can go back to inspect mode, click on one of those selected objects. It tells me I have actually 22 things in my inspection, and I can make them all indirect. And, well, actually this, yes, this did the job. All right. So this is what I wanted to show you. Selection mode has very powerful tools for working with selections. And it allows you to, edit the attributes of many elements. Okay. And we already saw that simulation. Okay. Now let's move over to the next, section of the tutorial. After the network editing, we have to deal with the traffic.

## Traffic
The original scenario that was created by the web wizard tool, has mostly random traffic. That's because there's no, no good source of traffic data that would be workable for the whole world. So we could just integrate it with the wizard. So we use random traffic to be able to build something for everyone. So the cars, they have random origins and destinations, and then they just use the fastest route, according to the current traffic conditions. The public transport for that, we actually have some data in OSM because it contains the route, which is the list of network elements that are being driven along with the stops. And maybe even the timing interval between successive, buses or trends of the same line, but we don't have the time. So the public transport in the scenarios is synthetic, in that it uses all the data from OpenStreetMap, and then it guesses the starting time for a particular line, and then derives all the other timings from a little background simulation. So it's a plausible way to get a transport schedule in the simulation, but it's definitely not the correct schedule. And then the persons, again, they have random origins and destinations, but they use the "fastest" intermodal route, which means they could either walk or they can use a succession of walks and rides with public transport.
Now, last year, we talked about using traffic, local traffic counts, to redefine our traffic scenario. If you're interested in that, I recommend that you look at last year's tutorial, but this year we're going to do it differently. We'll use an OD matrix. So that's short for origin destination matrix, which is based on a definition of areas in our simulation. And then we define traffic that goes from one area to the other with some kind of process, which says, well, actually, if you want to start on this area, then I'll pick a starting edge in that area for you. So it's a two-step process, but those metrics are powerful because they can be used with existing area definitions, and they're often available because, maybe not often, but they are available because other people collect that kind of data.
So this is what we were going to do for the car traffic, and then we'll replace the synthetic public transport schedules with the actual GTFS data, the general transit feed specification, which is available for many locations, but not all cities of the world. So the OD traffic.

## Traffic from OD-Matrix
There is a tool, part of the SUMO toolbox called **od2trips**, which uses a definition of traffic zones, along with a metrics definition, which says how many trips go from each zone to each other zone. And so the first thing we need to do is define some zones. Now, you could do this manually in netedit, in the TAZ edit mode, TAZ stands for traffic analysis zone, traffic assignment zone, and you could actually just draw such a zone and do this for many zones. But this is often not what you want to do. Either you can load those zones from some data set you have. Or maybe you just want to do this in a more abstract way. What we're going to use is we're going to generate a grid of zones. And there's a tool, part of SUMO, that's called **gridDistricts.py**, and we run it with those parameters. A network, an output file will specify the width of the grid cells, and we say it shall be a grid for passenger cars. You can also run this with the batch file in the `04_odtraffic` folder. And when we do this, we get a file that looks like this. It's just a bunch of XML lines with shapes and lists of network elements, namely edges, that make up those zones. But let's look at that in sumo-gui. And what we see here are the rectangles of the zones. They have been assigned random colors by the tool. And then the edges are colored according to the zone color, so to see them more nicely. And you see for those settings, only the edges that permit passenger cars are actually part of the zone definition. So those are our zones.
And now we want to define traffic between those zones. All right. So what we do is we load the network. I'll just reload this again. And then let's load the zones. So you can do this with the additional elements. And then it's the file we just generated, the grid. And here are our zones. Now what we want to do next is, we want to define the OD matrix. And for this, we use the data mode of netedit, which is used to edit and visualize network-related data. Last year, we looked at the counts on edges and turns. But we can also define counts or relations between those traffic assignment zones. So let's go to the data mode - that would be the <kbd>F4</kbd> key. And then we go to the TAZ mode. And the first thing we have to do is define a new dataSet. Let's call this "test", and we have to define for what time interval that data is relevant. So let's just use the default of one hour. And now we can, define relations between those zones. Now, it may be more useful if we can click anywhere instead of just on those thin lines. So there's another button for that. And now we can define our traffic relations. Let's say we have a relation from here to there. Now this is modeled via attributes, via the count attributes. So I'll just set this attribute here. I'll type it out. You could also edit it with a little dialogue. And now let's create a relation between those two zones. Confirm with the <kbd>Enter</kbd> key, and now actually there's going to be a button that you can click instead of remembering it's the <kbd>Enter</kbd> key. But that mode is pretty fresh, we did lots of features last week. And so just check back in another week or so. But you can see the line here, which defines the relation.

We can also inspect this. And go back on the attributes. And if you do this for all the relations that you want to define, then you can save that and get a file like this. Let's see where we have it. It's actually a pretty simple format. You could also generate that with some process. So it's a relation between those two zones, with a count value of 1000, for a specific interval. And that's that. All right. So now, as I said before, we can use the od2trips tool to combine that zone definition with the counts. There's a batch file for that. And then there's just a small hitch, because that tool doesn't know anything about connectivity in the network. So you could have gotten a trip that ends, let's say on this edge here. And as you can see, this edge has no predecessor. So you cannot reach that edge from anywhere. So some of those trips aren't actually valid. And to filter those out, we can run the duarouter application, which just throws out all these erroneous trips and gives you the valid trips only. Which, unfortunately reduced the number from 1000 to 964. So you may have to compensate, but then you have, OD traffic. And let's look at this in the simulation.
As you can see, the traffic all originated in one zone. And then it moves to another zone. So. This isn't a very realistic traffic definition. That's far too much traffic for that little area. But it shows you that the origin of the traffic is spread out, just not a single edge, which you could define with a flow definition, rather, it's traffic from one area to another area. And then you see it moving through the network. Of course, we kept the public transport, which is still going around here. So that's that. That's traffic from origin-destination matrices. Now to the last part of the tutorial. There are still two minutes left.

## GTFS-Import
Let's talk about the general transit specification. That's a plain text format, original introduced by Google. And now many, many, providers of public transport data are actually publishing their data. A good website for that is [https://mobilitydatabase.org/](https://mobilitydatabase.org/), and you can just select an area or city and get your GTFS file typically named "GTFS.zip". And SUMO now brings a tool that can import this data (gtfs2pt.py tool), you give it the network and the GTFS file, and a date and output file, and off you go. I've put all this together in an osm batch file `05_gtfs/gtfs_osm.bat` always be careful if you want to copy those commands out of slides, sometimes the dashes get broken by your presentation tools or by Word or PowerPoint, or whatever, so if in doubt, type all those commands, sometimes you will have funny problems because it's a typographic dash instead of a real dash. So that's what that script does is it generates infrastructure, where are the stops, and it generates the individual vehicles that make up the public transport, each with their real schedule.
And if you want the persons to actually use that public transport, then of course you have to tie that in when generating the persons. So, we had this batch script before that generates all kinds of traffic. And now if we're talking about the GTFS thing, we have to modify that batch script, at least for the persons, to make sure that it uses all those files that were just generated from the GTFS. So just be aware of that. Of course, there's a GTFS tutorial in the documentation, where you can look all that up. So, let's look at a simulation with that GTFS traffic. Well, actually no, because the time is up. So let's save some time.

## GTFS-Import - Intermodal Journeys
What we can do is we can look at the types of plans that are generated when the persons use that public transport. For that, we have the script analyzePersonPlans.py in the SUMO tools. And it will tell you that for the original OSM Web Wizard scenario, we have about, well, we have certain amount of walks, and then we have lots of trips that alternate between walking and public transport. Now, if we do the GTFS import, suddenly the number of walks goes up. And why is that? Well, the first thing that we have to recognize is that now suddenly times are important. Usually, we first generated our traffic from second zero to second 3600. This is shortly after midnight. And so there is not much public transport at that time of the day. So if you generate your persons, make sure they actually walk at a time that is more realistic. And then you'll have more walks. And the other thing you have to account for is that dates are important. So if you use the GTFS import tool, you have to set a reference date. And in the scenario in the very scenario that I showed, there's no tram service due to construction work at the moment. So when we naively use the current date, many persons that would have used the tram couldn't actually do this. So if you also set the appropriate date, then finally you reduce the number of walks again. If it's still more walks than in the WebWizard case, that may is very likely due to the synthetic schedules, there is a bunching of buses or trams, so there's too much service, and people use the tram too much. So look at the time, look at the date and then enjoy your GTFS schedules. This is all I wanted to show you today. If you have any questions, ask them on the mailing list, look at the documentation and report any bugs that you can find. Thank you very much.
