from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       






class QGL(_Mock):
  pass
  AccumBuffer = 16
  AlphaChannel = 8
  ColorIndex = 262144
  DeprecatedFunctions = 1024
  DepthBuffer = 2
  DirectRendering = 128
  DoubleBuffer = 1
  HasOverlay = 256
  IndirectRendering = 8388608
  NoAccumBuffer = 1048576
  NoAlphaChannel = 524288
  NoDeprecatedFunctions = 67108864
  NoDepthBuffer = 131072
  NoOverlay = 16777216
  NoSampleBuffers = 33554432
  NoStencilBuffer = 2097152
  NoStereoBuffers = 4194304
  Rgba = 4
  SampleBuffers = 512
  SingleBuffer = 65536
  StencilBuffer = 32
  StereoBuffers = 64

class QGLBuffer(_Mock):
  pass
  DynamicCopy = 35050
  DynamicDraw = 35048
  DynamicRead = 35049
  IndexBuffer = 34963
  PixelPackBuffer = 35051
  PixelUnpackBuffer = 35052
  ReadOnly = 35000
  ReadWrite = 35002
  StaticCopy = 35046
  StaticDraw = 35044
  StaticRead = 35045
  StreamCopy = 35042
  StreamDraw = 35040
  StreamRead = 35041
  VertexBuffer = 34962
  WriteOnly = 35001

class QGLColormap(_Mock):
  pass


class QGLContext(_Mock):
  pass
  DefaultBindOption = 11
  InvertedYBindOption = 1
  LinearFilteringBindOption = 8
  MipmapBindOption = 2
  NoBindOption = 0
  PremultipliedAlphaBindOption = 4

class QGLFormat(_Mock):
  pass
  CompatibilityProfile = 2
  CoreProfile = 1
  NoProfile = 0
  OpenGL_ES_CommonLite_Version_1_0 = 256
  OpenGL_ES_CommonLite_Version_1_1 = 1024
  OpenGL_ES_Common_Version_1_0 = 128
  OpenGL_ES_Common_Version_1_1 = 512
  OpenGL_ES_Version_2_0 = 2048
  OpenGL_Version_1_1 = 1
  OpenGL_Version_1_2 = 2
  OpenGL_Version_1_3 = 4
  OpenGL_Version_1_4 = 8
  OpenGL_Version_1_5 = 16
  OpenGL_Version_2_0 = 32
  OpenGL_Version_2_1 = 64
  OpenGL_Version_3_0 = 4096
  OpenGL_Version_3_1 = 8192
  OpenGL_Version_3_2 = 16384
  OpenGL_Version_3_3 = 32768
  OpenGL_Version_4_0 = 65536
  OpenGL_Version_None = 0

class QGLFramebufferObject(_Mock):
  pass
  CombinedDepthStencil = 1
  Depth = 2
  NoAttachment = 0
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QGLFramebufferObjectFormat(_Mock):
  pass


class QGLPixelBuffer(_Mock):
  pass
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QGLShader(_Mock):
  pass
  Fragment = 2
  Geometry = 4
  Vertex = 1

class QGLShaderProgram(_Mock):
  pass


class QGLWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

