[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctools::cvs n 1]
[see_also {[uri}]
[see_also http://wiki.tcl.tk/log2changelog]
[keywords changelog]
[keywords cvs]
[keywords {cvs log}]
[keywords emacs]
[keywords log]
[copyright {2003-2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Processing text in 'cvs log' format}]
[category  {Documentation tools}]
[require Tcl 8.2]
[require textutil]
[require doctools::cvs [opt 1]]
[description]

This package provides Tcl commands for the processing and reformatting
text in the format generated by the [syscmd {cvs log}] command.

[para]

The commands [cmd ::doctools::cvs::scanLog]
and [cmd ::doctools::cvs::toChangeLog] are derived from code found on
the [uri http://wiki.tcl.tk {Tcl'ers Wiki}]. See the references at the
end of the page.

[section API]

[list_begin definitions]

[call [cmd ::doctools::cvs::scanLog] [arg text] [arg evar] [arg cvar] [arg fvar]]

The command takes the [arg text] and parses it under the assumption
that it contains a CVS log as generated by [syscmd {cvs log}]. The
resulting information is stored in the variables whose names were
specified via [arg evar], [arg cvar], and [arg fvar].

[para]

Already existing information in the referenced variables is preserved,
allowing the caller to merge data from multiple logs into one
database.

[list_begin arguments]
[arg_def varname evar in]

Has to refer to a scalar variable. After the call this variable will
contain a list of all the entries found in the log file. An entry is
identified through the combination of date and author, and can be
split over multiple physical entries, one per touched file.

[para]

It should be noted that the entries are listed in the same order as
they were found in the [arg text]. This is not necessarily sorted by
date or author.

[para]

Each item in the list is a list containing two elements, the date of
the entry, and its author, in this order. The date is formatted as
[var year]/[var month]/[var day].

[arg_def varname cvar in]

Has to refer to an array variable. Keys are strings containing the
date and author of log entries, in this order, separated by a comma.

[para]

The values are lists of comments made for the entry.

[arg_def varname fvar in]

Has to refer to an array variable. Keys are strings containing
date, author of a log entry, and a comment for that entry, in this
order, separated by commas.

[para]

The values are lists of the files the entry is touching.

[list_end]
[para]

[call [cmd ::doctools::cvs::toChangeLog] [arg evar] [arg cvar] [arg fvar]]

The three arguments for this command are the same as the last three
arguments of the command [cmd ::doctools::cvs::scanLog]. This command
however expects them to be filled with information about one or more
logs. It takes this information and converts it into a text in the
format of a ChangeLog as accepted and generated by [syscmd emacs]. The
constructed text is returned as the result of the command.

[list_end]

[vset CATEGORY doctools]
[include ../common-text/feedback.inc]
[manpage_end]
