; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; PR1940

define i1 @zext_zext_sgt(i8 %x, i8 %y) {
; CHECK-LABEL: @zext_zext_sgt(
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = zext i8 %x to i32
  %b = zext i8 %y to i32
  %c = icmp sgt i32 %a, %b
  ret i1 %c
}

define <2 x i1> @zext_zext_ugt(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @zext_zext_ugt(
; CHECK-NEXT:    [[C:%.*]] = icmp ugt <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %a = zext <2 x i8> %x to <2 x i32>
  %b = zext <2 x i8> %y to <2 x i32>
  %c = icmp ugt <2 x i32> %a, %b
  ret <2 x i1> %c
}

define i1 @zext_zext_eq(i8 %x, i8 %y) {
; CHECK-LABEL: @zext_zext_eq(
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = zext i8 %x to i32
  %b = zext i8 %y to i32
  %c = icmp eq i32 %a, %b
  ret i1 %c
}

define i1 @zext_zext_sle_op0_narrow(i8 %x, i16 %y) {
; CHECK-LABEL: @zext_zext_sle_op0_narrow(
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[X:%.*]] to i16
; CHECK-NEXT:    [[C:%.*]] = icmp ule i16 [[TMP1]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = zext i8 %x to i32
  %b = zext i16 %y to i32
  %c = icmp sle i32 %a, %b
  ret i1 %c
}

define i1 @zext_zext_ule_op0_wide(i9 %x, i8 %y) {
; CHECK-LABEL: @zext_zext_ule_op0_wide(
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[Y:%.*]] to i9
; CHECK-NEXT:    [[C:%.*]] = icmp uge i9 [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = zext i9 %x to i32
  %b = zext i8 %y to i32
  %c = icmp ule i32 %a, %b
  ret i1 %c
}

define i1 @sext_sext_slt(i8 %x, i8 %y) {
; CHECK-LABEL: @sext_sext_slt(
; CHECK-NEXT:    [[C:%.*]] = icmp slt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i8 %x to i32
  %b = sext i8 %y to i32
  %c = icmp slt i32 %a, %b
  ret i1 %c
}

define i1 @sext_sext_ult(i8 %x, i8 %y) {
; CHECK-LABEL: @sext_sext_ult(
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i8 %x to i32
  %b = sext i8 %y to i32
  %c = icmp ult i32 %a, %b
  ret i1 %c
}

define i1 @sext_sext_ne(i8 %x, i8 %y) {
; CHECK-LABEL: @sext_sext_ne(
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i8 %x to i32
  %b = sext i8 %y to i32
  %c = icmp ne i32 %a, %b
  ret i1 %c
}

define i1 @sext_sext_sge_op0_narrow(i5 %x, i8 %y) {
; CHECK-LABEL: @sext_sext_sge_op0_narrow(
; CHECK-NEXT:    [[TMP1:%.*]] = sext i5 [[X:%.*]] to i8
; CHECK-NEXT:    [[C:%.*]] = icmp sge i8 [[TMP1]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i5 %x to i32
  %b = sext i8 %y to i32
  %c = icmp sge i32 %a, %b
  ret i1 %c
}

define <2 x i1> @sext_sext_uge_op0_wide(<2 x i16> %x, <2 x i8> %y) {
; CHECK-LABEL: @sext_sext_uge_op0_wide(
; CHECK-NEXT:    [[TMP1:%.*]] = sext <2 x i8> [[Y:%.*]] to <2 x i16>
; CHECK-NEXT:    [[C:%.*]] = icmp ule <2 x i16> [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %a = sext <2 x i16> %x to <2 x i32>
  %b = sext <2 x i8> %y to <2 x i32>
  %c = icmp uge <2 x i32> %a, %b
  ret <2 x i1> %c
}

define i1 @zext_sext_sgt(i8 %x, i8 %y) {
; CHECK-LABEL: @zext_sext_sgt(
; CHECK-NEXT:    [[A:%.*]] = zext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = sext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = zext i8 %x to i32
  %b = sext i8 %y to i32
  %c = icmp sgt i32 %a, %b
  ret i1 %c
}

define i1 @zext_sext_ugt(i8 %x, i8 %y) {
; CHECK-LABEL: @zext_sext_ugt(
; CHECK-NEXT:    [[A:%.*]] = zext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = sext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = zext i8 %x to i32
  %b = sext i8 %y to i32
  %c = icmp ugt i32 %a, %b
  ret i1 %c
}

define i1 @zext_sext_eq(i8 %x, i8 %y) {
; CHECK-LABEL: @zext_sext_eq(
; CHECK-NEXT:    [[A:%.*]] = zext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = sext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = zext i8 %x to i32
  %b = sext i8 %y to i32
  %c = icmp eq i32 %a, %b
  ret i1 %c
}

define i1 @zext_sext_sle_op0_narrow(i8 %x, i16 %y) {
; CHECK-LABEL: @zext_sext_sle_op0_narrow(
; CHECK-NEXT:    [[A:%.*]] = zext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = sext i16 [[Y:%.*]] to i32
; CHECK-NEXT:    [[C:%.*]] = icmp sle i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = zext i8 %x to i32
  %b = sext i16 %y to i32
  %c = icmp sle i32 %a, %b
  ret i1 %c
}

define i1 @zext_sext_ule_op0_wide(i9 %x, i8 %y) {
; CHECK-LABEL: @zext_sext_ule_op0_wide(
; CHECK-NEXT:    [[A:%.*]] = zext i9 [[X:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = sext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[C:%.*]] = icmp ule i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = zext i9 %x to i32
  %b = sext i8 %y to i32
  %c = icmp ule i32 %a, %b
  ret i1 %c
}

define i1 @sext_zext_slt(i8 %x, i8 %y) {
; CHECK-LABEL: @sext_zext_slt(
; CHECK-NEXT:    [[A:%.*]] = sext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = zext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[C:%.*]] = icmp slt i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i8 %x to i32
  %b = zext i8 %y to i32
  %c = icmp slt i32 %a, %b
  ret i1 %c
}

define i1 @sext_zext_ult(i8 %x, i8 %y) {
; CHECK-LABEL: @sext_zext_ult(
; CHECK-NEXT:    [[A:%.*]] = sext i8 [[X:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = zext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[C:%.*]] = icmp ult i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i8 %x to i32
  %b = zext i8 %y to i32
  %c = icmp ult i32 %a, %b
  ret i1 %c
}

define <2 x i1> @sext_zext_ne(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @sext_zext_ne(
; CHECK-NEXT:    [[A:%.*]] = sext <2 x i8> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[B:%.*]] = zext <2 x i8> [[Y:%.*]] to <2 x i32>
; CHECK-NEXT:    [[C:%.*]] = icmp ne <2 x i32> [[A]], [[B]]
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %a = sext <2 x i8> %x to <2 x i32>
  %b = zext <2 x i8> %y to <2 x i32>
  %c = icmp ne <2 x i32> %a, %b
  ret <2 x i1> %c
}

define i1 @sext_zext_sge_op0_narrow(i5 %x, i8 %y) {
; CHECK-LABEL: @sext_zext_sge_op0_narrow(
; CHECK-NEXT:    [[A:%.*]] = sext i5 [[X:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = zext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[C:%.*]] = icmp sge i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i5 %x to i32
  %b = zext i8 %y to i32
  %c = icmp sge i32 %a, %b
  ret i1 %c
}

define i1 @sext_zext_uge_op0_wide(i16 %x, i8 %y) {
; CHECK-LABEL: @sext_zext_uge_op0_wide(
; CHECK-NEXT:    [[A:%.*]] = sext i16 [[X:%.*]] to i32
; CHECK-NEXT:    [[B:%.*]] = zext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[C:%.*]] = icmp uge i32 [[A]], [[B]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i16 %x to i32
  %b = zext i8 %y to i32
  %c = icmp uge i32 %a, %b
  ret i1 %c
}

define i1 @zext_sext_sgt_known_nonneg(i8 %x, i8 %y) {
; CHECK-LABEL: @zext_sext_sgt_known_nonneg(
; CHECK-NEXT:    [[N:%.*]] = udiv i8 127, [[X:%.*]]
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i8 [[N]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %n = udiv i8 127, %x
  %a = zext i8 %n to i32
  %b = sext i8 %y to i32
  %c = icmp sgt i32 %a, %b
  ret i1 %c
}

define i1 @zext_sext_ugt_known_nonneg(i8 %x, i8 %y) {
; CHECK-LABEL: @zext_sext_ugt_known_nonneg(
; CHECK-NEXT:    [[N:%.*]] = and i8 [[X:%.*]], 127
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i8 [[N]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %n = and i8 %x, 127
  %a = zext i8 %n to i32
  %b = sext i8 %y to i32
  %c = icmp ugt i32 %a, %b
  ret i1 %c
}

define i1 @zext_sext_eq_known_nonneg(i8 %x, i8 %y) {
; CHECK-LABEL: @zext_sext_eq_known_nonneg(
; CHECK-NEXT:    [[N:%.*]] = lshr i8 [[X:%.*]], 1
; CHECK-NEXT:    [[C:%.*]] = icmp eq i8 [[N]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %n = lshr i8 %x, 1
  %a = zext i8 %n to i32
  %b = sext i8 %y to i32
  %c = icmp eq i32 %a, %b
  ret i1 %c
}

define i1 @zext_sext_sle_known_nonneg_op0_narrow(i8 %x, i16 %y) {
; CHECK-LABEL: @zext_sext_sle_known_nonneg_op0_narrow(
; CHECK-NEXT:    [[N:%.*]] = and i8 [[X:%.*]], 12
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[N]] to i16
; CHECK-NEXT:    [[C:%.*]] = icmp sle i16 [[TMP1]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %n = and i8 %x, 12
  %a = zext i8 %n to i32
  %b = sext i16 %y to i32
  %c = icmp sle i32 %a, %b
  ret i1 %c
}

define i1 @zext_sext_ule_known_nonneg_op0_wide(i9 %x, i8 %y) {
; CHECK-LABEL: @zext_sext_ule_known_nonneg_op0_wide(
; CHECK-NEXT:    [[N:%.*]] = urem i9 [[X:%.*]], 254
; CHECK-NEXT:    [[TMP1:%.*]] = sext i8 [[Y:%.*]] to i9
; CHECK-NEXT:    [[C:%.*]] = icmp ule i9 [[N]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %n = urem i9 %x, 254
  %a = zext i9 %n to i32
  %b = sext i8 %y to i32
  %c = icmp ule i32 %a, %b
  ret i1 %c
}

define i1 @sext_zext_slt_known_nonneg(i8 %x, i8 %y) {
; CHECK-LABEL: @sext_zext_slt_known_nonneg(
; CHECK-NEXT:    [[N:%.*]] = and i8 [[Y:%.*]], 126
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i8 [[N]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i8 %x to i32
  %n = and i8 %y, 126
  %b = zext i8 %n to i32
  %c = icmp slt i32 %a, %b
  ret i1 %c
}

define i1 @sext_zext_ult_known_nonneg(i8 %x, i8 %y) {
; CHECK-LABEL: @sext_zext_ult_known_nonneg(
; CHECK-NEXT:    [[N:%.*]] = lshr i8 [[Y:%.*]], 6
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i8 [[N]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i8 %x to i32
  %n = lshr i8 %y, 6
  %b = zext i8 %n to i32
  %c = icmp ult i32 %a, %b
  ret i1 %c
}

define i1 @sext_zext_ne_known_nonneg(i8 %x, i8 %y) {
; CHECK-LABEL: @sext_zext_ne_known_nonneg(
; CHECK-NEXT:    [[N:%.*]] = udiv i8 [[Y:%.*]], 6
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[N]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i8 %x to i32
  %n = udiv i8 %y, 6
  %b = zext i8 %n to i32
  %c = icmp ne i32 %a, %b
  ret i1 %c
}

define <2 x i1> @sext_zext_sge_known_nonneg_op0_narrow(<2 x i5> %x, <2 x i8> %y) {
; CHECK-LABEL: @sext_zext_sge_known_nonneg_op0_narrow(
; CHECK-NEXT:    [[N:%.*]] = mul nsw <2 x i8> [[Y:%.*]], [[Y]]
; CHECK-NEXT:    [[TMP1:%.*]] = sext <2 x i5> [[X:%.*]] to <2 x i8>
; CHECK-NEXT:    [[C:%.*]] = icmp sle <2 x i8> [[N]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i1> [[C]]
;
  %a = sext <2 x i5> %x to <2 x i32>
  %n = mul nsw <2 x i8> %y, %y
  %b = zext <2 x i8> %n to <2 x i32>
  %c = icmp sge <2 x i32> %a, %b
  ret <2 x i1> %c
}

define i1 @sext_zext_uge_known_nonneg_op0_wide(i16 %x, i8 %y) {
; CHECK-LABEL: @sext_zext_uge_known_nonneg_op0_wide(
; CHECK-NEXT:    [[N:%.*]] = and i8 [[Y:%.*]], 12
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[N]] to i16
; CHECK-NEXT:    [[C:%.*]] = icmp ule i16 [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[C]]
;
  %a = sext i16 %x to i32
  %n = and i8 %y, 12
  %b = zext i8 %n to i32
  %c = icmp uge i32 %a, %b
  ret i1 %c
}


define i1 @zext_eq_sext(i1 %a, i1 %b) {
; CHECK-LABEL: @zext_eq_sext(
; CHECK-NEXT:    [[TMP1:%.*]] = or i1 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[TOBOOL4:%.*]] = xor i1 [[TMP1]], true
; CHECK-NEXT:    ret i1 [[TOBOOL4]]
;
  %conv = zext i1 %a to i32
  %conv3.neg = sext i1 %b to i32
  %tobool4 = icmp eq i32 %conv, %conv3.neg
  ret i1 %tobool4
}

define i1 @zext_eq_sext_fail_not_i1(i1 %a, i8 %b) {
; CHECK-LABEL: @zext_eq_sext_fail_not_i1(
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[A:%.*]] to i32
; CHECK-NEXT:    [[CONV3_NEG:%.*]] = sext i8 [[B:%.*]] to i32
; CHECK-NEXT:    [[TOBOOL4:%.*]] = icmp eq i32 [[CONV]], [[CONV3_NEG]]
; CHECK-NEXT:    ret i1 [[TOBOOL4]]
;
  %conv = zext i1 %a to i32
  %conv3.neg = sext i8 %b to i32
  %tobool4 = icmp eq i32 %conv, %conv3.neg
  ret i1 %tobool4
}

define <2 x i1> @zext_ne_sext(<2 x i1> %a, <2 x i1> %b) {
; CHECK-LABEL: @zext_ne_sext(
; CHECK-NEXT:    [[TMP1:%.*]] = or <2 x i1> [[B:%.*]], [[A:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[TMP1]]
;
  %conv = zext <2 x i1> %a to <2 x i8>
  %conv3.neg = sext <2 x i1> %b to <2 x i8>
  %tobool4 = icmp ne <2 x i8> %conv3.neg, %conv
  ret <2 x i1> %tobool4
}
