/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_dev_nvlw_ip_h__
#define __ls10_dev_nvlw_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_NVLW                                         0x0000FFF:0x00000000 /* RW--D */
#define NV_NVLW_TOP_INTR_0_STATUS                             0x00000200      /* R--4R */
#define NV_NVLW_TOP_INTR_0_STATUS_LINK                        3:0             /* R-EVF */
#define NV_NVLW_TOP_INTR_0_STATUS_LINK_INIT                   0x00000000      /* R-E-V */
#define NV_NVLW_TOP_INTR_0_STATUS_COMMON                      31:31           /* R-EVF */
#define NV_NVLW_TOP_INTR_0_STATUS_COMMON_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_TOP_INTR_1_STATUS                             0x00000204      /* R--4R */
#define NV_NVLW_TOP_INTR_1_STATUS_LINK                        3:0             /* R-EVF */
#define NV_NVLW_TOP_INTR_1_STATUS_LINK_INIT                   0x00000000      /* R-E-V */
#define NV_NVLW_TOP_INTR_1_STATUS_COMMON                      31:31           /* R-EVF */
#define NV_NVLW_TOP_INTR_1_STATUS_COMMON_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_TOP_INTR_2_STATUS                             0x00000208      /* R--4R */
#define NV_NVLW_TOP_INTR_2_STATUS_LINK                        3:0             /* R-EVF */
#define NV_NVLW_TOP_INTR_2_STATUS_LINK_INIT                   0x00000000      /* R-E-V */
#define NV_NVLW_TOP_INTR_2_STATUS_COMMON                      31:31           /* R-EVF */
#define NV_NVLW_TOP_INTR_2_STATUS_COMMON_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_0_MASK                            0x00000220      /* RW-4R */
#define NV_NVLW_COMMON_INTR_0_MASK_FATAL                      0:0             /* RWEVF */
#define NV_NVLW_COMMON_INTR_0_MASK_FATAL_ENABLE               0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_0_MASK_FATAL_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_0_MASK_NONFATAL                   1:1             /* RWEVF */
#define NV_NVLW_COMMON_INTR_0_MASK_NONFATAL_ENABLE            0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_0_MASK_NONFATAL_DISABLE           0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_0_MASK_CORRECTABLE                2:2             /* RWEVF */
#define NV_NVLW_COMMON_INTR_0_MASK_CORRECTABLE_ENABLE         0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_0_MASK_CORRECTABLE_DISABLE        0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_0_MASK_INTR0                      3:3             /* RWEVF */
#define NV_NVLW_COMMON_INTR_0_MASK_INTR0_ENABLE               0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_0_MASK_INTR0_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_0_MASK_INTR1                      4:4             /* RWEVF */
#define NV_NVLW_COMMON_INTR_0_MASK_INTR1_ENABLE               0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_0_MASK_INTR1_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_0_STATUS                          0x00000224      /* R--4R */
#define NV_NVLW_COMMON_INTR_0_STATUS_FATAL                    0:0             /* R-EVF */
#define NV_NVLW_COMMON_INTR_0_STATUS_FATAL_INIT               0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_0_STATUS_NONFATAL                 1:1             /* R-EVF */
#define NV_NVLW_COMMON_INTR_0_STATUS_NONFATAL_INIT            0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_0_STATUS_CORRECTABLE              2:2             /* R-EVF */
#define NV_NVLW_COMMON_INTR_0_STATUS_CORRECTABLE_INIT         0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_0_STATUS_INTR0                    3:3             /* R-EVF */
#define NV_NVLW_COMMON_INTR_0_STATUS_INTR0_INIT               0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_0_STATUS_INTR1                    4:4             /* R-EVF */
#define NV_NVLW_COMMON_INTR_0_STATUS_INTR1_INIT               0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_1_MASK                            0x00000228      /* RW-4R */
#define NV_NVLW_COMMON_INTR_1_MASK_FATAL                      0:0             /* RWEVF */
#define NV_NVLW_COMMON_INTR_1_MASK_FATAL_ENABLE               0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_1_MASK_FATAL_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_1_MASK_NONFATAL                   1:1             /* RWEVF */
#define NV_NVLW_COMMON_INTR_1_MASK_NONFATAL_ENABLE            0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_1_MASK_NONFATAL_DISABLE           0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_1_MASK_CORRECTABLE                2:2             /* RWEVF */
#define NV_NVLW_COMMON_INTR_1_MASK_CORRECTABLE_ENABLE         0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_1_MASK_CORRECTABLE_DISABLE        0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_1_MASK_INTR0                      3:3             /* RWEVF */
#define NV_NVLW_COMMON_INTR_1_MASK_INTR0_ENABLE               0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_1_MASK_INTR0_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_1_MASK_INTR1                      4:4             /* RWEVF */
#define NV_NVLW_COMMON_INTR_1_MASK_INTR1_ENABLE               0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_1_MASK_INTR1_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_1_STATUS                          0x0000022c      /* R--4R */
#define NV_NVLW_COMMON_INTR_1_STATUS_FATAL                    0:0             /* R-EVF */
#define NV_NVLW_COMMON_INTR_1_STATUS_FATAL_INIT               0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_1_STATUS_NONFATAL                 1:1             /* R-EVF */
#define NV_NVLW_COMMON_INTR_1_STATUS_NONFATAL_INIT            0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_1_STATUS_CORRECTABLE              2:2             /* R-EVF */
#define NV_NVLW_COMMON_INTR_1_STATUS_CORRECTABLE_INIT         0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_1_STATUS_INTR0                    3:3             /* R-EVF */
#define NV_NVLW_COMMON_INTR_1_STATUS_INTR0_INIT               0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_1_STATUS_INTR1                    4:4             /* R-EVF */
#define NV_NVLW_COMMON_INTR_1_STATUS_INTR1_INIT               0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_2_MASK                            0x00000230      /* RW-4R */
#define NV_NVLW_COMMON_INTR_2_MASK_FATAL                      0:0             /* RWEVF */
#define NV_NVLW_COMMON_INTR_2_MASK_FATAL_ENABLE               0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_2_MASK_FATAL_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_2_MASK_NONFATAL                   1:1             /* RWEVF */
#define NV_NVLW_COMMON_INTR_2_MASK_NONFATAL_ENABLE            0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_2_MASK_NONFATAL_DISABLE           0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_2_MASK_CORRECTABLE                2:2             /* RWEVF */
#define NV_NVLW_COMMON_INTR_2_MASK_CORRECTABLE_ENABLE         0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_2_MASK_CORRECTABLE_DISABLE        0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_2_MASK_INTR0                      3:3             /* RWEVF */
#define NV_NVLW_COMMON_INTR_2_MASK_INTR0_ENABLE               0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_2_MASK_INTR0_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_2_MASK_INTR1                      4:4             /* RWEVF */
#define NV_NVLW_COMMON_INTR_2_MASK_INTR1_ENABLE               0x00000001      /* RW--V */
#define NV_NVLW_COMMON_INTR_2_MASK_INTR1_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLW_COMMON_INTR_2_STATUS                          0x00000234      /* R--4R */
#define NV_NVLW_COMMON_INTR_2_STATUS_FATAL                    0:0             /* R-EVF */
#define NV_NVLW_COMMON_INTR_2_STATUS_FATAL_INIT               0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_2_STATUS_NONFATAL                 1:1             /* R-EVF */
#define NV_NVLW_COMMON_INTR_2_STATUS_NONFATAL_INIT            0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_2_STATUS_CORRECTABLE              2:2             /* R-EVF */
#define NV_NVLW_COMMON_INTR_2_STATUS_CORRECTABLE_INIT         0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_2_STATUS_INTR0                    3:3             /* R-EVF */
#define NV_NVLW_COMMON_INTR_2_STATUS_INTR0_INIT               0x00000000      /* R-E-V */
#define NV_NVLW_COMMON_INTR_2_STATUS_INTR1                    4:4             /* R-EVF */
#define NV_NVLW_COMMON_INTR_2_STATUS_INTR1_INIT               0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_0_MASK(i)                           (0x00000300+(i)*0x40) /* RW-4A */
#define NV_NVLW_LINK_INTR_0_MASK__SIZE_1                      4               /*       */
#define NV_NVLW_LINK_INTR_0_MASK_FATAL                        0:0             /* RWEVF */
#define NV_NVLW_LINK_INTR_0_MASK_FATAL_ENABLE                 0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_0_MASK_FATAL_DISABLE                0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_0_MASK_NONFATAL                     1:1             /* RWEVF */
#define NV_NVLW_LINK_INTR_0_MASK_NONFATAL_ENABLE              0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_0_MASK_NONFATAL_DISABLE             0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_0_MASK_CORRECTABLE                  2:2             /* RWEVF */
#define NV_NVLW_LINK_INTR_0_MASK_CORRECTABLE_ENABLE           0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_0_MASK_CORRECTABLE_DISABLE          0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_0_MASK_INTR0                        3:3             /* RWEVF */
#define NV_NVLW_LINK_INTR_0_MASK_INTR0_ENABLE                 0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_0_MASK_INTR0_DISABLE                0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_0_MASK_INTR1                        4:4             /* RWEVF */
#define NV_NVLW_LINK_INTR_0_MASK_INTR1_ENABLE                 0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_0_MASK_INTR1_DISABLE                0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_0_STATUS(i)                         (0x00000304+(i)*0x40) /* R--4A */
#define NV_NVLW_LINK_INTR_0_STATUS__SIZE_1                    4               /*       */
#define NV_NVLW_LINK_INTR_0_STATUS_FATAL                      0:0             /* R-EVF */
#define NV_NVLW_LINK_INTR_0_STATUS_FATAL_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_0_STATUS_NONFATAL                   1:1             /* R-EVF */
#define NV_NVLW_LINK_INTR_0_STATUS_NONFATAL_INIT              0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_0_STATUS_CORRECTABLE                2:2             /* R-EVF */
#define NV_NVLW_LINK_INTR_0_STATUS_CORRECTABLE_INIT           0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_0_STATUS_INTR0                      3:3             /* R-EVF */
#define NV_NVLW_LINK_INTR_0_STATUS_INTR0_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_0_STATUS_INTR1                      4:4             /* R-EVF */
#define NV_NVLW_LINK_INTR_0_STATUS_INTR1_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_1_MASK(i)                           (0x00000308+(i)*0x40) /* RW-4A */
#define NV_NVLW_LINK_INTR_1_MASK__SIZE_1                      4               /*       */
#define NV_NVLW_LINK_INTR_1_MASK_FATAL                        0:0             /* RWEVF */
#define NV_NVLW_LINK_INTR_1_MASK_FATAL_ENABLE                 0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_1_MASK_FATAL_DISABLE                0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_1_MASK_NONFATAL                     1:1             /* RWEVF */
#define NV_NVLW_LINK_INTR_1_MASK_NONFATAL_ENABLE              0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_1_MASK_NONFATAL_DISABLE             0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_1_MASK_CORRECTABLE                  2:2             /* RWEVF */
#define NV_NVLW_LINK_INTR_1_MASK_CORRECTABLE_ENABLE           0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_1_MASK_CORRECTABLE_DISABLE          0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_1_MASK_INTR0                        3:3             /* RWEVF */
#define NV_NVLW_LINK_INTR_1_MASK_INTR0_ENABLE                 0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_1_MASK_INTR0_DISABLE                0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_1_MASK_INTR1                        4:4             /* RWEVF */
#define NV_NVLW_LINK_INTR_1_MASK_INTR1_ENABLE                 0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_1_MASK_INTR1_DISABLE                0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_1_STATUS(i)                         (0x0000030c+(i)*0x40) /* R--4A */
#define NV_NVLW_LINK_INTR_1_STATUS__SIZE_1                    4               /*       */
#define NV_NVLW_LINK_INTR_1_STATUS_FATAL                      0:0             /* R-EVF */
#define NV_NVLW_LINK_INTR_1_STATUS_FATAL_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_1_STATUS_NONFATAL                   1:1             /* R-EVF */
#define NV_NVLW_LINK_INTR_1_STATUS_NONFATAL_INIT              0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_1_STATUS_CORRECTABLE                2:2             /* R-EVF */
#define NV_NVLW_LINK_INTR_1_STATUS_CORRECTABLE_INIT           0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_1_STATUS_INTR0                      3:3             /* R-EVF */
#define NV_NVLW_LINK_INTR_1_STATUS_INTR0_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_1_STATUS_INTR1                      4:4             /* R-EVF */
#define NV_NVLW_LINK_INTR_1_STATUS_INTR1_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_2_MASK(i)                           (0x00000310+(i)*0x40) /* RW-4A */
#define NV_NVLW_LINK_INTR_2_MASK__SIZE_1                      4               /*       */
#define NV_NVLW_LINK_INTR_2_MASK_FATAL                        0:0             /* RWEVF */
#define NV_NVLW_LINK_INTR_2_MASK_FATAL_ENABLE                 0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_2_MASK_FATAL_DISABLE                0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_2_MASK_NONFATAL                     1:1             /* RWEVF */
#define NV_NVLW_LINK_INTR_2_MASK_NONFATAL_ENABLE              0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_2_MASK_NONFATAL_DISABLE             0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_2_MASK_CORRECTABLE                  2:2             /* RWEVF */
#define NV_NVLW_LINK_INTR_2_MASK_CORRECTABLE_ENABLE           0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_2_MASK_CORRECTABLE_DISABLE          0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_2_MASK_INTR0                        3:3             /* RWEVF */
#define NV_NVLW_LINK_INTR_2_MASK_INTR0_ENABLE                 0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_2_MASK_INTR0_DISABLE                0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_2_MASK_INTR1                        4:4             /* RWEVF */
#define NV_NVLW_LINK_INTR_2_MASK_INTR1_ENABLE                 0x00000001      /* RW--V */
#define NV_NVLW_LINK_INTR_2_MASK_INTR1_DISABLE                0x00000000      /* RWE-V */
#define NV_NVLW_LINK_INTR_2_STATUS(i)                         (0x00000314+(i)*0x40) /* R--4A */
#define NV_NVLW_LINK_INTR_2_STATUS__SIZE_1                    4               /*       */
#define NV_NVLW_LINK_INTR_2_STATUS_FATAL                      0:0             /* R-EVF */
#define NV_NVLW_LINK_INTR_2_STATUS_FATAL_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_2_STATUS_NONFATAL                   1:1             /* R-EVF */
#define NV_NVLW_LINK_INTR_2_STATUS_NONFATAL_INIT              0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_2_STATUS_CORRECTABLE                2:2             /* R-EVF */
#define NV_NVLW_LINK_INTR_2_STATUS_CORRECTABLE_INIT           0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_2_STATUS_INTR0                      3:3             /* R-EVF */
#define NV_NVLW_LINK_INTR_2_STATUS_INTR0_INIT                 0x00000000      /* R-E-V */
#define NV_NVLW_LINK_INTR_2_STATUS_INTR1                      4:4             /* R-EVF */
#define NV_NVLW_LINK_INTR_2_STATUS_INTR1_INIT                 0x00000000      /* R-E-V */
#endif // __ls10_dev_nvlw_ip_h__
