function(c_standard target version)
    set_property(TARGET ${target} PROPERTY C_STANDARD ${version})
    set_property(TARGET ${target} PROPERTY C_STANDARD_REQUIRED ON)
    set_property(TARGET ${target} PROPERTY C_EXTENSIONS OFF)
endfunction()

function(cxx_standard target version)
    set_property(TARGET ${target} PROPERTY CXX_STANDARD ${version})
    set_property(TARGET ${target} PROPERTY CXX_STANDARD_REQUIRED ON)
    set_property(TARGET ${target} PROPERTY CXX_EXTENSIONS OFF)
endfunction()

function(lto target)
    if(HAS_LTO)
        set_property(TARGET ${target} PROPERTY INTERPROCEDURAL_OPTIMIZATION TRUE)
    endif()
endfunction()

function(warnings target)
    if("${CMAKE_C_COMPILER_ID}" STREQUAL "GNU")
        target_compile_options(${target} PRIVATE $<$<COMPILE_LANGUAGE:C>:-Wall>)
    elseif("${CMAKE_C_COMPILER_ID}" MATCHES "Clang$")
        target_compile_options(${target} PRIVATE $<$<COMPILE_LANGUAGE:C>:-Wall>)
    endif()

    if("${CMAKE_CXX_COMPILER_ID}" STREQUAL "GNU")
        target_compile_options(${target} PRIVATE $<$<COMPILE_LANGUAGE:CXX>:-Wall>)
    elseif("${CMAKE_CXX_COMPILER_ID}" MATCHES "Clang$")
        target_compile_options(${target} PRIVATE $<$<COMPILE_LANGUAGE:CXX>:-Wall>)
    endif()
endfunction()
