/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.app;

import gmonitor.app.SimpleGrapherBaseUI;
import gmonitor.gui.DataTimeSpace;
import gmonitor.gui.GraphMonitor;
import gmonitor.gui.GraphMonitorModel;
import gmonitor.gui.RawData;
import gmonitor.gui.RawDataElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.text.Document;

public class SimpleGrapherApp
extends SimpleGrapherBaseUI {
    String currentDirectoryPath = null;
    String setTargetHostName = null;
    String setTargetEventName = null;
    String setTargetUnitName = null;
    int initialDelay = 0;
    String[] selectedHostsForTotal = null;
    DataTimeSpace dtSpace = null;
    ArrayList rawDataSeries = new ArrayList();
    GraphMonitorModel model = new GraphMonitorModel();
    private int autoUpdateInterval = 10;
    Timer timer = new Timer(this.autoUpdateInterval * 1000, new TimerAutoUpdateAction());
    private boolean timerInitFlag;
    private int resampleResolution = 100;
    File selectedDir = null;
    JFrame appFrame = new JFrame();
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    String propDataPathPrefix = null;
    ArrayList propDataFileList = new ArrayList();
    ArrayList propHostList = new ArrayList();
    String propEvent = null;
    boolean propTotalMode = false;
    boolean propDiffMode = false;
    boolean propAutoUpdate = false;
    boolean propLineStyle = true;
    boolean propBarStyle = true;
    boolean propPlotStyle = true;
    double propMultiplier = 1.0;
    boolean propControllerVisibility = true;
    boolean propStylePanelVisibility = true;
    boolean propUnitPanelVisibility = true;
    boolean propMenuBarVisibility = true;
    boolean propInformationPanelVisibility = true;
    private double savedInfoWidth = 0.0;
    private double savedInfoHeight = 0.0;
    private Dimension savedDimension = null;
    private Dimension savedDimension2 = null;
    private long magnificationY = 1L;
    private boolean disableComboEvent = false;
    private boolean setComboTargetsFlag = false;
    private static final String[] UNIT_PREFIX_TABLE = new String[]{"", "x 10^3", "x 10^6", "x 10^9", "x 10^12", "x 10^15", "x 10^18", "x 10^21", "x 10^24"};
    private String selectedUptimeEventForCorrection;
    private JComboBox comboUptimeSelection = null;
    private JDialog jd;
    private JList list;
    private boolean totalOkFlag;
    private boolean lockTimer = false;
    private boolean initFlag = true;
    private boolean checkHostFlag;
    private boolean checkEventFlag;
    private boolean lockRefresh = false;
    String lineSep = System.getProperty("line.separator");
    DecimalFormat decimalf = new DecimalFormat("###,###,##0");

    private void initializeFromProperty(String string) {
        ArrayList arrayList = this.extractCSV(System.getProperty(string + "DataFileList"));
        ArrayList arrayList2 = this.extractCSV(System.getProperty(string + "HostList"));
        this.propTotalMode = this.getBooleanWithDefault(string + "TotalMode", this.propTotalMode);
        this.propDiffMode = this.getBooleanWithDefault(string + "DiffMode", this.propDiffMode);
        this.propAutoUpdate = this.getBooleanWithDefault(string + "AutoUpdate", this.propAutoUpdate);
        this.propLineStyle = this.getBooleanWithDefault(string + "LineStyle", this.propLineStyle);
        this.propBarStyle = this.getBooleanWithDefault(string + "BarStyle", this.propBarStyle);
        this.propPlotStyle = this.getBooleanWithDefault(string + "PlotStyle", this.propPlotStyle);
        this.propMultiplier = this.getDoubleWithDefault(string + "Multiplier", this.propMultiplier);
        this.propControllerVisibility = this.getBooleanWithDefault(string + "ControllerVisibility", this.propControllerVisibility);
        this.propStylePanelVisibility = this.getBooleanWithDefault(string + "StylePanelVisibility", this.propStylePanelVisibility);
        this.propMenuBarVisibility = this.getBooleanWithDefault(string + "MenuBarVisibility", this.propMenuBarVisibility);
    }

    private void initializeEventHandlers() {
        MenuItemFileOpenAction menuItemFileOpenAction = new MenuItemFileOpenAction();
        this.menuItemFileOpen.addActionListener(menuItemFileOpenAction);
        this.buttonFileOpen.addActionListener(menuItemFileOpenAction);
        this.menuItemFileAutoUpdate.addActionListener(new FileAutoUpdateAction());
        this.menuItemFileExit.addActionListener(new MenuItemFileExitAction());
        this.buttonUpdateNow.addActionListener(new RepaintAction());
        this.comboEvent.addActionListener(new ComboEventSelectionAction());
        this.comboHostname.addActionListener(new ComboHostnameSelectionAction());
        this.checkGraphStyleBar.addActionListener(new CheckBoxBarAction());
        this.checkGraphStyleLine.addActionListener(new CheckBoxLineAction());
        this.checkGraphStylePlot.addActionListener(new CheckBoxPlotAction());
        this.checkDifferentialMode.addActionListener(new CheckBoxDifferentialModeAction());
        this.check8times.addActionListener(new CheckBox8timesAction());
        this.check1000times.addActionListener(new CheckBox1000timesAction());
        this.check100div.addActionListener(new CheckBox100divAction());
        this.checkTotal.addActionListener(new CheckBoxTotalAction());
        this.checkAutoUpdate.addActionListener(new CheckBoxAutoUpdateAction());
        this.menuItemGraphStyleBar.addActionListener(new MenuItemGraphStyleBarAction());
        this.menuItemGraphStyleLine.addActionListener(new MenuItemGraphStyleLineAction());
        this.menuItemGraphStylePlot.addActionListener(new MenuItemGraphStylePlotAction());
        this.menuItemDifferentialMode.addActionListener(new MenuItemDifferentialModeAction());
        this.menuItem8times.addActionListener(new MenuItem8timesAction());
        this.menuItem1000times.addActionListener(new MenuItem1000timesAction());
        this.menuItem100div.addActionListener(new MenuItem100divAction());
        this.menuItemTotal.addActionListener(new MenuItemTotalAction());
        this.menuItemAutoUpdate.addActionListener(new MenuItemAutoUpdateAction());
        this.menuItemCorrectByUptime.addActionListener(new CorrectByUptimeAction());
        RadioAction radioAction = new RadioAction();
        this.radioMenuNone.addActionListener(radioAction);
        this.radioMenubps.addActionListener(radioAction);
        this.radioMenuKB.addActionListener(radioAction);
        this.radioMenuLoad.addActionListener(radioAction);
        this.comboUnit.addActionListener(new ComboUnitSelectionAction());
        this.menuItemAutoUpdateInterval.addActionListener(new AutoUpdateIntervalAction());
        this.menuItemAutoUpdateInterval.setText(this.menuStrAutoUpdateInterval + " (" + String.valueOf(this.autoUpdateInterval) + ")");
        this.menuItemResolution.addActionListener(new ResampleResoAction());
        this.menuItemResolution.setText(this.menuStrResolution + " (" + String.valueOf(this.resampleResolution) + ")");
        this.menuItemRepaint.addActionListener(new RepaintAction());
        RepaintNow repaintNow = new RepaintNow();
        this.menuItemRaw.addActionListener(repaintNow);
        ResampleAction resampleAction = new ResampleAction();
        this.menuItemBefore.addActionListener(resampleAction);
        this.menuItemInterpolate.addActionListener(resampleAction);
        this.menuItemVisInfo.addActionListener(new VisibleInfoAction());
        this.menuItemVisInfo.setSelected(true);
        this.menuItemVisGraphStyle.addActionListener(new VisibleStyleAction());
        this.menuItemVisGraphStyle.setSelected(true);
        this.menuItemVisUnit.addActionListener(new VisibleUnitAction());
        this.menuItemVisUnit.setSelected(true);
        this.menuItemVisController.addActionListener(new VisibleControllerAction());
        this.menuItemVisController.setSelected(true);
        this.graphPane.addMouseListener(new GraphMouseAction());
    }

    private void initializeGUIComponents() {
        this.appFrame.setDefaultCloseOperation(3);
        this.textBeginTime.setText(this.dateFormat.format(new Date()));
        this.textRange.setText("3600");
        this.checkAutoUpdate.setSelected(this.propAutoUpdate);
        this.checkTotal.setSelected(this.propTotalMode);
        this.checkGraphStyleBar.setSelected(this.propBarStyle);
        this.menuItemGraphStyleBar.setSelected(this.propBarStyle);
        this.checkGraphStylePlot.setSelected(this.propPlotStyle);
        this.menuItemGraphStylePlot.setSelected(this.propPlotStyle);
        this.checkGraphStyleLine.setSelected(this.propLineStyle);
        this.menuItemGraphStyleLine.setSelected(this.propLineStyle);
    }

    private void actionCorrect(boolean bl) {
        this.selectedUptimeEventForCorrection = null;
        if (bl) {
            Object object;
            int n;
            if (this.dtSpace == null) {
                this.menuItemCorrectByUptime.setSelected(false);
                return;
            }
            JDialog jDialog = new JDialog(this.appFrame, "select an event of uptime", true);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.comboUptimeSelection = new JComboBox();
            this.comboUptimeSelection.setRenderer(new SimpleGrapherBaseUI.HostOidCellRenderer(this));
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.comboEvent.getModel();
            DefaultComboBoxModel defaultComboBoxModel2 = (DefaultComboBoxModel)this.comboUptimeSelection.getModel();
            int n2 = defaultComboBoxModel.getSize();
            for (n = 0; n < n2; ++n) {
                defaultComboBoxModel2.addElement(defaultComboBoxModel.getElementAt(n));
            }
            for (n = 0; n < this.comboUptimeSelection.getItemCount(); ++n) {
                object = this.comboUptimeSelection.getItemAt(n);
                if (!((String)object).startsWith("uptime")) continue;
                this.comboUptimeSelection.setSelectedItem(object);
                break;
            }
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SimpleGrapherApp.this.selectedUptimeEventForCorrection = (String)SimpleGrapherApp.this.comboUptimeSelection.getSelectedItem();
                    ((JButton)actionEvent.getSource()).getTopLevelAncestor().setVisible(false);
                    SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
                }
            });
            object = new JButton("Cancel");
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((JButton)actionEvent.getSource()).getTopLevelAncestor().setVisible(false);
                }
            });
            jPanel.add((Component)this.comboUptimeSelection, "North");
            jPanel.add((Component)jButton, "Center");
            jPanel.add((Component)object, "East");
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jDialog.setContentPane(jPanel);
            jDialog.pack();
            jDialog.setLocationRelativeTo(this.appFrame);
            jDialog.setVisible(true);
            if (this.selectedUptimeEventForCorrection == null) {
                this.menuItemCorrectByUptime.setSelected(false);
            }
        } else {
            this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    private void actionTotal(boolean bl) {
        boolean bl2;
        this.totalOkFlag = false;
        if (this.timer.isRunning()) {
            this.timer.stop();
            bl2 = true;
        } else {
            bl2 = false;
        }
        if (bl) {
            String[] stringArray;
            this.jd = new JDialog(this.appFrame, "select hosts", true);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.comboHostname.getModel();
            int n = defaultComboBoxModel.getSize();
            if (n <= 1) {
                this.checkTotal.setSelected(false);
                this.menuItemTotal.setSelected(false);
                this.comboHostname.setEnabled(true);
                return;
            }
            for (int i = 0; i < n; ++i) {
                stringArray = (String[])defaultComboBoxModel.getElementAt(i);
                arrayList.add(stringArray);
            }
            String[] stringArray2 = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray2);
            this.list = new JList<String>(stringArray);
            JButton jButton = new JButton("OK");
            this.list.setCellRenderer(new SimpleGrapherBaseUI.HostOidCellRenderer(this));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = SimpleGrapherApp.this.list.getSelectedValues();
                    if (objectArray == null || objectArray.length <= 1) {
                        return;
                    }
                    SimpleGrapherApp.this.selectedHostsForTotal = new String[objectArray.length];
                    System.out.println("--- Total ---");
                    for (int i = 0; i < objectArray.length; ++i) {
                        SimpleGrapherApp.this.selectedHostsForTotal[i] = (String)objectArray[i];
                        System.out.println(objectArray[i]);
                    }
                    SimpleGrapherApp.this.jd.setVisible(false);
                    SimpleGrapherApp.this.jd = null;
                    SimpleGrapherApp.this.totalOkFlag = true;
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SimpleGrapherApp.this.jd.setVisible(false);
                    SimpleGrapherApp.this.jd = null;
                    SimpleGrapherApp.this.totalOkFlag = false;
                }
            });
            jPanel.add((Component)new JScrollPane(this.list), "North");
            jPanel.add((Component)jButton, "Center");
            jPanel.add((Component)jButton2, "East");
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.jd.setContentPane(jPanel);
            this.jd.pack();
            this.jd.setLocationRelativeTo(this.appFrame);
            this.jd.setVisible(true);
        }
        if (this.totalOkFlag) {
            this.comboHostname.setEnabled(false);
        } else {
            this.checkTotal.setSelected(false);
            this.menuItemTotal.setSelected(false);
            this.comboHostname.setEnabled(true);
        }
        if (bl2) {
            this.timer.start();
        } else if (this.totalOkFlag) {
            this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void actionAutoUpdate(boolean bl, boolean bl2) {
        if (!bl) {
            this.textBeginTime.setEnabled(true);
            this.textRange.setEnabled(true);
            this.timer.stop();
            return;
        }
        if (bl2) {
            int n;
            this.initialDelay = -1;
            this.dialogDirOpen.setDialogTitle("Choose the directory where .glg files are contained");
            if (this.currentDirectoryPath != null) {
                String string;
                try {
                    File file = new File(this.currentDirectoryPath);
                    string = file.exists() ? file.getCanonicalPath() : "";
                }
                catch (IOException iOException) {
                    string = this.currentDirectoryPath;
                }
                this.dialogDirOpen.setCurrentDirectory(new File(string));
            }
            if ((n = this.dialogDirOpen.showOpenDialog(this.appFrame)) != 0) {
                this.menuItemAutoUpdate.setSelected(false);
                this.checkAutoUpdate.setSelected(false);
                this.timer.stop();
                return;
            }
            this.selectedDir = this.dialogDirOpen.getSelectedFile();
            this.currentDirectoryPath = this.selectedDir.getPath();
        } else {
            this.selectedDir = new File(this.currentDirectoryPath);
            if (!this.selectedDir.exists()) {
                this.menuItemAutoUpdate.setSelected(false);
                this.checkAutoUpdate.setSelected(false);
                this.timer.stop();
                return;
            }
        }
        if (this.selectedDir == null) {
            JOptionPane.showMessageDialog(this.appFrame, "No logdata is specified. Open logfile first.");
            this.menuItemAutoUpdate.setSelected(false);
            this.checkAutoUpdate.setSelected(false);
            this.timer.stop();
            return;
        }
        this.textBeginTime.setEnabled(false);
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timerInitFlag = false;
        this.timer.start();
    }

    private void defineNewComboBox(JComboBox jComboBox, String[] stringArray) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            defaultComboBoxModel.addElement(stringArray[i]);
        }
        jComboBox.setModel(defaultComboBoxModel);
    }

    private long getBeginDate() throws ParseException {
        Date date = this.dateFormat.parse(this.textBeginTime.getText());
        return date.getTime();
    }

    private long getTimeRange() throws ParseException {
        return Long.parseLong(this.textRange.getText()) * 1000L;
    }

    private String createTitle(String string, String string2) {
        return string + " " + string2;
    }

    private String createAxisLabelX(String string) {
        return "Date and Time";
    }

    private String createAxisLabelY(String string) {
        String string2 = string;
        String string3 = string.toLowerCase();
        if (string3.startsWith("available")) {
            string2 = "Available Disk space";
        } else if (string3.startsWith("used")) {
            string2 = "Used Disk space";
        } else if (string3.startsWith("eth")) {
            string2 = string3.indexOf("out") > 0 ? "TX Bandwidth" : (string3.indexOf("in") > 0 ? "RX Bandwidth" : "Network bandwidth");
        } else if (string3.startsWith("loadavg")) {
            string2 = "Load average (x100)";
        }
        return string2;
    }

    private String createUnit(String string) {
        String string2 = ".";
        String string3 = string.toLowerCase();
        if (string3.startsWith("available")) {
            string2 = "bytes";
        } else if (string3.startsWith("used")) {
            string2 = "bytes";
        } else if (string3.startsWith("eth")) {
            string2 = "bps";
        } else if (string3.startsWith("loadavg")) {
            string2 = "";
        }
        return string2;
    }

    protected int prefixIndex(long l) {
        long l2 = 0L;
        int n = 0;
        for (int i = 1; i < UNIT_PREFIX_TABLE.length; ++i) {
            l2 = (long)Math.pow(10.0, i * 3);
            n = i - 1;
            if (l / l2 <= 1L) break;
        }
        return n;
    }

    private void paintGraphAccordingToCurrentGUIStatus() {
        if (this.lockRefresh) {
            return;
        }
        this.checkHostFlag = true;
        this.checkEventFlag = true;
        this.lockRefresh = true;
        this.paintGraphAccordingToCurrentGUIStatus2();
        this.lockRefresh = false;
    }

    private void paintGraphAccordingToCurrentGUIStatus2() {
        String string;
        RawDataElement[] rawDataElementArray;
        Object object;
        Object object2;
        int n;
        if (this.dtSpace == null) {
            return;
        }
        String string2 = "";
        String string3 = ((JRadioButtonMenuItem)this.comboUnit.getSelectedItem()).getText();
        if (string3.equals(SimpleGrapherBaseUI.unitKB)) {
            string2 = string2 + " KB";
        } else if (string3.equals(SimpleGrapherBaseUI.unitNone)) {
            string2 = string2 + "";
        } else if (string3.equals(SimpleGrapherBaseUI.unitbps)) {
            string2 = string2 + " bps";
        } else if (string3.equals(SimpleGrapherBaseUI.unitLoad)) {
            string2 = string2 + " %";
        }
        boolean bl = this.checkDifferentialMode.isSelected();
        boolean bl2 = this.checkTotal.isSelected();
        boolean bl3 = this.checkAutoUpdate.isSelected();
        GraphMonitor graphMonitor = this.getGraphPane();
        String string4 = (String)this.comboEvent.getSelectedItem();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl2) {
            for (int i = 0; i < this.selectedHostsForTotal.length; ++i) {
                arrayList.add(this.selectedHostsForTotal[i]);
            }
        } else {
            String string5 = (String)this.comboHostname.getSelectedItem();
            arrayList.add(string5);
        }
        long l = 0L;
        long l2 = 0L;
        this.rawDataSeries.clear();
        try {
            l = this.getBeginDate();
            l2 = this.getTimeRange();
            this.model.setBegin(l);
            this.model.setTerm(l2);
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this.appFrame, "Invalid date time format, correct Begin Time or Time Range");
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object2 = (String)arrayList.get(n);
            try {
                ArrayList arrayList2;
                Object object3;
                object = this.dtSpace.getMeasurementData((String)object2, string4, l, l2);
                if (bl && this.menuItemCorrectByUptime.isSelected() && this.selectedUptimeEventForCorrection != null) {
                    object3 = this.dtSpace.getMeasurementData((String)object2, this.selectedUptimeEventForCorrection, l, l2);
                    if (this.menuItemBefore.isSelected()) {
                        object = this.dtSpace.resampleBeforeDateDataPairListToRawDataElements((ArrayList)object, this.resampleResolution);
                        object3 = this.dtSpace.resampleBeforeDateDataPairListToRawDataElements((ArrayList)object3, this.resampleResolution);
                    } else if (this.menuItemInterpolate.isSelected()) {
                        object = this.dtSpace.resampleEstimateDateDataPairListToRawDataElements((ArrayList)object, this.resampleResolution);
                        object3 = this.dtSpace.resampleEstimateDateDataPairListToRawDataElements((ArrayList)object3, this.resampleResolution);
                    }
                    arrayList2 = this.dtSpace.convertDateDataPairListToRawDataElementsByUptime((ArrayList)object, (ArrayList)object3);
                } else {
                    if (this.menuItemBefore.isSelected()) {
                        object = this.dtSpace.resampleBeforeDateDataPairListToRawDataElements((ArrayList)object, this.resampleResolution);
                    } else if (this.menuItemInterpolate.isSelected()) {
                        object = this.dtSpace.resampleEstimateDateDataPairListToRawDataElements((ArrayList)object, this.resampleResolution);
                    }
                    arrayList2 = this.dtSpace.convertDateDataPairListToRawDataElements((ArrayList)object, bl);
                }
                object3 = new RawData();
                ((RawData)object3).setValid(true);
                rawDataElementArray = new RawDataElement[arrayList2.size()];
                rawDataElementArray = arrayList2.toArray(rawDataElementArray);
                int n2 = 1;
                int n3 = 1;
                if (this.check8times.isSelected()) {
                    n2 *= 8;
                }
                if (this.check1000times.isSelected()) {
                    n2 *= 1000;
                }
                if (this.check100div.isSelected()) {
                    n3 *= 100;
                }
                if (n2 > 1 || n3 > 1) {
                    for (int i = 0; i < rawDataElementArray.length; ++i) {
                        rawDataElementArray[i].setValue(rawDataElementArray[i].getValue() * (long)n2 / (long)n3);
                    }
                }
                ((RawData)object3).setData(rawDataElementArray);
                this.rawDataSeries.add(object3);
                continue;
            }
            catch (Exception exception) {
                int n4 = this.comboEvent.getSelectedIndex();
                this.comboEvent.removeItemAt(n4);
                if (this.checkEventFlag) {
                    n4 = 0;
                    this.checkEventFlag = false;
                }
                if (n4 < this.comboEvent.getItemCount()) {
                    this.disableComboEvent = true;
                    this.comboEvent.setSelectedIndex(n4);
                    this.disableComboEvent = false;
                    this.paintGraphAccordingToCurrentGUIStatus2();
                    return;
                }
                this.defineNewComboBox(this.comboEvent, this.dtSpace.getEvents());
                this.checkEventFlag = true;
                this.disableComboEvent = true;
                this.comboEvent.setSelectedIndex(0);
                this.disableComboEvent = false;
                n4 = this.comboHostname.getSelectedIndex();
                this.comboHostname.removeItemAt(n4);
                if (this.checkHostFlag) {
                    n4 = 0;
                    this.checkHostFlag = false;
                }
                if (n4 < this.comboHostname.getItemCount()) {
                    this.disableComboEvent = true;
                    this.comboHostname.setSelectedIndex(n4);
                    this.disableComboEvent = false;
                    this.paintGraphAccordingToCurrentGUIStatus2();
                    return;
                }
                this.actionAutoUpdate(false, false);
                this.checkAutoUpdate.setSelected(false);
                this.menuItemTotal.setSelected(false);
                JOptionPane.showMessageDialog(this.appFrame, "Error: no data");
                graphMonitor.setModel(null);
                if (bl2) {
                    this.checkTotal.setSelected(false);
                    this.menuItemTotal.setSelected(false);
                    this.comboHostname.setEnabled(true);
                }
                return;
            }
        }
        if (bl2) {
            this.rawDataSeries = this.totalofRawDataSeries(this.rawDataSeries);
        }
        for (n = 0; n < this.rawDataSeries.size(); ++n) {
            object2 = (RawData)this.rawDataSeries.get(n);
            ((RawData)object2).setDiffMode(bl);
            ((RawData)object2).setMax(this.model.getTopValue());
        }
        this.model.setRawDataSeries(this.rawDataSeries, this.magnificationY);
        n = this.prefixIndex(this.model.getTopValue());
        int n5 = this.cookPrefixIndex(n, string4);
        object = UNIT_PREFIX_TABLE[n5];
        long l3 = (long)Math.pow(1000.0, n);
        this.model.setPrefixFactor(l3);
        this.model.setSumMode(bl2);
        rawDataElementArray = this.createAxisLabelX(string4);
        Object object4 = "";
        object4 = string2 == null || string2.equals("") ? object : (String)object + " (" + string2 + ")";
        graphMonitor.setStyleFill(this.checkGraphStyleBar.isSelected());
        graphMonitor.setStyleJoin(this.checkGraphStyleLine.isSelected());
        graphMonitor.setStylePlot(this.checkGraphStylePlot.isSelected());
        if (bl2) {
            string = "Total of ";
        } else {
            string = (String)this.comboHostname.getSelectedItem();
            string = this.getName1(string);
        }
        string4 = this.getName1(string4);
        graphMonitor.setTitle(this.createTitle(string, string4));
        graphMonitor.setModel(this.model);
        graphMonitor.setAxisLabelX((String)rawDataElementArray);
        graphMonitor.setAxisLabelY((String)object4);
        Document document = this.txtInfo.getDocument();
        String string6 = "";
        string6 = string6 + "Latest (" + SimpleGrapherApp.dateString(this.model.getLatestValueTime()) + "): " + this.decimalf.format(this.model.getLatestValue()) + string2 + this.lineSep;
        string6 = string6 + "Max (" + SimpleGrapherApp.dateString(this.model.getMaxValueTime()) + "): " + this.decimalf.format(this.model.getMaxValue()) + string2 + this.lineSep;
        string6 = string6 + "Min (" + SimpleGrapherApp.dateString(this.model.getMinValueTime()) + "): " + this.decimalf.format(this.model.getMinValue()) + string2 + this.lineSep;
        string6 = string6 + "Average: " + this.decimalf.format((long)Math.rint(this.model.getAvgValue())) + string2;
        if (bl2) {
            string6 = string6 + this.lineSep + "Total: " + string4 + " (";
            int n6 = 0;
            while (true) {
                string6 = string6 + this.getName1(this.selectedHostsForTotal[n6]);
                if (n6 >= this.selectedHostsForTotal.length - 1) {
                    string6 = string6 + ")";
                    break;
                }
                string6 = string6 + ", ";
                ++n6;
            }
        }
        this.txtInfo.setText(string6);
        this.txtInfo.repaint();
        if (this.initFlag) {
            this.initFlag = false;
        }
        this.appFrame.repaint();
    }

    public static String dateString(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return simpleDateFormat.format(new Date(l));
    }

    private int cookPrefixIndex(int n, String string) {
        int n2 = n;
        String string2 = string.toLowerCase();
        if (string2.startsWith("available") || string2.startsWith("used") || string2.startsWith("eth") || string2.startsWith("loadavg")) {
            // empty if block
        }
        return n2;
    }

    private ArrayList totalofRawDataSeries(ArrayList arrayList) {
        RawData[] rawDataArray = new RawData[arrayList.size()];
        rawDataArray = arrayList.toArray(rawDataArray);
        RawDataElement[] rawDataElementArray = this.total(rawDataArray);
        ArrayList<RawData> arrayList2 = new ArrayList<RawData>();
        RawData rawData = new RawData();
        rawData.setMax(rawDataArray[0].getMax());
        rawData.setBarColor(rawDataArray[0].getBarColor());
        rawData.setLevelColor(rawDataArray[0].getLevelColor());
        rawData.setLineColor(rawDataArray[0].getLineColor());
        rawData.setPlotColor(rawDataArray[0].getPlotColor());
        rawData.setDiffMode(rawDataArray[0].isDiffmode());
        rawData.setValid(true);
        rawData.setData(rawDataElementArray);
        arrayList2.add(rawData);
        return arrayList2;
    }

    public void setOptions2(String[] stringArray) {
        this.currentDirectoryPath = stringArray.length >= 1 ? stringArray[0] : null;
        this.panelInformation.setVisible(false);
        this.menuItemVisInfo.setSelected(false);
        this.panelController.setVisible(false);
        this.menuItemVisController.setSelected(false);
    }

    public void printHelp() {
        String string = System.getProperty("line.separator");
        String string2 = "usage: java -jar gmonitor3.jar [ -d TargetAutoUpdateDirectory ]" + string;
        string2 = string2 + "       [ -h TargetHostname ] [ -e TargetEventNickName ] " + string;
        string2 = string2 + "       [ -u UnitName(bps/KB/Load) ] [ --help ]" + string;
        string2 = string2 + "       [ --no-line ] [ --no-bar ] [ --no-plot ]" + string;
        string2 = string2 + "       [ --no-information ] [ --no-style ] [ --no-unit ] [ --no-controller ]";
        System.err.println(string2);
    }

    public void setOptions(String[] stringArray) {
        int n = stringArray.length;
        this.currentDirectoryPath = null;
        this.setTargetHostName = null;
        this.setTargetEventName = null;
        this.setTargetUnitName = null;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (!string.startsWith("-")) continue;
            String string2 = string.substring(1);
            if (string2.startsWith("d")) {
                if (++i < n) {
                    this.currentDirectoryPath = stringArray[i];
                    continue;
                }
                System.err.println("");
                this.printHelp();
                System.exit(1);
                continue;
            }
            if (string2.startsWith("h")) {
                if (++i < n) {
                    this.setTargetHostName = stringArray[i];
                    continue;
                }
                System.err.println("");
                this.printHelp();
                System.exit(1);
                continue;
            }
            if (string2.startsWith("e")) {
                if (++i < n) {
                    this.setTargetEventName = stringArray[i];
                    continue;
                }
                System.err.println("");
                this.printHelp();
                System.exit(1);
                continue;
            }
            if (string2.startsWith("u")) {
                if (++i < n) {
                    this.setTargetUnitName = stringArray[i];
                    continue;
                }
                System.err.println("");
                this.printHelp();
                System.exit(1);
                continue;
            }
            if (string2.startsWith("-")) {
                String string3 = string2.substring(1);
                if (string3.equals("no-line")) {
                    this.menuItemGraphStyleLine.setSelected(false);
                    this.checkGraphStyleLine.setSelected(false);
                    continue;
                }
                if (string3.equals("no-bar")) {
                    this.menuItemGraphStyleBar.setSelected(false);
                    this.checkGraphStyleBar.setSelected(false);
                    continue;
                }
                if (string3.equals("no-plot")) {
                    this.menuItemGraphStylePlot.setSelected(false);
                    this.checkGraphStylePlot.setSelected(false);
                    continue;
                }
                if (string3.equals("no-information")) {
                    this.panelInformation.setVisible(false);
                    this.menuItemVisInfo.setSelected(false);
                    continue;
                }
                if (string3.equals("no-style")) {
                    this.panelGraphStyle.setVisible(false);
                    this.menuItemVisGraphStyle.setSelected(false);
                    continue;
                }
                if (string3.equals("no-unit")) {
                    this.panelUnit.setVisible(false);
                    this.menuItemVisUnit.setSelected(false);
                    continue;
                }
                if (string3.equals("no-controller")) {
                    this.panelController.setVisible(false);
                    this.menuItemVisController.setSelected(false);
                    continue;
                }
                if (string3.equals("help")) {
                    this.printHelp();
                    System.exit(1);
                    continue;
                }
                System.err.println("invalid option -- " + string3);
                this.printHelp();
                System.exit(1);
                continue;
            }
            System.err.println("invalid option -- " + string2);
            this.printHelp();
            System.exit(1);
        }
        if (this.currentDirectoryPath != null) {
            this.checkAutoUpdate.setSelected(true);
            this.menuItemAutoUpdate.setSelected(true);
            this.timer.setInitialDelay(1000);
            this.actionAutoUpdate(true, false);
        }
        this.timer.setInitialDelay(0);
    }

    public void setComboTargets() {
        Object e;
        int n;
        this.setComboTargetsFlag = true;
        if (this.setTargetHostName != null) {
            for (n = 0; n < this.comboHostname.getItemCount(); ++n) {
                e = this.comboHostname.getItemAt(n);
                if (e == null || ((String)e).indexOf(this.setTargetHostName) < 0) continue;
                this.comboHostname.setSelectedItem(e);
                break;
            }
        }
        if (this.setTargetEventName != null) {
            for (n = 0; n < this.comboEvent.getItemCount(); ++n) {
                e = this.comboEvent.getItemAt(n);
                if (e == null || ((String)e).indexOf(this.setTargetEventName) < 0) continue;
                this.comboEvent.setSelectedItem(e);
                break;
            }
        }
        if (this.setTargetUnitName != null) {
            if (this.setTargetUnitName.equals("bps")) {
                this.comboUnit.setSelectedItem(this.radioMenubps);
            } else if (this.setTargetUnitName.equals("KB")) {
                this.comboUnit.setSelectedItem(this.radioMenuKB);
            } else if (this.setTargetUnitName.equals("Load")) {
                this.comboUnit.setSelectedItem(this.radioMenuLoad);
            }
        }
        this.setComboTargetsFlag = false;
    }

    public SimpleGrapherApp(String[] stringArray) {
        this.initializeFromProperty("GMonitor.");
        this.initializeEventHandlers();
        this.initializeGUIComponents();
        JFrame jFrame = this.appFrame;
        if (this.propMenuBarVisibility) {
            jFrame.setJMenuBar(this.getMenubar());
        }
        Container container = jFrame.getContentPane();
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.getGraphPane(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        if (this.propInformationPanelVisibility) {
            jPanel.add((Component)this.getPanelInformation(), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        if (this.propStylePanelVisibility) {
            jPanel.add((Component)this.getPanelGraphStyle(), gridBagConstraints);
        }
        if (this.propUnitPanelVisibility) {
            jPanel.add((Component)this.getPanelUnit(), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        if (this.propControllerVisibility) {
            jPanel.add((Component)this.getPanelController(), gridBagConstraints);
        }
        container.add(jPanel);
    }

    public static void main(String[] stringArray) {
        SimpleGrapherApp simpleGrapherApp = new SimpleGrapherApp(stringArray);
        simpleGrapherApp.setTitle("GMonitor");
        simpleGrapherApp.pack();
        simpleGrapherApp.setOptions(stringArray);
        try {
            Dimension dimension = simpleGrapherApp.appFrame.getSize();
            DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
            simpleGrapherApp.appFrame.setLocation(displayMode.getWidth() / 2 - dimension.width / 2, displayMode.getHeight() / 2 - dimension.height / 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        simpleGrapherApp.show();
    }

    public void setSize(int n, int n2) {
        this.appFrame.setSize(n, n2);
    }

    public void setTitle(String string) {
        this.appFrame.setTitle(string);
    }

    public void setVisible(boolean bl) {
        this.appFrame.setVisible(bl);
    }

    public void show() {
        this.appFrame.show();
    }

    public void pack() {
        this.appFrame.pack();
    }

    private RawDataElement[] total(RawData[] rawDataArray) {
        RawData rawData = new RawData();
        ArrayList<RawDataElement> arrayList = new ArrayList<RawDataElement>();
        long l = 0L;
        int n = rawDataArray.length;
        RawDataElement[] rawDataElementArray = new RawDataElement[n];
        int[] nArray = new int[n];
        long[] lArray = new long[n];
        this.fillEndTime(lArray, rawDataArray);
        do {
            l = this.scanNext(l, rawDataArray, nArray, rawDataElementArray);
            long l2 = this.addup(rawDataElementArray);
            RawDataElement rawDataElement = new RawDataElement();
            rawDataElement.setTime(l);
            rawDataElement.setValue(l2);
            rawDataElement.setValid(true);
            arrayList.add(rawDataElement);
        } while (!this.isFinishedTime(l, lArray));
        RawDataElement[] rawDataElementArray2 = new RawDataElement[arrayList.size()];
        rawDataElementArray2 = arrayList.toArray(rawDataElementArray2);
        return rawDataElementArray2;
    }

    private long scanNext(long l, RawData[] rawDataArray, int[] nArray, RawDataElement[] rawDataElementArray) {
        RawDataElement[] rawDataElementArray2;
        int n;
        int n2 = rawDataArray.length;
        long l2 = Long.MAX_VALUE;
        for (n = 0; n < n2; ++n) {
            rawDataElementArray2 = rawDataArray[n].getData();
            int n3 = this.findFirstExceededTime(l, rawDataElementArray2);
            if (n3 < 0) continue;
            nArray[n] = n3;
            long l3 = rawDataElementArray2[n3].getTime();
            if (l2 <= l3) continue;
            l2 = l3;
        }
        for (n = 0; n < n2; ++n) {
            rawDataElementArray2 = rawDataArray[n].getData();
            if (rawDataElementArray2[nArray[n]].getTime() != l2) continue;
            rawDataElementArray[n] = rawDataElementArray2[nArray[n]];
        }
        return l2;
    }

    private int findFirstExceededTime(long l, RawDataElement[] rawDataElementArray) {
        for (int i = 0; i < rawDataElementArray.length; ++i) {
            if (!rawDataElementArray[i].isValid() || rawDataElementArray[i].getTime() <= l) continue;
            return i;
        }
        return -1;
    }

    private boolean isFinishedTime(long l, long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            if (l >= lArray[i]) continue;
            return false;
        }
        return true;
    }

    private void fillEndTime(long[] lArray, RawData[] rawDataArray) {
        for (int i = 0; i < rawDataArray.length; ++i) {
            RawDataElement[] rawDataElementArray = rawDataArray[i].getData();
            lArray[i] = rawDataElementArray[rawDataElementArray.length - 1].getTime();
        }
    }

    private long addup(RawDataElement[] rawDataElementArray) {
        long l = 0L;
        for (int i = 0; i < rawDataElementArray.length; ++i) {
            if (rawDataElementArray[i] == null) continue;
            l += rawDataElementArray[i].getValue();
        }
        return l;
    }

    class MenuItemFileOpenAction
    implements ActionListener {
        MenuItemFileOpenAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            File[] fileArray;
            SimpleGrapherApp.this.actionAutoUpdate(false, false);
            SimpleGrapherApp.this.menuItemAutoUpdate.setSelected(false);
            SimpleGrapherApp.this.checkAutoUpdate.setSelected(false);
            SimpleGrapherApp.this.timer.stop();
            if (SimpleGrapherApp.this.currentDirectoryPath != null) {
                String string;
                try {
                    fileArray = new File(SimpleGrapherApp.this.currentDirectoryPath);
                    string = fileArray.exists() ? fileArray.getCanonicalPath() : "";
                }
                catch (IOException iOException) {
                    string = SimpleGrapherApp.this.currentDirectoryPath;
                }
                SimpleGrapherApp.this.dialogFileOpen.setCurrentDirectory(new File(string));
            }
            if ((n = SimpleGrapherApp.this.dialogFileOpen.showOpenDialog(SimpleGrapherApp.this.appFrame)) == 0) {
                fileArray = SimpleGrapherApp.this.dialogFileOpen.getSelectedFiles();
                SimpleGrapherApp.this.selectedDir = fileArray[0].getParentFile();
                SimpleGrapherApp.this.currentDirectoryPath = SimpleGrapherApp.this.selectedDir.getAbsolutePath();
                String[] stringArray = new String[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    stringArray[i] = fileArray[i].getPath();
                }
                try {
                    SimpleGrapherApp.this.dtSpace = new DataTimeSpace(stringArray);
                    long l = SimpleGrapherApp.this.dtSpace.getBeginDateTime() - 500L;
                    long l2 = SimpleGrapherApp.this.dtSpace.getLatestDateTime();
                    String string = SimpleGrapherApp.this.dateFormat.format(new Date(l));
                    SimpleGrapherApp.this.textBeginTime.setText(string);
                    long l3 = (l2 - l) / 1000L;
                    if (l3 <= 0L) {
                        l3 = 1L;
                    }
                    SimpleGrapherApp.this.textRange.setText("" + l3);
                    SimpleGrapherApp.this.defineNewComboBox(SimpleGrapherApp.this.comboHostname, SimpleGrapherApp.this.dtSpace.getHostnames());
                    SimpleGrapherApp.this.defineNewComboBox(SimpleGrapherApp.this.comboEvent, SimpleGrapherApp.this.dtSpace.getEvents());
                    SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
                }
                catch (Exception exception) {
                    String string = "File open error.";
                    JOptionPane.showMessageDialog(SimpleGrapherApp.this.appFrame, string);
                }
            }
        }
    }

    class MenuItemFileExitAction
    implements ActionListener {
        MenuItemFileExitAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    class RepaintNow
    implements ActionListener {
        RepaintNow() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class RepaintAction
    implements ActionListener {
        RepaintAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.gc();
            SimpleGrapherApp.this.defineNewComboBox(SimpleGrapherApp.this.comboHostname, SimpleGrapherApp.this.dtSpace.getHostnames());
            SimpleGrapherApp.this.defineNewComboBox(SimpleGrapherApp.this.comboEvent, SimpleGrapherApp.this.dtSpace.getEvents());
            SimpleGrapherApp.this.setComboTargets();
            if (SimpleGrapherApp.this.menuItemAutoUpdate.isSelected()) {
                SimpleGrapherApp.this.timer.stop();
                SimpleGrapherApp.this.timer.start();
            } else {
                SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
            }
        }
    }

    class ComboHostnameSelectionAction
    implements ActionListener {
        ComboHostnameSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SimpleGrapherApp.this.setComboTargetsFlag) {
                return;
            }
            SimpleGrapherApp.this.setTargetHostName = (String)SimpleGrapherApp.this.comboHostname.getSelectedItem();
            if (!SimpleGrapherApp.this.disableComboEvent) {
                SimpleGrapherApp.this.defineNewComboBox(SimpleGrapherApp.this.comboEvent, SimpleGrapherApp.this.dtSpace.getEvents());
                SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
            }
        }
    }

    class ComboEventSelectionAction
    implements ActionListener {
        ComboEventSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SimpleGrapherApp.this.setComboTargetsFlag) {
                return;
            }
            SimpleGrapherApp.this.setTargetEventName = (String)SimpleGrapherApp.this.comboEvent.getSelectedItem();
            if (!SimpleGrapherApp.this.disableComboEvent) {
                SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
            }
        }
    }

    class MenuItemAutoUpdateAction
    implements ActionListener {
        MenuItemAutoUpdateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.checkAutoUpdate.setSelected(SimpleGrapherApp.this.menuItemAutoUpdate.isSelected());
            SimpleGrapherApp.this.actionAutoUpdate(SimpleGrapherApp.this.menuItemAutoUpdate.isSelected(), true);
        }
    }

    class MenuItemTotalAction
    implements ActionListener {
        MenuItemTotalAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.checkTotal.setSelected(SimpleGrapherApp.this.menuItemTotal.isSelected());
            SimpleGrapherApp.this.actionTotal(SimpleGrapherApp.this.menuItemTotal.isSelected());
        }
    }

    class MenuItem100divAction
    implements ActionListener {
        MenuItem100divAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.check100div.setSelected(SimpleGrapherApp.this.menuItem100div.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class MenuItem1000timesAction
    implements ActionListener {
        MenuItem1000timesAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.check1000times.setSelected(SimpleGrapherApp.this.menuItem1000times.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class MenuItem8timesAction
    implements ActionListener {
        MenuItem8timesAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.check8times.setSelected(SimpleGrapherApp.this.menuItem8times.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class MenuItemDifferentialModeAction
    implements ActionListener {
        MenuItemDifferentialModeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.checkDifferentialMode.setSelected(SimpleGrapherApp.this.menuItemDifferentialMode.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class MenuItemGraphStylePlotAction
    implements ActionListener {
        MenuItemGraphStylePlotAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.checkGraphStylePlot.setSelected(SimpleGrapherApp.this.menuItemGraphStylePlot.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class MenuItemGraphStyleLineAction
    implements ActionListener {
        MenuItemGraphStyleLineAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.checkGraphStyleLine.setSelected(SimpleGrapherApp.this.menuItemGraphStyleLine.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class MenuItemGraphStyleBarAction
    implements ActionListener {
        MenuItemGraphStyleBarAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.checkGraphStyleBar.setSelected(SimpleGrapherApp.this.menuItemGraphStyleBar.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class TimerAutoUpdateAction
    implements ActionListener {
        TimerAutoUpdateAction() {
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            if (SimpleGrapherApp.this.lockTimer) {
                return;
            }
            SimpleGrapherApp.this.lockTimer = true;
            File[] fileArray = SimpleGrapherApp.this.selectedDir.listFiles(new FileFilter(this){
                private final /* synthetic */ TimerAutoUpdateAction this$1;
                {
                    this.this$1 = timerAutoUpdateAction;
                }

                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".glg");
                }
            });
            if (fileArray == null) {
                SimpleGrapherApp.this.lockTimer = false;
                System.out.println("AutoUpdate: no .glg file");
                return;
            }
            String[] stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = fileArray[i].getPath();
            }
            try {
                SimpleGrapherApp.this.dtSpace = new DataTimeSpace(stringArray);
                long l = SimpleGrapherApp.this.dtSpace.getLatestDateTime();
                long l2 = Long.parseLong(SimpleGrapherApp.this.textRange.getText()) * 1000L;
                String string = SimpleGrapherApp.this.dateFormat.format(new Date(l - l2));
                SimpleGrapherApp.this.textBeginTime.setText(string);
                if (!SimpleGrapherApp.this.timerInitFlag) {
                    SimpleGrapherApp.this.defineNewComboBox(SimpleGrapherApp.this.comboHostname, SimpleGrapherApp.this.dtSpace.getHostnames());
                    SimpleGrapherApp.this.defineNewComboBox(SimpleGrapherApp.this.comboEvent, SimpleGrapherApp.this.dtSpace.getEvents());
                    SimpleGrapherApp.this.setComboTargets();
                    SimpleGrapherApp.this.timerInitFlag = true;
                }
                SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
            }
            catch (IOException iOException) {
                String string = "File open error.";
                System.out.println(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("invalid Time Range.");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            SimpleGrapherApp.this.lockTimer = false;
        }
    }

    class CheckBoxAutoUpdateAction
    implements ActionListener {
        CheckBoxAutoUpdateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = SimpleGrapherApp.this.checkAutoUpdate;
            SimpleGrapherApp.this.menuItemAutoUpdate.setSelected(jCheckBox.isSelected());
            SimpleGrapherApp.this.actionAutoUpdate(jCheckBox.isSelected(), true);
        }
    }

    class FileAutoUpdateAction
    implements ActionListener {
        FileAutoUpdateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.checkAutoUpdate.setSelected(true);
            SimpleGrapherApp.this.menuItemAutoUpdate.setSelected(true);
            SimpleGrapherApp.this.actionAutoUpdate(true, true);
        }
    }

    class CheckBoxTotalAction
    implements ActionListener {
        CheckBoxTotalAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = SimpleGrapherApp.this.checkTotal;
            SimpleGrapherApp.this.menuItemTotal.setSelected(jCheckBox.isSelected());
            SimpleGrapherApp.this.actionTotal(jCheckBox.isSelected());
        }
    }

    class CheckBox100divAction
    implements ActionListener {
        CheckBox100divAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.menuItem100div.setSelected(SimpleGrapherApp.this.check100div.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class CheckBox1000timesAction
    implements ActionListener {
        CheckBox1000timesAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.menuItem1000times.setSelected(SimpleGrapherApp.this.check1000times.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class CheckBox8timesAction
    implements ActionListener {
        CheckBox8timesAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.menuItem8times.setSelected(SimpleGrapherApp.this.check8times.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class CheckBoxDifferentialModeAction
    implements ActionListener {
        CheckBoxDifferentialModeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.menuItemDifferentialMode.setSelected(SimpleGrapherApp.this.checkDifferentialMode.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class CheckBoxPlotAction
    implements ActionListener {
        CheckBoxPlotAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.menuItemGraphStylePlot.setSelected(SimpleGrapherApp.this.checkGraphStylePlot.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class CheckBoxLineAction
    implements ActionListener {
        CheckBoxLineAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.menuItemGraphStyleLine.setSelected(SimpleGrapherApp.this.checkGraphStyleLine.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class CheckBoxBarAction
    implements ActionListener {
        CheckBoxBarAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.menuItemGraphStyleBar.setSelected(SimpleGrapherApp.this.checkGraphStyleBar.isSelected());
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class ComboUnitSelectionAction
    implements ActionListener {
        ComboUnitSelectionAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((JRadioButtonMenuItem)SimpleGrapherApp.this.comboUnit.getSelectedItem()).setSelected(true);
            ((JRadioButtonMenuItem)SimpleGrapherApp.this.comboUnit.getSelectedItem()).doClick();
            if (SimpleGrapherApp.this.setComboTargetsFlag) {
                return;
            }
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class ResampleResoAction
    implements ActionListener {
        ResampleResoAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(SimpleGrapherApp.this.appFrame, "Resampling Resolution (second)", String.valueOf(SimpleGrapherApp.this.resampleResolution));
            try {
                if (string != null) {
                    int n = Integer.parseInt(string);
                    if (n <= 0) {
                        return;
                    }
                    SimpleGrapherApp.this.resampleResolution = n;
                    SimpleGrapherApp.this.menuItemResolution.setText(SimpleGrapherApp.this.menuStrResolution + " (" + string + ")");
                    SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class AutoUpdateIntervalAction
    implements ActionListener {
        AutoUpdateIntervalAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SimpleGrapherApp.this.checkAutoUpdate.isSelected()) {
                SimpleGrapherApp.this.timer.stop();
            }
            String string = JOptionPane.showInputDialog(SimpleGrapherApp.this.appFrame, "AutoUpdate Interval (second)", String.valueOf(SimpleGrapherApp.this.autoUpdateInterval));
            try {
                if (string != null) {
                    int n = Integer.parseInt(string);
                    if (n <= 0) {
                        return;
                    }
                    SimpleGrapherApp.this.autoUpdateInterval = n;
                    SimpleGrapherApp.this.menuItemAutoUpdateInterval.setText(SimpleGrapherApp.this.menuStrAutoUpdateInterval + " (" + string + ")");
                    SimpleGrapherApp.this.timer.setDelay(SimpleGrapherApp.this.autoUpdateInterval * 1000);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (SimpleGrapherApp.this.checkAutoUpdate.isSelected()) {
                SimpleGrapherApp.this.timer.start();
            }
        }
    }

    class RadioAction
    implements ActionListener {
        RadioAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (((JRadioButtonMenuItem)actionEvent.getSource()).equals(SimpleGrapherApp.this.radioMenubps)) {
                SimpleGrapherApp.this.menuItem8times.setSelected(true);
                SimpleGrapherApp.this.check8times.setSelected(true);
                SimpleGrapherApp.this.menuItemDifferentialMode.setSelected(true);
                SimpleGrapherApp.this.checkDifferentialMode.setSelected(true);
            } else {
                SimpleGrapherApp.this.menuItem8times.setSelected(false);
                SimpleGrapherApp.this.check8times.setSelected(false);
                SimpleGrapherApp.this.menuItemDifferentialMode.setSelected(false);
                SimpleGrapherApp.this.checkDifferentialMode.setSelected(false);
            }
            SimpleGrapherApp.this.comboUnit.setSelectedItem((JRadioButtonMenuItem)actionEvent.getSource());
        }
    }

    class VisibleControllerAction
    implements ActionListener {
        VisibleControllerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.panelController.setVisible(SimpleGrapherApp.this.menuItemVisController.isSelected());
        }
    }

    class VisibleUnitAction
    implements ActionListener {
        VisibleUnitAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.panelUnit.setVisible(SimpleGrapherApp.this.menuItemVisUnit.isSelected());
        }
    }

    class VisibleStyleAction
    implements ActionListener {
        VisibleStyleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.panelGraphStyle.setVisible(SimpleGrapherApp.this.menuItemVisGraphStyle.isSelected());
        }
    }

    class VisibleInfoAction
    implements ActionListener {
        VisibleInfoAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.panelInformation.setVisible(SimpleGrapherApp.this.menuItemVisInfo.isSelected());
        }
    }

    class ResampleAction
    implements ActionListener {
        ResampleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.dtSpace.initResampingMode();
            SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
        }
    }

    class GraphMouseAction
    implements MouseListener {
        private boolean rightFlag;
        int click;

        GraphMouseAction() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.click = mouseEvent.getClickCount();
            if (this.click >= 2) {
                // empty if block
            }
            this.rightFlag = false;
            this.event(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.event(mouseEvent);
            if (!this.rightFlag && this.click >= 2) {
                SimpleGrapherApp.this.magnificationY *= 2L;
                SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
            }
        }

        private void event(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && !this.rightFlag) {
                if (this.click == 1) {
                    SimpleGrapherApp.this.magnificationY /= 2L;
                    if (SimpleGrapherApp.this.magnificationY <= 0L) {
                        SimpleGrapherApp.this.magnificationY = 1L;
                    }
                } else if (this.click == 2) {
                    SimpleGrapherApp.this.magnificationY = 1L;
                }
                SimpleGrapherApp.this.paintGraphAccordingToCurrentGUIStatus();
                this.rightFlag = true;
            }
        }
    }

    class CorrectByUptimeAction
    implements ActionListener {
        CorrectByUptimeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleGrapherApp.this.actionCorrect(SimpleGrapherApp.this.menuItemCorrectByUptime.isSelected());
        }
    }
}

