/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.logdata;

import gmonitor.logdata.BinaryBlock;
import gmonitor.logdata.IntervalDefElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class IntervalDefBlock
extends BinaryBlock {
    protected ArrayList definition = new ArrayList();

    public static IntervalDefBlock newInstance(InputStream inputStream, int n) throws IOException {
        IntervalDefBlock intervalDefBlock = new IntervalDefBlock();
        intervalDefBlock.deserialize(inputStream, n);
        return intervalDefBlock;
    }

    public int getCount() {
        return this.definition.size();
    }

    public IntervalDefElement getElement(int n) {
        return (IntervalDefElement)this.definition.get(n);
    }

    protected void parse_binary_block(InputStream inputStream) throws IOException {
        for (int i = 0; i < this.size; i += 8) {
            IntervalDefElement intervalDefElement = new IntervalDefElement();
            intervalDefElement.setHostIndex(this.read2bytesInt(inputStream));
            i += 2;
            intervalDefElement.setOidIndex(this.read2bytesInt(inputStream));
            i += 2;
            int n = this.read4bytesInt(inputStream);
            intervalDefElement.setTime_unix_seconds(n);
            int n2 = this.read4bytesInt(inputStream);
            intervalDefElement.setTime_unix_useconds(n2);
            intervalDefElement.setTime(n * 1000 + n2 / 1000);
            this.definition.add(intervalDefElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("# IntervalDefBlock");
        ArrayList arrayList = this.definition;
        synchronized (arrayList) {
            int n = this.definition.size();
            for (int i = 0; i < n; ++i) {
                IntervalDefElement intervalDefElement = (IntervalDefElement)this.definition.get(i);
                stringBuffer.append('\n');
                stringBuffer.append(intervalDefElement.toString(i));
            }
        }
        return stringBuffer.toString();
    }
}

