module Paths_pkg2 (
    version,
    getBinDir, getLibDir, getDataDir, getLibexecDir,
    getDataFileName, getSysconfDir
  ) where

import qualified Control.Exception as Exception
import Data.Version (Version(..))
import System.Environment (getEnv)
import Prelude

catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
catchIO = Exception.catch

version :: Version
version = Version [1] []
bindir, libdir, datadir, libexecdir, sysconfdir :: FilePath

bindir     = "/usr/local/bin"
libdir     = "/usr/local/lib/x86_64-linux-ghc-7.10.2.20151111/pkg2-1-LihyBe7JeTL9Qqs1IhEwxm"
datadir    = "/usr/local/share/x86_64-linux-ghc-7.10.2.20151111/pkg2-1"
libexecdir = "/usr/local/libexec"
sysconfdir = "/usr/local/etc"

getBinDir, getLibDir, getDataDir, getLibexecDir, getSysconfDir :: IO FilePath
getBinDir = catchIO (getEnv "pkg2_bindir") (\_ -> return bindir)
getLibDir = catchIO (getEnv "pkg2_libdir") (\_ -> return libdir)
getDataDir = catchIO (getEnv "pkg2_datadir") (\_ -> return datadir)
getLibexecDir = catchIO (getEnv "pkg2_libexecdir") (\_ -> return libexecdir)
getSysconfDir = catchIO (getEnv "pkg2_sysconfdir") (\_ -> return sysconfdir)

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = do
  dir <- getDataDir
  return (dir ++ "/" ++ name)
