---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab mr list`

List merge requests.

```plaintext
glab mr list [flags]
```

## Aliases

```plaintext
ls
```

## Examples

```plaintext
glab mr list --all
glab mr ls -a
glab mr list --assignee=@me
glab mr list --reviewer=@me
glab mr list --source-branch=new-feature
glab mr list --target-branch=main
glab mr list --search "this adds feature X"
glab mr list --label needs-review
glab mr list --not-label waiting-maintainer-feedback,subsystem-x
glab mr list -M --per-page 10

```

## Options

```plaintext
  -A, --all                    Get all merge requests.
  -a, --assignee strings       Get only merge requests assigned to users.
      --author string          Filter merge request by author <username>.
  -c, --closed                 Get only closed merge requests.
  -d, --draft                  Filter by draft merge requests.
  -g, --group string           Select a group/subgroup. This option is ignored if a repo argument is set.
  -l, --label strings          Filter merge request by label <name>.
  -M, --merged                 Get only merged merge requests.
  -m, --milestone string       Filter merge request by milestone <id>.
      --not-label strings      Filter merge requests by not having label <name>.
  -F, --output string          Format output as: text, json. (default "text")
  -p, --page int               Page number. (default 1)
  -P, --per-page int           Number of items to list per page. (default 30)
  -R, --repo OWNER/REPO        Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
  -r, --reviewer strings       Get only merge requests with users as reviewer.
      --search string          Filter by <string> in title and description.
  -s, --source-branch string   Filter by source branch <name>.
  -t, --target-branch string   Filter by target branch <name>.
```

## Options inherited from parent commands

```plaintext
      --help   Show help for this command.
```
