-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_files.adb,v $
--  Description     : File Select dialog
--  Author          : Michael Erdmann
--  Created         : 18.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/09/21 20:47:30 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;        use Ada.Text_IO;
with Gtk.Box;            use Gtk.Box;
with Gtk.Button;         use Gtk.Button;
with Gtk.Enums;          use Gtk.Enums;
with Gtk.File_Selection; use Gtk.File_Selection;
with Gtk.Handlers;       use Gtk.Handlers;
with Gtk.Widget;         use Gtk.Widget;
with Gtk;                use Gtk;

with GUI_Editor;         use GUI_Editor;

package body GUI_Files is

   type Gtk_File_Selection_Access is access all Gtk_File_Selection;
   package Destroy_Cb is new Handlers.User_Callback
     (Gtk_File_Selection_Record, Gtk_File_Selection_Access);
   package Files_Cb is new Handlers.Callback
     (Gtk_File_Selection_Record);


   package Widget_Handler is new Handlers.Callback (Gtk_Widget_Record);

   File_Select : aliased Gtk_File_Selection;

   --- *************************************************************************** --
   --- ***                   HANDLE FILE SELECTION                             *** --
   --- *************************************************************************** --

   --------
   -- Ok --
   --------
   procedure OK (Files : access Gtk_File_Selection_Record'Class) is
      File : File_Type ;
   begin
      Put_Line ("Selected " & Get_Filename (Files) & ".");
      -- GUI_Editor.Save_As( Name => Get_Filename( Files ) );
      Destroy (Files);
   end Ok;

   ------------
   -- Cancel --
   ------------
   procedure Cancel (Win : access Gtk_Widget_Record'Class) is
   begin
      Destroy (Win);
   end Cancel;

  ---------------
   -- Destroyed --
   ---------------
   procedure Destroyed (
      Win : access Gtk_File_Selection_Record'Class;
      Ptr : in Gtk_File_Selection_Access) is
      pragma Warnings (Off, Win);
   begin
      Ptr.all := null;
   end Destroyed;

   ------------------------
   -- File_Select_Dialog --
   ------------------------
   procedure Dialog is
      Button : Gtk_Button;
   begin
      Gtk_New (File_Select, Title => "File Selection Dialog");
      Hide_Fileop_Buttons (File_Select);
      Set_Position (File_Select, Win_Pos_Mouse);

      Destroy_Cb.Connect(
         File_Select, "destroy",
         Destroy_Cb.To_Marshaller (Destroyed'Access), File_Select'Access
      );

      Files_Cb.Object_Connect(
         Get_Ok_Button (File_Select), "clicked",
         Files_Cb.To_Marshaller (Ok'Access),
         Slot_Object => File_Select
      );
      Widget_Handler.Object_Connect(
         Get_Cancel_Button(File_Select), "clicked",
         Widget_Handler.To_Marshaller (Cancel'Access),
         Slot_Object => File_Select
      );
      Show (File_Select);
   end Dialog;

end GUI_Files;
