-------------------------------------------------------------------------------
--                                                                           --
--             GNat Ada Database Environment - GNADE                         --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/text_block.ads,v $
--  Description     : handle test blocks in text buffers
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/10/03 19:56:03 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with GSQL_Types;                        use GSQL_Types;
with Ada.Strings.Unbounded;             use Ada.Strings.Unbounded;

package Text_Block is

   End_Of_Block_Reached : exception;
   --------------------
   -- Get_text_Block --
   --------------------
   procedure Get_Text_Block(
      Dest : in out Text_Buffer;
      Src  : in     Text_Buffer;
      Last : in out Positive );

   --------------------
   -- Put_Text_Block --
   --------------------
   procedure Put_Text_Block(
      Dest : in out Text_buffer;
      Src  : in     Text_buffer;
      Last : in out Positive );

   ----------------
   -- Fetch_Next --
   ----------------
   procedure Fetch_Next(
      Dest : out Unbounded_String;
      Src  : in  Text_Buffer;
      Last : in out Positive );

   ---------------------
   -- Is_End_Of_Block --
   ---------------------
   function Is_End_Of_Block(
      S    : in Unbounded_String ) return Boolean;

   -------------------------
   -- Insert_End_Of_Block --
   -------------------------
   procedure Insert_End_Of_Block(
      Dest : in out Text_Buffer;
      Last : in out Positive );

end Text_Block;
