with Ada.Streams;               	use Ada.Streams;
with Ada.Streams.Stream_IO;     	use Ada.Streams.Stream_IO;
--with Ada.Text_IO;			use Ada.Text_IO;
--with Ada.Calendar;			use Ada.Calendar;
with Ada.Unchecked_Conversion;
use  Ada;

with GNU.DB.SQLCLI;			use GNU.DB.SQLCLI;

with BLOB_Stream;			use BLOB_Stream;
with MD5;				use MD5;


package body Key_Type is

   Version : String := "$Id: key_type.adb,v 1.2 2007/01/13 21:44:40 merdmann Exp $";

   ---------------
   -- To_Binary --
   ---------------
   function To_BINARY(
      F : in MD5.Fingerprint ) return GNADE.BINARY is

      function To_SQLCHAR is new Ada.Unchecked_Conversion
        (Target => SQL.SQLCHAR, Source  => Stream_Element );

      Result : GNADE.BINARY( 1..16 );
   begin
      for i in F'Range loop
         Result(Integer(i)) := To_SQLCHAR( F(i) );
      end loop;

      return Result;
   end To_BINARY;

   ----------
   -- Hash --
   ----------
   function Hash(
      This   : in Object'Class ) return GNADE.BINARY is
      S      : Stream_Access := BLOB_Stream.Stream( Key_Size );
      Result : GNADE.BINARY(1..16);
   begin
      Object'Class'Output(S, This );
      Result := To_Binary(Hash(S));
      Destroy(S);

      return Result;
   end Hash;


   ----------
   -- Hash --
   ----------
   function Hash(
      ID     : in Integer ) return GNADE.BINARY is
      S      : Stream_Access := BLOB_Stream.Stream( Key_Size );
      Result : GNADE.BINARY(1..16);
   begin
      Integer'Output(S, ID );
      Result := To_Binary(Hash(S));
      Destroy(S);

      return Result;
   end Hash;



end Key_Type;
