------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-date-internal.ads,v 1.1 2008/02/11 08:52:33 vagul Exp $

with Ada.Calendar;

package OCI.Thick.Date.Internal is

   type Date_Time is private;
   --  Internal oracle date representation.
   --  SQLT_DAT.

   function To_String (From : Date_Time; Format : String) return String;

   function To_Date (Item : String; Format : String) return Date_Time;

   function To_Ada (DT : in Date_Time) return Ada.Calendar.Time;

   function To_Oracle (DT : in Ada.Calendar.Time) return Date_Time;

   function To_OCI (DT : in Date_Time) return OCIDate;
   function To_Oracle (DT : in OCIDate) return Date_Time;

   function SysDate return Date_Time;

private

   type Date_Time is array (0 .. 6) of Ub1;

end OCI.Thick.Date.Internal;
