------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-servers.ads,v 1.9 2007/04/25 10:08:46 vagul Exp $

with OCI.Environments;

package OCI.Thick.Servers is

   type Server is new Handle_Reference with private;

   function Attach (Name : String) return Server;

   procedure Set_Blocking (Item : in out Server; Mode : in Boolean);

   function Is_Blocking (Item : in Server) return Boolean;

   function Server_Version (Item : in Server) return String;

   procedure Break (It : Server);
   procedure Reset (It : Server);

private

   type Server is new Handle_Reference with record
      Environment : OCI.Environments.Thread_Environment;
   end record;

   overriding procedure Destroy (It : in out Server);

end OCI.Thick.Servers;
