-- ----------------------------------------------------------------------------
--                                                                           --
--                      GNADE  : GNu Ada Database Environment                --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/samples/sample_db/gnade.oracle.sql,v $
--  Description     : Makefile for the Oracle sample database
--  Author          : Juergen Pfeifer <juergen.pfeifer@gmx.net> 
--  Created On      : 03-Jan-2001
--  Last Modified By: Franois Fabien
--  Last Modified On: $Date: 2001/10/21 10:48:20 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000-2001
--
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  GNADE distribution.                                                      --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-- ----------------------------------------------------------------------------
--  Functional Description						     
--  ======================						     
--  This SQL Script generates the test data base as it is used by	     
--  the code in the ./samples directory. The user must log under SQL*Plus
--  and type SQL>@gnade_oracle to execute the script.
--				                                              
--									     
--  Restrictions							     
--  ============							    
--  The script has been build and tested with Oracle 8i Lite on Win95.		    
--									    
--  References								    
--  ==========								    
--  Decimal follow European rule with ',' as separator and not '.' as US
									    
CREATE TABLE EMPLOYEES (
        empno		 int NOT NULL,
        name		 character(20) NOT NULL,
        firstname	       character(20),
        deptno	 	 int,
	  since		 date,
        manager	 	 int,
        job		       character(20),
        promotion	       character(1),
        salary	 	 decimal(8,4));

CREATE TABLE DEPARTMENTS (
        deptno 		 int NOT NULL,
        name 		 character(20) NOT NULL,
        location 	       character(20));                                          


insert into EMPLOYEES values 
(  1, 'Erdmann',	'Michael',	1001,	'31-DEC-1999',	 2, 'Coding Monkey', 'T', '200,1234' );
insert into EMPLOYEES values 
(  2, 'Massalski',	'Marina',	1000,	'01-SEP-2000', null, 'Supervisor',    'F', '200,00' );
insert into EMPLOYEES values 
(  3, 'Tully',		'Noel',		1001,	'23-JAN-1959',	 2, 'Supervisor',    'T', '200,00' );
insert into EMPLOYEES values 
(  4, 'Pfeifer',	'Jrgen',	1001,	'01-JAN-2001',	 2, 'Designer',	     'T', '200,00' );
insert into EMPLOYEES values 
(  5, 'Smith',		'John',		1000,	'1980-06-11',	 3, 'Coding Monkey', 'T', '250,00' );
insert into EMPLOYEES values 
(  6, 'Smith',		'John',		1001,	'1972-06-11',	 3, 'Designer',	     'T', '820,00' );
insert into EMPLOYEES values 
( 50, 'Simpson',	'Bud',		1003,	'1980-06-11',	 3, 'Clerk',	     'F',  '20,00' );
insert into EMPLOYEES values 
( 51, 'Bundy',		'Al',		1003,	'1980-06-11',	 3, 'Clerk',	     'F',  '10,00' );
insert into EMPLOYEES values 
( 52, 'Bundy',		'Peggy',	1003,	'1988-06-15',	 3,  null,	     'F', '-10,00' );
insert into EMPLOYEES values 
( 53, 'Simpson',	'Kelly',	1003,	'1995-09-11',	 3, 'Secretary',     'F',  '20,00' );
insert into EMPLOYEES values 
(500, 'Rutherford',	'Ernest',	2000,	'1930-05-30',	 3, 'Genius',	     'T','1200,00' );
insert into EMPLOYEES values 
(501, 'Fermi',		null,		2000,	'1940-07-29',	 3, 'Genius',	     'T','1200,00' );
insert into EMPLOYEES values 
(502, 'Poincar',	  'Henri',  	2000,	'1904-01-01',	 2, 'Genius',	     'T','1200,00' );
insert into EMPLOYEES values 
(503, 'Fermi',		null,		2000,	'1020-08-15',	 2, 'Genius',	     'T','1200,99' );  

insert into DEPARTMENTS 
   values( 1001, 'Sales',		'Berlin' );
insert into DEPARTMENTS 
   values( 1000, 'Developement',	'Stuttgart' );
insert into DEPARTMENTS 
   values( 1002, 'CM and Production',	'Bonn' );
insert into DEPARTMENTS 
   values( 1003, 'Support',		'Chicago' );
insert into DEPARTMENTS 
   values( 2000, 'Masterminds',		null );      


CREATE TABLE LOCATIONS (
        NAME     CHARACTER(20) NOT NULL PRIMARY KEY,
        CITY     VARCHAR(40),
        STREET   VARCHAR(80),
        NO       CHARACTER(5),
        ZIPCODE  INT
); 


insert into locations
   values( 'Berlin', 'Berlin','Siemensdamm', '50a', 10243 );                  
insert into locations
   values( 'Bonn', 'Bonn','Oberkasselerstrasse', '8', 47112 );          
insert into locations
   values( 'Stuttgart', 'Stuttgart','Lorenzweg', '1', 60001 );          
insert into locations
   values( 'Chicage', 'Chicago','Bundy Stree', '9996', 70001 );          

commit;
