#ifndef __GM_EDITOR_VIEW_H__
#define __GM_EDITOR_VIEW_H__

#include <glib-object.h>
#include <gtk/gtk.h>
#include "gm-editor.h"
#include "gm-world.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_EDITOR_VIEW					(gm_editor_view_get_type())
#define GM_EDITOR_VIEW(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_EDITOR_VIEW, GmEditorView))
#define GM_EDITOR_VIEW_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj),\
		GM_TYPE_EDITOR_VIEW, GmEditorView const))
#define GM_EDITOR_VIEW_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_EDITOR_VIEW, GmEditorViewClass))
#define GM_IS_EDITOR_VIEW(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_EDITOR_VIEW))
#define GM_IS_EDITOR_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_EDITOR_VIEW))
#define GM_EDITOR_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_EDITOR_VIEW, GmEditorViewClass))

/* Private structure type */
typedef struct _GmEditorViewPrivate GmEditorViewPrivate;

/*
 * Main object structure
 */
typedef struct _GmEditorView GmEditorView;
 
struct _GmEditorView {
	GtkVBox parent;
	
	/*< private > */
	GmEditorViewPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmEditorViewClass 	GmEditorViewClass;

struct _GmEditorViewClass {
	GtkVBoxClass parent_class;

	/* Signals */
	void (* modified_changed) (GmEditorView *obj, gboolean modified);
};

GType gm_editor_view_get_type(void) G_GNUC_CONST;
GmEditorView *gm_editor_view_new(GmWorld *world, GmEditor *editor);
GmEditor *gm_editor_view_editor(GmEditorView *view);
void gm_editor_view_save(GmEditorView *view);
void gm_editor_view_check_syntax(GmEditorView *view);

G_END_DECLS
#endif /* __GM_EDITOR_VIEW_H__ */
