#ifndef __GM_EMBEDDED_VIEW_H__
#define __GM_EMBEDDED_VIEW_H__

#include <glib-object.h>
#include <gtk/gtk.h>
#include "gm-editor.h"
#include "gm-world.h"

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_EMBEDDED_VIEW					(gm_embedded_view_get_type())
#define GM_EMBEDDED_VIEW(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_EMBEDDED_VIEW, GmEmbeddedView))
#define GM_EMBEDDED_VIEW_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj),\
		GM_TYPE_EMBEDDED_VIEW, GmEmbeddedView const))
#define GM_EMBEDDED_VIEW_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_EMBEDDED_VIEW, GmEmbeddedViewClass))
#define GM_IS_EMBEDDED_VIEW(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_EMBEDDED_VIEW))
#define GM_IS_EMBEDDED_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_EMBEDDED_VIEW))
#define GM_EMBEDDED_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_EMBEDDED_VIEW, GmEmbeddedViewClass))

/* Private structure type */
typedef struct _GmEmbeddedViewPrivate GmEmbeddedViewPrivate;

/*
 * Main object structure
 */
typedef struct _GmEmbeddedView GmEmbeddedView;
 
struct _GmEmbeddedView {
	GtkHBox parent;
	
	/*< private > */
	GmEmbeddedViewPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmEmbeddedViewClass 	GmEmbeddedViewClass;

struct _GmEmbeddedViewClass {
	GtkHBoxClass parent_class;

	/* Signals
	void (* proto) (GmEmbeddedView *obj); */
};

GType gm_embedded_view_get_type(void) G_GNUC_CONST;
GmEmbeddedView *gm_embedded_view_new(GmWorld *world, GmEditor *editor);
GmEditor *gm_embedded_view_editor(GmEmbeddedView *view);

G_END_DECLS
#endif /* __GM_EMBEDDED_VIEW_H__ */
