=begin  
  editing.rb
    Copyright (c) 2004 by Jesse van den Kieboom <jesse@icecrew.nl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
	Defines:
	  e - edit a verb
	  me - edit your description
	  he - edit your locations description
	  de - edit a objects description
	  ne - edit a property
=end

def register_functions
  $scripts.register("e", "use: /e <obj>:<verb>\nedit a verb", "edit_e")
  $scripts.register("me", "use: /me\nedit your description", "edit_me")
  $scripts.register("he", "use: /he\nedit your locations description", "edit_he")
  $scripts.register("de", "use: /de <obj>\nedit a objects description", "edit_de")
  $scripts.register("ne", "use: /ne <obj>.<prop>\nedit a property", "edit_ne")
end

def edit_e(argstr)
  $world.sendln("@edit " + argstr)
end

def edit_me(argstr)
  $world.sendln("@notedit me.description")
end

def edit_he(argstr)
  $world.sendln("@notedit here.description")
end

def edit_ne(argstr)
  $world.sendln("@notedit " + argstr)
end

def edit_de(argstr)
  $world.sendln("@notedit " + argstr + ".description")
end
